/*
 Highstock JS v10.3.3 (2023-01-20)

 Highcharts Stock as a plugin for Highcharts

 (c) 2010-2021 Torstein Honsi

 License: www.highcharts.com/license
*/
(function(a){"object"===typeof module&&module.exports?(a["default"]=a,module.exports=a):"function"===typeof define&&define.amd?define("highcharts/modules/stock",["highcharts"],function(C){a(C);a.Highcharts=C;return a}):a("undefined"!==typeof Highcharts?Highcharts:void 0)})(function(a){function C(a,q,z,v){a.hasOwnProperty(q)||(a[q]=v.apply(null,z),"function"===typeof CustomEvent&&window.dispatchEvent(new CustomEvent("HighchartsModuleLoaded",{detail:{path:q,module:a[q]}})))}a=a?a._modules:{};C(a,"Core/Axis/BrokenAxis.js",
[a["Core/Axis/Stacking/StackItem.js"],a["Core/Utilities.js"]],function(a,q){var E=q.addEvent,v=q.find,t=q.fireEvent,B=q.isArray,w=q.isNumber,y=q.pick,r;(function(m){function e(){"undefined"!==typeof this.brokenAxis&&this.brokenAxis.setBreaks(this.options.breaks,!1)}function r(){this.brokenAxis&&this.brokenAxis.hasBreaks&&(this.options.ordinal=!1)}function p(){var f=this.brokenAxis;if(f&&f.hasBreaks){for(var c=this.tickPositions,u=this.tickPositions.info,l=[],d=0;d<c.length;d++)f.isInAnyBreak(c[d])||
l.push(c[d]);this.tickPositions=l;this.tickPositions.info=u}}function c(){this.brokenAxis||(this.brokenAxis=new F(this))}function J(){var f=this.options.connectNulls,c=this.points,u=this.xAxis,l=this.yAxis;if(this.isDirty)for(var d=c.length;d--;){var h=c[d],b=!(null===h.y&&!1===f)&&(u&&u.brokenAxis&&u.brokenAxis.isInAnyBreak(h.x,!0)||l&&l.brokenAxis&&l.brokenAxis.isInAnyBreak(h.y,!0));h.visible=b?!1:!1!==h.options.visible}}function f(){this.drawBreaks(this.xAxis,["x"]);this.drawBreaks(this.yAxis,
y(this.pointArrayMap,["y"]))}function D(f,c){var u=this,l=u.points,d,h,b,n;if(f&&f.brokenAxis&&f.brokenAxis.hasBreaks){var k=f.brokenAxis;c.forEach(function(A){d=k&&k.breakArray||[];h=f.isXAxis?f.min:y(u.options.threshold,f.min);l.forEach(function(k){n=y(k["stack"+A.toUpperCase()],k[A]);d.forEach(function(d){if(w(h)&&w(n)){b=!1;if(h<d.from&&n>d.to||h>d.from&&n<d.from)b="pointBreak";else if(h<d.from&&n>d.from&&n<d.to||h>d.from&&n>d.to&&n<d.from)b="pointInBreak";b&&t(f,b,{point:k,brk:d})}})})})}}function L(){var f=
this.currentDataGrouping,c=f&&f.gapSize;f=this.points.slice();var u=this.yAxis,l=this.options.gapSize,d=f.length-1,h;if(l&&0<d)for("value"!==this.options.gapUnit&&(l*=this.basePointRange),c&&c>l&&c>=this.basePointRange&&(l=c),h=void 0;d--;)h&&!1!==h.visible||(h=f[d+1]),c=f[d],!1!==h.visible&&!1!==c.visible&&(h.x-c.x>l&&(h=(c.x+h.x)/2,f.splice(d+1,0,{isNull:!0,x:h}),u.stacking&&this.options.stacking&&(h=u.stacking.stacks[this.stackKey][h]=new a(u,u.options.stackLabels,!1,h,this.stack),h.total=0)),
h=c);return this.getGraphPath(f)}var q=[];m.compose=function(a,m){-1===q.indexOf(a)&&(q.push(a),a.keepProps.push("brokenAxis"),E(a,"init",c),E(a,"afterInit",e),E(a,"afterSetTickPositions",p),E(a,"afterSetOptions",r));if(-1===q.indexOf(m)){q.push(m);var u=m.prototype;u.drawBreaks=D;u.gappedPath=L;E(m,"afterGeneratePoints",J);E(m,"afterRender",f)}return a};var F=function(){function f(f){this.hasBreaks=!1;this.axis=f}f.isInBreak=function(f,c){var l=f.repeat||Infinity,d=f.from,h=f.to-f.from;c=c>=d?(c-
d)%l:l-(d-c)%l;return f.inclusive?c<=h:c<h&&0!==c};f.lin2Val=function(c){var u=this.brokenAxis;u=u&&u.breakArray;if(!u||!w(c))return c;var l;for(l=0;l<u.length;l++){var d=u[l];if(d.from>=c)break;else d.to<c?c+=d.len:f.isInBreak(d,c)&&(c+=d.len)}return c};f.val2Lin=function(c){var u=this.brokenAxis;u=u&&u.breakArray;if(!u||!w(c))return c;var l=c,d;for(d=0;d<u.length;d++){var h=u[d];if(h.to<=c)l-=h.len;else if(h.from>=c)break;else if(f.isInBreak(h,c)){l-=c-h.from;break}}return l};f.prototype.findBreakAt=
function(f,c){return v(c,function(l){return l.from<f&&f<l.to})};f.prototype.isInAnyBreak=function(c,u){var l=this.axis,d=l.options.breaks||[],h=d.length,b;if(h&&w(c)){for(;h--;)if(f.isInBreak(d[h],c)){var n=!0;b||(b=y(d[h].showPoints,!l.isXAxis))}var k=n&&u?n&&!b:n}return k};f.prototype.setBreaks=function(c,u){var l=this,d=l.axis,h=B(c)&&!!c.length;d.isDirty=l.hasBreaks!==h;l.hasBreaks=h;d.options.breaks=d.userOptions.breaks=c;d.forceRedraw=!0;d.series.forEach(function(b){b.isDirty=!0});h||d.val2lin!==
f.val2Lin||(delete d.val2lin,delete d.lin2val);h&&(d.userOptions.ordinal=!1,d.lin2val=f.lin2Val,d.val2lin=f.val2Lin,d.setExtremes=function(b,n,k,A,h){if(l.hasBreaks){for(var M=this.options.breaks||[],f;f=l.findBreakAt(b,M);)b=f.to;for(;f=l.findBreakAt(n,M);)n=f.from;n<b&&(n=b)}d.constructor.prototype.setExtremes.call(this,b,n,k,A,h)},d.setAxisTranslation=function(){d.constructor.prototype.setAxisTranslation.call(this);l.unitLength=void 0;if(l.hasBreaks){var b=d.options.breaks||[],n=[],k=[],A=y(d.pointRangePadding,
0),h=0,c,K=d.userMin||d.min,H=d.userMax||d.max,u;b.forEach(function(b){c=b.repeat||Infinity;w(K)&&w(H)&&(f.isInBreak(b,K)&&(K+=b.to%c-K%c),f.isInBreak(b,H)&&(H-=H%c-b.from%c))});b.forEach(function(b){I=b.from;c=b.repeat||Infinity;if(w(K)&&w(H)){for(;I-c>K;)I-=c;for(;I<K;)I+=c;for(u=I;u<H;u+=c)n.push({value:u,move:"in"}),n.push({value:u+b.to-b.from,move:"out",size:b.breakSize})}});n.sort(function(b,n){return b.value===n.value?("in"===b.move?0:1)-("in"===n.move?0:1):b.value-n.value});var a=0;var I=
K;n.forEach(function(b){a+="in"===b.move?1:-1;1===a&&"in"===b.move&&(I=b.value);0===a&&w(I)&&(k.push({from:I,to:b.value,len:b.value-I-(b.size||0)}),h+=b.value-I-(b.size||0))});l.breakArray=k;w(K)&&w(H)&&w(d.min)&&(l.unitLength=H-K-h+A,t(d,"afterBreaks"),d.staticScale?d.transA=d.staticScale:l.unitLength&&(d.transA*=(H-d.min+A)/l.unitLength),A&&(d.minPixelPadding=d.transA*(d.minPointOffset||0)),d.min=K,d.max=H)}});y(u,!0)&&d.chart.redraw()};return f}();m.Additions=F})(r||(r={}));return r});C(a,"masters/modules/broken-axis.src.js",
[a["Core/Globals.js"],a["Core/Axis/BrokenAxis.js"]],function(a,q){q.compose(a.Axis,a.Series)});C(a,"Extensions/DataGrouping/ApproximationRegistry.js",[],function(){return{}});C(a,"Extensions/DataGrouping/ApproximationDefaults.js",[a["Extensions/DataGrouping/ApproximationRegistry.js"],a["Core/Utilities.js"]],function(a,q){function E(a){var e=a.length;a=v(a);r(a)&&e&&(a=w(a/e));return a}function v(a){var e=a.length;if(!e&&a.hasNulls)var m=null;else if(e)for(m=0;e--;)m+=a[e];return m}var t=q.arrayMax,
B=q.arrayMin,w=q.correctFloat,y=q.extend,r=q.isNumber;q={average:E,averages:function(){var a=[];[].forEach.call(arguments,function(e){a.push(E(e))});return"undefined"===typeof a[0]?void 0:a},close:function(a){return a.length?a[a.length-1]:a.hasNulls?null:void 0},high:function(a){return a.length?t(a):a.hasNulls?null:void 0},hlc:function(m,e,g){m=a.high(m);e=a.low(e);g=a.close(g);if(r(m)||r(e)||r(g))return[m,e,g]},low:function(a){return a.length?B(a):a.hasNulls?null:void 0},ohlc:function(m,e,g,p){m=
a.open(m);e=a.high(e);g=a.low(g);p=a.close(p);if(r(m)||r(e)||r(g)||r(p))return[m,e,g,p]},open:function(a){return a.length?a[0]:a.hasNulls?null:void 0},range:function(m,e){m=a.low(m);e=a.high(e);if(r(m)||r(e))return[m,e];if(null===m&&null===e)return null},sum:v};y(a,q);return q});C(a,"Extensions/DataGrouping/DataGroupingDefaults.js",[],function(){return{common:{groupPixelWidth:2,dateTimeLabelFormats:{millisecond:["%A, %b %e, %H:%M:%S.%L","%A, %b %e, %H:%M:%S.%L","-%H:%M:%S.%L"],second:["%A, %b %e, %H:%M:%S",
"%A, %b %e, %H:%M:%S","-%H:%M:%S"],minute:["%A, %b %e, %H:%M","%A, %b %e, %H:%M","-%H:%M"],hour:["%A, %b %e, %H:%M","%A, %b %e, %H:%M","-%H:%M"],day:["%A, %b %e, %Y","%A, %b %e","-%A, %b %e, %Y"],week:["Week from %A, %b %e, %Y","%A, %b %e","-%A, %b %e, %Y"],month:["%B %Y","%B","-%B %Y"],year:["%Y","%Y","-%Y"]}},seriesSpecific:{line:{},spline:{},area:{},areaspline:{},arearange:{},column:{groupPixelWidth:10},columnrange:{groupPixelWidth:10},candlestick:{groupPixelWidth:10},ohlc:{groupPixelWidth:5},
hlc:{groupPixelWidth:5},heikinashi:{groupPixelWidth:10}},units:[["millisecond",[1,2,5,10,20,25,50,100,200,500]],["second",[1,2,5,10,15,30]],["minute",[1,2,5,10,15,30]],["hour",[1,2,3,4,6,8,12]],["day",[1]],["week",[1]],["month",[1,3,6]],["year",null]]}});C(a,"Extensions/DataGrouping/DataGroupingAxisComposition.js",[a["Extensions/DataGrouping/DataGroupingDefaults.js"],a["Core/Utilities.js"]],function(a,q){function E(a){var c=this,e=c.series;e.forEach(function(f){f.groupPixelWidth=void 0});e.forEach(function(f){f.groupPixelWidth=
c.getGroupPixelWidth&&c.getGroupPixelWidth();f.groupPixelWidth&&(f.hasProcessed=!0);f.applyGrouping(!!a.hasExtremesChanged)})}function v(){for(var e=this.series,c=e.length,r=0,f=!1,D,g;c--;)if(g=e[c].options.dataGrouping)if(r=Math.max(r,m(g.groupPixelWidth,a.common.groupPixelWidth)),D=(e[c].processedXData||e[c].data).length,e[c].groupPixelWidth||D>this.chart.plotSizeX/r||D&&g.forced)f=!0;return f?r:0}function t(){this.series.forEach(function(a){a.hasProcessed=!1})}function B(a,c){var e;c=m(c,!0);
a||(a={forced:!1,units:null});if(this instanceof g)for(e=this.series.length;e--;)this.series[e].update({dataGrouping:a},!1);else this.chart.options.series.forEach(function(f){f.dataGrouping="boolean"===typeof a?a:r(a,f.dataGrouping)});this.ordinal&&(this.ordinal.slope=void 0);c&&this.chart.redraw()}var w=q.addEvent,y=q.extend,r=q.merge,m=q.pick,e=[],g;return{compose:function(a){g=a;-1===e.indexOf(a)&&(e.push(a),w(a,"afterSetScale",t),w(a,"postProcessData",E),y(a.prototype,{applyGrouping:E,getGroupPixelWidth:v,
setDataGrouping:B}))}}});C(a,"Extensions/DataGrouping/DataGroupingSeriesComposition.js",[a["Extensions/DataGrouping/ApproximationRegistry.js"],a["Extensions/DataGrouping/DataGroupingDefaults.js"],a["Core/Axis/DateTimeAxis.js"],a["Core/Defaults.js"],a["Core/Series/SeriesRegistry.js"],a["Core/Utilities.js"]],function(a,q,z,v,t,B){function w(a){var c=this.chart,d=this.options.dataGrouping,h=!1!==this.allowDG&&d&&F(d.enabled,c.options.isStock),b=this.visible||!c.options.chart.ignoreHiddenSeries,n=this.currentDataGrouping,
k=!1;h&&!this.requireSorting&&(this.requireSorting=k=!0);a=!1===!(this.isCartesian&&!this.isDirty&&!this.xAxis.isDirty&&!this.yAxis.isDirty&&!a)||!h;k&&(this.requireSorting=!1);if(!a){this.destroyGroupedData();var A=d.groupAll?this.xData:this.processedXData,M=d.groupAll?this.yData:this.processedYData;h=c.plotSizeX;a=this.xAxis;var N=a.options.ordinal,K=this.groupPixelWidth;k=void 0;if(K&&A&&A.length&&h){this.isDirty=k=!0;this.points=null;var H=a.getExtremes();var e=H.min;H=H.max;N=N&&a.ordinal&&a.ordinal.getGroupIntervalFactor(e,
H,this)||1;h=a.getTimeTicks(z.Additions.prototype.normalizeTimeTickInterval(K*(H-e)/h*N,d.units||q.units),Math.min(e,A[0]),Math.max(H,A[A.length-1]),a.options.startOfWeek,A,this.closestPointRange);K=p.groupData.apply(this,[A,M,h,d.approximation]);A=K.groupedXData;M=K.groupedYData;N=0;d&&d.smoothed&&A.length&&(d.firstAnchor="firstPoint",d.anchor="middle",d.lastAnchor="lastPoint",f(32,!1,c,{"dataGrouping.smoothed":"use dataGrouping.anchor"}));c=A;var D=this.options.dataGrouping;e=this.currentDataGrouping&&
this.currentDataGrouping.gapSize;if(D&&this.xData&&e&&this.groupMap){var I=c.length-1;var r=D.anchor;var u=F(D.firstAnchor,r);D=F(D.lastAnchor,r);if(r&&"start"!==r){var g=e*{middle:.5,end:1}[r];for(r=c.length-1;r--&&0<r;)c[r]+=g}if(u&&"start"!==u&&this.xData[0]>=c[0]){r=this.groupMap[0].start;g=this.groupMap[0].length;var m=void 0;L(r)&&L(g)&&(m=r+(g-1));c[0]={middle:c[0]+.5*e,end:c[0]+e,firstPoint:this.xData[0],lastPoint:m&&this.xData[m]}[u]}D&&"start"!==D&&e&&c[I]>=H-e&&(H=this.groupMap[this.groupMap.length-
1].start,c[I]={middle:c[I]+.5*e,end:c[I]+e,firstPoint:H&&this.xData[H],lastPoint:this.xData[this.xData.length-1]}[D])}for(H=1;H<h.length;H++)h.info.segmentStarts&&-1!==h.info.segmentStarts.indexOf(H)||(N=Math.max(h[H]-h[H-1],N));H=h.info;H.gapSize=N;this.closestPointRange=h.info.totalRange;this.groupMap=K.groupMap;if(b){b=A;if(J(b[0])&&L(a.min)&&L(a.dataMin)&&b[0]<a.min){if(!J(a.options.min)&&a.min<=a.dataMin||a.min===a.dataMin)a.min=Math.min(b[0],a.min);a.dataMin=Math.min(b[0],a.dataMin)}if(J(b[b.length-
1])&&L(a.max)&&L(a.dataMax)&&b[b.length-1]>a.max){if(!J(a.options.max)&&L(a.dataMax)&&a.max>=a.dataMax||a.max===a.dataMax)a.max=Math.max(b[b.length-1],a.max);a.dataMax=Math.max(b[b.length-1],a.dataMax)}}d.groupAll&&(this.allGroupedData=M,d=this.cropData(A,M,a.min,a.max,1),A=d.xData,M=d.yData,this.cropStart=d.start);this.processedXData=A;this.processedYData=M}else this.groupMap=null;this.hasGroupedData=k;this.currentDataGrouping=H;this.preventGraphAnimation=(n&&n.totalRange)!==(H&&H.totalRange)}}function y(){this.groupedData&&
(this.groupedData.forEach(function(a,f){a&&(this.groupedData[f]=a.destroy?a.destroy():null)},this),this.groupedData.length=0)}function r(){x.apply(this);this.destroyGroupedData();this.groupedData=this.hasGroupedData?this.points:null}function m(){return this.is("arearange")?"range":this.is("ohlc")?"ohlc":this.is("hlc")?"hlc":this.is("column")?"sum":"average"}function e(f,c,d,h){var b=this,n=b.data,k=b.options&&b.options.data,A=[],M=[],N=[],K=f.length,H=!!c,l=[],e=b.pointArrayMap,I=e&&e.length,r=["x"].concat(e||
["y"]),D=this.options.dataGrouping&&this.options.dataGrouping.groupAll,g=0,u=0;h="function"===typeof h?h:h&&a[h]?a[h]:a[b.getDGApproximation&&b.getDGApproximation()||"average"];if(I)for(var m=e.length;m--;)l.push([]);else l.push([]);m=I||1;for(var p=0;p<=K;p++)if(!(f[p]<d[0])){for(;"undefined"!==typeof d[g+1]&&f[p]>=d[g+1]||p===K;){var x=d[g];b.dataGroupInfo={start:D?u:b.cropStart+u,length:l[0].length};var w=h.apply(b,l);b.pointClass&&!J(b.dataGroupInfo.options)&&(b.dataGroupInfo.options=E(b.pointClass.prototype.optionsToObject.call({series:b},
b.options.data[b.cropStart+u])),r.forEach(function(n){delete b.dataGroupInfo.options[n]}));"undefined"!==typeof w&&(A.push(x),M.push(w),N.push(b.dataGroupInfo));u=p;for(x=0;x<m;x++)l[x].length=0,l[x].hasNulls=!1;g+=1;if(p===K)break}if(p===K)break;if(e){x=b.options.dataGrouping&&b.options.dataGrouping.groupAll?p:b.cropStart+p;w=n&&n[x]||b.pointClass.prototype.applyOptions.apply({series:b},[k[x]]);var q=void 0;for(x=0;x<I;x++)q=w[e[x]],L(q)?l[x].push(q):null===q&&(l[x].hasNulls=!0)}else x=H?c[p]:null,
L(x)?l[0].push(x):null===x&&(l[0].hasNulls=!0)}return{groupedXData:A,groupedYData:M,groupMap:N}}function g(a){a=a.options;var f=this.type,d=this.chart.options.plotOptions,h=this.useCommonDataGrouping&&q.common,b=q.seriesSpecific,n=v.defaultOptions.plotOptions[f].dataGrouping;if(d&&(b[f]||h)){var k=this.chart.rangeSelector;n||(n=E(q.common,b[f]));a.dataGrouping=E(h,n,d.series&&d.series.dataGrouping,d[f].dataGrouping,this.userOptions.dataGrouping,!a.isInternal&&k&&L(k.selected)&&k.buttonOptions[k.selected].dataGrouping)}}
var p=t.series.prototype,c=B.addEvent,J=B.defined,f=B.error,D=B.extend,L=B.isNumber,E=B.merge,F=B.pick,x=p.generatePoints,G=[];return{compose:function(a){var l=a.prototype.pointClass;-1===G.indexOf(l)&&(G.push(l),c(l,"update",function(){if(this.dataGroup)return f(24,!1,this.series.chart),!1}));-1===G.indexOf(a)&&(G.push(a),c(a,"afterSetOptions",g),c(a,"destroy",y),D(a.prototype,{applyGrouping:w,destroyGroupedData:y,generatePoints:r,getDGApproximation:m,groupData:e}))},groupData:e}});C(a,"Extensions/DataGrouping/DataGrouping.js",
[a["Extensions/DataGrouping/DataGroupingAxisComposition.js"],a["Extensions/DataGrouping/DataGroupingDefaults.js"],a["Extensions/DataGrouping/DataGroupingSeriesComposition.js"],a["Core/FormatUtilities.js"],a["Core/Utilities.js"]],function(a,q,z,v,t){function B(a){var e=this.chart,c=e.time,g=a.labelConfig,f=g.series,D=f.tooltipOptions,L=f.options.dataGrouping,v=f.xAxis,F=D.xDateFormat,x=D[a.isFooter?"footerFormat":"headerFormat"];if(v&&"datetime"===v.options.type&&L&&m(g.key)){var t=f.currentDataGrouping;
L=L.dateTimeLabelFormats||q.common.dateTimeLabelFormats;if(t)if(D=L[t.unitName],1===t.count)F=D[0];else{F=D[1];var u=D[2]}else!F&&L&&v.dateTime&&(F=v.dateTime.getXDateFormat(g.x,D.dateTimeLabelFormats));F=c.dateFormat(F,g.key);u&&(F+=c.dateFormat(u,g.key+t.totalRange-1));f.chart.styledMode&&(x=this.styledModeFormat(x));a.text=w(x,{point:r(g.point,{key:F}),series:f},e);a.preventDefault()}}var w=v.format,y=t.addEvent,r=t.extend,m=t.isNumber,e=[];v={compose:function(r,m,c){a.compose(r);z.compose(m);
-1===e.indexOf(c)&&(e.push(c),y(c,"headerFormatter",B))},groupData:z.groupData};"";"";return v});C(a,"masters/modules/datagrouping.src.js",[a["Core/Globals.js"],a["Extensions/DataGrouping/ApproximationDefaults.js"],a["Extensions/DataGrouping/ApproximationRegistry.js"],a["Extensions/DataGrouping/DataGrouping.js"]],function(a,q,z,v){a.dataGrouping={approximationDefaults:q,approximations:z};v.compose(a.Axis,a.Series,a.Tooltip)});C(a,"Series/DataModifyComposition.js",[a["Core/Axis/Axis.js"],a["Core/Series/Point.js"],
a["Core/Series/Series.js"],a["Core/Utilities.js"]],function(a,q,z,v){var t=q.prototype.tooltipFormatter,B=v.addEvent,w=v.arrayMax,y=v.arrayMin,r=v.correctFloat,m=v.defined,e=v.isArray,g=v.isNumber,p=v.isString,c=v.pick,J;(function(a){function f(b,k,d){this.isXAxis||(this.series.forEach(function(n){"compare"===b&&"boolean"!==typeof k?n.setCompare(k,!1):"cumulative"!==b||p(k)||n.setCumulative(k,!1)}),c(d,!0)&&this.chart.redraw())}function L(b){var n=this,d=n.series.chart.numberFormatter,h=function(k){b=
b.replace("{point."+k+"}",(0<n[k]&&"change"===k?"+":"")+d(n[k],c(n.series.tooltipOptions.changeDecimals,2)))};m(n.change)&&h("change");m(n.cumulativeSum)&&h("cumulativeSum");return t.apply(this,[b])}function J(){var n=this.options.compare;if("percent"===n||"value"===n||this.options.cumulative){var k=new b(this);"percent"===n||"value"===n?k.initCompare(n):k.initCumulative()}this.dataModify=k}function q(n){n=n.dataExtremes;var k=n.activeYData;if(this.dataModify&&n){var d=void 0;this.options.compare?
d=[this.dataModify.modifyValue(n.dataMin),this.dataModify.modifyValue(n.dataMax)]:this.options.cumulative&&e(k)&&2<=k.length&&(d=b.getCumulativeExtremes(k));d&&(n.dataMin=y(d),n.dataMax=w(d))}}function x(b,k){this.options.compare=this.userOptions.compare=b;this.update({},c(k,!0));!this.dataModify||"value"!==b&&"percent"!==b?this.points.forEach(function(b){delete b.change}):this.dataModify.initCompare(b)}function v(){if(this.xAxis&&this.processedYData&&this.dataModify){var b=this.processedXData,k=
this.processedYData,d=k.length,h=!0===this.options.compareStart?0:1,a=-1,f;this.pointArrayMap&&(a=this.pointArrayMap.indexOf(this.options.pointValKey||this.pointValKey||"y"));for(f=0;f<d-h;f++){var c=k[f]&&-1<a?k[f][a]:k[f];if(g(c)&&0!==c&&b[f+h]>=(this.xAxis.min||0)){this.dataModify.compareValue=c;break}}}}function u(b,k){this.setModifier("compare",b,k)}function l(b,k){b=c(b,!1);this.options.cumulative=this.userOptions.cumulative=b;this.update({},c(k,!0));this.dataModify?this.dataModify.initCumulative():
this.points.forEach(function(b){delete b.cumulativeSum})}function d(b,k){this.setModifier("cumulative",b,k)}var h=[];a.compose=function(b,k,A){if(-1===h.indexOf(b)){h.push(b);var n=b.prototype;n.setCompare=x;n.setCumulative=l;B(b,"afterInit",J);B(b,"afterGetExtremes",q);B(b,"afterProcessData",v)}-1===h.indexOf(k)&&(h.push(k),k=k.prototype,k.setCompare=u,k.setModifier=f,k.setCumulative=d);-1===h.indexOf(A)&&(h.push(A),A.prototype.tooltipFormatter=L);return b};var b=function(){function b(b){this.series=
b}b.prototype.modifyValue=function(){return 0};b.getCumulativeExtremes=function(b){var n=Infinity,k=-Infinity;b.reduce(function(b,d){d=b+d;n=Math.min(n,d,b);k=Math.max(k,d,b);return d});return[n,k]};b.prototype.initCompare=function(b){this.modifyValue=function(n,k){null===n&&(n=0);var d=this.compareValue;return"undefined"!==typeof n&&"undefined"!==typeof d?(n="value"===b?n-d:n/d*100-(100===this.series.options.compareBase?0:100),"undefined"!==typeof k&&(k=this.series.points[k])&&(k.change=n),n):0}};
b.prototype.initCumulative=function(){this.modifyValue=function(b,n){null===b&&(b=0);if(void 0!==b&&void 0!==n){var k=0<n?this.series.points[n-1]:null;k&&k.cumulativeSum&&(b=r(k.cumulativeSum+b));if(n=this.series.points[n])n.cumulativeSum=b;return b}return 0}};return b}();a.Additions=b})(J||(J={}));"";return J});C(a,"Core/Axis/NavigatorAxisComposition.js",[a["Core/Globals.js"],a["Core/Utilities.js"]],function(a,q){function E(){this.navigatorAxis||(this.navigatorAxis=new g(this))}function v(a){var c=
this.chart.options,e=c.navigator,f=this.navigatorAxis,r=c.chart.zooming.pinchType,g=c.rangeSelector;c=c.chart.zooming.type;this.isXAxis&&(e&&e.enabled||g&&g.enabled)&&("y"===c?a.zoomed=!1:(!t&&"xy"===c||t&&"xy"===r)&&this.options.range&&(e=f.previousZoom,y(a.newMin)?f.previousZoom=[this.min,this.max]:e&&(a.newMin=e[0],a.newMax=e[1],f.previousZoom=void 0)));"undefined"!==typeof a.zoomed&&a.preventDefault()}var t=a.isTouchDevice,B=q.addEvent,w=q.correctFloat,y=q.defined,r=q.isNumber,m=q.pick,e=[],g=
function(){function a(a){this.axis=a}a.compose=function(a){-1===e.indexOf(a)&&(e.push(a),a.keepProps.push("navigatorAxis"),B(a,"init",E),B(a,"zoom",v))};a.prototype.destroy=function(){this.axis=void 0};a.prototype.toFixedRange=function(a,e,f,D){var c=this.axis,g=c.chart;a=m(f,c.translate(a,!0,!c.horiz));e=m(D,c.translate(e,!0,!c.horiz));g=g&&g.fixedRange;c=(c.pointRange||0)/2;var p=g&&(e-a)/g;y(f)||(a=w(a+c));y(D)||(e=w(e-c));.7<p&&1.3>p&&(D?a=e-g:e=a+g);r(a)&&r(e)||(a=e=void 0);return{min:a,max:e}};
return a}();return g});C(a,"Stock/Navigator/NavigatorDefaults.js",[a["Core/Color/Color.js"],a["Core/Series/SeriesRegistry.js"]],function(a,q){a=a.parse;q=q.seriesTypes;q={height:40,margin:25,maskInside:!0,handles:{width:7,height:15,symbols:["navigator-handle","navigator-handle"],enabled:!0,lineWidth:1,backgroundColor:"#f2f2f2",borderColor:"#999999"},maskFill:a("#6685c2").setOpacity(.3).get(),outlineColor:"#cccccc",outlineWidth:1,series:{type:"undefined"===typeof q.areaspline?"line":"areaspline",fillOpacity:.05,
lineWidth:1,compare:null,dataGrouping:{approximation:"average",enabled:!0,groupPixelWidth:2,firstAnchor:"firstPoint",anchor:"middle",lastAnchor:"lastPoint",units:[["millisecond",[1,2,5,10,20,25,50,100,200,500]],["second",[1,2,5,10,15,30]],["minute",[1,2,5,10,15,30]],["hour",[1,2,3,4,6,8,12]],["day",[1,2,3,4]],["week",[1,2,3]],["month",[1,3,6]],["year",null]]},dataLabels:{enabled:!1,zIndex:2},id:"highcharts-navigator-series",className:"highcharts-navigator-series",lineColor:null,marker:{enabled:!1},
threshold:null},xAxis:{overscroll:0,className:"highcharts-navigator-xaxis",tickLength:0,lineWidth:0,gridLineColor:"#e6e6e6",gridLineWidth:1,tickPixelInterval:200,labels:{align:"left",style:{color:"#999999"},x:3,y:-4},crosshair:!1},yAxis:{className:"highcharts-navigator-yaxis",gridLineWidth:0,startOnTick:!1,endOnTick:!1,minPadding:.1,maxPadding:.1,labels:{enabled:!1},crosshair:!1,title:{text:null},tickLength:0,tickWidth:0}};"";return q});C(a,"Stock/Navigator/NavigatorSymbols.js",[],function(){return{"navigator-handle":function(a,
q,z,v,t){void 0===t&&(t={});a=t.width?t.width/2:z;q=Math.round(a/3)+.5;v=t.height||v;return[["M",-a-1,.5],["L",a,.5],["L",a,v+.5],["L",-a-1,v+.5],["L",-a-1,.5],["M",-q,4],["L",-q,v-3],["M",q-1,4],["L",q-1,v-3]]}}});C(a,"Stock/Navigator/NavigatorComposition.js",[a["Core/Defaults.js"],a["Core/Globals.js"],a["Core/Axis/NavigatorAxisComposition.js"],a["Stock/Navigator/NavigatorDefaults.js"],a["Stock/Navigator/NavigatorSymbols.js"],a["Core/Renderer/RendererRegistry.js"],a["Core/Utilities.js"]],function(a,
q,z,v,t,B,w){function y(){this.navigator&&this.navigator.setBaseSeries(null,!1)}function r(){var d=this.legend,b=this.navigator;if(b){var n=d&&d.options;var k=b.xAxis;var a=b.yAxis;var f=b.scrollbarHeight;this.inverted?(b.left=b.opposite?this.chartWidth-f-b.height:this.spacing[3]+f,b.top=this.plotTop+f):(b.left=u(k.left,this.plotLeft+f),b.top=b.navigatorOptions.top||this.chartHeight-b.height-f-this.spacing[2]-(this.rangeSelector&&this.extraBottomMargin?this.rangeSelector.getHeight():0)-(n&&"bottom"===
n.verticalAlign&&"proximate"!==n.layout&&n.enabled&&!n.floating?d.legendHeight+u(n.margin,10):0)-(this.titleOffset?this.titleOffset[2]:0));k&&a&&(this.inverted?k.options.left=a.options.left=b.left:k.options.top=a.options.top=b.top,k.setAxisSize(),a.setAxisSize())}}function m(a){this.navigator||this.scroller||!this.options.navigator.enabled&&!this.options.scrollbar.enabled||(this.scroller=this.navigator=new d(this),u(a.redraw,!0)&&this.redraw(a.animation))}function e(){var a=this.options;if(a.navigator.enabled||
a.scrollbar.enabled)this.scroller=this.navigator=new d(this)}function g(){var d=this.options,b=d.navigator,n=d.rangeSelector;if((b&&b.enabled||n&&n.enabled)&&(!L&&"x"===d.chart.zooming.type||L&&"x"===d.chart.zooming.pinchType))return!1}function p(d){var b=d.navigator;b&&d.xAxis[0]&&(d=d.xAxis[0].getExtremes(),b.render(d.min,d.max))}function c(d){var b=d.options.navigator||{},n=d.options.scrollbar||{};this.navigator||this.scroller||!b.enabled&&!n.enabled||(G(!0,this.options.navigator,b),G(!0,this.options.scrollbar,
n),delete d.options.navigator,delete d.options.scrollbar)}function J(){this.chart.navigator&&!this.options.isInternal&&this.chart.navigator.setBaseSeries(null,!1)}var f=a.defaultOptions,D=a.setOptions,L=q.isTouchDevice,E=B.getRendererType,F=w.addEvent,x=w.extend,G=w.merge,u=w.pick,l=[],d;return{compose:function(a,b,n,k){z.compose(a);d=n;-1===l.indexOf(b)&&(l.push(b),b.prototype.callbacks.push(p),F(b,"afterAddSeries",y),F(b,"afterSetChartSize",r),F(b,"afterUpdate",m),F(b,"beforeRender",e),F(b,"beforeShowResetZoom",
g),F(b,"update",c));-1===l.indexOf(k)&&(l.push(k),F(k,"afterUpdate",J));-1===l.indexOf(E)&&(l.push(E),x(E().prototype.symbols,t));-1===l.indexOf(D)&&(l.push(D),x(f,{navigator:v}))}}});C(a,"Core/Axis/ScrollbarAxis.js",[a["Core/Utilities.js"]],function(a){var q=a.addEvent,z=a.defined,v=a.pick;return function(){function a(){}a.compose=function(t,w){if(-1===a.composed.indexOf(t))a.composed.push(t);else return t;var y=function(a){var r=v(a.options&&a.options.min,a.min),e=v(a.options&&a.options.max,a.max);
return{axisMin:r,axisMax:e,scrollMin:z(a.dataMin)?Math.min(r,a.min,a.dataMin,v(a.threshold,Infinity)):r,scrollMax:z(a.dataMax)?Math.max(e,a.max,a.dataMax,v(a.threshold,-Infinity)):e}};q(t,"afterInit",function(){var a=this;a.options&&a.options.scrollbar&&a.options.scrollbar.enabled&&(a.options.scrollbar.vertical=!a.horiz,a.options.startOnTick=a.options.endOnTick=!1,a.scrollbar=new w(a.chart.renderer,a.options.scrollbar,a.chart),q(a.scrollbar,"changed",function(r){var e=y(a),g=e.axisMax,m=e.scrollMin,
c=e.scrollMax-m;z(e.axisMin)&&z(g)&&(a.horiz&&!a.reversed||!a.horiz&&a.reversed?(e=m+c*this.to,m+=c*this.from):(e=m+c*(1-this.from),m+=c*(1-this.to)),this.shouldUpdateExtremes(r.DOMType)?a.setExtremes(m,e,!0,"mousemove"!==r.DOMType&&"touchmove"!==r.DOMType,r):this.setRange(this.from,this.to))}))});q(t,"afterRender",function(){var a=y(this),m=a.scrollMin,e=a.scrollMax;a=this.scrollbar;var g=this.axisTitleMargin+(this.titleOffset||0),p=this.chart.scrollbarsOffsets,c=this.options.margin||0;a&&(this.horiz?
(this.opposite||(p[1]+=g),a.position(this.left,this.top+this.height+2+p[1]-(this.opposite?c:0),this.width,this.height),this.opposite||(p[1]+=c),g=1):(this.opposite&&(p[0]+=g),a.position(a.options.opposite?this.left+this.width+2+p[0]-(this.opposite?0:c):this.opposite?0:c,this.top,this.width,this.height),this.opposite&&(p[0]+=c),g=0),p[g]+=a.size+a.options.margin,isNaN(m)||isNaN(e)||!z(this.min)||!z(this.max)||this.min===this.max?a.setRange(0,1):(p=(this.min-m)/(e-m),m=(this.max-m)/(e-m),this.horiz&&
!this.reversed||!this.horiz&&this.reversed?a.setRange(p,m):a.setRange(1-m,1-p)))});q(t,"afterGetOffset",function(){var a=this.scrollbar&&!this.scrollbar.options.opposite;a=this.horiz?2:a?3:1;var m=this.scrollbar;m&&(this.chart.scrollbarsOffsets=[0,0],this.chart.axisOffset[a]+=m.size+m.options.margin)});return t};a.composed=[];return a}()});C(a,"Stock/Scrollbar/ScrollbarDefaults.js",[a["Core/Globals.js"]],function(a){return{height:a.isTouchDevice?20:14,barBorderRadius:0,buttonBorderRadius:0,liveRedraw:void 0,
margin:10,minWidth:6,opposite:!0,step:.2,zIndex:3,barBackgroundColor:"#cccccc",barBorderWidth:1,barBorderColor:"#cccccc",buttonArrowColor:"#333333",buttonBackgroundColor:"#e6e6e6",buttonBorderColor:"#cccccc",buttonBorderWidth:1,rifleColor:"#333333",trackBackgroundColor:"#f2f2f2",trackBorderColor:"#f2f2f2",trackBorderWidth:1}});C(a,"Stock/Scrollbar/Scrollbar.js",[a["Core/Defaults.js"],a["Core/Globals.js"],a["Core/Axis/ScrollbarAxis.js"],a["Stock/Scrollbar/ScrollbarDefaults.js"],a["Core/Utilities.js"]],
function(a,q,z,v,t){var B=a.defaultOptions,w=t.addEvent,y=t.correctFloat,r=t.defined,m=t.destroyObjectProperties,e=t.fireEvent,g=t.merge,p=t.pick,c=t.removeEvent;a=function(){function a(a,c,e){this._events=[];this.chart=void 0;this.from=this.chartY=this.chartX=0;this.scrollbar=this.renderer=this.options=this.group=void 0;this.scrollbarButtons=[];this.scrollbarGroup=void 0;this.scrollbarLeft=0;this.scrollbarRifles=void 0;this.scrollbarStrokeWidth=1;this.to=this.size=this.scrollbarTop=0;this.track=
void 0;this.trackBorderWidth=1;this.userOptions=void 0;this.y=this.x=0;this.init(a,c,e)}a.compose=function(f){z.compose(f,a)};a.swapXY=function(a,c){c&&a.forEach(function(a){for(var f=a.length,c,e=0;e<f;e+=2)c=a[e+1],"number"===typeof c&&(a[e+1]=a[e+2],a[e+2]=c)});return a};a.prototype.addEvents=function(){var a=this.options.inverted?[1,0]:[0,1],c=this.scrollbarButtons,e=this.scrollbarGroup.element,g=this.track.element,m=this.mouseDownHandler.bind(this),x=this.mouseMoveHandler.bind(this),r=this.mouseUpHandler.bind(this);
a=[[c[a[0]].element,"click",this.buttonToMinClick.bind(this)],[c[a[1]].element,"click",this.buttonToMaxClick.bind(this)],[g,"click",this.trackClick.bind(this)],[e,"mousedown",m],[e.ownerDocument,"mousemove",x],[e.ownerDocument,"mouseup",r]];q.hasTouch&&a.push([e,"touchstart",m],[e.ownerDocument,"touchmove",x],[e.ownerDocument,"touchend",r]);a.forEach(function(a){w.apply(null,a)});this._events=a};a.prototype.buttonToMaxClick=function(a){var f=(this.to-this.from)*p(this.options.step,.2);this.updatePosition(this.from+
f,this.to+f);e(this,"changed",{from:this.from,to:this.to,trigger:"scrollbar",DOMEvent:a})};a.prototype.buttonToMinClick=function(a){var f=y(this.to-this.from)*p(this.options.step,.2);this.updatePosition(y(this.from-f),y(this.to-f));e(this,"changed",{from:this.from,to:this.to,trigger:"scrollbar",DOMEvent:a})};a.prototype.cursorToScrollbarPosition=function(a){var f=this.options;f=f.minWidth>this.calculatedWidth?f.minWidth:0;return{chartX:(a.chartX-this.x-this.xOffset)/(this.barWidth-f),chartY:(a.chartY-
this.y-this.yOffset)/(this.barWidth-f)}};a.prototype.destroy=function(){var a=this,c=a.chart.scroller;a.removeEvents();["track","scrollbarRifles","scrollbar","scrollbarGroup","group"].forEach(function(f){a[f]&&a[f].destroy&&(a[f]=a[f].destroy())});c&&a===c.scrollbar&&(c.scrollbar=null,m(c.scrollbarButtons))};a.prototype.drawScrollbarButton=function(f){var c=this.renderer,e=this.scrollbarButtons,g=this.options,m=this.size,x=c.g().add(this.group);e.push(x);x=c.rect().addClass("highcharts-scrollbar-button").add(x);
this.chart.styledMode||x.attr({stroke:g.buttonBorderColor,"stroke-width":g.buttonBorderWidth,fill:g.buttonBackgroundColor});x.attr(x.crisp({x:-.5,y:-.5,width:m+1,height:m+1,r:g.buttonBorderRadius},x.strokeWidth()));x=c.path(a.swapXY([["M",m/2+(f?-1:1),m/2-3],["L",m/2+(f?-1:1),m/2+3],["L",m/2+(f?2:-2),m/2]],g.vertical)).addClass("highcharts-scrollbar-arrow").add(e[f]);this.chart.styledMode||x.attr({fill:g.buttonArrowColor})};a.prototype.init=function(a,c,e){this.scrollbarButtons=[];this.renderer=a;
this.userOptions=c;this.options=g(v,B.scrollbar,c);this.chart=e;this.size=p(this.options.size,this.options.height);c.enabled&&(this.render(),this.addEvents())};a.prototype.mouseDownHandler=function(a){a=this.chart.pointer.normalize(a);a=this.cursorToScrollbarPosition(a);this.chartX=a.chartX;this.chartY=a.chartY;this.initPositions=[this.from,this.to];this.grabbedCenter=!0};a.prototype.mouseMoveHandler=function(a){var c=this.chart.pointer.normalize(a),f=this.options.vertical?"chartY":"chartX",g=this.initPositions||
[];!this.grabbedCenter||a.touches&&0===a.touches[0][f]||(c=this.cursorToScrollbarPosition(c)[f],f=this[f],f=c-f,this.hasDragged=!0,this.updatePosition(g[0]+f,g[1]+f),this.hasDragged&&e(this,"changed",{from:this.from,to:this.to,trigger:"scrollbar",DOMType:a.type,DOMEvent:a}))};a.prototype.mouseUpHandler=function(a){this.hasDragged&&e(this,"changed",{from:this.from,to:this.to,trigger:"scrollbar",DOMType:a.type,DOMEvent:a});this.grabbedCenter=this.hasDragged=this.chartX=this.chartY=null};a.prototype.position=
function(a,c,e,g){var f=this.options.vertical,m=this.rendered?"animate":"attr",r=g,u=0;this.group.show();this.x=a;this.y=c+this.trackBorderWidth;this.width=e;this.height=g;this.xOffset=r;this.yOffset=u;f?(this.width=this.yOffset=e=u=this.size,this.xOffset=r=0,this.barWidth=g-2*e,this.x=a+=this.options.margin):(this.height=this.xOffset=g=r=this.size,this.barWidth=e-2*g,this.y+=this.options.margin);this.group[m]({translateX:a,translateY:this.y});this.track[m]({width:e,height:g});this.scrollbarButtons[1][m]({translateX:f?
0:e-r,translateY:f?g-u:0})};a.prototype.removeEvents=function(){this._events.forEach(function(a){c.apply(null,a)});this._events.length=0};a.prototype.render=function(){var c=this.renderer,e=this.options,g=this.size,m=this.chart.styledMode,r=c.g("scrollbar").attr({zIndex:e.zIndex}).hide().add();this.group=r;this.track=c.rect().addClass("highcharts-scrollbar-track").attr({x:0,r:e.trackBorderRadius||0,height:g,width:g}).add(r);m||this.track.attr({fill:e.trackBackgroundColor,stroke:e.trackBorderColor,
"stroke-width":e.trackBorderWidth});this.trackBorderWidth=this.track.strokeWidth();this.track.attr({y:-this.trackBorderWidth%2/2});this.scrollbarGroup=c.g().add(r);this.scrollbar=c.rect().addClass("highcharts-scrollbar-thumb").attr({height:g,width:g,r:e.barBorderRadius||0}).add(this.scrollbarGroup);this.scrollbarRifles=c.path(a.swapXY([["M",-3,g/4],["L",-3,2*g/3],["M",0,g/4],["L",0,2*g/3],["M",3,g/4],["L",3,2*g/3]],e.vertical)).addClass("highcharts-scrollbar-rifles").add(this.scrollbarGroup);m||(this.scrollbar.attr({fill:e.barBackgroundColor,
stroke:e.barBorderColor,"stroke-width":e.barBorderWidth}),this.scrollbarRifles.attr({stroke:e.rifleColor,"stroke-width":1}));this.scrollbarStrokeWidth=this.scrollbar.strokeWidth();this.scrollbarGroup.translate(-this.scrollbarStrokeWidth%2/2,-this.scrollbarStrokeWidth%2/2);this.drawScrollbarButton(0);this.drawScrollbarButton(1)};a.prototype.setRange=function(a,c){var e=this.options,f=e.vertical,g=e.minWidth,m=this.barWidth,p=!this.rendered||this.hasDragged||this.chart.navigator&&this.chart.navigator.hasDragged?
"attr":"animate";if(r(m)){var u=m*Math.min(c,1);a=Math.max(a,0);var l=Math.ceil(m*a);this.calculatedWidth=u=y(u-l);u<g&&(l=(m-g+u)*a,u=g);g=Math.floor(l+this.xOffset+this.yOffset);m=u/2-.5;this.from=a;this.to=c;f?(this.scrollbarGroup[p]({translateY:g}),this.scrollbar[p]({height:u}),this.scrollbarRifles[p]({translateY:m}),this.scrollbarTop=g,this.scrollbarLeft=0):(this.scrollbarGroup[p]({translateX:g}),this.scrollbar[p]({width:u}),this.scrollbarRifles[p]({translateX:m}),this.scrollbarLeft=g,this.scrollbarTop=
0);12>=u?this.scrollbarRifles.hide():this.scrollbarRifles.show();!1===e.showFull&&(0>=a&&1<=c?this.group.hide():this.group.show());this.rendered=!0}};a.prototype.shouldUpdateExtremes=function(a){return p(this.options.liveRedraw,q.svg&&!q.isTouchDevice&&!this.chart.boosted)||"mouseup"===a||"touchend"===a||!r(a)};a.prototype.trackClick=function(a){var c=this.chart.pointer.normalize(a),f=this.to-this.from,g=this.y+this.scrollbarTop,m=this.x+this.scrollbarLeft;this.options.vertical&&c.chartY>g||!this.options.vertical&&
c.chartX>m?this.updatePosition(this.from+f,this.to+f):this.updatePosition(this.from-f,this.to-f);e(this,"changed",{from:this.from,to:this.to,trigger:"scrollbar",DOMEvent:a})};a.prototype.update=function(a){this.destroy();this.init(this.chart.renderer,g(!0,this.options,a),this.chart)};a.prototype.updatePosition=function(a,c){1<c&&(a=y(1-y(c-a)),c=1);0>a&&(c=y(c-a),a=0);this.from=a;this.to=c};a.defaultOptions=v;return a}();B.scrollbar=g(!0,a.defaultOptions,B.scrollbar);return a});C(a,"Stock/Navigator/Navigator.js",
[a["Core/Axis/Axis.js"],a["Core/Defaults.js"],a["Core/Globals.js"],a["Core/Axis/NavigatorAxisComposition.js"],a["Stock/Navigator/NavigatorComposition.js"],a["Stock/Scrollbar/Scrollbar.js"],a["Core/Utilities.js"]],function(a,q,z,v,t,B,w){function y(a){for(var b=[],n=1;n<arguments.length;n++)b[n-1]=arguments[n];b=[].filter.call(b,x);if(b.length)return Math[a].apply(0,b)}var r=q.defaultOptions,m=z.hasTouch,e=z.isTouchDevice,g=w.addEvent,p=w.clamp,c=w.correctFloat,J=w.defined,f=w.destroyObjectProperties,
D=w.erase,E=w.extend,C=w.find,F=w.isArray,x=w.isNumber,G=w.merge,u=w.pick,l=w.removeEvent,d=w.splat;return function(){function h(b){this.zoomedMin=this.zoomedMax=this.yAxis=this.xAxis=this.top=this.size=this.shades=this.rendered=this.range=this.outlineHeight=this.outline=this.opposite=this.navigatorSize=this.navigatorSeries=this.navigatorOptions=this.navigatorGroup=this.navigatorEnabled=this.left=this.height=this.handles=this.chart=this.baseSeries=void 0;this.init(b)}h.compose=function(b,a,k){t.compose(b,
a,h,k)};h.prototype.drawHandle=function(b,a,k,d){var n=this.navigatorOptions.handles.height;this.handles[a][d](k?{translateX:Math.round(this.left+this.height/2),translateY:Math.round(this.top+parseInt(b,10)+.5-n)}:{translateX:Math.round(this.left+parseInt(b,10)),translateY:Math.round(this.top+this.height/2-n/2-1)})};h.prototype.drawOutline=function(b,a,k,d){var n=this.navigatorOptions.maskInside,h=this.outline.strokeWidth(),A=h/2,c=h%2/2;h=this.outlineHeight;var e=this.scrollbarHeight||0,f=this.size,
l=this.left-e,g=this.top;k?(l-=A,k=g+a+c,a=g+b+c,c=[["M",l+h,g-e-c],["L",l+h,k],["L",l,k],["L",l,a],["L",l+h,a],["L",l+h,g+f+e]],n&&c.push(["M",l+h,k-A],["L",l+h,a+A])):(b+=l+e-c,a+=l+e-c,g+=A,c=[["M",l,g],["L",b,g],["L",b,g+h],["L",a,g+h],["L",a,g],["L",l+f+2*e,g]],n&&c.push(["M",b-A,g],["L",a+A,g]));this.outline[d]({d:c})};h.prototype.drawMasks=function(b,a,k,d){var n=this.left,h=this.top,A=this.height;if(k){var c=[n,n,n];var e=[h,h+b,h+a];var f=[A,A,A];var l=[b,a-b,this.size-a]}else c=[n,n+b,n+
a],e=[h,h,h],f=[b,a-b,this.size-a],l=[A,A,A];this.shades.forEach(function(b,a){b[d]({x:c[a],y:e[a],width:f[a],height:l[a]})})};h.prototype.renderElements=function(){var b=this,a=b.navigatorOptions,d=a.maskInside,h=b.chart,c=h.renderer,e={cursor:h.inverted?"ns-resize":"ew-resize"},f=b.navigatorGroup=c.g("navigator").attr({zIndex:8,visibility:"hidden"}).add();[!d,d,!d].forEach(function(n,d){var k=c.rect().addClass("highcharts-navigator-mask"+(1===d?"-inside":"-outside")).add(f);h.styledMode||(k.attr({fill:n?
a.maskFill:"rgba(0,0,0,0)"}),1===d&&k.css(e));b.shades[d]=k});b.outline=c.path().addClass("highcharts-navigator-outline").add(f);h.styledMode||b.outline.attr({"stroke-width":a.outlineWidth,stroke:a.outlineColor});if(a.handles&&a.handles.enabled){var l=a.handles,g=l.height,m=l.width;[0,1].forEach(function(a){b.handles[a]=c.symbol(l.symbols[a],-m/2-1,0,m,g,l);h.inverted&&b.handles[a].attr({rotation:90,rotationOriginX:Math.floor(-m/2),rotationOriginY:(g+m)/2});b.handles[a].attr({zIndex:7-a}).addClass("highcharts-navigator-handle highcharts-navigator-handle-"+
["left","right"][a]).add(f);h.styledMode||b.handles[a].attr({fill:l.backgroundColor,stroke:l.borderColor,"stroke-width":l.lineWidth}).css(e)})}};h.prototype.update=function(b){(this.series||[]).forEach(function(b){b.baseSeries&&delete b.baseSeries.navigatorSeries});this.destroy();G(!0,this.chart.options.navigator,b);this.init(this.chart)};h.prototype.render=function(b,a,d,h){var n=this.chart,k=this.xAxis,A=k.pointRange||0,e=k.navigatorAxis.fake?n.xAxis[0]:k,f=this.navigatorEnabled,l=this.rendered,
g=n.inverted,m=n.xAxis[0].minRange,r=n.xAxis[0].options.maxRange,w=this.scrollbarHeight,q;if(!this.hasDragged||J(d)){b=c(b-A/2);a=c(a+A/2);if(!x(b)||!x(a))if(l)d=0,h=u(k.width,e.width);else return;this.left=u(k.left,n.plotLeft+w+(g?n.plotWidth:0));var v=this.size=q=u(k.len,(g?n.plotHeight:n.plotWidth)-2*w);n=g?w:q+2*w;d=u(d,k.toPixels(b,!0));h=u(h,k.toPixels(a,!0));x(d)&&Infinity!==Math.abs(d)||(d=0,h=n);b=k.toValue(d,!0);a=k.toValue(h,!0);var t=Math.abs(c(a-b));t<m?this.grabbedLeft?d=k.toPixels(a-
m-A,!0):this.grabbedRight&&(h=k.toPixels(b+m+A,!0)):J(r)&&c(t-A)>r&&(this.grabbedLeft?d=k.toPixels(a-r-A,!0):this.grabbedRight&&(h=k.toPixels(b+r+A,!0)));this.zoomedMax=p(Math.max(d,h),0,v);this.zoomedMin=p(this.fixedWidth?this.zoomedMax-this.fixedWidth:Math.min(d,h),0,v);this.range=this.zoomedMax-this.zoomedMin;v=Math.round(this.zoomedMax);d=Math.round(this.zoomedMin);f&&(this.navigatorGroup.attr({visibility:"inherit"}),l=l&&!this.hasDragged?"animate":"attr",this.drawMasks(d,v,g,l),this.drawOutline(d,
v,g,l),this.navigatorOptions.handles.enabled&&(this.drawHandle(d,0,g,l),this.drawHandle(v,1,g,l)));this.scrollbar&&(g?(g=this.top-w,e=this.left-w+(f||!e.opposite?0:(e.titleOffset||0)+e.axisTitleMargin),w=q+2*w):(g=this.top+(f?this.height:-w),e=this.left-w),this.scrollbar.position(e,g,n,w),this.scrollbar.setRange(this.zoomedMin/(q||1),this.zoomedMax/(q||1)));this.rendered=!0}};h.prototype.addMouseEvents=function(){var b=this,a=b.chart,d=a.container,h=[],c,e;b.mouseMoveHandler=c=function(a){b.onMouseMove(a)};
b.mouseUpHandler=e=function(a){b.onMouseUp(a)};h=b.getPartsEvents("mousedown");h.push(g(a.renderTo,"mousemove",c),g(d.ownerDocument,"mouseup",e));m&&(h.push(g(a.renderTo,"touchmove",c),g(d.ownerDocument,"touchend",e)),h.concat(b.getPartsEvents("touchstart")));b.eventsToUnbind=h;b.series&&b.series[0]&&h.push(g(b.series[0].xAxis,"foundExtremes",function(){a.navigator.modifyNavigatorAxisExtremes()}))};h.prototype.getPartsEvents=function(b){var a=this,d=[];["shades","handles"].forEach(function(n){a[n].forEach(function(k,
h){d.push(g(k.element,b,function(b){a[n+"Mousedown"](b,h)}))})});return d};h.prototype.shadesMousedown=function(b,a){b=this.chart.pointer.normalize(b);var n=this.chart,d=this.xAxis,h=this.zoomedMin,c=this.size,e=this.range,f=this.left,l=b.chartX;n.inverted&&(l=b.chartY,f=this.top);if(1===a)this.grabbedCenter=l,this.fixedWidth=e,this.dragOffset=l-h;else{b=l-f-e/2;if(0===a)b=Math.max(0,b);else if(2===a&&b+e>=c)if(b=c-e,this.reversedExtremes){b-=e;var g=this.getUnionExtremes().dataMin}else var m=this.getUnionExtremes().dataMax;
b!==h&&(this.fixedWidth=e,a=d.navigatorAxis.toFixedRange(b,b+e,g,m),J(a.min)&&n.xAxis[0].setExtremes(Math.min(a.min,a.max),Math.max(a.min,a.max),!0,null,{trigger:"navigator"}))}};h.prototype.handlesMousedown=function(b,a){this.chart.pointer.normalize(b);b=this.chart;var n=b.xAxis[0],d=this.reversedExtremes;0===a?(this.grabbedLeft=!0,this.otherHandlePos=this.zoomedMax,this.fixedExtreme=d?n.min:n.max):(this.grabbedRight=!0,this.otherHandlePos=this.zoomedMin,this.fixedExtreme=d?n.max:n.min);b.fixedRange=
null};h.prototype.onMouseMove=function(b){var a=this,d=a.chart,h=a.navigatorSize,c=a.range,f=a.dragOffset,l=d.inverted,g=a.left;b.touches&&0===b.touches[0].pageX||(b=d.pointer.normalize(b),d=b.chartX,l&&(g=a.top,d=b.chartY),a.grabbedLeft?(a.hasDragged=!0,a.render(0,0,d-g,a.otherHandlePos)):a.grabbedRight?(a.hasDragged=!0,a.render(0,0,a.otherHandlePos,d-g)):a.grabbedCenter&&(a.hasDragged=!0,d<f?d=f:d>h+f-c&&(d=h+f-c),a.render(0,0,d-f,d-f+c)),a.hasDragged&&a.scrollbar&&u(a.scrollbar.options.liveRedraw,
z.svg&&!e&&!this.chart.boosted)&&(b.DOMType=b.type,setTimeout(function(){a.onMouseUp(b)},0)))};h.prototype.onMouseUp=function(b){var a=this.chart,d=this.xAxis,h=this.scrollbar,c=b.DOMEvent||b,e=a.inverted,f=this.rendered&&!this.hasDragged?"animate":"attr";if(this.hasDragged&&(!h||!h.hasDragged)||"scrollbar"===b.trigger){h=this.getUnionExtremes();if(this.zoomedMin===this.otherHandlePos)var l=this.fixedExtreme;else if(this.zoomedMax===this.otherHandlePos)var g=this.fixedExtreme;this.zoomedMax===this.size&&
(g=this.reversedExtremes?h.dataMin:h.dataMax);0===this.zoomedMin&&(l=this.reversedExtremes?h.dataMax:h.dataMin);d=d.navigatorAxis.toFixedRange(this.zoomedMin,this.zoomedMax,l,g);J(d.min)&&a.xAxis[0].setExtremes(Math.min(d.min,d.max),Math.max(d.min,d.max),!0,this.hasDragged?!1:null,{trigger:"navigator",triggerOp:"navigator-drag",DOMEvent:c})}"mousemove"!==b.DOMType&&"touchmove"!==b.DOMType&&(this.grabbedLeft=this.grabbedRight=this.grabbedCenter=this.fixedWidth=this.fixedExtreme=this.otherHandlePos=
this.hasDragged=this.dragOffset=null);this.navigatorEnabled&&x(this.zoomedMin)&&x(this.zoomedMax)&&(a=Math.round(this.zoomedMin),b=Math.round(this.zoomedMax),this.shades&&this.drawMasks(a,b,e,f),this.outline&&this.drawOutline(a,b,e,f),this.navigatorOptions.handles.enabled&&Object.keys(this.handles).length===this.handles.length&&(this.drawHandle(a,0,e,f),this.drawHandle(b,1,e,f)))};h.prototype.removeEvents=function(){this.eventsToUnbind&&(this.eventsToUnbind.forEach(function(b){b()}),this.eventsToUnbind=
void 0);this.removeBaseSeriesEvents()};h.prototype.removeBaseSeriesEvents=function(){var b=this.baseSeries||[];this.navigatorEnabled&&b[0]&&(!1!==this.navigatorOptions.adaptToUpdatedData&&b.forEach(function(b){l(b,"updatedData",this.updatedDataHandler)},this),b[0].xAxis&&l(b[0].xAxis,"foundExtremes",this.modifyBaseAxisExtremes))};h.prototype.init=function(b){var d=b.options,k=d.navigator||{},h=k.enabled,c=d.scrollbar||{},e=c.enabled;d=h&&k.height||0;var f=e&&c.height||0;this.handles=[];this.shades=
[];this.chart=b;this.setBaseSeries();this.height=d;this.scrollbarHeight=f;this.scrollbarEnabled=e;this.navigatorEnabled=h;this.navigatorOptions=k;this.scrollbarOptions=c;this.outlineHeight=d+f;this.opposite=u(k.opposite,!(h||!b.inverted));var l=this;h=l.baseSeries;c=b.xAxis.length;e=b.yAxis.length;var m=h&&h[0]&&h[0].xAxis||b.xAxis[0]||{options:{}};b.isDirtyBox=!0;l.navigatorEnabled?(l.xAxis=new a(b,G({breaks:m.options.breaks,ordinal:m.options.ordinal},k.xAxis,{id:"navigator-x-axis",yAxis:"navigator-y-axis",
isX:!0,type:"datetime",index:c,isInternal:!0,offset:0,keepOrdinalPadding:!0,startOnTick:!1,endOnTick:!1,minPadding:0,maxPadding:0,zoomEnabled:!1},b.inverted?{offsets:[f,0,-f,0],width:d}:{offsets:[0,-f,0,f],height:d})),l.yAxis=new a(b,G(k.yAxis,{id:"navigator-y-axis",alignTicks:!1,offset:0,index:e,isInternal:!0,reversed:u(k.yAxis&&k.yAxis.reversed,b.yAxis[0]&&b.yAxis[0].reversed,!1),zoomEnabled:!1},b.inverted?{width:d}:{height:d})),h||k.series.data?l.updateNavigatorSeries(!1):0===b.series.length&&
(l.unbindRedraw=g(b,"beforeRedraw",function(){0<b.series.length&&!l.series&&(l.setBaseSeries(),l.unbindRedraw())})),l.reversedExtremes=b.inverted&&!l.xAxis.reversed||!b.inverted&&l.xAxis.reversed,l.renderElements(),l.addMouseEvents()):(l.xAxis={chart:b,navigatorAxis:{fake:!0},translate:function(a,d){var n=b.xAxis[0],k=n.getExtremes(),h=n.len-2*f,c=y("min",n.options.min,k.dataMin);n=y("max",n.options.max,k.dataMax)-c;return d?a*n/h+c:h*(a-c)/n},toPixels:function(b){return this.translate(b)},toValue:function(b){return this.translate(b,
!0)}},l.xAxis.navigatorAxis.axis=l.xAxis,l.xAxis.navigatorAxis.toFixedRange=v.prototype.toFixedRange.bind(l.xAxis.navigatorAxis));b.options.scrollbar.enabled&&(b.scrollbar=l.scrollbar=new B(b.renderer,G(b.options.scrollbar,{margin:l.navigatorEnabled?0:10,vertical:b.inverted}),b),g(l.scrollbar,"changed",function(b){var a=l.size,d=a*this.to;a*=this.from;l.hasDragged=l.scrollbar.hasDragged;l.render(0,0,a,d);this.shouldUpdateExtremes(b.DOMType)&&setTimeout(function(){l.onMouseUp(b)})}));l.addBaseSeriesEvents();
l.addChartEvents()};h.prototype.getUnionExtremes=function(b){var a=this.chart.xAxis[0],d=this.xAxis,h=d.options,c=a.options,e;b&&null===a.dataMin||(e={dataMin:u(h&&h.min,y("min",c.min,a.dataMin,d.dataMin,d.min)),dataMax:u(h&&h.max,y("max",c.max,a.dataMax,d.dataMax,d.max))});return e};h.prototype.setBaseSeries=function(b,a){var d=this.chart,n=this.baseSeries=[];b=b||d.options&&d.options.navigator.baseSeries||(d.series.length?C(d.series,function(b){return!b.options.isInternal}).index:0);(d.series||
[]).forEach(function(a,d){a.options.isInternal||!a.options.showInNavigator&&(d!==b&&a.options.id!==b||!1===a.options.showInNavigator)||n.push(a)});this.xAxis&&!this.xAxis.navigatorAxis.fake&&this.updateNavigatorSeries(!0,a)};h.prototype.updateNavigatorSeries=function(a,n){var b=this,h=b.chart,c=b.baseSeries,e={enableMouseTracking:!1,index:null,linkedTo:null,group:"nav",padXAxis:!1,xAxis:"navigator-x-axis",yAxis:"navigator-y-axis",showInLegend:!1,stacking:void 0,isInternal:!0,states:{inactive:{opacity:1}}},
f=b.series=(b.series||[]).filter(function(a){var d=a.baseSeries;return 0>c.indexOf(d)?(d&&(l(d,"updatedData",b.updatedDataHandler),delete d.navigatorSeries),a.chart&&a.destroy(),!1):!0}),g,m,p=b.navigatorOptions.series,I;c&&c.length&&c.forEach(function(a){var k=a.navigatorSeries,l=E({color:a.color,visible:a.visible},F(p)?r.navigator.series:p);k&&!1===b.navigatorOptions.adaptToUpdatedData||(e.name="Navigator "+c.length,g=a.options||{},I=g.navigatorOptions||{},l.dataLabels=d(l.dataLabels),m=G(g,e,l,
I),m.pointRange=u(l.pointRange,I.pointRange,r.plotOptions[m.type||"line"].pointRange),l=I.data||l.data,b.hasNavigatorData=b.hasNavigatorData||!!l,m.data=l||g.data&&g.data.slice(0),k&&k.options?k.update(m,n):(a.navigatorSeries=h.initSeries(m),a.navigatorSeries.baseSeries=a,f.push(a.navigatorSeries)))});if(p.data&&(!c||!c.length)||F(p))b.hasNavigatorData=!1,p=d(p),p.forEach(function(a,d){e.name="Navigator "+(f.length+1);m=G(r.navigator.series,{color:h.series[d]&&!h.series[d].options.isInternal&&h.series[d].color||
h.options.colors[d]||h.options.colors[0]},e,a);m.data=a.data;m.data&&(b.hasNavigatorData=!0,f.push(h.initSeries(m)))});a&&this.addBaseSeriesEvents()};h.prototype.addBaseSeriesEvents=function(){var a=this,d=this,k=d.baseSeries||[];k[0]&&k[0].xAxis&&k[0].eventsToUnbind.push(g(k[0].xAxis,"foundExtremes",this.modifyBaseAxisExtremes));k.forEach(function(b){b.eventsToUnbind.push(g(b,"show",function(){this.navigatorSeries&&this.navigatorSeries.setVisible(!0,!1)}));b.eventsToUnbind.push(g(b,"hide",function(){this.navigatorSeries&&
this.navigatorSeries.setVisible(!1,!1)}));!1!==a.navigatorOptions.adaptToUpdatedData&&b.xAxis&&b.eventsToUnbind.push(g(b,"updatedData",a.updatedDataHandler));b.eventsToUnbind.push(g(b,"remove",function(){this.navigatorSeries&&(D(d.series,this.navigatorSeries),J(this.navigatorSeries.options)&&this.navigatorSeries.remove(!1),delete this.navigatorSeries)}))})};h.prototype.getBaseSeriesMin=function(a){return this.baseSeries.reduce(function(a,b){return Math.min(a,b.xData&&b.xData.length?b.xData[0]:a)},
a)};h.prototype.modifyNavigatorAxisExtremes=function(){var a=this.xAxis;if("undefined"!==typeof a.getExtremes){var d=this.getUnionExtremes(!0);!d||d.dataMin===a.min&&d.dataMax===a.max||(a.min=d.dataMin,a.max=d.dataMax)}};h.prototype.modifyBaseAxisExtremes=function(){var a=this.chart.navigator,d=this.getExtremes(),k=d.dataMin,h=d.dataMax;d=d.max-d.min;var c=a.stickToMin,e=a.stickToMax,f=u(this.options.overscroll,0),l=a.series&&a.series[0],g=!!this.setExtremes;if(!this.eventArgs||"rangeSelectorButton"!==
this.eventArgs.trigger){if(c){var m=k;var r=m+d}e&&(r=h+f,c||(m=Math.max(k,r-d,a.getBaseSeriesMin(l&&l.xData?l.xData[0]:-Number.MAX_VALUE))));g&&(c||e)&&x(m)&&(this.min=this.userMin=m,this.max=this.userMax=r)}a.stickToMin=a.stickToMax=null};h.prototype.updatedDataHandler=function(){var a=this.chart.navigator,d=this.navigatorSeries;a.stickToMax=u(this.chart.options.navigator&&this.chart.options.navigator.stickToMax,a.reversedExtremes?0===Math.round(a.zoomedMin):Math.round(a.zoomedMax)>=Math.round(a.size));
a.stickToMin=a.shouldStickToMin(this,a);d&&!a.hasNavigatorData&&(d.options.pointStart=this.xData[0],d.setData(this.options.data,!1,null,!1))};h.prototype.shouldStickToMin=function(a,d){d=d.getBaseSeriesMin(a.xData[0]);var b=a.xAxis;a=b.max;var n=b.min;b=b.options.range;return x(a)&&x(n)?b&&0<a-d?a-d<b:n<=d:!1};h.prototype.addChartEvents=function(){this.eventsToUnbind||(this.eventsToUnbind=[]);this.eventsToUnbind.push(g(this.chart,"redraw",function(){var a=this.navigator,d=a&&(a.baseSeries&&a.baseSeries[0]&&
a.baseSeries[0].xAxis||this.xAxis[0]);d&&a.render(d.min,d.max)}),g(this.chart,"getMargins",function(){var a=this.navigator,d=a.opposite?"plotTop":"marginBottom";this.inverted&&(d=a.opposite?"marginRight":"plotLeft");this[d]=(this[d]||0)+(a.navigatorEnabled||!this.inverted?a.outlineHeight:0)+a.navigatorOptions.margin}))};h.prototype.destroy=function(){var a=this;this.removeEvents();this.xAxis&&(D(this.chart.xAxis,this.xAxis),D(this.chart.axes,this.xAxis));this.yAxis&&(D(this.chart.yAxis,this.yAxis),
D(this.chart.axes,this.yAxis));(this.series||[]).forEach(function(a){a.destroy&&a.destroy()});"series xAxis yAxis shades outline scrollbarTrack scrollbarRifles scrollbarGroup scrollbar navigatorGroup rendered".split(" ").forEach(function(b){a[b]&&a[b].destroy&&a[b].destroy();a[b]=null});[this.handles].forEach(function(a){f(a)})};return h}()});C(a,"Stock/RangeSelector/RangeSelectorDefaults.js",[],function(){return{lang:{rangeSelectorZoom:"Zoom",rangeSelectorFrom:"",rangeSelectorTo:"\u2192"},rangeSelector:{allButtonsEnabled:!1,
buttons:void 0,buttonSpacing:5,dropdown:"responsive",enabled:void 0,verticalAlign:"top",buttonTheme:{width:28,height:18,padding:2,zIndex:7},floating:!1,x:0,y:0,height:void 0,inputBoxBorderColor:"none",inputBoxHeight:17,inputBoxWidth:void 0,inputDateFormat:"%b %e, %Y",inputDateParser:void 0,inputEditDateFormat:"%Y-%m-%d",inputEnabled:!0,inputPosition:{align:"right",x:0,y:0},inputSpacing:5,selected:void 0,buttonPosition:{align:"left",x:0,y:0},inputStyle:{color:"#335cad",cursor:"pointer"},labelStyle:{color:"#666666"}}}});
C(a,"Stock/RangeSelector/RangeSelectorComposition.js",[a["Core/Defaults.js"],a["Stock/RangeSelector/RangeSelectorDefaults.js"],a["Core/Utilities.js"]],function(a,q,z){function v(){var a=this.range,d=a.type,h=this.max,b=this.chart.time,n=function(a,n){var h="year"===d?"FullYear":"Month",k=new b.Date(a),c=b.get(h,k);b.set(h,k,c+n);c===b.get(h,k)&&b.set("Date",k,0);return k.getTime()-a};if(E(a)){var k=h-a;var c=a}else a&&(k=h+n(h,-(a.count||1)),this.chart&&(this.chart.fixedRange=h-k));var e=F(this.dataMin,
Number.MIN_VALUE);E(k)||(k=e);k<=e&&(k=e,"undefined"===typeof c&&(c=n(k,a.count)),this.newMax=Math.min(k+c,F(this.dataMax,Number.MAX_VALUE)));E(h)?!E(a)&&a&&a._offsetMin&&(k+=a._offsetMin):k=void 0;return k}function t(){this.options.rangeSelector&&this.options.rangeSelector.enabled&&(this.rangeSelector=new u(this))}function B(){var a=this.axes,d=this.rangeSelector;d&&(E(d.deferredYTDClick)&&(d.clickButton(d.deferredYTDClick),delete d.deferredYTDClick),a.forEach(function(a){a.updateNames();a.setScale()}),
this.getAxisMargins(),d.render(),a=d.options.verticalAlign,d.options.floating||("bottom"===a?this.extraBottomMargin=!0:"middle"!==a&&(this.extraTopMargin=!0)))}function w(a){var d,h,b,n,k=a.rangeSelector,e=function(){k&&(d=a.xAxis[0].getExtremes(),h=a.legend,n=k&&k.options.verticalAlign,E(d.min)&&k.render(d.min,d.max),h.display&&"top"===n&&n===h.options.verticalAlign&&(b=C(a.spacingBox),b.y="vertical"===h.options.layout?a.plotTop:b.y+k.getHeight(),h.group.placed=!1,h.align(b)))};k&&(D(x,function(b){return b[0]===
a})||x.push([a,[c(a.xAxis[0],"afterSetExtremes",function(a){k&&k.render(a.min,a.max)}),c(a,"redraw",e)]]),e())}function y(){for(var a=0,d=x.length;a<d;++a){var h=x[a];if(h[0]===this){h[1].forEach(function(a){return a()});x.splice(a,1);break}}}function r(){var a=this.rangeSelector;a&&(a=a.getHeight(),this.extraTopMargin&&(this.plotTop+=a),this.extraBottomMargin&&(this.marginBottom+=a))}function m(){var a=this.rangeSelector;a&&!a.options.floating&&(a.render(),a=a.options.verticalAlign,"bottom"===a?
this.extraBottomMargin=!0:"middle"!==a&&(this.extraTopMargin=!0))}function e(a){var d=a.options.rangeSelector;a=this.extraBottomMargin;var h=this.extraTopMargin,b=this.rangeSelector;d&&d.enabled&&!J(b)&&this.options.rangeSelector&&(this.options.rangeSelector.enabled=!0,this.rangeSelector=b=new u(this));this.extraTopMargin=this.extraBottomMargin=!1;b&&(w(this),d=d&&d.verticalAlign||b.options&&b.options.verticalAlign,b.options.floating||("bottom"===d?this.extraBottomMargin=!0:"middle"!==d&&(this.extraTopMargin=
!0)),this.extraBottomMargin!==a||this.extraTopMargin!==h)&&(this.isDirtyBox=!0)}var g=a.defaultOptions,p=a.setOptions,c=z.addEvent,J=z.defined,f=z.extend,D=z.find,E=z.isNumber,C=z.merge,F=z.pick,x=[],G=[],u;return{compose:function(a,d,h){u=h;-1===G.indexOf(a)&&(G.push(a),a.prototype.minFromRange=v);-1===G.indexOf(d)&&(G.push(d),c(d,"afterGetContainer",t),c(d,"beforeRender",B),c(d,"destroy",y),c(d,"getMargins",r),c(d,"render",m),c(d,"update",e),d.prototype.callbacks.push(w));-1===G.indexOf(p)&&(f(g,
{rangeSelector:q.rangeSelector}),f(g.lang,q.lang))}}});C(a,"Stock/RangeSelector/RangeSelector.js",[a["Core/Axis/Axis.js"],a["Core/Defaults.js"],a["Core/Globals.js"],a["Stock/RangeSelector/RangeSelectorComposition.js"],a["Core/Renderer/SVG/SVGElement.js"],a["Core/Utilities.js"]],function(a,q,z,v,t,B){function w(a){if(-1!==a.indexOf("%L"))return"text";var d="aAdewbBmoyY".split("").some(function(b){return-1!==a.indexOf("%"+b)}),h="HkIlMS".split("").some(function(b){return-1!==a.indexOf("%"+b)});return d&&
h?"datetime-local":d?"date":h?"time":"text"}var y=q.defaultOptions,r=B.addEvent,m=B.createElement,e=B.css,g=B.defined,p=B.destroyObjectProperties,c=B.discardElement,J=B.extend,f=B.fireEvent,D=B.isNumber,E=B.merge,C=B.objectEach,F=B.pad,x=B.pick,G=B.pInt,u=B.splat;q=function(){function l(a){this.buttons=void 0;this.buttonOptions=l.prototype.defaultButtons;this.initialButtonGroupWidth=0;this.options=void 0;this.chart=a;this.init(a)}l.compose=function(a,h){v.compose(a,h,l)};l.prototype.clickButton=function(d,
h){var b=this.chart,n=this.buttonOptions[d],k=b.xAxis[0],c=b.scroller&&b.scroller.getUnionExtremes()||k||{},e=n.type,l=n.dataGrouping,m=c.dataMin,p=c.dataMax,w=k&&Math.round(Math.min(k.max,x(p,k.max)));c=n._range;var v,I=!0;if(null!==m&&null!==p){b.fixedRange=c;this.setSelected(d);l&&(this.forcedDataGrouping=!0,a.prototype.setDataGrouping.call(k||{chart:this.chart},l,!1),this.frozenStates=n.preserveDataGrouping);if("month"===e||"year"===e)if(k){e={range:n,max:w,chart:b,dataMin:m,dataMax:p};var q=
k.minFromRange.call(e);D(e.newMax)&&(w=e.newMax);I=!1}else c=n;else if(c)q=Math.max(w-c,m),w=Math.min(q+c,p),I=!1;else if("ytd"===e)if(k){if("undefined"===typeof p||"undefined"===typeof m)m=Number.MAX_VALUE,p=Number.MIN_VALUE,b.series.forEach(function(a){if(a=a.xData)m=Math.min(a[0],m),p=Math.max(a[a.length-1],p)}),h=!1;e=this.getYTDExtremes(p,m,b.time.useUTC);q=v=e.min;w=e.max}else{this.deferredYTDClick=d;return}else"all"===e&&k&&(b.navigator&&b.navigator.baseSeries[0]&&(b.navigator.baseSeries[0].xAxis.options.range=
void 0),q=m,w=p);I&&n._offsetMin&&g(q)&&(q+=n._offsetMin);n._offsetMax&&g(w)&&(w+=n._offsetMax);this.dropdown&&(this.dropdown.selectedIndex=d+1);if(k)k.setExtremes(q,w,x(h,!0),void 0,{trigger:"rangeSelectorButton",rangeSelectorButton:n});else{var t=u(b.options.xAxis)[0];var y=t.range;t.range=c;var B=t.min;t.min=v;r(b,"load",function(){t.range=y;t.min=B})}f(this,"afterBtnClick")}};l.prototype.setSelected=function(a){this.selected=this.options.selected=a};l.prototype.init=function(a){var d=this,b=a.options.rangeSelector,
n=b.buttons||d.defaultButtons.slice(),k=b.selected,c=function(){var a=d.minInput,b=d.maxInput;a&&a.blur&&f(a,"blur");b&&b.blur&&f(b,"blur")};d.chart=a;d.options=b;d.buttons=[];d.buttonOptions=n;this.eventsToUnbind=[];this.eventsToUnbind.push(r(a.container,"mousedown",c));this.eventsToUnbind.push(r(a,"resize",c));n.forEach(d.computeButtonRange);"undefined"!==typeof k&&n[k]&&this.clickButton(k,!1);this.eventsToUnbind.push(r(a,"load",function(){a.xAxis&&a.xAxis[0]&&r(a.xAxis[0],"setExtremes",function(b){this.max-
this.min!==a.fixedRange&&"rangeSelectorButton"!==b.trigger&&"updatedData"!==b.trigger&&d.forcedDataGrouping&&!d.frozenStates&&this.setDataGrouping(!1,!1)})}))};l.prototype.updateButtonStates=function(){var a=this,h=this.chart,b=this.dropdown,n=h.xAxis[0],k=Math.round(n.max-n.min),c=!n.hasVisibleSeries,e=h.scroller&&h.scroller.getUnionExtremes()||n,f=e.dataMin,g=e.dataMax;h=a.getYTDExtremes(g,f,h.time.useUTC);var l=h.min,m=h.max,r=a.selected,p=a.options.allButtonsEnabled,w=a.buttons,u=D(r);a.buttonOptions.forEach(function(d,
h){var e=d._range,A=d.type,M=d.count||1,K=w[h],I=d._offsetMax-d._offsetMin,q=h===r,v=e>g-f,x=e<n.minRange;d=0;var t=!1,H=!1;e=e===k;("month"===A||"year"===A)&&k+36E5>=864E5*{month:28,year:365}[A]*M-I&&k-36E5<=864E5*{month:31,year:366}[A]*M+I?e=!0:"ytd"===A?(e=m-l+I===k,t=!q):"all"===A&&(e=n.max-n.min>=g-f,H=!q&&u&&e);A=!p&&(v||x||H||c);M=q&&e||e&&!u&&!t||q&&a.frozenStates;A?d=3:M&&(u=!0,d=2);K.state!==d&&(K.setState(d),b&&(b.options[h+1].disabled=A,2===d&&(b.selectedIndex=h+1)),0===d&&r===h&&a.setSelected())})};
l.prototype.computeButtonRange=function(a){var d=a.type,b=a.count||1,n={millisecond:1,second:1E3,minute:6E4,hour:36E5,day:864E5,week:6048E5};if(n[d])a._range=n[d]*b;else if("month"===d||"year"===d)a._range=864E5*{month:30,year:365}[d]*b;a._offsetMin=x(a.offsetMin,0);a._offsetMax=x(a.offsetMax,0);a._range+=a._offsetMax-a._offsetMin};l.prototype.getInputValue=function(a){a="min"===a?this.minInput:this.maxInput;var d=this.chart.options.rangeSelector,b=this.chart.time;return a?("text"===a.type&&d.inputDateParser||
this.defaultInputDateParser)(a.value,b.useUTC,b):0};l.prototype.setInputValue=function(a,h){var b=this.options,d=this.chart.time,k="min"===a?this.minInput:this.maxInput;a="min"===a?this.minDateBox:this.maxDateBox;if(k){var c=k.getAttribute("data-hc-time");c=g(c)?Number(c):void 0;g(h)&&(g(c)&&k.setAttribute("data-hc-time-previous",c),k.setAttribute("data-hc-time",h),c=h);k.value=d.dateFormat(this.inputTypeFormats[k.type]||b.inputEditDateFormat,c);a&&a.attr({text:d.dateFormat(b.inputDateFormat,c)})}};
l.prototype.setInputExtremes=function(a,h,b){if(a="min"===a?this.minInput:this.maxInput){var d=this.inputTypeFormats[a.type],k=this.chart.time;d&&(h=k.dateFormat(d,h),a.min!==h&&(a.min=h),b=k.dateFormat(d,b),a.max!==b&&(a.max=b))}};l.prototype.showInput=function(a){var d="min"===a?this.minDateBox:this.maxDateBox;if((a="min"===a?this.minInput:this.maxInput)&&d&&this.inputGroup){var b="text"===a.type,n=this.inputGroup,k=n.translateX;n=n.translateY;var c=this.options.inputBoxWidth;e(a,{width:b?d.width+
(c?-2:20)+"px":"auto",height:b?d.height-2+"px":"auto",border:"2px solid silver"});b&&c?e(a,{left:k+d.x+"px",top:n+"px"}):e(a,{left:Math.min(Math.round(d.x+k-(a.offsetWidth-d.width)/2),this.chart.chartWidth-a.offsetWidth)+"px",top:n-(a.offsetHeight-d.height)/2+"px"})}};l.prototype.hideInput=function(a){(a="min"===a?this.minInput:this.maxInput)&&e(a,{top:"-9999em",border:0,width:"1px",height:"1px"})};l.prototype.defaultInputDateParser=function(a,c,b){var d=a.split("/").join("-").split(" ").join("T");
-1===d.indexOf("T")&&(d+="T00:00");if(c)d+="Z";else{var k;if(k=z.isSafari)k=d,k=!(6<k.length&&(k.lastIndexOf("-")===k.length-6||k.lastIndexOf("+")===k.length-6));k&&(k=(new Date(d)).getTimezoneOffset()/60,d+=0>=k?"+".concat(F(-k),":00"):"-".concat(F(k),":00"))}d=Date.parse(d);D(d)||(a=a.split("-"),d=Date.UTC(G(a[0]),G(a[1])-1,G(a[2])));b&&c&&D(d)&&(d+=b.getTimezoneOffset(d));return d};l.prototype.drawInput=function(a){function d(){var d=c.maxInput,n=c.minInput,k=b.xAxis[0],h=b.scroller&&b.scroller.xAxis?
b.scroller.xAxis:k,e=h.dataMin;h=h.dataMax;var f=c.getInputValue(a);f!==Number(u.getAttribute("data-hc-time-previous"))&&D(f)&&(u.setAttribute("data-hc-time-previous",f),r&&d&&D(e)?f>Number(d.getAttribute("data-hc-time"))?f=void 0:f<e&&(f=e):n&&D(h)&&(f<Number(n.getAttribute("data-hc-time"))?f=void 0:f>h&&(f=h)),"undefined"!==typeof f&&k.setExtremes(r?f:k.min,r?k.max:f,void 0,void 0,{trigger:"rangeSelectorInput"}))}var b=this.chart,n=this.div,k=this.inputGroup,c=this,f=b.renderer.style||{},g=b.renderer,
l=b.options.rangeSelector,r="min"===a,p=y.lang[r?"rangeSelectorFrom":"rangeSelectorTo"]||"";p=g.label(p,0).addClass("highcharts-range-label").attr({padding:p?2:0,height:p?l.inputBoxHeight:0}).add(k);g=g.label("",0).addClass("highcharts-range-input").attr({padding:2,width:l.inputBoxWidth,height:l.inputBoxHeight,"text-align":"center"}).on("click",function(){c.showInput(a);c[a+"Input"].focus()});b.styledMode||g.attr({stroke:l.inputBoxBorderColor,"stroke-width":1});g.add(k);var u=m("input",{name:a,className:"highcharts-range-selector"},
void 0,n);u.setAttribute("type",w(l.inputDateFormat||"%b %e, %Y"));b.styledMode||(p.css(E(f,l.labelStyle)),g.css(E({color:"#333333"},f,l.inputStyle)),e(u,J({position:"absolute",border:0,boxShadow:"0 0 15px rgba(0,0,0,0.3)",width:"1px",height:"1px",padding:0,textAlign:"center",fontSize:f.fontSize,fontFamily:f.fontFamily,top:"-9999em"},l.inputStyle)));u.onfocus=function(){c.showInput(a)};u.onblur=function(){u===z.doc.activeElement&&d();c.hideInput(a);c.setInputValue(a);u.blur()};var I=!1;u.onchange=
function(){I||(d(),c.hideInput(a),u.blur())};u.onkeypress=function(a){13===a.keyCode&&d()};u.onkeydown=function(a){I=!0;38!==a.keyCode&&40!==a.keyCode||d()};u.onkeyup=function(){I=!1};return{dateBox:g,input:u,label:p}};l.prototype.getPosition=function(){var a=this.chart,c=a.options.rangeSelector;a="top"===c.verticalAlign?a.plotTop-a.axisOffset[0]:0;return{buttonTop:a+c.buttonPosition.y,inputTop:a+c.inputPosition.y-10}};l.prototype.getYTDExtremes=function(a,c,b){var d=this.chart.time,k=new d.Date(a),
h=d.get("FullYear",k);b=b?d.Date.UTC(h,0,1):+new d.Date(h,0,1);c=Math.max(c,b);k=k.getTime();return{max:Math.min(a||k,k),min:c}};l.prototype.render=function(a,c){var b=this.chart,d=b.renderer,k=b.container,h=b.options,e=h.rangeSelector,f=x(h.chart.style&&h.chart.style.zIndex,0)+1;h=e.inputEnabled;if(!1!==e.enabled){this.rendered||(this.group=d.g("range-selector-group").attr({zIndex:7}).add(),this.div=m("div",void 0,{position:"relative",height:0,zIndex:f}),this.buttonOptions.length&&this.renderButtons(),
k.parentNode&&k.parentNode.insertBefore(this.div,k),h&&(this.inputGroup=d.g("input-group").add(this.group),d=this.drawInput("min"),this.minDateBox=d.dateBox,this.minLabel=d.label,this.minInput=d.input,d=this.drawInput("max"),this.maxDateBox=d.dateBox,this.maxLabel=d.label,this.maxInput=d.input));if(h&&(this.setInputValue("min",a),this.setInputValue("max",c),a=b.scroller&&b.scroller.getUnionExtremes()||b.xAxis[0]||{},g(a.dataMin)&&g(a.dataMax)&&(b=b.xAxis[0].minRange||0,this.setInputExtremes("min",
a.dataMin,Math.min(a.dataMax,this.getInputValue("max"))-b),this.setInputExtremes("max",Math.max(a.dataMin,this.getInputValue("min"))+b,a.dataMax)),this.inputGroup)){var l=0;[this.minLabel,this.minDateBox,this.maxLabel,this.maxDateBox].forEach(function(a){if(a){var b=a.getBBox().width;b&&(a.attr({x:l}),l+=b+e.inputSpacing)}})}this.alignElements();this.rendered=!0}};l.prototype.renderButtons=function(){var a=this,c=this.buttons,b=this.options,n=y.lang,k=this.chart.renderer,e=E(b.buttonTheme),g=e&&e.states,
l=e.width||28;delete e.width;delete e.states;this.buttonGroup=k.g("range-selector-buttons").add(this.group);var p=this.dropdown=m("select",void 0,{position:"absolute",width:"1px",height:"1px",padding:0,border:0,top:"-9999em",cursor:"pointer",opacity:.0001},this.div);r(p,"touchstart",function(){p.style.fontSize="16px"});[[z.isMS?"mouseover":"mouseenter"],[z.isMS?"mouseout":"mouseleave"],["change","click"]].forEach(function(b){var d=b[0],k=b[1];r(p,d,function(){var b=c[a.currentButtonIndex()];b&&f(b.element,
k||d)})});this.zoomText=k.label(n&&n.rangeSelectorZoom||"",0).attr({padding:b.buttonTheme.padding,height:b.buttonTheme.height,paddingLeft:0,paddingRight:0}).add(this.buttonGroup);this.chart.styledMode||(this.zoomText.css(b.labelStyle),e["stroke-width"]=x(e["stroke-width"],0));m("option",{textContent:this.zoomText.textStr,disabled:!0},void 0,p);this.buttonOptions.forEach(function(b,d){m("option",{textContent:b.title||b.text},void 0,p);c[d]=k.button(b.text,0,0,function(k){var c=b.events&&b.events.click,
n;c&&(n=c.call(b,k));!1!==n&&a.clickButton(d);a.isActive=!0},e,g&&g.hover,g&&g.select,g&&g.disabled).attr({"text-align":"center",width:l}).add(a.buttonGroup);b.title&&c[d].attr("title",b.title)})};l.prototype.alignElements=function(){var a=this,c=this.buttonGroup,b=this.buttons,n=this.chart,k=this.group,e=this.inputGroup,f=this.options,g=this.zoomText,l=n.options,m=l.exporting&&!1!==l.exporting.enabled&&l.navigation&&l.navigation.buttonOptions;l=f.buttonPosition;var p=f.inputPosition,r=f.verticalAlign,
u=function(b,d){return m&&a.titleCollision(n)&&"top"===r&&"right"===d.align&&d.y-b.getBBox().height-12<(m.y||0)+(m.height||0)+n.spacing[0]?-40:0},w=n.plotLeft;if(k&&l&&p){var q=l.x-n.spacing[3];if(c){this.positionButtons();if(!this.initialButtonGroupWidth){var v=0;g&&(v+=g.getBBox().width+5);b.forEach(function(a,d){v+=a.width;d!==b.length-1&&(v+=f.buttonSpacing)});this.initialButtonGroupWidth=v}w-=n.spacing[3];this.updateButtonStates();g=u(c,l);this.alignButtonGroup(g);k.placed=c.placed=n.hasLoaded}c=
0;e&&(c=u(e,p),"left"===p.align?q=w:"right"===p.align&&(q=-Math.max(n.axisOffset[1],-c)),e.align({y:p.y,width:e.getBBox().width,align:p.align,x:p.x+q-2},!0,n.spacingBox),e.placed=n.hasLoaded);this.handleCollision(c);k.align({verticalAlign:r},!0,n.spacingBox);e=k.alignAttr.translateY;c=k.getBBox().height+20;u=0;"bottom"===r&&(u=(u=n.legend&&n.legend.options)&&"bottom"===u.verticalAlign&&u.enabled&&!u.floating?n.legend.legendHeight+x(u.margin,10):0,c=c+u-20,u=e-c-(f.floating?0:f.y)-(n.titleOffset?n.titleOffset[2]:
0)-10);if("top"===r)f.floating&&(u=0),n.titleOffset&&n.titleOffset[0]&&(u=n.titleOffset[0]),u+=n.margin[0]-n.spacing[0]||0;else if("middle"===r)if(p.y===l.y)u=e;else if(p.y||l.y)u=0>p.y||0>l.y?u-Math.min(p.y,l.y):e-c;k.translate(f.x,f.y+Math.floor(u));l=this.minInput;p=this.maxInput;e=this.dropdown;f.inputEnabled&&l&&p&&(l.style.marginTop=k.translateY+"px",p.style.marginTop=k.translateY+"px");e&&(e.style.marginTop=k.translateY+"px")}};l.prototype.alignButtonGroup=function(a,c){var b=this.chart,d=
this.buttonGroup,k=this.options.buttonPosition,e=b.plotLeft-b.spacing[3],h=k.x-b.spacing[3];"right"===k.align?h+=a-e:"center"===k.align&&(h-=e/2);d&&d.align({y:k.y,width:x(c,this.initialButtonGroupWidth),align:k.align,x:h},!0,b.spacingBox)};l.prototype.positionButtons=function(){var a=this.buttons,c=this.chart,b=this.options,n=this.zoomText,k=c.hasLoaded?"animate":"attr",e=b.buttonPosition,f=c=c.plotLeft;n&&"hidden"!==n.visibility&&(n[k]({x:x(c+e.x,c)}),f+=e.x+n.getBBox().width+5);n=0;for(e=this.buttonOptions.length;n<
e;++n)if("hidden"!==a[n].visibility)a[n][k]({x:f}),f+=a[n].width+b.buttonSpacing;else a[n][k]({x:c})};l.prototype.handleCollision=function(a){var d=this,b=this.chart,c=this.buttonGroup,k=this.inputGroup,e=this.options,f=e.buttonPosition,g=e.dropdown,l=e.inputPosition;e=function(){var a=0;d.buttons.forEach(function(b){b=b.getBBox();b.width>a&&(a=b.width)});return a};var m=function(b){if(k&&c){var d=k.alignAttr.translateX+k.alignOptions.x-a+k.getBBox().x+2,n=k.alignOptions.width,e=c.alignAttr.translateX+
c.getBBox().x;return e+b>d&&d+n>e&&f.y<l.y+k.getBBox().height}return!1},p=function(){k&&c&&k.attr({translateX:k.alignAttr.translateX+(b.axisOffset[1]>=-a?0:-a),translateY:k.alignAttr.translateY+c.getBBox().height+10})};if(c){if("always"===g){this.collapseButtons(a);m(e())&&p();return}"never"===g&&this.expandButtons()}k&&c?l.align===f.align||m(this.initialButtonGroupWidth+20)?"responsive"===g?(this.collapseButtons(a),m(e())&&p()):p():"responsive"===g&&this.expandButtons():c&&"responsive"===g&&(this.initialButtonGroupWidth>
b.plotWidth?this.collapseButtons(a):this.expandButtons())};l.prototype.collapseButtons=function(a){var d=this.buttons,b=this.buttonOptions,c=this.chart,k=this.dropdown,e=this.options,f=this.zoomText,g=c.userOptions.rangeSelector&&c.userOptions.rangeSelector.buttonTheme||{},l=function(a){return{text:a?""+a+" \u25be":"\u25be",width:"auto",paddingLeft:x(e.buttonTheme.paddingLeft,g.padding,8),paddingRight:x(e.buttonTheme.paddingRight,g.padding,8)}};f&&f.hide();var m=!1;b.forEach(function(a,b){b=d[b];
2!==b.state?b.hide():(b.show(),b.attr(l(a.text)),m=!0)});m||(k&&(k.selectedIndex=0),d[0].show(),d[0].attr(l(this.zoomText&&this.zoomText.textStr)));b=e.buttonPosition.align;this.positionButtons();"right"!==b&&"center"!==b||this.alignButtonGroup(a,d[this.currentButtonIndex()].getBBox().width);this.showDropdown()};l.prototype.expandButtons=function(){var a=this.buttons,c=this.buttonOptions,b=this.options,n=this.zoomText;this.hideDropdown();n&&n.show();c.forEach(function(d,c){c=a[c];c.show();c.attr({text:d.text,
width:b.buttonTheme.width||28,paddingLeft:x(b.buttonTheme.paddingLeft,"unset"),paddingRight:x(b.buttonTheme.paddingRight,"unset")});2>c.state&&c.setState(0)});this.positionButtons()};l.prototype.currentButtonIndex=function(){var a=this.dropdown;return a&&0<a.selectedIndex?a.selectedIndex-1:0};l.prototype.showDropdown=function(){var a=this.buttonGroup,c=this.buttons,b=this.chart,n=this.dropdown;if(a&&n){var k=a.translateX;a=a.translateY;c=c[this.currentButtonIndex()].getBBox();e(n,{left:b.plotLeft+
k+"px",top:a+.5+"px",width:c.width+"px",height:c.height+"px"});this.hasVisibleDropdown=!0}};l.prototype.hideDropdown=function(){var a=this.dropdown;a&&(e(a,{top:"-9999em",width:"1px",height:"1px"}),this.hasVisibleDropdown=!1)};l.prototype.getHeight=function(){var a=this.options,c=this.group,b=a.y,n=a.buttonPosition.y,k=a.inputPosition.y;if(a.height)return a.height;this.alignElements();a=c?c.getBBox(!0).height+13+b:0;c=Math.min(k,n);if(0>k&&0>n||0<k&&0<n)a+=Math.abs(c);return a};l.prototype.titleCollision=
function(a){return!(a.options.title.text||a.options.subtitle.text)};l.prototype.update=function(a){var d=this.chart;E(!0,d.options.rangeSelector,a);this.destroy();this.init(d);this.render()};l.prototype.destroy=function(){var a=this,e=a.minInput,b=a.maxInput;a.eventsToUnbind&&(a.eventsToUnbind.forEach(function(a){return a()}),a.eventsToUnbind=void 0);p(a.buttons);e&&(e.onfocus=e.onblur=e.onchange=null);b&&(b.onfocus=b.onblur=b.onchange=null);C(a,function(b,d){b&&"chart"!==d&&(b instanceof t?b.destroy():
b instanceof window.HTMLElement&&c(b));b!==l.prototype[d]&&(a[d]=null)},this)};return l}();J(q.prototype,{defaultButtons:[{type:"month",count:1,text:"1m",title:"View 1 month"},{type:"month",count:3,text:"3m",title:"View 3 months"},{type:"month",count:6,text:"6m",title:"View 6 months"},{type:"ytd",text:"YTD",title:"View year to date"},{type:"year",count:1,text:"1y",title:"View 1 year"},{type:"all",text:"All",title:"View all"}],inputTypeFormats:{"datetime-local":"%Y-%m-%dT%H:%M:%S",date:"%Y-%m-%d",
time:"%H:%M:%S"}});"";return q});C(a,"Core/Axis/OrdinalAxis.js",[a["Core/Axis/Axis.js"],a["Core/Globals.js"],a["Core/Series/Series.js"],a["Core/Utilities.js"]],function(a,q,z,v){var t=v.addEvent,B=v.correctFloat,w=v.css,y=v.defined,r=v.error,m=v.pick,e=v.timeUnits,g=[],p;(function(a){function c(a,d,c,h,f,g,l){void 0===f&&(f=[]);void 0===g&&(g=0);var b={},k=this.options.tickPixelInterval,n=this.chart.time,m=[],p,u,A=0,w=[],q=-Number.MAX_VALUE;if(!this.options.ordinal&&!this.options.breaks||!f||3>f.length||
"undefined"===typeof d)return n.getTimeTicks.apply(n,arguments);var v=f.length;for(p=0;p<v;p++){var x=p&&f[p-1]>c;f[p]<d&&(A=p);if(p===v-1||f[p+1]-f[p]>5*g||x){if(f[p]>q){for(u=n.getTimeTicks(a,f[A],f[p],h);u.length&&u[0]<=q;)u.shift();u.length&&(q=u[u.length-1]);m.push(w.length);w=w.concat(u)}A=p+1}if(x)break}if(u){u=u.info;if(l&&u.unitRange<=e.hour){p=w.length-1;for(A=1;A<p;A++)if(n.dateFormat("%d",w[A])!==n.dateFormat("%d",w[A-1])){b[w[A]]="day";var t=!0}t&&(b[w[0]]="day");u.higherRanks=b}u.segmentStarts=
m;w.info=u}else r(12,!1,this.chart);if(l&&y(k)){u=w.length;n=[];A=[];p=void 0;for(t=u;t--;)m=this.translate(w[t]),p&&(A[t]=p-m),n[t]=p=m;A.sort();A=A[Math.floor(A.length/2)];A<.6*k&&(A=null);t=w[u-1]>c?u-1:u;for(p=void 0;t--;)m=n[t],u=Math.abs(p-m),p&&u<.8*k&&(null===A||u<.8*A)?(b[w[t]]&&!b[w[t+1]]?(u=t+1,p=m):u=t,w.splice(u,1)):p=m}return w}function f(a){var b=this.ordinal.positions;if(!b)return a;var d=b.length-1;if(0>a)a=b[0];else if(a>d)a=b[d];else{d=Math.floor(a);var c=a-d}return"undefined"!==
typeof c&&"undefined"!==typeof b[d]?b[d]+(c?c*(b[d+1]-b[d]):0):a}function p(a){var b=this.ordinal,d=b.positions;if(!d)return a;var c=(a-(this.old?this.old.min:this.min))*(this.old?this.old.transA:this.transA)+this.minPixelPadding;0<c&&c<this.left+this.len||(b.extendedOrdinalPositions||(b.extendedOrdinalPositions=b.getExtendedPositions()),d=b.extendedOrdinalPositions);if(d&&d.length){a=b.getIndexOfPoint(c,d);b=B(a%1);if(0<=a&&a<d.length-1)return d[Math.floor(a)]+b*(d[Math.ceil(a)]-d[Math.floor(a)]);
b=d.length;c=d[0];d=d[b-1];var e=(d-c)/(b-1);return 0>a?c+e*a:d+e*(a-b)}return a}function v(b,d){var c=a.Additions.findIndexOf(b,d,!0);return b[c]===d?c:c+(d-b[c])/(b[c+1]-b[c])}function E(){this.ordinal||(this.ordinal=new a.Additions(this))}function F(){this.isXAxis&&y(this.options.overscroll)&&this.max===this.dataMax&&(!this.chart.mouseIsDown||this.isInternal)&&(!this.eventArgs||this.eventArgs&&"navigator"!==this.eventArgs.trigger)&&(this.max+=this.options.overscroll,!this.isInternal&&y(this.userMin)&&
(this.min+=this.options.overscroll))}function x(){this.horiz&&!this.isDirty&&(this.isDirty=this.isOrdinal&&this.chart.navigator&&!this.chart.navigator.adaptToUpdatedData)}function G(){this.ordinal&&(this.ordinal.beforeSetTickPositions(),this.tickInterval=this.ordinal.postProcessTickInterval(this.tickInterval))}function u(a){var b=this.xAxis[0],d=b.options.overscroll,c=a.originalEvent.chartX,e=this.options.chart.panning,f=!1;if(e&&"y"!==e.type&&b.options.ordinal&&b.series.length){var h=this.mouseDownX,
g=b.getExtremes(),l=g.dataMax,m=g.min,p=g.max,u=this.hoverPoints,r=b.closestPointRange||b.ordinal&&b.ordinal.overscrollPointsRange;h=(h-c)/(b.translationSlope*(b.ordinal.slope||r));r=b.ordinal.getExtendedPositions();r={ordinal:{positions:r,extendedOrdinalPositions:r}};var q=b.index2val,v=b.val2lin,t=void 0,x=t=void 0,y=void 0;r.ordinal.positions?1<Math.abs(h)&&(u&&u.forEach(function(a){a.setState()}),0>h?(x=r,y=b.ordinal.positions?b:r):(x=b.ordinal.positions?b:r,y=r),t=y.ordinal.positions,l>t[t.length-
1]&&t.push(l),this.fixedRange=p-m,t=b.navigatorAxis.toFixedRange(void 0,void 0,q.apply(x,[v.apply(x,[m,!0])+h]),q.apply(y,[v.apply(y,[p,!0])+h])),t.min>=Math.min(g.dataMin,m)&&t.max<=Math.max(l,p)+d&&b.setExtremes(t.min,t.max,!0,!1,{trigger:"pan"}),this.mouseDownX=c,w(this.container,{cursor:"move"})):f=!0}else f=!0;f||e&&/y/.test(e.type)?d&&(b.max=b.dataMax+d):a.preventDefault()}function l(){var a=this.xAxis;a&&a.options.ordinal&&(delete a.ordinal.index,delete a.ordinal.extendedOrdinalPositions)}
function d(a,d){var b=this.ordinal,c=b.positions,e=b.slope,f=b.extendedOrdinalPositions;if(!c)return a;var n=c.length;if(c[0]<=a&&c[n-1]>=a)a=v(c,a);else{f||(f=b.getExtendedPositions&&b.getExtendedPositions(),b.extendedOrdinalPositions=f);if(!f||!f.length)return a;n=f.length;e||(e=(f[n-1]-f[0])/n);c=v(f,c[0]);a>=f[0]&&a<=f[n-1]?a=v(f,a)-c:a<f[0]?(a=f[0]-a,a=-c-a/e):(a-=f[n-1],a=a/e+n-c)}return d?a:e*(a||0)+b.offset}a.compose=function(a,e,k){if(-1===g.indexOf(a)){g.push(a);var b=a.prototype;b.getTimeTicks=
c;b.index2val=f;b.lin2val=p;b.val2lin=d;b.ordinal2lin=b.val2lin;t(a,"afterInit",E);t(a,"foundExtremes",F);t(a,"afterSetScale",x);t(a,"initialAxisTranslation",G)}-1===g.indexOf(k)&&(g.push(k),t(k,"pan",u));-1===g.indexOf(e)&&(g.push(e),t(e,"updatedData",l));return a};var h=function(){function a(a){this.index={};this.axis=a}a.prototype.beforeSetTickPositions=function(){var a=this.axis,b=a.ordinal,d=a.getExtremes(),c=d.min,e=d.max,f=a.isXAxis&&!!a.options.breaks;d=a.options.ordinal;var h=a.chart.options.chart.ignoreHiddenSeries,
g,l,p=[],u=Number.MAX_VALUE,r=!1,w=!1,t=!1;if(d||f){var q=0;a.series.forEach(function(a,b){g=[];0<b&&"highcharts-navigator-series"!==a.options.id&&1<a.processedXData.length&&(w=q!==a.processedXData[1]-a.processedXData[0]);q=a.processedXData[1]-a.processedXData[0];a.boosted&&(t=a.boosted);if(!(h&&!1===a.visible||!1===a.takeOrdinalPosition&&!f)&&(p=p.concat(a.processedXData),v=p.length,p.sort(function(a,b){return a-b}),u=Math.min(u,m(a.closestPointRange,u)),v)){for(b=0;b<v-1;)p[b]!==p[b+1]&&g.push(p[b+
1]),b++;g[0]!==p[0]&&g.unshift(p[0]);p=g}});w&&t&&(p.pop(),p.shift());var v=p.length;if(2<v){var x=p[1]-p[0];for(l=v-1;l--&&!r;)p[l+1]-p[l]!==x&&(r=!0);!a.options.keepOrdinalPadding&&(p[0]-c>x||e-p[p.length-1]>x)&&(r=!0)}else a.options.overscroll&&(2===v?u=p[1]-p[0]:1===v?(u=a.options.overscroll,p=[p[0],p[0]+u]):u=b.overscrollPointsRange);r||a.forceOrdinal?(a.options.overscroll&&(b.overscrollPointsRange=u,p=p.concat(b.getOverscrollPositions())),b.positions=p,x=a.ordinal2lin(Math.max(c,p[0]),!0),l=
Math.max(a.ordinal2lin(Math.min(e,p[p.length-1]),!0),1),b.slope=e=(e-c)/(l-x),b.offset=c-x*e):(b.overscrollPointsRange=m(a.closestPointRange,b.overscrollPointsRange),b.positions=a.ordinal.slope=b.offset=void 0)}a.isOrdinal=d&&r;b.groupIntervalFactor=null};a.findIndexOf=function(a,b,d){for(var c=0,e=a.length-1,f;c<e;)f=Math.ceil((c+e)/2),a[f]<=b?c=f:e=f-1;return a[c]===b?c:d?c:-1};a.prototype.getExtendedPositions=function(){var a=this,b=a.axis,d=b.constructor.prototype,c=b.chart,e=b.series[0].currentDataGrouping,
f=e?e.count+e.unitName:"raw",h=b.options.overscroll,g=b.getExtremes(),l=void 0,p=a.index;p||(p=a.index={});if(!p[f]){var m={series:[],chart:c,forceOrdinal:!1,getExtremes:function(){return{min:g.dataMin,max:g.dataMax+h}},getGroupPixelWidth:d.getGroupPixelWidth,getTimeTicks:d.getTimeTicks,options:{ordinal:!0},ordinal:{getGroupIntervalFactor:this.getGroupIntervalFactor},ordinal2lin:d.ordinal2lin,getIndexOfPoint:d.getIndexOfPoint,val2lin:d.val2lin};m.ordinal.axis=m;b.series.forEach(function(b){l={xAxis:m,
xData:b.xData.slice(),chart:c,destroyGroupedData:q.noop,getProcessedData:z.prototype.getProcessedData,applyGrouping:z.prototype.applyGrouping};l.xData=l.xData.concat(a.getOverscrollPositions());l.options={dataGrouping:e?{firstAnchor:"firstPoint",anchor:"middle",lastAnchor:"lastPoint",enabled:!0,forced:!0,approximation:"open",units:[[e.unitName,[e.count]]]}:{enabled:!1}};m.series.push(l);b.processData.apply(l)});l.closestPointRange!==l.basePointRange&&l.currentDataGrouping&&(m.forceOrdinal=!0);b.ordinal.beforeSetTickPositions.apply({axis:m});
p[f]=m.ordinal.positions}return p[f]};a.prototype.getGroupIntervalFactor=function(a,b,d){d=d.processedXData;var c=d.length,e=[];var f=this.groupIntervalFactor;if(!f){for(f=0;f<c-1;f++)e[f]=d[f+1]-d[f];e.sort(function(a,b){return a-b});e=e[Math.floor(c/2)];a=Math.max(a,d[0]);b=Math.min(b,d[c-1]);this.groupIntervalFactor=f=c*e/(b-a)}return f};a.prototype.getIndexOfPoint=function(b,d){var c=this.axis,e=this.positions?this.positions[0]:0,f=c.series[0].points&&c.series[0].points[0]&&c.series[0].points[0].plotX||
c.minPixelPadding;1<c.series.length&&c.series.forEach(function(a){a.points&&y(a.points[0])&&y(a.points[0].plotX)&&a.points[0].plotX<f&&a.points[0].plotX>=m(c.min,-Infinity)&&(f=a.points[0].plotX)});b=(b-f)/(c.translationSlope*(this.slope||c.closestPointRange||this.overscrollPointsRange));return a.findIndexOf(d,e)+b};a.prototype.getOverscrollPositions=function(){var a=this.axis,b=a.options.overscroll,d=this.overscrollPointsRange,c=[],e=a.dataMax;if(y(d))for(;e<=a.dataMax+b;)e+=d,c.push(e);return c};
a.prototype.postProcessTickInterval=function(a){var b=this.axis,d=this.slope;return d?b.options.breaks?b.closestPointRange||a:a/(d/b.closestPointRange):a};return a}();a.Additions=h})(p||(p={}));return p});C(a,"Series/HLC/HLCPoint.js",[a["Core/Series/SeriesRegistry.js"]],function(a){var q=this&&this.__extends||function(){var a=function(v,t){a=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(a,w){a.__proto__=w}||function(a,w){for(var t in w)w.hasOwnProperty(t)&&(a[t]=w[t])};return a(v,
t)};return function(v,t){function q(){this.constructor=v}a(v,t);v.prototype=null===t?Object.create(t):(q.prototype=t.prototype,new q)}}();return function(a){function v(){var t=null!==a&&a.apply(this,arguments)||this;t.close=void 0;t.high=void 0;t.low=void 0;t.options=void 0;t.plotClose=void 0;t.series=void 0;return t}q(v,a);return v}(a.seriesTypes.column.prototype.pointClass)});C(a,"Series/HLC/HLCSeriesDefaults.js",[],function(){"";return{lineWidth:1,tooltip:{pointFormat:'<span style="color:{point.color}">\u25cf</span> <b> {series.name}</b><br/>High: {point.high}<br/>Low: {point.low}<br/>Close: {point.close}<br/>'},
threshold:null,states:{hover:{lineWidth:3}},stickyTracking:!0}});C(a,"Series/HLC/HLCSeries.js",[a["Series/HLC/HLCPoint.js"],a["Series/HLC/HLCSeriesDefaults.js"],a["Core/Series/SeriesRegistry.js"],a["Core/Utilities.js"]],function(a,q,z,v){var t=this&&this.__extends||function(){var a=function(m,e){a=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(a,e){a.__proto__=e}||function(a,e){for(var c in e)e.hasOwnProperty(c)&&(a[c]=e[c])};return a(m,e)};return function(m,e){function g(){this.constructor=
m}a(m,e);m.prototype=null===e?Object.create(e):(g.prototype=e.prototype,new g)}}(),B=z.seriesTypes.column,w=v.extend,y=v.merge;v=function(a){function m(){var e=null!==a&&a.apply(this,arguments)||this;e.data=void 0;e.options=void 0;e.points=void 0;e.yData=void 0;return e}t(m,a);m.prototype.extendStem=function(a,g,p){var c=a[0];a=a[1];"number"===typeof c[2]&&(c[2]=Math.max(p+g,c[2]));"number"===typeof a[2]&&(a[2]=Math.min(p-g,a[2]))};m.prototype.getPointPath=function(a,g){g=g.strokeWidth();var e=a.series,
c=g%2/2,m=Math.round(a.plotX)-c,f=Math.round(a.shapeArgs.width/2),r=[["M",m,Math.round(a.yBottom)],["L",m,Math.round(a.plotHigh)]];null!==a.close&&(a=Math.round(a.plotClose)+c,r.push(["M",m,a],["L",m+f,a]),e.extendStem(r,g/2,a));return r};m.prototype.drawSinglePoint=function(a){var e=a.series,m=e.chart,c=a.graphic;"undefined"!==typeof a.plotY&&(c||(a.graphic=c=m.renderer.path().add(e.group)),m.styledMode||c.attr(e.pointAttribs(a,a.selected&&"select")),e=e.getPointPath(a,c),c[c?"animate":"attr"]({d:e}).addClass(a.getClassName(),
!0))};m.prototype.drawPoints=function(){this.points.forEach(this.drawSinglePoint)};m.prototype.init=function(){a.prototype.init.apply(this,arguments);this.options.stacking=void 0};m.prototype.pointAttribs=function(e,g){e=a.prototype.pointAttribs.call(this,e,g);delete e.fill;return e};m.prototype.toYData=function(a){return[a.high,a.low,a.close]};m.prototype.translate=function(){var e=this,g=e.yAxis,m=this.pointArrayMap&&this.pointArrayMap.slice()||[],c=m.map(function(a){return"plot".concat(a.charAt(0).toUpperCase()+
a.slice(1))});c.push("yBottom");m.push("low");a.prototype.translate.apply(e);e.points.forEach(function(a){m.forEach(function(f,m){f=a[f];null!==f&&(e.dataModify&&(f=e.dataModify.modifyValue(f)),a[c[m]]=g.toPixels(f,!0))});a.tooltipPos[1]=a.plotHigh+g.pos-e.chart.plotTop})};m.defaultOptions=y(B.defaultOptions,q);return m}(B);w(v.prototype,{pointClass:a,animate:null,directTouch:!1,pointArrayMap:["high","low","close"],pointAttrToOptions:{stroke:"color","stroke-width":"lineWidth"},pointValKey:"close"});
z.registerSeriesType("hlc",v);return v});C(a,"Series/OHLC/OHLCPoint.js",[a["Core/Series/SeriesRegistry.js"]],function(a){var q=this&&this.__extends||function(){var a=function(q,t){a=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(a,w){a.__proto__=w}||function(a,w){for(var t in w)w.hasOwnProperty(t)&&(a[t]=w[t])};return a(q,t)};return function(q,t){function v(){this.constructor=q}a(q,t);q.prototype=null===t?Object.create(t):(v.prototype=t.prototype,new v)}}();return function(a){function v(){var t=
null!==a&&a.apply(this,arguments)||this;t.open=void 0;t.options=void 0;t.plotOpen=void 0;t.series=void 0;return t}q(v,a);v.prototype.getClassName=function(){return a.prototype.getClassName.call(this)+(this.open<this.close?" highcharts-point-up":" highcharts-point-down")};v.prototype.resolveUpColor=function(){this.open<this.close&&!this.options.color&&this.series.options.upColor&&(this.color=this.series.options.upColor)};v.prototype.resolveColor=function(){a.prototype.resolveColor.call(this);this.resolveUpColor()};
v.prototype.getZone=function(){var t=a.prototype.getZone.call(this);this.resolveUpColor();return t};v.prototype.applyOptions=function(){a.prototype.applyOptions.apply(this,arguments);this.resolveColor&&this.resolveColor();return this};return v}(a.seriesTypes.hlc.prototype.pointClass)});C(a,"Series/OHLC/OHLCSeriesDefaults.js",[],function(){"";return{tooltip:{pointFormat:'<span style="color:{point.color}">\u25cf</span> <b> {series.name}</b><br/>Open: {point.open}<br/>High: {point.high}<br/>Low: {point.low}<br/>Close: {point.close}<br/>'}}});
C(a,"Series/OHLC/OHLCSeries.js",[a["Series/OHLC/OHLCPoint.js"],a["Series/OHLC/OHLCSeriesDefaults.js"],a["Core/Series/SeriesRegistry.js"],a["Core/Utilities.js"]],function(a,q,z,v){function t(a){a=a.options;var c=a.dataGrouping;c&&a.useOhlcData&&"highcharts-navigator-series"!==a.id&&(c.approximation="ohlc")}function B(a){a=a.options;a.useOhlcData&&"highcharts-navigator-series"!==a.id&&m(this,{pointValKey:p.prototype.pointValKey,pointArrayMap:p.prototype.pointArrayMap,toYData:p.prototype.toYData})}var w=
this&&this.__extends||function(){var a=function(c,e){a=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(a,c){a.__proto__=c}||function(a,c){for(var e in c)c.hasOwnProperty(e)&&(a[e]=c[e])};return a(c,e)};return function(c,e){function f(){this.constructor=c}a(c,e);c.prototype=null===e?Object.create(e):(f.prototype=e.prototype,new f)}}(),y=z.seriesTypes.hlc,r=v.addEvent,m=v.extend,e=v.merge,g=[],p=function(a){function c(){var c=null!==a&&a.apply(this,arguments)||this;c.data=void 0;c.options=
void 0;c.points=void 0;return c}w(c,a);c.compose=function(a){for(var c=1;c<arguments.length;c++);-1===g.indexOf(a)&&(g.push(a),r(a,"afterSetOptions",t),r(a,"init",B))};c.prototype.getPointPath=function(c,e){var f=a.prototype.getPointPath.call(this,c,e);e=e.strokeWidth();var g=e%2/2,m=Math.round(c.plotX)-g,p=Math.round(c.shapeArgs.width/2);null!==c.open&&(c=Math.round(c.plotOpen)+g,f.push(["M",m,c],["L",m-p,c]),a.prototype.extendStem.call(this,f,e/2,c));return f};c.prototype.pointAttribs=function(c,
e){e=a.prototype.pointAttribs.call(this,c,e);var f=this.options;delete e.fill;!c.options.color&&f.upColor&&c.open<c.close&&(e.stroke=f.upColor);return e};c.prototype.toYData=function(a){return[a.open,a.high,a.low,a.close]};c.defaultOptions=e(y.defaultOptions,q);return c}(y);m(p.prototype,{pointClass:a,pointArrayMap:["open","high","low","close"]});z.registerSeriesType("ohlc",p);return p});C(a,"Series/Candlestick/CandlestickSeriesDefaults.js",[a["Core/Defaults.js"],a["Core/Utilities.js"]],function(a,
q){"";return{states:{hover:{lineWidth:2}},threshold:null,lineColor:"#000000",lineWidth:1,upColor:"#ffffff",stickyTracking:!0}});C(a,"Series/Candlestick/CandlestickSeries.js",[a["Series/Candlestick/CandlestickSeriesDefaults.js"],a["Core/Defaults.js"],a["Core/Series/SeriesRegistry.js"],a["Core/Utilities.js"]],function(a,q,z,v){var t=this&&this.__extends||function(){var a=function(e,g){a=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(a,c){a.__proto__=c}||function(a,c){for(var e in c)c.hasOwnProperty(e)&&
(a[e]=c[e])};return a(e,g)};return function(e,g){function m(){this.constructor=e}a(e,g);e.prototype=null===g?Object.create(g):(m.prototype=g.prototype,new m)}}(),B=q.defaultOptions;q=z.seriesTypes;var w=q.column,y=q.ohlc,r=v.merge;v=function(m){function e(){var a=null!==m&&m.apply(this,arguments)||this;a.data=void 0;a.options=void 0;a.points=void 0;return a}t(e,m);e.prototype.pointAttribs=function(a,e){var c=w.prototype.pointAttribs.call(this,a,e),g=this.options,f=a.open<a.close,m=g.lineColor||this.color,
p=a.color||this.color;c["stroke-width"]=g.lineWidth;c.fill=a.options.color||(f?g.upColor||p:p);c.stroke=a.options.lineColor||(f?g.upLineColor||m:m);e&&(a=g.states[e],c.fill=a.color||c.fill,c.stroke=a.lineColor||c.stroke,c["stroke-width"]=a.lineWidth||c["stroke-width"]);return c};e.prototype.drawPoints=function(){for(var a=this.chart,e=this.yAxis.reversed,c=0,m=this.points;c<m.length;c++){var f=m[c],r=f.graphic,w=!r;if("undefined"!==typeof f.plotY){r||(f.graphic=r=a.renderer.path().add(this.group));
this.chart.styledMode||r.attr(this.pointAttribs(f,f.selected&&"select")).shadow(this.options.shadow);var t=r.strokeWidth()%2/2;var q=Math.round(f.plotX)-t;var v=f.plotOpen;var y=f.plotClose;var u=Math.min(v,y);v=Math.max(v,y);var l=Math.round(f.shapeArgs.width/2);y=e?v!==f.yBottom:Math.round(u)!==Math.round(f.plotHigh);var d=e?Math.round(u)!==Math.round(f.plotHigh):v!==f.yBottom;u=Math.round(u)+t;v=Math.round(v)+t;t=[];t.push(["M",q-l,v],["L",q-l,u],["L",q+l,u],["L",q+l,v],["Z"],["M",q,u],["L",q,
y?Math.round(e?f.yBottom:f.plotHigh):u],["M",q,v],["L",q,d?Math.round(e?f.plotHigh:f.yBottom):v]);r[w?"attr":"animate"]({d:t}).addClass(f.getClassName(),!0)}}};e.defaultOptions=r(y.defaultOptions,B.plotOptions,{tooltip:y.defaultOptions.tooltip},a);return e}(y);z.registerSeriesType("candlestick",v);return v});C(a,"Series/Flags/FlagsPoint.js",[a["Core/Series/SeriesRegistry.js"],a["Core/Utilities.js"]],function(a,q){var z=this&&this.__extends||function(){var a=function(q,w){a=Object.setPrototypeOf||
{__proto__:[]}instanceof Array&&function(a,r){a.__proto__=r}||function(a,r){for(var m in r)r.hasOwnProperty(m)&&(a[m]=r[m])};return a(q,w)};return function(q,w){function t(){this.constructor=q}a(q,w);q.prototype=null===w?Object.create(w):(t.prototype=w.prototype,new t)}}(),v=q.isNumber;return function(a){function q(){var q=null!==a&&a.apply(this,arguments)||this;q.options=void 0;q.series=void 0;q.ttBelow=!1;return q}z(q,a);q.prototype.isValid=function(){return v(this.y)||"undefined"===typeof this.y};
q.prototype.hasNewShapeType=function(){var a=this.options.shape||this.series.options.shape;return this.graphic&&a&&a!==this.graphic.symbolKey};return q}(a.seriesTypes.column.prototype.pointClass)});C(a,"Series/Flags/FlagsSeriesDefaults.js",[],function(){"";return{pointRange:0,allowOverlapX:!1,shape:"flag",stackDistance:12,textAlign:"center",tooltip:{pointFormat:"{point.text}"},threshold:null,y:-30,fillColor:"#ffffff",lineWidth:1,states:{hover:{lineColor:"#000000",fillColor:"#ccd6eb"}},style:{fontSize:"11px",
fontWeight:"bold"}}});C(a,"Series/Flags/FlagsSymbols.js",[a["Core/Renderer/RendererRegistry.js"]],function(a){var q;(function(q){function v(a,q,r,m,e){var g=e&&e.anchorX||a;e=e&&e.anchorY||q;var p=this.circle(g-1,e-1,2,2);p.push(["M",g,e],["L",a,q+m],["L",a,q],["L",a+r,q],["L",a+r,q+m],["L",a,q+m],["Z"]);return p}function t(a,q){a[q+"pin"]=function(r,m,e,g,p){var c=p&&p.anchorX;p=p&&p.anchorY;"circle"===q&&g>e&&(r-=Math.round((g-e)/2),e=g);var t=a[q](r,m,e,g);if(c&&p){var f=c;"circle"===q?f=r+e/2:
(r=t[0],e=t[1],"M"===r[0]&&"L"===e[0]&&(f=(r[1]+e[1])/2));t.push(["M",f,m>p?m:m+g],["L",c,p]);t=t.concat(a.circle(c-1,p-1,2,2))}return t}}var B=[];q.compose=function(q){if(-1===B.indexOf(q)){B.push(q);var w=q.prototype.symbols;w.flag=v;t(w,"circle");t(w,"square")}var r=a.getRendererType();B.indexOf(r)&&(B.push(r),w=q.prototype.symbols,q=r.prototype.symbols,q.circlepin=w.circlepin,q.flag=w.flag.bind(w),q.squarepin=w.squarepin)}})(q||(q={}));return q});C(a,"Series/OnSeriesComposition.js",[a["Series/Column/ColumnSeries.js"],
a["Core/Series/Series.js"],a["Core/Utilities.js"]],function(a,q,z){var v=a.prototype,t=q.prototype,B=z.defined,w=z.stableSort,y;(function(a){function m(a){return t.getPlotBox.call(this.options.onSeries&&this.chart.get(this.options.onSeries)||this,a)}function e(){v.translate.apply(this);var a=this,c=a.options,e=a.chart,f=a.points,g=c.onSeries,m=(g=g&&e.get(g))&&g.options.step,q=g&&g.points,r=e.inverted,t=a.xAxis,y=a.yAxis;e=f.length-1;var u;c=c.onKey||"y";var l=q&&q.length,d=0,h;if(g&&g.visible&&l){d=
(g.pointXOffset||0)+(g.barW||0)/2;var b=g.currentDataGrouping;var n=q[l-1].x+(b?b.totalRange:0);w(f,function(a,b){return a.x-b.x});for(c="plot"+c[0].toUpperCase()+c.substr(1);l--&&f[e];){var k=q[l];b=f[e];b.y=k.y;if(k.x<=b.x&&"undefined"!==typeof k[c]){if(b.x<=n&&(b.plotY=k[c],k.x<b.x&&!m&&(h=q[l+1])&&"undefined"!==typeof h[c])){var A=(b.x-k.x)/(h.x-k.x);b.plotY+=A*(h[c]-k[c]);b.y+=A*(h.y-k.y)}e--;l++;if(0>e)break}}}f.forEach(function(b,c){b.plotX+=d;if("undefined"===typeof b.plotY||r)0<=b.plotX&&
b.plotX<=t.len?r?(b.plotY=t.translate(b.x,0,1,0,1),b.plotX=B(b.y)?y.translate(b.y,0,0,0,1):0):b.plotY=(t.opposite?0:a.yAxis.len)+t.offset:b.shapeArgs={};if((u=f[c-1])&&u.plotX===b.plotX){"undefined"===typeof u.stackIndex&&(u.stackIndex=0);var e=u.stackIndex+1}b.stackIndex=e});this.onSeries=g}var g=[];a.compose=function(a){if(-1===g.indexOf(a)){g.push(a);var c=a.prototype;c.getPlotBox=m;c.translate=e}return a};a.getPlotBox=m;a.translate=e})(y||(y={}));return y});C(a,"Series/Flags/FlagsSeries.js",[a["Series/Flags/FlagsPoint.js"],
a["Series/Flags/FlagsSeriesDefaults.js"],a["Series/Flags/FlagsSymbols.js"],a["Core/Globals.js"],a["Series/OnSeriesComposition.js"],a["Core/Renderer/RendererUtilities.js"],a["Core/Series/SeriesRegistry.js"],a["Core/Renderer/SVG/SVGElement.js"],a["Core/Utilities.js"]],function(a,q,z,v,t,B,w,y,r){var m=this&&this.__extends||function(){var a=function(c,e){a=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(a,c){a.__proto__=c}||function(a,c){for(var e in c)c.hasOwnProperty(e)&&(a[e]=c[e])};
return a(c,e)};return function(c,e){function f(){this.constructor=c}a(c,e);c.prototype=null===e?Object.create(e):(f.prototype=e.prototype,new f)}}();v=v.noop;var e=B.distribute,g=w.series,p=w.seriesTypes.column,c=r.addEvent,E=r.defined;B=r.extend;var f=r.merge,D=r.objectEach,C=r.wrap;r=function(a){function r(){var c=null!==a&&a.apply(this,arguments)||this;c.data=void 0;c.options=void 0;c.points=void 0;return c}m(r,a);r.prototype.animate=function(a){a&&this.setClip()};r.prototype.drawPoints=function(){var a=
this.points,c=this.chart,g=c.renderer,l=c.inverted,d=this.options,h=d.y,b=this.yAxis,n={},k=[],m;for(m=a.length;m--;){var p=a[m];var q=(l?p.plotY:p.plotX)>this.xAxis.len;var r=p.plotX;var t=p.stackIndex;var v=p.options.shape||d.shape;var w=p.plotY;"undefined"!==typeof w&&(w=p.plotY+h-("undefined"!==typeof t&&t*d.stackDistance));p.anchorX=t?void 0:p.plotX;var B=t?void 0:p.plotY;var z="flag"!==v;t=p.graphic;"undefined"!==typeof w&&0<=r&&!q?(t&&p.hasNewShapeType()&&(t=t.destroy()),t||(t=p.graphic=g.label("",
null,null,v,null,null,d.useHTML).addClass("highcharts-point").add(this.markerGroup),p.graphic.div&&(p.graphic.div.point=p),t.isNew=!0),t.attr({align:z?"center":"left",width:d.width,height:d.height,"text-align":d.textAlign}),c.styledMode||t.attr(this.pointAttribs(p)).css(f(d.style,p.style)).shadow(d.shadow),0<r&&(r-=t.strokeWidth()%2),v={y:w,anchorY:B},d.allowOverlapX&&(v.x=r,v.anchorX=p.anchorX),t.attr({text:p.options.title||d.title||"A"})[t.isNew?"attr":"animate"](v),d.allowOverlapX||(n[p.plotX]?
n[p.plotX].size=Math.max(n[p.plotX].size,t.width):n[p.plotX]={align:z?.5:0,size:t.width,target:r,anchorX:r}),p.tooltipPos=[r,w+b.pos-c.plotTop]):t&&(p.graphic=t.destroy())}if(!d.allowOverlapX){var F=100;D(n,function(a){a.plotX=a.anchorX;k.push(a);F=Math.max(a.size,F)});e(k,l?b.len:this.xAxis.len,F);for(c=0;c<a.length;c++)g=a[c],h=g.plotX,(h=(l=g.graphic)&&n[h])&&l&&(E(h.pos)?l[l.isNew?"attr":"animate"]({x:h.pos+(h.align||0)*h.size,anchorX:g.anchorX}).show().isNew=!1:l.hide().isNew=!0)}d.useHTML&&
this.markerGroup&&C(this.markerGroup,"on",function(a){return y.prototype.on.apply(a.apply(this,[].slice.call(arguments,1)),[].slice.call(arguments,1))})};r.prototype.drawTracker=function(){var e=this.points;a.prototype.drawTracker.call(this);for(var f=function(a){var d=a.graphic;d&&(a.unbindMouseOver&&a.unbindMouseOver(),a.unbindMouseOver=c(d.element,"mouseover",function(){0<a.stackIndex&&!a.raised&&(a._y=d.y,d.attr({y:a._y-8}),a.raised=!0);for(var c=0;c<e.length;c++){var b=e[c];b!==a&&b.raised&&
b.graphic&&(b.graphic.attr({y:b._y}),b.raised=!1)}}))},g=0;g<e.length;g++)f(e[g])};r.prototype.pointAttribs=function(a,c){var e=this.options,f=a&&a.color||this.color,d=e.lineColor,h=a&&a.lineWidth;a=a&&a.fillColor||e.fillColor;c&&(a=e.states[c].fillColor,d=e.states[c].lineColor,h=e.states[c].lineWidth);return{fill:a||f,stroke:d||f,"stroke-width":h||e.lineWidth||0}};r.prototype.setClip=function(){g.prototype.setClip.apply(this,arguments);!1!==this.options.clip&&this.sharedClipKey&&this.markerGroup&&
this.markerGroup.clip(this.chart.sharedClips[this.sharedClipKey])};r.compose=z.compose;r.defaultOptions=f(p.defaultOptions,q);return r}(p);t.compose(r);B(r.prototype,{allowDG:!1,forceCrop:!0,invertible:!1,noSharedTooltip:!0,pointClass:a,sorted:!1,takeOrdinalPosition:!1,trackerGroups:["markerGroup"],buildKDTree:v,init:g.prototype.init});w.registerSeriesType("flags",r);"";return r});C(a,"Core/Chart/StockChart.js",[a["Core/Axis/Axis.js"],a["Core/Chart/Chart.js"],a["Core/FormatUtilities.js"],a["Core/Defaults.js"],
a["Stock/Navigator/NavigatorDefaults.js"],a["Stock/RangeSelector/RangeSelectorDefaults.js"],a["Stock/Scrollbar/ScrollbarDefaults.js"],a["Core/Series/Series.js"],a["Core/Renderer/SVG/SVGRenderer.js"],a["Core/Utilities.js"]],function(a,q,z,v,t,B,w,y,r,m){function e(a,c){return"xAxis"===a?{minPadding:0,maxPadding:0,overscroll:0,ordinal:!0,title:{text:null},labels:{overflow:"justify"},showLastLabel:!0}:"yAxis"===a?{labels:{y:-2},opposite:u(c.opposite,!0),showLastLabel:!(!c.categories&&"category"!==c.type),
title:{text:null}}:{}}function g(a,c){return"xAxis"===a?(a={type:"datetime",categories:void 0},u(c.navigator&&c.navigator.enabled,t.enabled,!0)&&(a.startOnTick=!1,a.endOnTick=!1),a):{}}var p=this&&this.__extends||function(){var a=function(c,b){a=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(a,b){a.__proto__=b}||function(a,b){for(var c in b)b.hasOwnProperty(c)&&(a[c]=b[c])};return a(c,b)};return function(c,b){function d(){this.constructor=c}a(c,b);c.prototype=null===b?Object.create(b):
(d.prototype=b.prototype,new d)}}(),c=z.format,E=v.getOptions;z=m.addEvent;var f=m.clamp,D=m.defined,C=m.extend,O=m.find,F=m.isNumber,x=m.isString,G=m.merge,u=m.pick,l=m.splat;m=function(a){function c(){return null!==a&&a.apply(this,arguments)||this}p(c,a);c.prototype.init=function(b,c){var d=E(),f=b.xAxis,h=b.yAxis,n=u(b.navigator&&b.navigator.enabled,t.enabled,!0);b.xAxis=b.yAxis=void 0;n=G({chart:{panning:{enabled:!0,type:"x"},zooming:{pinchType:"x"}},navigator:{enabled:n},scrollbar:{enabled:u(w.enabled,
!0)},rangeSelector:{enabled:u(B.rangeSelector.enabled,!0)},title:{text:null},tooltip:{split:u(d.tooltip.split,!0),crosshairs:!0},legend:{enabled:!1}},b,{isStock:!0});b.xAxis=f;b.yAxis=h;n.xAxis=l(b.xAxis||{}).map(function(a,c){return G(e("xAxis",a),d.xAxis,d.xAxis&&d.xAxis[c],a,g("xAxis",b))});n.yAxis=l(b.yAxis||{}).map(function(a,b){return G(e("yAxis",a),d.yAxis,d.yAxis&&d.yAxis[b],a)});a.prototype.init.call(this,n,c)};c.prototype.createAxis=function(b,c){c.axis=G(e(b,c.axis),c.axis,g(b,this.userOptions));
return a.prototype.createAxis.call(this,b,c)};return c}(q);(function(a){a.stockChart=function(c,b,d){return new a(c,b,d)}})(m||(m={}));z(y,"setOptions",function(a){var c;this.chart.options.isStock&&(this.is("column")||this.is("columnrange")?c={borderWidth:0,shadow:!1}:this.is("scatter")||this.is("sma")||(c={marker:{enabled:!1,radius:2}}),c&&(a.plotOptions[this.type]=G(a.plotOptions[this.type],c)))});z(a,"autoLabelAlign",function(a){var c=this.chart,b=this.options;c=c._labelPanes=c._labelPanes||{};
var d=this.options.labels;this.chart.options.isStock&&"yAxis"===this.coll&&(b=b.top+","+b.height,!c[b]&&d.enabled&&(15===d.x&&(d.x=0),"undefined"===typeof d.align&&(d.align="right"),c[b]=this,a.align="right",a.preventDefault()))});z(a,"destroy",function(){var a=this.chart,c=this.options&&this.options.top+","+this.options.height;c&&a._labelPanes&&a._labelPanes[c]===this&&delete a._labelPanes[c]});z(a,"getPlotLinePath",function(a){function c(a){var c="xAxis"===a?"yAxis":"xAxis";a=b.options[c];return F(a)?
[e[c][a]]:x(a)?[e.get(a)]:d.map(function(a){return a[c]})}var b=this,d=this.isLinked&&!this.series?this.linkedParent.series:this.series,e=b.chart,g=e.renderer,l=b.left,m=b.top,p,q,r,t,v=[],w=[],y=a.translatedValue,B=a.value,z=a.force;if(e.options.isStock&&!1!==a.acrossPanes&&"xAxis"===b.coll||"yAxis"===b.coll){a.preventDefault();w=c(b.coll);var E=b.isXAxis?e.yAxis:e.xAxis;E.forEach(function(a){if(D(a.options.id)?-1===a.options.id.indexOf("navigator"):1){var c=a.isXAxis?"yAxis":"xAxis";c=D(a.options[c])?
e[c][a.options[c]]:e[c][0];b===c&&w.push(a)}});var C=w.length?[]:[b.isXAxis?e.yAxis[0]:e.xAxis[0]];w.forEach(function(a){-1!==C.indexOf(a)||O(C,function(b){return b.pos===a.pos&&b.len===a.len})||C.push(a)});var G=u(y,b.translate(B,void 0,void 0,a.old));F(G)&&(b.horiz?C.forEach(function(a){var c;q=a.pos;t=q+a.len;p=r=Math.round(G+b.transB);"pass"!==z&&(p<l||p>l+b.width)&&(z?p=r=f(p,l,l+b.width):c=!0);c||v.push(["M",p,q],["L",r,t])}):C.forEach(function(a){var c;p=a.pos;r=p+a.len;q=t=Math.round(m+b.height-
G);"pass"!==z&&(q<m||q>m+b.height)&&(z?q=t=f(q,m,m+b.height):c=!0);c||v.push(["M",p,q],["L",r,t])}));a.path=0<v.length?g.crispPolyLine(v,a.lineWidth||1):null}});r.prototype.crispPolyLine=function(a,c){for(var b=0;b<a.length;b+=2){var d=a[b],e=a[b+1];d[1]===e[1]&&(d[1]=e[1]=Math.round(d[1])-c%2/2);d[2]===e[2]&&(d[2]=e[2]=Math.round(d[2])+c%2/2)}return a};z(a,"afterHideCrosshair",function(){this.crossLabel&&(this.crossLabel=this.crossLabel.hide())});z(a,"afterDrawCrosshair",function(a){var d,b;if(this.crosshair&&
this.crosshair.label&&this.crosshair.label.enabled&&this.cross&&F(this.min)&&F(this.max)){var e=this.chart,f=this.logarithmic,g=this.crosshair.label,l=this.horiz,m=this.opposite,p=this.left,q=this.top,r=this.crossLabel,t=g.format,v="",w="inside"===this.options.tickPosition,x=!1!==this.crosshair.snap,y=0,z=a.e||this.cross&&this.cross.e;a=a.point;var B=this.min,E=this.max;f&&(B=f.lin2log(B),E=f.lin2log(E));f=l?"center":m?"right"===this.labelAlign?"right":"left":"left"===this.labelAlign?"left":"center";
r||(r=this.crossLabel=e.renderer.label("",0,void 0,g.shape||"callout").addClass("highcharts-crosshair-label highcharts-color-"+(a&&a.series?a.series.colorIndex:this.series[0]&&this.series[0].colorIndex)).attr({align:g.align||f,padding:u(g.padding,8),r:u(g.borderRadius,3),zIndex:2}).add(this.labelGroup),e.styledMode||r.attr({fill:g.backgroundColor||a&&a.series&&a.series.color||"#666666",stroke:g.borderColor||"","stroke-width":g.borderWidth||0}).css(C({color:"#ffffff",fontWeight:"normal",fontSize:"11px",
textAlign:"center"},g.style||{})));l?(f=x?(a.plotX||0)+p:z.chartX,q+=m?0:this.height):(f=m?this.width+p:0,q=x?(a.plotY||0)+q:z.chartY);t||g.formatter||(this.dateTime&&(v="%b %d, %Y"),t="{value"+(v?":"+v:"")+"}");v=x?this.isXAxis?a.x:a.y:this.toValue(l?z.chartX:z.chartY);x=a&&a.series?a.series.isPointInside(a):F(v)&&v>B&&v<E;z="";t?z=c(t,{value:v},e):g.formatter&&F(v)&&(z=g.formatter.call(this,v));r.attr({text:z,x:f,y:q,visibility:x?"inherit":"hidden"});g=r.getBBox();if(F(r.y))if(l){if(w&&!m||!w&&
m)q=r.y-g.height}else q=r.y-g.height/2;l?(d=p-g.x,b=p+this.width-g.x):(d="left"===this.labelAlign?p:0,b="right"===this.labelAlign?p+this.width:e.chartWidth);r.translateX<d&&(y=d-r.translateX);r.translateX+g.width>=b&&(y=-(r.translateX+g.width-b));r.attr({x:f+y,y:q,anchorX:l?f:this.opposite?0:e.chartWidth,anchorY:l?this.opposite?e.chartHeight:0:q+g.height/2})}});y.prototype.forceCropping=function(){var a=this.chart,c=this.options.dataGrouping;return!1!==this.allowDG&&c&&u(c.enabled,a.options.isStock)};
z(q,"update",function(a){a=a.options;"scrollbar"in a&&this.navigator&&(G(!0,this.options.scrollbar,a.scrollbar),this.navigator.update({}),delete a.scrollbar)});return m});C(a,"masters/modules/stock.src.js",[a["Core/Globals.js"],a["Series/DataModifyComposition.js"],a["Stock/Navigator/Navigator.js"],a["Stock/RangeSelector/RangeSelector.js"],a["Stock/Scrollbar/Scrollbar.js"],a["Core/Axis/OrdinalAxis.js"],a["Series/OHLC/OHLCSeries.js"],a["Series/Flags/FlagsSeries.js"],a["Core/Chart/StockChart.js"]],function(a,
q,z,v,t,B,w,y,r){a.Navigator=z;a.RangeSelector=v;a.Scrollbar=t;a.StockChart=a.stockChart=r.stockChart;q.compose(a.Series,a.Axis,a.Point);y.compose(a.Renderer);z.compose(a.Axis,a.Chart,a.Series);w.compose(a.Series);B.compose(a.Axis,a.Series,a.Chart);v.compose(a.Axis,a.Chart);t.compose(a.Axis)})});
//# sourceMappingURL=stock.js.map