/*
 Highcharts JS v10.3.3 (2023-01-20)

 Boost module

 (c) 2010-2021 Highsoft AS
 Author: Torstein Honsi

 License: www.highcharts.com/license

*/
(function(a){"object"===typeof module&&module.exports?(a["default"]=a,module.exports=a):"function"===typeof define&&define.amd?define("highcharts/modules/boost",["highcharts"],function(v){a(v);a.Highcharts=v;return a}):a("undefined"!==typeof Highcharts?Highcharts:void 0)})(function(a){function v(a,e,c,Q){a.hasOwnProperty(e)||(a[e]=Q.apply(null,c),"function"===typeof CustomEvent&&window.dispatchEvent(new CustomEvent("HighchartsModuleLoaded",{detail:{path:e,module:a[e]}})))}a=a?a._modules:{};v(a,"Extensions/Boost/Boostables.js",
[],function(){return"area areaspline arearange column columnrange bar line scatter heatmap bubble treemap".split(" ")});v(a,"Extensions/Boost/BoostableMap.js",[a["Extensions/Boost/Boostables.js"]],function(a){var e={};a.forEach(function(a){e[a]=!0});return e});v(a,"Extensions/Boost/BoostChart.js",[a["Extensions/Boost/BoostableMap.js"],a["Core/Utilities.js"]],function(a,e){function c(b){var g=b.series,e=b.boost=b.boost||{},q=b.options.boost||{},c=E(q.seriesThreshold,50);if(g.length>=c)return!0;if(1===
g.length)return!1;q=q.allowForce;if("undefined"===typeof q)for(q=!0,c=0,b=b.xAxis;c<b.length;c++){var m=b[c];if(E(m.min,-Infinity)>E(m.dataMin,-Infinity)||E(m.max,Infinity)<E(m.dataMax,Infinity)){q=!1;break}}if("undefined"!==typeof e.forceChartBoost){if(q)return e.forceChartBoost;e.forceChartBoost=void 0}for(var r=c=b=0;r<g.length;r++){var K=g[r];m=K.options;0!==m.boostThreshold&&!1!==K.visible&&"heatmap"!==K.type&&(a[K.type]&&++b,t(K.processedXData,m.data,K.points)>=(m.boostThreshold||Number.MAX_VALUE)&&
++c)}e.forceChartBoost=q&&(b===g.length&&0<c||5<c);return e.forceChartBoost}function r(b){g(b,"predraw",function(){b.boost=b.boost||{};b.boost.forceChartBoost=void 0;b.boosted=!1;b.boost.clear&&b.boost.clear();b.boost.canvas&&b.boost.wgl&&c(b)&&b.boost.wgl.allocateBuffer(b);b.boost.markerGroup&&b.xAxis&&0<b.xAxis.length&&b.yAxis&&0<b.yAxis.length&&b.boost.markerGroup.translate(b.xAxis[0].pos,b.yAxis[0].pos)});g(b,"render",function(){b.boost&&b.boost.wgl&&c(b)&&b.boost.wgl.render(b)});var a=-1,e=-1;
g(b.pointer,"afterGetHoverData",function(){var g=b.hoverSeries;b.boost=b.boost||{};if(b.boost.markerGroup&&g){var t=b.inverted?g.yAxis:g.xAxis;g=b.inverted?g.xAxis:g.yAxis;if(t&&t.pos!==a||g&&g.pos!==e)b.boost.markerGroup.translate(t.pos,g.pos),a=t.pos,e=g.pos}})}function t(){for(var b=[],g=0;g<arguments.length;g++)b[g]=arguments[g];var a=-Number.MAX_VALUE;b.forEach(function(b){if("undefined"!==typeof b&&null!==b&&"undefined"!==typeof b.length&&0<b.length)return a=b.length,!0});return a}var g=e.addEvent,
E=e.pick,m=[];return{compose:function(b,g){g&&-1===m.indexOf(b)&&(m.push(b),b.prototype.callbacks.push(r));return b},getBoostClipRect:function(b,g){var a={x:b.plotLeft,y:b.plotTop,width:b.plotWidth,height:b.plotHeight};g===b&&(g=b.inverted?b.xAxis:b.yAxis,1>=g.length?(a.y=Math.min(g[0].pos,a.y),a.height=g[0].pos-b.plotTop+g[0].len):a.height=b.plotHeight);return a},isChartSeriesBoosting:c}});v(a,"Extensions/Boost/WGLDrawMode.js",[],function(){return{area:"LINES",arearange:"LINES",areaspline:"LINES",
column:"LINES",columnrange:"LINES",bar:"LINES",line:"LINE_STRIP",scatter:"POINTS",heatmap:"TRIANGLES",treemap:"TRIANGLES",bubble:"POINTS"}});v(a,"Extensions/Boost/WGLShader.js",[a["Core/Utilities.js"]],function(a){var e=a.clamp,c=a.error,r=a.pick;return function(){function a(a){this.errors=[];this.uLocations={};(this.gl=a)&&this.createShader()}a.prototype.bind=function(){this.gl&&this.shaderProgram&&this.gl.useProgram(this.shaderProgram)};a.prototype.createShader=function(){var a=this,e=this.stringToProgram("#version 100\n#define LN10 2.302585092994046\nprecision highp float;\nattribute vec4 aVertexPosition;\nattribute vec4 aColor;\nvarying highp vec2 position;\nvarying highp vec4 vColor;\nuniform mat4 uPMatrix;\nuniform float pSize;\nuniform float translatedThreshold;\nuniform bool hasThreshold;\nuniform bool skipTranslation;\nuniform float xAxisTrans;\nuniform float xAxisMin;\nuniform float xAxisMinPad;\nuniform float xAxisPointRange;\nuniform float xAxisLen;\nuniform bool  xAxisPostTranslate;\nuniform float xAxisOrdinalSlope;\nuniform float xAxisOrdinalOffset;\nuniform float xAxisPos;\nuniform bool  xAxisCVSCoord;\nuniform bool  xAxisIsLog;\nuniform bool  xAxisReversed;\nuniform float yAxisTrans;\nuniform float yAxisMin;\nuniform float yAxisMinPad;\nuniform float yAxisPointRange;\nuniform float yAxisLen;\nuniform bool  yAxisPostTranslate;\nuniform float yAxisOrdinalSlope;\nuniform float yAxisOrdinalOffset;\nuniform float yAxisPos;\nuniform bool  yAxisCVSCoord;\nuniform bool  yAxisIsLog;\nuniform bool  yAxisReversed;\nuniform bool  isBubble;\nuniform bool  bubbleSizeByArea;\nuniform float bubbleZMin;\nuniform float bubbleZMax;\nuniform float bubbleZThreshold;\nuniform float bubbleMinSize;\nuniform float bubbleMaxSize;\nuniform bool  bubbleSizeAbs;\nuniform bool  isInverted;\nfloat bubbleRadius(){\nfloat value = aVertexPosition.w;\nfloat zMax = bubbleZMax;\nfloat zMin = bubbleZMin;\nfloat radius = 0.0;\nfloat pos = 0.0;\nfloat zRange = zMax - zMin;\nif (bubbleSizeAbs){\nvalue = value - bubbleZThreshold;\nzMax = max(zMax - bubbleZThreshold, zMin - bubbleZThreshold);\nzMin = 0.0;\n}\nif (value < zMin){\nradius = bubbleZMin / 2.0 - 1.0;\n} else {\npos = zRange > 0.0 ? (value - zMin) / zRange : 0.5;\nif (bubbleSizeByArea && pos > 0.0){\npos = sqrt(pos);\n}\nradius = ceil(bubbleMinSize + pos * (bubbleMaxSize - bubbleMinSize)) / 2.0;\n}\nreturn radius * 2.0;\n}\nfloat translate(float val,\nfloat pointPlacement,\nfloat localA,\nfloat localMin,\nfloat minPixelPadding,\nfloat pointRange,\nfloat len,\nbool  cvsCoord,\nbool  isLog,\nbool  reversed\n){\nfloat sign = 1.0;\nfloat cvsOffset = 0.0;\nif (cvsCoord) {\nsign *= -1.0;\ncvsOffset = len;\n}\nif (isLog) {\nval = log(val) / LN10;\n}\nif (reversed) {\nsign *= -1.0;\ncvsOffset -= sign * len;\n}\nreturn sign * (val - localMin) * localA + cvsOffset + \n(sign * minPixelPadding);\n}\nfloat xToPixels(float value) {\nif (skipTranslation){\nreturn value;// + xAxisPos;\n}\nreturn translate(value, 0.0, xAxisTrans, xAxisMin, xAxisMinPad, xAxisPointRange, xAxisLen, xAxisCVSCoord, xAxisIsLog, xAxisReversed);// + xAxisPos;\n}\nfloat yToPixels(float value, float checkTreshold) {\nfloat v;\nif (skipTranslation){\nv = value;// + yAxisPos;\n} else {\nv = translate(value, 0.0, yAxisTrans, yAxisMin, yAxisMinPad, yAxisPointRange, yAxisLen, yAxisCVSCoord, yAxisIsLog, yAxisReversed);// + yAxisPos;\nif (v > yAxisLen) {\nv = yAxisLen;\n}\n}\nif (checkTreshold > 0.0 && hasThreshold) {\nv = min(v, translatedThreshold);\n}\nreturn v;\n}\nvoid main(void) {\nif (isBubble){\ngl_PointSize = bubbleRadius();\n} else {\ngl_PointSize = pSize;\n}\nvColor = aColor;\nif (skipTranslation && isInverted) {\ngl_Position = uPMatrix * vec4(aVertexPosition.y + yAxisPos, aVertexPosition.x + xAxisPos, 0.0, 1.0);\n} else if (isInverted) {\ngl_Position = uPMatrix * vec4(yToPixels(aVertexPosition.y, aVertexPosition.z) + yAxisPos, xToPixels(aVertexPosition.x) + xAxisPos, 0.0, 1.0);\n} else {\ngl_Position = uPMatrix * vec4(xToPixels(aVertexPosition.x) + xAxisPos, yToPixels(aVertexPosition.y, aVertexPosition.z) + yAxisPos, 0.0, 1.0);\n}\n}",
"vertex"),c=this.stringToProgram("precision highp float;\nuniform vec4 fillColor;\nvarying highp vec2 position;\nvarying highp vec4 vColor;\nuniform sampler2D uSampler;\nuniform bool isCircle;\nuniform bool hasColor;\nvoid main(void) {\nvec4 col = fillColor;\nvec4 tcol = texture2D(uSampler, gl_PointCoord.st);\nif (hasColor) {\ncol = vColor;\n}\nif (isCircle) {\ncol *= tcol;\nif (tcol.r < 0.0) {\ndiscard;\n} else {\ngl_FragColor = col;\n}\n} else {\ngl_FragColor = col;\n}\n}","fragment"),b=function(b){return a.gl.getUniformLocation(a.shaderProgram,
b)};if(!e||!c)return this.shaderProgram=!1,this.handleErrors(),!1;this.shaderProgram=this.gl.createProgram();this.gl.attachShader(this.shaderProgram,e);this.gl.attachShader(this.shaderProgram,c);this.gl.linkProgram(this.shaderProgram);if(!this.gl.getProgramParameter(this.shaderProgram,this.gl.LINK_STATUS))return this.errors.push(this.gl.getProgramInfoLog(this.shaderProgram)),this.handleErrors(),this.shaderProgram=!1;this.gl.useProgram(this.shaderProgram);this.gl.bindAttribLocation(this.shaderProgram,
0,"aVertexPosition");this.pUniform=b("uPMatrix");this.psUniform=b("pSize");this.fcUniform=b("fillColor");this.isBubbleUniform=b("isBubble");this.bubbleSizeAbsUniform=b("bubbleSizeAbs");this.bubbleSizeAreaUniform=b("bubbleSizeByArea");this.uSamplerUniform=b("uSampler");this.skipTranslationUniform=b("skipTranslation");this.isCircleUniform=b("isCircle");this.isInverted=b("isInverted");return!0};a.prototype.handleErrors=function(){this.errors.length&&c("[highcharts boost] shader error - "+this.errors.join("\n"))};
a.prototype.stringToProgram=function(a,e){var g=this.gl.createShader("vertex"===e?this.gl.VERTEX_SHADER:this.gl.FRAGMENT_SHADER);this.gl.shaderSource(g,a);this.gl.compileShader(g);return this.gl.getShaderParameter(g,this.gl.COMPILE_STATUS)?g:(this.errors.push("when compiling "+e+" shader:\n"+this.gl.getShaderInfoLog(g)),!1)};a.prototype.destroy=function(){this.gl&&this.shaderProgram&&(this.gl.deleteProgram(this.shaderProgram),this.shaderProgram=!1)};a.prototype.fillColorUniform=function(){return this.fcUniform};
a.prototype.getProgram=function(){return this.shaderProgram};a.prototype.pointSizeUniform=function(){return this.psUniform};a.prototype.perspectiveUniform=function(){return this.pUniform};a.prototype.reset=function(){this.gl&&this.shaderProgram&&(this.gl.uniform1i(this.isBubbleUniform,0),this.gl.uniform1i(this.isCircleUniform,0))};a.prototype.setBubbleUniforms=function(a,c,m,b){void 0===b&&(b=1);var g=a.options,t=Number.MAX_VALUE,q=-Number.MAX_VALUE;if(this.gl&&this.shaderProgram&&a.is("bubble")){var E=
a.getPxExtremes();t=r(g.zMin,e(c,!1===g.displayNegative?g.zThreshold:-Number.MAX_VALUE,t));q=r(g.zMax,Math.max(q,m));this.gl.uniform1i(this.isBubbleUniform,1);this.gl.uniform1i(this.isCircleUniform,1);this.gl.uniform1i(this.bubbleSizeAreaUniform,"width"!==a.options.sizeBy);this.gl.uniform1i(this.bubbleSizeAbsUniform,a.options.sizeByAbsoluteValue);this.setUniform("bubbleMinSize",E.minPxSize*b);this.setUniform("bubbleMaxSize",E.maxPxSize*b);this.setUniform("bubbleZMin",t);this.setUniform("bubbleZMax",
q);this.setUniform("bubbleZThreshold",a.options.zThreshold)}};a.prototype.setColor=function(a){this.gl&&this.shaderProgram&&this.gl.uniform4f(this.fcUniform,a[0]/255,a[1]/255,a[2]/255,a[3])};a.prototype.setDrawAsCircle=function(a){this.gl&&this.shaderProgram&&this.gl.uniform1i(this.isCircleUniform,a?1:0)};a.prototype.setInverted=function(a){this.gl&&this.shaderProgram&&this.gl.uniform1i(this.isInverted,a)};a.prototype.setPMatrix=function(a){this.gl&&this.shaderProgram&&this.gl.uniformMatrix4fv(this.pUniform,
!1,a)};a.prototype.setPointSize=function(a){this.gl&&this.shaderProgram&&this.gl.uniform1f(this.psUniform,a)};a.prototype.setSkipTranslation=function(a){this.gl&&this.shaderProgram&&this.gl.uniform1i(this.skipTranslationUniform,!0===a?1:0)};a.prototype.setTexture=function(a){this.gl&&this.shaderProgram&&this.gl.uniform1i(this.uSamplerUniform,a)};a.prototype.setUniform=function(a,e){this.gl&&this.shaderProgram&&(a=this.uLocations[a]=this.uLocations[a]||this.gl.getUniformLocation(this.shaderProgram,
a),this.gl.uniform1f(a,e))};return a}()});v(a,"Extensions/Boost/WGLVertexBuffer.js",[],function(){return function(){function a(a,c,r){this.buffer=!1;this.iterator=0;this.vertAttribute=this.preAllocated=!1;this.components=r||2;this.dataComponents=r;this.gl=a;this.shader=c}a.prototype.allocate=function(a){this.iterator=-1;this.preAllocated=new Float32Array(4*a)};a.prototype.bind=function(){if(!this.buffer)return!1;this.gl.vertexAttribPointer(this.vertAttribute,this.components,this.gl.FLOAT,!1,0,0)};
a.prototype.build=function(a,c,r){var e;this.data=a||[];if(!(this.data&&0!==this.data.length||this.preAllocated))return this.destroy(),!1;this.components=r||this.components;this.buffer&&this.gl.deleteBuffer(this.buffer);this.preAllocated||(e=new Float32Array(this.data));this.buffer=this.gl.createBuffer();this.gl.bindBuffer(this.gl.ARRAY_BUFFER,this.buffer);this.gl.bufferData(this.gl.ARRAY_BUFFER,this.preAllocated||e,this.gl.STATIC_DRAW);this.vertAttribute=this.gl.getAttribLocation(this.shader.getProgram(),
c);this.gl.enableVertexAttribArray(this.vertAttribute);return!0};a.prototype.destroy=function(){this.buffer&&(this.gl.deleteBuffer(this.buffer),this.vertAttribute=this.buffer=!1);this.iterator=0;this.components=this.dataComponents||2;this.data=[]};a.prototype.push=function(a,c,r,t){this.preAllocated&&(this.preAllocated[++this.iterator]=a,this.preAllocated[++this.iterator]=c,this.preAllocated[++this.iterator]=r,this.preAllocated[++this.iterator]=t)};a.prototype.render=function(a,c,r){var e=this.preAllocated?
this.preAllocated.length:this.data.length;if(!this.buffer||!e)return!1;if(!a||a>e||0>a)a=0;if(!c||c>e)c=e;if(a>=c)return!1;this.gl.drawArrays(this.gl[r||"POINTS"],a/this.components,(c-a)/this.components);return!0};return a}()});v(a,"Extensions/Boost/WGLRenderer.js",[a["Core/Color/Color.js"],a["Core/Globals.js"],a["Core/Utilities.js"],a["Extensions/Boost/WGLDrawMode.js"],a["Extensions/Boost/WGLShader.js"],a["Extensions/Boost/WGLVertexBuffer.js"]],function(a,e,c,v,t,g){var r=a.parse,m=e.doc,b=e.win,
Q=c.isNumber,oa=c.isObject,q=c.merge,N=c.objectEach,O=c.pick,w={column:!0,columnrange:!0,bar:!0,area:!0,areaspline:!0,arearange:!0},K={scatter:!0,bubble:!0},D=["webgl","experimental-webgl","moz-webgl","webkit-3d"];return function(){function c(a){this.data=[];this.height=0;this.isInited=!1;this.markerData=[];this.series=[];this.textureHandles={};this.width=0;this.postRenderCallback=a;this.settings={pointSize:1,lineWidth:1,fillColor:"#AA00AA",useAlpha:!0,usePreallocated:!1,useGPUTranslations:!1,debug:{timeRendering:!1,
timeSeriesProcessing:!1,timeSetup:!1,timeBufferCopy:!1,timeKDTree:!1,showSkipSummary:!1}}}c.orthoMatrix=function(a,b){return[2/a,0,0,0,0,-(2/b),0,0,0,0,-2,0,-1,1,-1,1]};c.seriesPointCount=function(a){if(a.boosted){var n=!!a.options.stacking;var b=a.xData||a.options.xData||a.processedXData;n=(n?a.data:b||a.options.data).length;"treemap"===a.type?n*=12:"heatmap"===a.type?n*=6:w[a.type]&&(n*=2);return n}return 0};c.prototype.getPixelRatio=function(){return this.settings.pixelRatio||b.devicePixelRatio||
1};c.prototype.setOptions=function(a){"pixelRatio"in a||(a.pixelRatio=1);q(!0,this.settings,a)};c.prototype.allocateBuffer=function(a){var n=this.vbuffer,b=0;this.settings.usePreallocated&&(a.series.forEach(function(a){a.boosted&&(b+=c.seriesPointCount(a))}),n&&n.allocate(b))};c.prototype.allocateBufferForSingleSeries=function(a){var n=this.vbuffer,b=0;this.settings.usePreallocated&&(a.boosted&&(b=c.seriesPointCount(a)),n&&n.allocate(b))};c.prototype.clear=function(){var a=this.gl;a&&a.clear(a.COLOR_BUFFER_BIT|
a.DEPTH_BUFFER_BIT)};c.prototype.pushSeriesData=function(a,b){var n=this,c=this.data,g=this.settings,f=this.vbuffer,k=a.pointArrayMap&&"low,high"===a.pointArrayMap.join(","),p=a.chart,l=a.options,G=!!l.stacking,fa=l.data,d=a.xAxis.getExtremes(),S=d.min,e=d.max;d=a.yAxis.getExtremes();var m=d.min,t=d.max,q=a.xData||l.xData||a.processedXData,K=a.yData||l.yData||a.processedYData,H=a.zData||l.zData||a.processedZData,D=a.yAxis,v=a.xAxis,y=!q||0===q.length,O=l.connectNulls;d=a.points||!1;var F=G?a.data:
q||fa,h={x:Number.MAX_VALUE,y:0},B={x:-Number.MAX_VALUE,y:0},wa="undefined"===typeof p.index,Ga=w[a.type],ya=l.zoneAxis||"y",aa=l.zones||!1,V=l.threshold,ba=this.getPixelRatio(),sa=a.chart.plotWidth,ia=!1,E=!1,Z,T,ea=0,Q=!1,C,x,J,ja,z=-1,R=!1,W=!1,P,N=!1,ma=!1,A=!1,ta=!1,ua=!0,na=!0,L=!1,M=!1,ca=0;if(!(l.boostData&&0<l.boostData.length)){l.gapSize&&(M="value"!==l.gapUnit?l.gapSize*a.closestPointRange:l.gapSize);if(aa){var da=[];aa.forEach(function(a,b){if(a.color){var h=r(a.color).rgba;h[0]/=255;
h[1]/=255;h[2]/=255;da[b]=h;L||"undefined"!==typeof a.value||(L=h)}});L||(q=a.pointAttribs&&a.pointAttribs().fill||a.color,L=r(q).rgba,L[0]/=255,L[1]/=255,L[2]/=255)}p.inverted&&(sa=a.chart.plotHeight);a.closestPointRangePx=Number.MAX_VALUE;var ka=function(a){a&&(b.colorData.push(a[0]),b.colorData.push(a[1]),b.colorData.push(a[2]),b.colorData.push(a[3]))},X=function(a,h,B,k,n){void 0===k&&(k=1);ka(n);1===ba||g.useGPUTranslations&&!b.skipTranslation||(a*=ba,h*=ba,k*=ba);g.usePreallocated&&f?(f.push(a,
h,B?1:0,k),ca+=4):(c.push(a),c.push(h),c.push(B?ba:0),c.push(k))},Da=function(){b.segments.length&&(b.segments[b.segments.length-1].to=c.length||ca)},xa=function(){b.segments.length&&b.segments[b.segments.length-1].from===(c.length||ca)||(Da(),b.segments.push({from:c.length||ca}))},Ea=function(a,h,b,f,k){ka(k);X(a+b,h);ka(k);X(a,h);ka(k);X(a,h+f);ka(k);X(a,h+f);ka(k);X(a+b,h+f);ka(k);X(a+b,h)};xa();if(d&&0<d.length)b.skipTranslation=!0,b.drawMode="TRIANGLES",d[0].node&&d[0].node.levelDynamic&&d.sort(function(a,
h){if(a.node){if(a.node.levelDynamic>h.node.levelDynamic)return 1;if(a.node.levelDynamic<h.node.levelDynamic)return-1}return 0}),d.forEach(function(h){var b=h.plotY;if("undefined"!==typeof b&&!isNaN(b)&&null!==h.y&&h.shapeArgs){var f=h.shapeArgs;b=f.x;b=void 0===b?0:b;var k=f.y;k=void 0===k?0:k;var B=f.width;B=void 0===B?0:B;f=f.height;f=void 0===f?0:f;var n=p.styledMode?h.series.colorAttribs(h):n=h.series.pointAttribs(h);h=n["stroke-width"]||0;A=r(n.fill).rgba;A[0]/=255;A[1]/=255;A[2]/=255;a.is("treemap")&&
(h=h||1,T=r(n.stroke).rgba,T[0]/=255,T[1]/=255,T[2]/=255,Ea(b,k,B,f,T),h/=2);a.is("heatmap")&&p.inverted&&(b=v.len-b,k=D.len-k,B=-B,f=-f);Ea(b+h,k+h,B-2*h,f-2*h,A)}});else{for(d=function(){J=F[++z];if("undefined"===typeof J)return"continue";if(wa)return"break";var f=fa&&fa[z];!y&&oa(f,!0)&&f.color&&(A=r(f.color).rgba,A[0]/=255,A[1]/=255,A[2]/=255);y?(C=J[0],x=J[1],F[z+1]&&(W=F[z+1][0]),F[z-1]&&(R=F[z-1][0]),3<=J.length&&(ja=J[2],J[2]>b.zMax&&(b.zMax=J[2]),J[2]<b.zMin&&(b.zMin=J[2]))):(C=J,x=K[z],
F[z+1]&&(W=F[z+1]),F[z-1]&&(R=F[z-1]),H&&H.length&&(ja=H[z],H[z]>b.zMax&&(b.zMax=H[z]),H[z]<b.zMin&&(b.zMin=H[z])));if(!O&&(null===C||null===x))return xa(),"continue";W&&W>=S&&W<=e&&(N=!0);R&&R>=S&&R<=e&&(ma=!0);k?(y&&(x=J.slice(1,3)),P=x[0],x=x[1]):G&&(C=J.x,x=J.stackY,P=x-J.y);null!==m&&"undefined"!==typeof m&&null!==t&&"undefined"!==typeof t&&(ua=x>=m&&x<=t);C>e&&B.x<e&&(B.x=C,B.y=x);C<S&&h.x>S&&(h.x=C,h.y=x);if(null===x&&O)return"continue";if(null===x||!ua&&!N&&!ma)return xa(),"continue";(W>=
S||C>=S)&&(R<=e||C<=e)&&(ta=!0);if(!ta&&!N&&!ma)return"continue";M&&C-R>M&&xa();if(aa){var n;aa.some(function(a,h){var b=aa[h-1];return"x"===ya?"undefined"!==typeof a.value&&C<=a.value?(da[h]&&(!b||C>=b.value)&&(n=da[h]),!0):!1:"undefined"!==typeof a.value&&x<=a.value?(da[h]&&(!b||x>=b.value)&&(n=da[h]),!0):!1});A=n||L||A}if(!g.useGPUTranslations&&(b.skipTranslation=!0,C=v.toPixels(C,!0),x=D.toPixels(x,!0),C>sa&&"POINTS"===b.drawMode))return"continue";b.hasMarkers&&ta&&!1!==ia&&(a.closestPointRangePx=
Math.min(a.closestPointRangePx,Math.abs(C-ia)));if(!g.useGPUTranslations&&!g.usePreallocated&&ia&&1>Math.abs(C-ia)&&E&&1>Math.abs(x-E))return g.debug.showSkipSummary&&++ea,"continue";if(Ga){Z=P;if(!1===P||"undefined"===typeof P)Z=0>x?x:0;k||G||(Z=Math.max(null===V?m:V,m));g.useGPUTranslations||(Z=D.toPixels(Z,!0));X(C,Z,0,0,A)}l.step&&!na&&X(C,E,0,2,A);X(C,x,0,"bubble"===a.type?ja||1:2,A);ia=C;E=x;Q=!0;na=!1};z<F.length-1&&"break"!==d(););g.debug.showSkipSummary&&console.log("skipped points:",ea);
d=function(a,h){g.useGPUTranslations||(b.skipTranslation=!0,a.x=v.toPixels(a.x,!0),a.y=D.toPixels(a.y,!0));h?n.data=[a.x,a.y,0,2].concat(n.data):X(a.x,a.y,0,2)};Q||!1===O||"line_strip"!==a.drawMode||(h.x<Number.MAX_VALUE&&d(h,!0),B.x>-Number.MAX_VALUE&&d(B))}Da()}};c.prototype.pushSeries=function(a){var b=this.markerData,n=this.series,c=this.settings;0<n.length&&n[n.length-1].hasMarkers&&(n[n.length-1].markerTo=b.length);c.debug.timeSeriesProcessing&&console.time("building "+a.type+" series");b={segments:[],
markerFrom:b.length,colorData:[],series:a,zMin:Number.MAX_VALUE,zMax:-Number.MAX_VALUE,hasMarkers:a.options.marker?!1!==a.options.marker.enabled:!1,showMarkers:!0,drawMode:v[a.type]||"LINE_STRIP"};a.index>=n.length?n.push(b):n[a.index]=b;this.pushSeriesData(a,b);c.debug.timeSeriesProcessing&&console.timeEnd("building "+a.type+" series")};c.prototype.flush=function(){var a=this.vbuffer;this.data=[];this.markerData=[];this.series=[];a&&a.destroy()};c.prototype.setXAxis=function(a){var b=this.shader;
if(b){var c=this.getPixelRatio();b.setUniform("xAxisTrans",a.transA*c);b.setUniform("xAxisMin",a.min);b.setUniform("xAxisMinPad",a.minPixelPadding*c);b.setUniform("xAxisPointRange",a.pointRange);b.setUniform("xAxisLen",a.len*c);b.setUniform("xAxisPos",a.pos*c);b.setUniform("xAxisCVSCoord",!a.horiz);b.setUniform("xAxisIsLog",!!a.logarithmic);b.setUniform("xAxisReversed",!!a.reversed)}};c.prototype.setYAxis=function(a){var b=this.shader;if(b){var c=this.getPixelRatio();b.setUniform("yAxisTrans",a.transA*
c);b.setUniform("yAxisMin",a.min);b.setUniform("yAxisMinPad",a.minPixelPadding*c);b.setUniform("yAxisPointRange",a.pointRange);b.setUniform("yAxisLen",a.len*c);b.setUniform("yAxisPos",a.pos*c);b.setUniform("yAxisCVSCoord",!a.horiz);b.setUniform("yAxisIsLog",!!a.logarithmic);b.setUniform("yAxisReversed",!!a.reversed)}};c.prototype.setThreshold=function(a,b){var c=this.shader;c&&(c.setUniform("hasThreshold",a),c.setUniform("translatedThreshold",b))};c.prototype.renderChart=function(b){var n=this,u=
this.gl,m=this.settings,q=this.shader,f=this.vbuffer,k=this.getPixelRatio();if(b)this.width=b.chartWidth*k,this.height=b.chartHeight*k;else return!1;var p=this.height,l=this.width;if(!(u&&q&&l&&p))return!1;m.debug.timeRendering&&console.time("gl rendering");u.canvas.width=l;u.canvas.height=p;q.bind();u.viewport(0,0,l,p);q.setPMatrix(c.orthoMatrix(l,p));1<m.lineWidth&&!e.isMS&&u.lineWidth(m.lineWidth);f&&(f.build(this.data,"aVertexPosition",4),f.bind());q.setInverted(b.inverted);this.series.forEach(function(c,
l){var d=c.series.options,e=d.marker,p="undefined"!==typeof d.lineWidth?d.lineWidth:1,G=d.threshold,t=Q(G),w=c.series.yAxis.getThreshold(G);G=O(d.marker?d.marker.enabled:null,c.series.xAxis.isRadial?!0:null,c.series.closestPointRangePx>2*((d.marker?d.marker.radius:10)||10));e=n.textureHandles[e&&e.symbol||c.series.symbol]||n.textureHandles.circle;if(0!==c.segments.length&&c.segments[0].from!==c.segments[0].to&&(e.isReady&&(u.bindTexture(u.TEXTURE_2D,e.handle),q.setTexture(e.handle)),b.styledMode?
e=c.series.markerGroup&&c.series.markerGroup.getStyle("fill"):(e="POINTS"===c.drawMode&&c.series.pointAttribs&&c.series.pointAttribs().fill||c.series.color,d.colorByPoint&&(e=c.series.chart.options.colors[l])),c.series.fillOpacity&&d.fillOpacity&&(e=(new a(e)).setOpacity(O(d.fillOpacity,1)).get()),e=r(e).rgba,m.useAlpha||(e[3]=1),"LINES"===c.drawMode&&m.useAlpha&&1>e[3]&&(e[3]/=10),"add"===d.boostBlending?(u.blendFunc(u.SRC_ALPHA,u.ONE),u.blendEquation(u.FUNC_ADD)):"mult"===d.boostBlending||"multiply"===
d.boostBlending?u.blendFunc(u.DST_COLOR,u.ZERO):"darken"===d.boostBlending?(u.blendFunc(u.ONE,u.ONE),u.blendEquation(u.FUNC_MIN)):u.blendFuncSeparate(u.SRC_ALPHA,u.ONE_MINUS_SRC_ALPHA,u.ONE,u.ONE_MINUS_SRC_ALPHA),q.reset(),0<c.colorData.length?(q.setUniform("hasColor",1),l=new g(u,q),l.build(c.colorData,"aColor",4),l.bind()):u.disableVertexAttribArray(u.getAttribLocation(q.getProgram(),"aColor")),q.setColor(e),n.setXAxis(c.series.xAxis),n.setYAxis(c.series.yAxis),n.setThreshold(t,w),"POINTS"===c.drawMode&&
q.setPointSize(2*O(d.marker&&d.marker.radius,.5)*k),q.setSkipTranslation(c.skipTranslation),"bubble"===c.series.type&&q.setBubbleUniforms(c.series,c.zMin,c.zMax,k),q.setDrawAsCircle(K[c.series.type]||!1),f)){if(0<p||"LINE_STRIP"!==c.drawMode)for(p=0;p<c.segments.length;p++)f.render(c.segments[p].from,c.segments[p].to,c.drawMode);if(c.hasMarkers&&G)for(q.setPointSize(2*O(d.marker&&d.marker.radius,5)*k),q.setDrawAsCircle(!0),p=0;p<c.segments.length;p++)f.render(c.segments[p].from,c.segments[p].to,"POINTS")}});
m.debug.timeRendering&&console.timeEnd("gl rendering");this.postRenderCallback&&this.postRenderCallback(this);this.flush()};c.prototype.render=function(a){var b=this;this.clear();if(a.renderer.forExport)return this.renderChart(a);this.isInited?this.renderChart(a):setTimeout(function(){b.render(a)},1)};c.prototype.setSize=function(a,b){var e=this.shader;!e||this.width===a&&this.height===b||(this.width=a,this.height=b,e.bind(),e.setPMatrix(c.orthoMatrix(a,b)))};c.prototype.init=function(a,b){var c=
this,e=this.settings;this.isInited=!1;if(!a)return!1;e.debug.timeSetup&&console.time("gl setup");for(var n=0;n<D.length&&!(this.gl=a.getContext(D[n],{}));++n);var f=this.gl;if(f)b||this.flush();else return!1;f.enable(f.BLEND);f.blendFunc(f.SRC_ALPHA,f.ONE_MINUS_SRC_ALPHA);f.disable(f.DEPTH_TEST);f.depthFunc(f.LESS);a=this.shader=new t(f);if(!a)return!1;this.vbuffer=new g(f,a);a=function(a,b){var k={isReady:!1,texture:m.createElement("canvas"),handle:f.createTexture()},e=k.texture.getContext("2d");
c.textureHandles[a]=k;k.texture.width=512;k.texture.height=512;e.mozImageSmoothingEnabled=!1;e.webkitImageSmoothingEnabled=!1;e.msImageSmoothingEnabled=!1;e.imageSmoothingEnabled=!1;e.strokeStyle="rgba(255, 255, 255, 0)";e.fillStyle="#FFF";b(e);try{f.activeTexture(f.TEXTURE0),f.bindTexture(f.TEXTURE_2D,k.handle),f.texImage2D(f.TEXTURE_2D,0,f.RGBA,f.RGBA,f.UNSIGNED_BYTE,k.texture),f.texParameteri(f.TEXTURE_2D,f.TEXTURE_WRAP_S,f.CLAMP_TO_EDGE),f.texParameteri(f.TEXTURE_2D,f.TEXTURE_WRAP_T,f.CLAMP_TO_EDGE),
f.texParameteri(f.TEXTURE_2D,f.TEXTURE_MAG_FILTER,f.LINEAR),f.texParameteri(f.TEXTURE_2D,f.TEXTURE_MIN_FILTER,f.LINEAR),f.bindTexture(f.TEXTURE_2D,null),k.isReady=!0}catch(ha){}};a("circle",function(a){a.beginPath();a.arc(256,256,256,0,2*Math.PI);a.stroke();a.fill()});a("square",function(a){a.fillRect(0,0,512,512)});a("diamond",function(a){a.beginPath();a.moveTo(256,0);a.lineTo(512,256);a.lineTo(256,512);a.lineTo(0,256);a.lineTo(256,0);a.fill()});a("triangle",function(a){a.beginPath();a.moveTo(0,
512);a.lineTo(256,0);a.lineTo(512,512);a.lineTo(0,512);a.fill()});a("triangle-down",function(a){a.beginPath();a.moveTo(0,0);a.lineTo(256,512);a.lineTo(512,0);a.lineTo(0,0);a.fill()});this.isInited=!0;e.debug.timeSetup&&console.timeEnd("gl setup");return!0};c.prototype.destroy=function(){var a=this.gl,b=this.shader,c=this.vbuffer;this.flush();c&&c.destroy();b&&b.destroy();a&&(N(this.textureHandles,function(b){b.handle&&a.deleteTexture(b.handle)}),a.canvas.width=1,a.canvas.height=1)};return c}()});
v(a,"Extensions/Boost/BoostSeries.js",[a["Extensions/Boost/BoostableMap.js"],a["Extensions/Boost/Boostables.js"],a["Extensions/Boost/BoostChart.js"],a["Core/Defaults.js"],a["Core/Globals.js"],a["Core/Utilities.js"],a["Extensions/Boost/WGLRenderer.js"]],function(a,e,c,v,t,g,E){function m(a,b){var h=b.boost;a&&h&&h.target&&h.canvas&&!l(b.chart)&&a.allocateBufferForSingleSeries(b)}function b(a){return Aa(a&&a.options&&a.options.boost&&a.options.boost.enabled,!0)}function r(a,b){var h=a.constructor,f=
a.seriesGroup||b.group,c=a.chartWidth,B=a.chartHeight,e=a,k="undefined"!==typeof SVGForeignObjectElement;e=l(a)?a:b;var d=e.boost=e.boost||{};k=!1;F||(F=ha.createElement("canvas"));d.target||(d.canvas=F,a.renderer.forExport||!k?(e.renderTarget=d.target=a.renderer.image("",0,0,c,B).addClass("highcharts-boost-canvas").add(f),d.clear=function(){d.target.attr({href:"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAEAAAABCAQAAAC1HAwCAAAAC0lEQVR42mNkYAAAAAYAAjCB0C8AAAAASUVORK5CYII="})},d.copy=function(){d.resize();
d.target.attr({href:d.canvas.toDataURL("image/png")})}):(d.targetFo=a.renderer.createElement("foreignObject").add(f),e.renderTarget=d.target=ha.createElement("canvas"),d.targetCtx=d.target.getContext("2d"),d.targetFo.element.appendChild(d.target),d.clear=function(){d.target.width=d.canvas.width;d.target.height=d.canvas.height},d.copy=function(){d.target.width=d.canvas.width;d.target.height=d.canvas.height;d.targetCtx.drawImage(d.canvas,0,0)}),d.resize=function(){c=a.chartWidth;B=a.chartHeight;(d.targetFo||
d.target).attr({x:0,y:0,width:c,height:B}).css({pointerEvents:"none",mixedBlendMode:"normal",opacity:1});e instanceof h&&e.boost.markerGroup.translate(a.plotLeft,a.plotTop)},d.clipRect=a.renderer.clipRect(),(d.targetFo||d.target).clip(d.clipRect),e instanceof h&&(e.boost.markerGroup=e.renderer.g().add(f).translate(b.xAxis.pos,b.yAxis.pos)));d.canvas.width=c;d.canvas.height=B;d.clipRect&&d.clipRect.attr(p(a,e));d.resize();d.clear();d.wgl||(d.wgl=new E(function(a){a.settings.debug.timeBufferCopy&&console.time("buffer copy");
d.copy();a.settings.debug.timeBufferCopy&&console.timeEnd("buffer copy")}),d.wgl.init(d.canvas)||za("[highcharts boost] - unable to init WebGL renderer"),d.wgl.setOptions(a.options.boost||{}),e instanceof h&&d.wgl.allocateBuffer(a));d.wgl.setSize(c,B);return d.wgl}function Q(a){var b=a.points;if(b){var h=void 0,c=void 0;for(c=0;c<b.length;c+=1)(h=b[c])&&h.destroyElements&&h.destroyElements()}["graph","area","tracker"].forEach(function(b){var h=a[b];h&&(a[b]=h.destroy())});a.getZonesGraphs&&a.getZonesGraphs([["graph",
"highcharts-graph"]]).forEach(function(b){var h=a[b[0]];h&&(a[b[0]]=h.destroy())})}function q(a,b,c,f,d,e){d=d||0;f=f||3E3;for(var h=d+f,k=!0;k&&d<h&&d<a.length;)k=b(a[d],d),++d;k&&(d<a.length?e?q(a,b,c,f,d,e):S.requestAnimationFrame?S.requestAnimationFrame(function(){q(a,b,c,f,d)}):setTimeout(q,0,a,b,c,f,d):c&&c())}function N(a){a.boost=a.boost||{getPoint:function(b){return n(a,b)}};var b=a.boost.altered=[];["allowDG","directTouch","stickyTracking"].forEach(function(c){b.push({prop:c,val:a[c],own:Object.hasOwnProperty.call(a,
c)})});a.allowDG=!1;a.directTouch=!1;a.stickyTracking=!0;a.finishedAnimating=!0;a.labelBySeries&&(a.labelBySeries=a.labelBySeries.destroy())}function O(a){var b=a.boost;b&&((b.altered||[]).forEach(function(b){b.own?a[b.prop]=b.val:delete a[b.prop]}),b.clear&&b.clear())}function w(a,b){var c=a.options,f=a.xAxis&&a.xAxis.options,d=a.yAxis&&a.yAxis.options;a=a.colorAxis&&a.colorAxis.options;return c.data.length>(c.boostThreshold||Number.MAX_VALUE)&&H(d.min)&&H(d.max)&&(!b||H(f.min)&&H(f.max))&&(!a||
H(a.min)&&H(a.max))}function K(){var a=this,b=a.chart;b.boost&&b.boost.markerGroup===a.markerGroup&&(a.markerGroup=null);b.hoverPoints&&(b.hoverPoints=b.hoverPoints.filter(function(b){return b.series===a}));b.hoverPoint&&b.hoverPoint.series===a&&(b.hoverPoint=null)}function D(){var a=this.boost;a&&a.canvas&&a.target&&(a.wgl&&a.wgl.clear(),a.clear&&a.clear())}function ea(a){var b=a.boost;b&&b.canvas&&b.target&&b.wgl&&!l(a.chart)&&b.wgl.render(a.chart)}function n(a,b){var c=a.options,f=a.xAxis,d=a.pointClass;
if(b instanceof d)return b;c=a.xData||c.xData||a.processedXData||!1;d=(new d).init(a,a.options.data[b.i],c?c[b.i]:void 0);d.category=Aa(f.categories?f.categories[d.x]:d.x,d.x);d.dist=b.dist;d.distX=b.distX;d.plotX=b.plotX;d.plotY=b.plotY;d.index=b.i;d.percentage=b.percentage;d.isInside=a.isPointInside(d);return d}function fa(){function a(a,b){var c="undefined"===typeof f.index,d=!1,h=!0;if("undefined"===typeof a)return!0;if(!c){if(O){var g=a[0];var l=a[1]}else g=a,l=p[b];if(y)O&&(l=a.slice(1,3)),
d=l[0],l=l[1];else if(v){g=a.x;l=a.stackY;d=l-a.y;var n=a.percentage}D||(h=(l||0)>=u&&l<=K);if(null!==l&&g>=S&&g<=t&&h)if(a=e.toPixels(g,!0),C){if("undefined"===typeof Y||a===ha){y||(d=l);if("undefined"===typeof L||l>I)I=l,L=b;if("undefined"===typeof Y||d<F)F=d,Y=b}E&&a===ha||("undefined"!==typeof Y&&(l=k.toPixels(I,!0),A=k.toPixels(F,!0),ca(a,l,L,n),A!==l&&ca(a,A,Y,n)),Y=L=void 0,ha=a)}else l=Math.ceil(k.toPixels(l,!0)),ca(a,l,b,n)}return!c}var b=this,c=this.options||{},f=this.chart,e=this.xAxis,
k=this.yAxis,g=c.xData||this.processedXData,p=c.yData||this.processedYData,n=c.data,G=e.getExtremes(),S=G.min,t=G.max;G=k.getExtremes();var u=G.min,K=G.max,w={},C=!!this.sampling,x=!1!==c.enableMouseTracking;G=c.threshold;var y=this.pointArrayMap&&"low,high"===this.pointArrayMap.join(","),v=!!c.stacking,z=this.cropStart||0,D=this.requireSorting,O=!g,E="x"===c.findNearestPointBy,H=this.xData||this.options.xData||this.processedXData||!1;c=!1;var ha,A=k.getThreshold(G),F,I,Y,L;c=r(f,this);f.boosted=
!0;if(this.visible){(this.points||this.graph)&&Q(this);l(f)?(this.markerGroup&&this.markerGroup!==f.boost.markerGroup&&this.markerGroup.destroy(),this.markerGroup=f.boost.markerGroup,this.boost&&this.boost.target&&(this.renderTarget=this.boost.target=this.boost.target.destroy())):(f.boost&&this.markerGroup===f.boost.markerGroup&&(this.markerGroup=void 0),this.markerGroup=this.plotGroup("markerGroup","markers",!0,1,f.seriesGroup));var M=this.points=[],ca=function(a,b,c,d){a=Math.ceil(a);ra=E?a:a+","+
b;x&&!w[ra]&&(w[ra]=!0,f.inverted&&(a=e.len-a,b=k.len-b),M.push({x:H?H[z+c]:!1,clientX:a,plotX:a,plotY:b,i:z+c,percentage:d}))};this.buildKDTree=d;c&&(m(c,this),c.pushSeries(this),ea(this));var da=c.settings;c=function(){pa(b,"renderedCanvas");delete b.buildKDTree;b.buildKDTree();da.debug.timeKDTree&&console.timeEnd("kd tree building")};f.renderer.forExport||(da.debug.timeKDTree&&console.time("kd tree building"),q(v?this.data:g||n,a,c))}}function u(a){var b=!0;this.chart.options&&this.chart.options.boost&&
(b="undefined"===typeof this.chart.options.boost.enabled?!0:this.chart.options.boost.enabled);if(!b||!this.boosted)return a.call(this);this.chart.boosted=!0;if(a=r(this.chart,this))m(a,this),a.pushSeries(this);ea(this)}function la(c,f,d){function e(c){var f=this.options.stacking&&("translate"===d||"generatePoints"===d);this.boosted&&!f&&b(this.chart)&&"heatmap"!==this.type&&"treemap"!==this.type&&a[this.type]&&0!==this.options.boostThreshold?"render"===d&&this.renderCanvas&&this.renderCanvas():c.call(this)}
U(c,d,e);"translate"===d&&["column","arearange","columnrange","heatmap","treemap"].forEach(function(a){f[a]&&U(f[a].prototype,d,e)})}function va(a){return this.boosted&&w(this)?{}:a.apply(this,[].slice.call(arguments,1))}function f(c){var f=this,d=this.options.data,e=function(a){return f.forceCrop?!1:l(f.chart)||(a?a.length:0)>=(f.options.boostThreshold||Number.MAX_VALUE)};b(this.chart)&&a[this.type]?(e(d)&&"heatmap"!==this.type&&"treemap"!==this.type&&!this.options.stacking&&w(this,!0)||(c.apply(this,
[].slice.call(arguments,1)),d=this.processedXData),(this.boosted=e(d))?(d=void 0,this.options.data&&this.options.data.length&&(d=this.getFirstValidPoint(this.options.data),H(d)||qa(d)||za(12,!1,this.chart)),N(this)):O(this)):c.apply(this,[].slice.call(arguments,1))}function k(a){var b=a.apply(this,[].slice.call(arguments,1));return this.boost&&b?this.boost.getPoint(b):b}var p=c.getBoostClipRect,l=c.isChartSeriesBoosting,G=v.getOptions,ha=t.doc,d=t.noop,S=t.win,Y=g.addEvent,za=g.error,I=g.extend,pa=
g.fireEvent,qa=g.isArray,H=g.isNumber,Aa=g.pick,U=g.wrap,y=[],ra,F;return{compose:function(a,b,c){if(-1===y.indexOf(a)){y.push(a);Y(a,"destroy",K);Y(a,"hide",D);var d=a.prototype;c&&(d.renderCanvas=fa);U(d,"getExtremes",va);U(d,"processData",f);U(d,"searchPoint",k);["translate","generatePoints","drawTracker","drawPoints","render"].forEach(function(a){return la(d,b,a)})}if(-1===y.indexOf(G)){y.push(G);var g=G().plotOptions;e.forEach(function(a){var c=g[a];c&&(c.boostThreshold=5E3,c.boostData=[],b[a].prototype.fillOpacity=
!0)})}if(c){var h=b.area,l=b.areaspline,p=b.bubble;c=b.column;var n=b.heatmap,q=b.scatter,m=b.treemap;h&&-1===y.indexOf(h)&&(y.push(h),I(h.prototype,{fill:!0,fillOpacity:!0,sampling:!0}));l&&-1===y.indexOf(l)&&(y.push(l),I(l.prototype,{fill:!0,fillOpacity:!0,sampling:!0}));p&&-1===y.indexOf(p)&&(y.push(p),h=p.prototype,delete h.buildKDTree,U(h,"markerAttribs",function(a){return this.boosted?!1:a.apply(this,[].slice.call(arguments,1))}));c&&-1===y.indexOf(c)&&(y.push(c),I(c.prototype,{fill:!0,sampling:!0}));
q&&-1===y.indexOf(q)&&(y.push(q),q.prototype.fill=!0);[n,m].forEach(function(a){a&&-1===y.indexOf(a)&&(y.push(a),U(a.prototype,"drawPoints",u))})}return a},destroyGraphics:Q,getPoint:n}});v(a,"Extensions/BoostCanvas.js",[a["Extensions/Boost/BoostChart.js"],a["Extensions/Boost/BoostSeries.js"],a["Core/Chart/Chart.js"],a["Core/Color/Color.js"],a["Core/Globals.js"],a["Core/Series/Series.js"],a["Core/Series/SeriesRegistry.js"],a["Core/Utilities.js"]],function(a,e,c,v,t,g,E,m){var b=a.getBoostClipRect,
r=a.isChartSeriesBoosting,Q=e.destroyGraphics,q=v.parse,N=t.doc,O=t.noop,w=E.seriesTypes,K=m.addEvent,D=m.extend,ea=m.fireEvent,n=m.isNumber,fa=m.merge,u=m.pick,la=m.wrap,va;return function(){t.seriesTypes.heatmap&&la(t.seriesTypes.heatmap.prototype,"drawPoints",function(){var a=this.chart,b=this.getContext(),c=this.chart.inverted,e=this.xAxis,g=this.yAxis;b?(this.points.forEach(function(f){var d=f.plotY;if("undefined"!==typeof d&&!isNaN(d)&&null!==f.y&&b){var k=f.shapeArgs||{};d=k.x;d=void 0===d?
0:d;var l=k.y;l=void 0===l?0:l;var p=k.width;p=void 0===p?0:p;k=k.height;k=void 0===k?0:k;f=a.styledMode?f.series.colorAttribs(f):f.series.pointAttribs(f);b.fillStyle=f.fill;c?b.fillRect(g.len-l+e.left,e.len-d+g.top,-k,-p):b.fillRect(d+e.left,l+g.top,p,k)}}),this.canvasToSVG()):this.chart.showLoading("Your browser doesn't support HTML5 canvas, <br>please use a modern browser")});D(g.prototype,{getContext:function(){var a=this.chart,c=r(a)?a:this,e=c===a?a.seriesGroup:a.seriesGroup||this.group,g=a.chartWidth,
n=a.chartHeight,q=function(a,b,c,d,f,e,k){a.call(this,c,b,d,f,e,k)},d=c.boost=c.boost||{};var m=d.targetCtx;d.canvas||(d.canvas=N.createElement("canvas"),d.target=a.renderer.image("",0,0,g,n).addClass("highcharts-boost-canvas").add(e),m=d.targetCtx=d.canvas.getContext("2d"),a.inverted&&["moveTo","lineTo","rect","arc"].forEach(function(a){la(m,a,q)}),d.copy=function(){d.target.attr({href:d.canvas.toDataURL("image/png")})},d.clear=function(){m.clearRect(0,0,d.canvas.width,d.canvas.height);c===d.target&&
d.target.attr({href:"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAEAAAABCAQAAAC1HAwCAAAAC0lEQVR42mNkYAAAAAYAAjCB0C8AAAAASUVORK5CYII="})},d.clipRect=a.renderer.clipRect(),d.target.clip(d.clipRect));d.canvas.width!==g&&(d.canvas.width=g);d.canvas.height!==n&&(d.canvas.height=n);d.target.attr({x:0,y:0,width:g,height:n,style:"pointer-events: none",href:"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAEAAAABCAQAAAC1HAwCAAAAC0lEQVR42mNkYAAAAAYAAjCB0C8AAAAASUVORK5CYII="});d.clipRect&&d.clipRect.attr(b(a,
c));return m},canvasToSVG:function(){r(this.chart)?this.boost&&this.boost.clear&&this.boost.clear():this.boost&&this.boost.copy?this.boost.copy():this.chart.boost&&this.chart.boost.copy&&this.chart.boost.copy()},cvsLineTo:function(a,b,c){a.lineTo(b,c)},renderCanvas:function(){var a=this,b=a.options,c=a.chart,e=this.xAxis,g=this.yAxis,r=(c.options.boost||{}).timeRendering||!1,d=0,w=a.processedXData,E=a.processedYData,N=b.data,I=e.getExtremes(),pa=I.min,qa=I.max;I=g.getExtremes();var H=I.min,la=I.max,
U={},y,ra=!!a.sampling,F=b.marker&&b.marker.radius,h=this.cvsDrawPoint,B=b.lineWidth?this.cvsLineTo:void 0,wa=F&&1>=F?this.cvsMarkerSquare:this.cvsMarkerCircle,oa=this.cvsStrokeBatch||1E3,ya=!1!==b.enableMouseTracking,aa;I=b.threshold;var V=g.getThreshold(I),ba=n(I),sa=V,ia=this.fill,Ba=a.pointArrayMap&&"low,high"===a.pointArrayMap.join(","),Z=!!b.stacking,T=a.cropStart||0;I=c.options.loading;var Fa=a.requireSorting,Ca,C=b.connectNulls,x=!w,J,ja,z,R,W,P=Z?a.data:w||N,Ha=a.fillOpacity?v.parse(a.color).setOpacity(u(b.fillOpacity,
.75)).get():a.color,ma=function(){ia?(M.fillStyle=Ha,M.fill()):(M.strokeStyle=a.color,M.lineWidth=b.lineWidth,M.stroke())},A=function(b,f,e,g){0===d&&(M.beginPath(),B&&(M.lineJoin="round"));c.scroller&&"highcharts-navigator-series"===a.options.className?(f+=c.scroller.top,e&&(e+=c.scroller.top)):f+=c.plotTop;b+=c.plotLeft;Ca?M.moveTo(b,f):h?h(M,b,f,e,aa):B?B(M,b,f):wa&&wa.call(a,M,b,f,F,g);d+=1;d===oa&&(ma(),d=0);aa={clientX:b,plotY:f,yBottom:e}},ta="x"===b.findNearestPointBy,ua=this.xData||this.options.xData||
this.processedXData||!1,na=function(a,b,d){W=ta?a:a+","+b;ya&&!U[W]&&(U[W]=!0,c.inverted&&(a=e.len-a,b=g.len-b),L.push({x:ua?ua[T+d]:!1,clientX:a,plotX:a,plotY:b,i:T+d}))};w=this.boost||{};w.target&&w.target.attr({href:"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAEAAAABCAQAAAC1HAwCAAAAC0lEQVR42mNkYAAAAAYAAjCB0C8AAAAASUVORK5CYII="});(this.points||this.graph)&&Q(this);a.plotGroup("group","series",a.visible?"visible":"hidden",b.zIndex,c.seriesGroup);a.markerGroup=a.group;K(a,"destroy",function(){a.markerGroup=
null});var L=this.points=[];var M=this.getContext();a.buildKDTree=O;w.clear&&w.clear();this.visible&&(99999<N.length&&(c.options.loading=fa(I,{labelStyle:{backgroundColor:q("#ffffff").setOpacity(.75).get(),padding:"1em",borderRadius:"0.5em"},style:{backgroundColor:"none",opacity:1}}),m.clearTimeout(va),c.showLoading("Drawing..."),c.options.loading=I),r&&console.time("canvas rendering"),t.eachAsync(P,function(b,d){var f=!1,k=!1,h=!1,l=!1,n="undefined"===typeof c.index,q=!0;if(!n){if(x){var m=b[0];
var p=b[1];P[d+1]&&(h=P[d+1][0]);P[d-1]&&(l=P[d-1][0])}else m=b,p=E[d],P[d+1]&&(h=P[d+1]),P[d-1]&&(l=P[d-1]);h&&h>=pa&&h<=qa&&(f=!0);l&&l>=pa&&l<=qa&&(k=!0);if(Ba){x&&(p=b.slice(1,3));var r=p[0];p=p[1]}else Z&&(m=b.x,p=b.stackY,r=p-b.y);b=null===p;Fa||(q=p>=H&&p<=la);if(!b&&(m>=pa&&m<=qa&&q||f||k))if(m=Math.round(e.toPixels(m,!0)),ra){if("undefined"===typeof z||m===y){Ba||(r=p);if("undefined"===typeof R||p>ja)ja=p,R=d;if("undefined"===typeof z||r<J)J=r,z=d}m!==y&&("undefined"!==typeof z&&(p=g.toPixels(ja,
!0),V=g.toPixels(J,!0),A(m,ba?Math.min(p,sa):p,ba?Math.max(V,sa):V,d),na(m,p,R),V!==p&&na(m,V,z)),z=R=void 0,y=m)}else p=Math.round(g.toPixels(p,!0)),A(m,p,V,d),na(m,p,d);Ca=b&&!C;0===d%5E4&&(a.boost&&a.boost.copy?a.boost.copy():a.chart.boost&&a.chart.boost.copy&&a.chart.boost.copy())}return!n},function(){var b=c.loadingDiv,d=c.loadingShown;ma();a.canvasToSVG();r&&console.timeEnd("canvas rendering");ea(a,"renderedCanvas");d&&(D(b.style,{transition:"opacity 250ms",opacity:0}),c.loadingShown=!1,va=
setTimeout(function(){b.parentNode&&b.parentNode.removeChild(b);c.loadingDiv=c.loadingSpan=null},250));delete a.buildKDTree;a.buildKDTree()},c.renderer.forExport?Number.MAX_VALUE:void 0))}});w.scatter.prototype.cvsMarkerCircle=function(a,b,c,e){a.moveTo(b,c);a.arc(b,c,e,0,2*Math.PI,!1)};w.scatter.prototype.cvsMarkerSquare=function(a,b,c,e){a.rect(b-e,c-e,2*e,2*e)};w.scatter.prototype.fill=!0;w.bubble&&(w.bubble.prototype.cvsMarkerCircle=function(a,b,c,e,g){a.moveTo(b,c);a.arc(b,c,this.radii&&this.radii[g],
0,2*Math.PI,!1)},w.bubble.prototype.cvsStrokeBatch=1);D(w.area.prototype,{cvsDrawPoint:function(a,b,c,e,g){g&&b!==g.clientX&&(a.moveTo(g.clientX,g.yBottom),a.lineTo(g.clientX,g.plotY),a.lineTo(b,c),a.lineTo(b,e))},fill:!0,fillOpacity:!0,sampling:!0});D(w.column.prototype,{cvsDrawPoint:function(a,b,c,e){a.rect(b-1,c,1,e-c)},fill:!0,sampling:!0});c.prototype.callbacks.push(function(a){K(a,"predraw",function(){var a=this.boost||{};a.target&&a.target.attr({href:"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAEAAAABCAQAAAC1HAwCAAAAC0lEQVR42mNkYAAAAAYAAjCB0C8AAAAASUVORK5CYII="});
a.canvas&&a.canvas.getContext("2d").clearRect(0,0,a.canvas.width,a.canvas.height)});K(a,"render",function(){a.boost&&a.boost.copy&&a.boost.copy()})})}});v(a,"Extensions/Boost/NamedColors.js",[],function(){return{defaultHTMLColorMap:{aliceblue:"#f0f8ff",antiquewhite:"#faebd7",aqua:"#00ffff",aquamarine:"#7fffd4",azure:"#f0ffff",beige:"#f5f5dc",bisque:"#ffe4c4",blanchedalmond:"#ffebcd",blue:"#0000ff",blueviolet:"#8a2be2",brown:"#a52a2a",burlywood:"#deb887",cadetblue:"#5f9ea0",chartreuse:"#7fff00",chocolate:"#d2691e",
coral:"#ff7f50",cornflowerblue:"#6495ed",cornsilk:"#fff8dc",crimson:"#dc143c",cyan:"#00ffff",darkblue:"#00008b",darkcyan:"#008b8b",darkgoldenrod:"#b8860b",darkgray:"#a9a9a9",darkgreen:"#006400",darkkhaki:"#bdb76b",darkmagenta:"#8b008b",darkolivegreen:"#556b2f",darkorange:"#ff8c00",darkorchid:"#9932cc",darkred:"#8b0000",darksalmon:"#e9967a",darkseagreen:"#8fbc8f",darkslateblue:"#483d8b",darkslategray:"#2f4f4f",darkturquoise:"#00ced1",darkviolet:"#9400d3",deeppink:"#ff1493",deepskyblue:"#00bfff",dimgray:"#696969",
dodgerblue:"#1e90ff",feldspar:"#d19275",firebrick:"#b22222",floralwhite:"#fffaf0",forestgreen:"#228b22",fuchsia:"#ff00ff",gainsboro:"#dcdcdc",ghostwhite:"#f8f8ff",gold:"#ffd700",goldenrod:"#daa520",gray:"#808080",grey:"#808080",green:"#008000",greenyellow:"#adff2f",honeydew:"#f0fff0",hotpink:"#ff69b4",indianred:"#cd5c5c",indigo:"#4b0082",ivory:"#fffff0",khaki:"#f0e68c",lavender:"#e6e6fa",lavenderblush:"#fff0f5",lawngreen:"#7cfc00",lemonchiffon:"#fffacd",lightblue:"#add8e6",lightcoral:"#f08080",lightcyan:"#e0ffff",
lightgoldenrodyellow:"#fafad2",lightgrey:"#d3d3d3",lightgreen:"#90ee90",lightpink:"#ffb6c1",lightsalmon:"#ffa07a",lightseagreen:"#20b2aa",lightskyblue:"#87cefa",lightslateblue:"#8470ff",lightslategray:"#778899",lightsteelblue:"#b0c4de",lightyellow:"#ffffe0",lime:"#00ff00",limegreen:"#32cd32",linen:"#faf0e6",magenta:"#ff00ff",maroon:"#800000",mediumaquamarine:"#66cdaa",mediumblue:"#0000cd",mediumorchid:"#ba55d3",mediumpurple:"#9370d8",mediumseagreen:"#3cb371",mediumslateblue:"#7b68ee",mediumspringgreen:"#00fa9a",
mediumturquoise:"#48d1cc",mediumvioletred:"#c71585",midnightblue:"#191970",mintcream:"#f5fffa",mistyrose:"#ffe4e1",moccasin:"#ffe4b5",navajowhite:"#ffdead",navy:"#000080",oldlace:"#fdf5e6",olive:"#808000",olivedrab:"#6b8e23",orange:"#ffa500",orangered:"#ff4500",orchid:"#da70d6",palegoldenrod:"#eee8aa",palegreen:"#98fb98",paleturquoise:"#afeeee",palevioletred:"#d87093",papayawhip:"#ffefd5",peachpuff:"#ffdab9",peru:"#cd853f",pink:"#ffc0cb",plum:"#dda0dd",powderblue:"#b0e0e6",purple:"#800080",red:"#ff0000",
rosybrown:"#bc8f8f",royalblue:"#4169e1",saddlebrown:"#8b4513",salmon:"#fa8072",sandybrown:"#f4a460",seagreen:"#2e8b57",seashell:"#fff5ee",sienna:"#a0522d",silver:"#c0c0c0",skyblue:"#87ceeb",slateblue:"#6a5acd",slategray:"#708090",snow:"#fffafa",springgreen:"#00ff7f",steelblue:"#4682b4",tan:"#d2b48c",teal:"#008080",thistle:"#d8bfd8",tomato:"#ff6347",turquoise:"#40e0d0",violet:"#ee82ee",violetred:"#d02090",wheat:"#f5deb3",whitesmoke:"#f5f5f5",yellow:"#ffff00",yellowgreen:"#9acd32"}}});v(a,"Extensions/Boost/Boost.js",
[a["Extensions/Boost/BoostChart.js"],a["Extensions/Boost/BoostSeries.js"],a["Core/Globals.js"],a["Extensions/BoostCanvas.js"],a["Extensions/Boost/NamedColors.js"],a["Core/Utilities.js"]],function(a,e,c,v,t,g){function r(){var a=!1;if("undefined"!==typeof b.WebGLRenderingContext){var c=Q.createElement("canvas");for(var e=0;e<N.length;++e)try{if(a=c.getContext(N[e]),"undefined"!==typeof a&&null!==a)return!0}catch(D){}}return!1}var m=this&&this.__assign||function(){m=Object.assign||function(a){for(var b,
c=1,e=arguments.length;c<e;c++){b=arguments[c];for(var g in b)Object.prototype.hasOwnProperty.call(b,g)&&(a[g]=b[g])}return a};return m.apply(this,arguments)},b=c.win,Q=c.doc,oa=g.error,q=[],N=["webgl","experimental-webgl","moz-webgl","webkit-3d"];c={compose:function(b,c,g,D){var w=r();w||("undefined"!==typeof v?v():oa(26));D&&-1===q.indexOf(D)&&(q.push(D),D.names=m(m({},D.names),t.defaultHTMLColorMap));a.compose(b,w);e.compose(c,g,w)},hasWebGLSupport:r};"";return c});v(a,"masters/modules/boost.src.js",
[a["Core/Globals.js"],a["Extensions/Boost/Boost.js"]],function(a,e){a.hasWebGLSupport=e.hasWebGLSupport;e.compose(a.Chart,a.Series,a.seriesTypes,a.Color)})});
//# sourceMappingURL=boost.js.map