/*
 Highstock JS v10.3.3 (2023-01-20)

 Indicator series type for Highcharts Stock

 (c) 2010-2021 Pawe Dalek

 License: www.highcharts.com/license
*/
(function(b){"object"===typeof module&&module.exports?(b["default"]=b,module.exports=b):"function"===typeof define&&define.amd?define("highcharts/indicators/volume-by-price",["highcharts","highcharts/modules/stock"],function(p){b(p);b.Highcharts=p;return b}):b("undefined"!==typeof Highcharts?Highcharts:void 0)})(function(b){function p(b,h,y,f){b.hasOwnProperty(h)||(b[h]=f.apply(null,y),"function"===typeof CustomEvent&&window.dispatchEvent(new CustomEvent("HighchartsModuleLoaded",{detail:{path:h,module:b[h]}})))}
b=b?b._modules:{};p(b,"Stock/Indicators/VBP/VBPPoint.js",[b["Core/Series/SeriesRegistry.js"]],function(b){var h=this&&this.__extends||function(){var b=function(f,a){b=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(b,a){b.__proto__=a}||function(b,a){for(var f in a)Object.prototype.hasOwnProperty.call(a,f)&&(b[f]=a[f])};return b(f,a)};return function(f,a){function h(){this.constructor=f}if("function"!==typeof a&&null!==a)throw new TypeError("Class extends value "+String(a)+" is not a constructor or null");
b(f,a);f.prototype=null===a?Object.create(a):(h.prototype=a.prototype,new h)}}();return function(b){function f(){return null!==b&&b.apply(this,arguments)||this}h(f,b);f.prototype.destroy=function(){this.negativeGraphic&&(this.negativeGraphic=this.negativeGraphic.destroy());return b.prototype.destroy.apply(this,arguments)};return f}(b.seriesTypes.sma.prototype.pointClass)});p(b,"Stock/Indicators/VBP/VBPIndicator.js",[b["Stock/Indicators/VBP/VBPPoint.js"],b["Core/Animation/AnimationUtilities.js"],b["Core/Globals.js"],
b["Core/Series/SeriesRegistry.js"],b["Core/Utilities.js"],b["Core/Chart/StockChart.js"]],function(b,h,p,f,a,I){var y=this&&this.__extends||function(){var b=function(a,c){b=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(c,b){c.__proto__=b}||function(c,b){for(var d in b)Object.prototype.hasOwnProperty.call(b,d)&&(c[d]=b[d])};return b(a,c)};return function(a,c){function w(){this.constructor=a}if("function"!==typeof c&&null!==c)throw new TypeError("Class extends value "+String(c)+" is not a constructor or null");
b(a,c);a.prototype=null===c?Object.create(c):(w.prototype=c.prototype,new w)}}(),J=h.animObject;h=p.noop;var D=f.seriesTypes,x=D.column.prototype,E=D.sma,A=a.addEvent,F=a.arrayMax,K=a.arrayMin,B=a.correctFloat,G=a.defined,C=a.error,H=a.extend,L=a.isArray,M=a.merge,u=Math.abs;a=function(b){function a(){var c=null!==b&&b.apply(this,arguments)||this;c.data=void 0;c.negWidths=void 0;c.options=void 0;c.points=void 0;c.posWidths=void 0;c.priceZones=void 0;c.rangeStep=void 0;c.volumeDataArray=void 0;c.zoneStarts=
void 0;c.zoneLinesSVG=void 0;return c}y(a,b);a.prototype.init=function(c){var b=this,a,d,k;p.seriesTypes.sma.prototype.init.apply(b,arguments);var r=A(I,"afterLinkSeries",function(){b.options&&(a=b.options.params,d=b.linkedParent,k=c.get(a.volumeSeriesID),b.addCustomEvents(d,k));r()},{order:1});return b};a.prototype.addCustomEvents=function(c,b){function a(){d.chart.redraw();d.setData([]);d.zoneStarts=[];d.zoneLinesSVG&&(d.zoneLinesSVG=d.zoneLinesSVG.destroy())}var d=this;d.dataEventsToUnbind.push(A(c,
"remove",function(){a()}));b&&d.dataEventsToUnbind.push(A(b,"remove",function(){a()}));return d};a.prototype.animate=function(c){var b=this,a=b.chart.inverted,d=b.group,k={};!c&&d&&(c=a?b.yAxis.top:b.xAxis.left,a?(d["forceAnimate:translateY"]=!0,k.translateY=c):(d["forceAnimate:translateX"]=!0,k.translateX=c),d.animate(k,H(J(b.options.animation),{step:function(c,a){b.group.attr({scaleX:Math.max(.001,a.pos)})}})))};a.prototype.drawPoints=function(){this.options.volumeDivision.enabled&&(this.posNegVolume(!0,
!0),x.drawPoints.apply(this,arguments),this.posNegVolume(!1,!1));x.drawPoints.apply(this,arguments)};a.prototype.posNegVolume=function(b,a){var c=a?["positive","negative"]:["negative","positive"],d=this.options.volumeDivision,k=this.points.length,r=[],e=[],l=0,m;b?(this.posWidths=r,this.negWidths=e):(r=this.posWidths,e=this.negWidths);for(;l<k;l++){var g=this.points[l];g[c[0]+"Graphic"]=g.graphic;g.graphic=g[c[1]+"Graphic"];if(b){var w=g.shapeArgs.width;var n=this.priceZones[l];(m=n.wholeVolumeData)?
(r.push(w/m*n.positiveVolumeData),e.push(w/m*n.negativeVolumeData)):(r.push(0),e.push(0))}g.color=a?d.styles.positiveColor:d.styles.negativeColor;g.shapeArgs.width=a?this.posWidths[l]:this.negWidths[l];g.shapeArgs.x=a?g.shapeArgs.x:this.posWidths[l]}};a.prototype.translate=function(){var b=this,a=b.options,z=b.chart,d=b.yAxis,k=d.min,r=b.options.zoneLines,e=b.priceZones,l=0,m,g,f;x.translate.apply(b);var n=b.points;if(n.length){var h=.5>a.pointPadding?a.pointPadding:.1;a=b.volumeDataArray;var t=F(a);
var q=z.plotWidth/2;var N=z.plotTop;var v=u(d.toPixels(k)-d.toPixels(k+b.rangeStep));var p=u(d.toPixels(k)-d.toPixels(k+b.rangeStep));h&&(k=u(v*(1-2*h)),l=u((v-k)/2),v=u(k));n.forEach(function(a,c){g=a.barX=a.plotX=0;f=a.plotY=d.toPixels(e[c].start)-N-(d.reversed?v-p:v)-l;m=B(q*e[c].wholeVolumeData/t);a.pointWidth=m;a.shapeArgs=b.crispCol.apply(b,[g,f,m,v]);a.volumeNeg=e[c].negativeVolumeData;a.volumePos=e[c].positiveVolumeData;a.volumeAll=e[c].wholeVolumeData});r.enabled&&b.drawZones(z,d,b.zoneStarts,
r.styles)}};a.prototype.getValues=function(b,a){var c=b.processedXData,d=b.processedYData,k=this.chart,r=a.ranges,e=[],l=[],m=[],g;if(b.chart)if(g=k.get(a.volumeSeriesID))if((a=L(d[0]))&&4!==d[0].length)C("Type of "+b.name+" series is different than line, OHLC or candlestick.",!0,k);else return(this.priceZones=this.specifyZones(a,c,d,r,g)).forEach(function(b,a){e.push([b.x,b.end]);l.push(e[a][0]);m.push(e[a][1])}),{values:e,xData:l,yData:m};else C("Series "+a.volumeSeriesID+" not found! Check `volumeSeriesID`.",
!0,k);else C("Base series not found! In case it has been removed, add a new one.",!0,k)};a.prototype.specifyZones=function(b,a,f,d,k){if(b){var c=f.length;for(var e=f[0][3],l=e,m=1,g;m<c;m++)g=f[m][3],g<e&&(e=g),g>l&&(l=g);c={min:e,max:l}}else c=!1;c=(e=c)?e.min:K(f);g=e?e.max:F(f);e=this.zoneStarts=[];l=[];var h=0;m=1;var n=this.linkedParent;!this.options.compareToMain&&n.dataModify&&(c=n.dataModify.modifyValue(c),g=n.dataModify.modifyValue(g));if(!G(c)||!G(g))return this.points.length&&(this.setData([]),
this.zoneStarts=[],this.zoneLinesSVG&&(this.zoneLinesSVG=this.zoneLinesSVG.destroy())),[];n=this.rangeStep=B(g-c)/d;for(e.push(c);h<d-1;h++)e.push(B(e[h]+n));e.push(g);for(d=e.length;m<d;m++)l.push({index:m-1,x:a[0],start:e[m-1],end:e[m]});return this.volumePerZone(b,l,k,a,f)};a.prototype.volumePerZone=function(b,a,f,d,k){var c=this,e=f.processedXData,l=f.processedYData,m=a.length-1,g=k.length;f=l.length;var h,n,p,t,q;u(g-f)&&(d[0]!==e[0]&&l.unshift(0),d[g-1]!==e[f-1]&&l.push(0));c.volumeDataArray=
[];a.forEach(function(a){a.wholeVolumeData=0;a.positiveVolumeData=0;for(q=a.negativeVolumeData=0;q<g;q++){p=n=!1;t=b?k[q][3]:k[q];h=q?b?k[q-1][3]:k[q-1]:t;var d=c.linkedParent;!c.options.compareToMain&&d.dataModify&&(t=d.dataModify.modifyValue(t),h=d.dataModify.modifyValue(h));t<=a.start&&0===a.index&&(n=!0);t>=a.end&&a.index===m&&(p=!0);(t>a.start||n)&&(t<a.end||p)&&(a.wholeVolumeData+=l[q],h>t?a.negativeVolumeData+=l[q]:a.positiveVolumeData+=l[q])}c.volumeDataArray.push(a.wholeVolumeData)});return a};
a.prototype.drawZones=function(a,b,f,d){var c=a.renderer,h=this.zoneLinesSVG,e=[],l=a.plotWidth,m=a.plotTop,g;f.forEach(function(c){g=b.toPixels(c)-m;e=e.concat(a.renderer.crispLine([["M",0,g],["L",l,g]],d.lineWidth))});h?h.animate({d:e}):h=this.zoneLinesSVG=c.path(e).attr({"stroke-width":d.lineWidth,stroke:d.color,dashstyle:d.dashStyle,zIndex:this.group.zIndex+.1}).add(this.group)};a.defaultOptions=M(E.defaultOptions,{params:{index:void 0,period:void 0,ranges:12,volumeSeriesID:"volume"},zoneLines:{enabled:!0,
styles:{color:"#0A9AC9",dashStyle:"LongDash",lineWidth:1}},volumeDivision:{enabled:!0,styles:{positiveColor:"rgba(144, 237, 125, 0.8)",negativeColor:"rgba(244, 91, 91, 0.8)"}},animationLimit:1E3,enableMouseTracking:!1,pointPadding:0,zIndex:-1,crisp:!0,dataGrouping:{enabled:!1},dataLabels:{allowOverlap:!0,enabled:!0,format:"P: {point.volumePos:.2f} | N: {point.volumeNeg:.2f}",padding:0,style:{fontSize:"7px"},verticalAlign:"top"}});return a}(E);H(a.prototype,{nameBase:"Volume by Price",nameComponents:["ranges"],
calculateOn:{chart:"render",xAxis:"afterSetExtremes"},pointClass:b,markerAttribs:h,drawGraph:h,getColumnMetrics:x.getColumnMetrics,crispCol:x.crispCol});f.registerSeriesType("vbp",a);"";return a});p(b,"masters/indicators/volume-by-price.src.js",[],function(){})});
//# sourceMappingURL=volume-by-price.js.map