<?php echo csrf_field(); ?>

<!--begin::Input group --- countries group -->
<div class="row mb-6">
    <?php
        $shadow = isset($shadow) ? (true === $shadow) : true;
        $hasTitle = isset($title) ? (true === $title) : true;
        $user_role = auth()->user()->role;
        $admin  = 1;
    ?>
    <div class="col-xl-12 col-md-6 mb-6">
        <div class="card <?php if($shadow): ?> shadow <?php endif; ?> <?php if($hasTitle): ?> card-permissions <?php endif; ?>">
            <?php if($hasTitle): ?>
            <div class="card-header">
                <div class="group-name">
                <?php echo e($form_title); ?>

                </div>
                <div class="select-all">
                    <div class="custom-control custom-switch form-check form-switch">
                        <input
                            class="custom-control-input form-check-input select-all-groups"
                            type="checkbox"
                            id="all_items"
                            >
                        <label class="custom-control-label" for="all_items"><?php echo e(__('view.select_all')); ?></label>
                    </div>
                </div>
            </div>
            <?php endif; ?>

            <div class="card-body">
                <div class="view-permissions">
                    <div class="row">
                        <?php $__currentLoopData = $items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div class="col-md-3">
                                <div class="permission-checkbox mb-3">
                                    <div class="custom-control custom-switch form-check form-switch">
                                        <input
                                            class="custom-control-input form-check-input select-single-permission"
                                            name="covered_items[]"
                                            type="checkbox"
                                            id="check_box_item<?php echo e($item->name); ?>"
                                            <?php if($item->covered == 1): ?> checked <?php endif; ?>
                                            value="<?php echo e($item->id); ?>">
                                        <label
                                            class="custom-control-label"
                                            for="check_box_item<?php echo e($item->name); ?>">
                                            <?php echo e(str_replace('-', ' ', $item->name)); ?>

                                        </label>
                                        <?php if(auth()->user()->can('add-covered-regions') || $user_role == $admin ): ?>
                                            <?php if($typeForm == 'country'): ?>
                                                <br>
                                                <?php if($item->covered == 1): ?>
                                                    <a href="<?php echo e(route('countries.covered_states', ['country_id' => $item->id])); ?>">
                                                        <?php echo e(__('cargo::view.add_covered_regions')); ?>

                                                    </a>
                                                <?php endif; ?>
                                            <?php endif; ?>
                                        <?php endif; ?>
                                    </div>
                                </div>
                            </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<!--end::Input group --- permissions group -->



<?php $__env->startSection('styles'); ?>
    <link href="<?php echo e(asset('assets/custom/css/acl.css')); ?>" rel="stylesheet" />
<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>
    <script>
        if($('.select-single-permission:checked').length == $('.select-single-permission').length){
            $('.select-all-groups').prop('checked', true);
        }
    </script>
<?php $__env->stopSection(); ?>


<?php /**PATH C:\laragon\www\cargo\Modules/Cargo\Resources/views/adminLte/pages/form.blade.php ENDPATH**/ ?>