/*
 Highmaps JS v10.3.3 (2023-01-20)

 Highmaps as a plugin for Highcharts or Highcharts Stock.

 (c) 2011-2021 Torstein Honsi

 License: www.highcharts.com/license
*/
(function(c){"object"===typeof module&&module.exports?(c["default"]=c,module.exports=c):"function"===typeof define&&define.amd?define("highcharts/modules/map",["highcharts"],function(y){c(y);c.Highcharts=y;return c}):c("undefined"!==typeof Highcharts?Highcharts:void 0)})(function(c){function y(c,h,q,m){c.hasOwnProperty(h)||(c[h]=m.apply(null,q),"function"===typeof CustomEvent&&window.dispatchEvent(new CustomEvent("HighchartsModuleLoaded",{detail:{path:h,module:c[h]}})))}c=c?c._modules:{};y(c,"Core/Axis/Color/ColorAxisComposition.js",
[c["Core/Color/Color.js"],c["Core/Utilities.js"]],function(c,h){var q=c.parse,m=h.addEvent,p=h.extend,d=h.merge,g=h.pick,D=h.splat,r;(function(l){function r(){var f=this,a=this.options;this.colorAxis=[];a.colorAxis&&(a.colorAxis=D(a.colorAxis),a.colorAxis.forEach(function(a,n){a.index=n;new z(f,a)}))}function b(f){var a=this,n=function(n){n=f.allItems.indexOf(n);-1!==n&&(a.destroyItem(f.allItems[n]),f.allItems.splice(n,1))},b=[],v,e;(this.chart.colorAxis||[]).forEach(function(f){(v=f.options)&&v.showInLegend&&
(v.dataClasses&&v.visible?b=b.concat(f.getDataClassLegendSymbols()):v.visible&&b.push(f),f.series.forEach(function(f){if(!f.options.showInLegend||v.dataClasses)"point"===f.options.legendType?f.points.forEach(function(f){n(f)}):n(f)}))});for(e=b.length;e--;)f.allItems.unshift(b[e])}function a(f){f.visible&&f.item.legendColor&&f.item.legendItem.symbol.attr({fill:f.item.legendColor})}function e(){var f=this.chart.colorAxis;f&&f.forEach(function(f,a,n){f.update({},n)})}function u(){(this.chart.colorAxis&&
this.chart.colorAxis.length||this.colorAttribs)&&this.translateColors()}function t(){var f=this.axisTypes;f?-1===f.indexOf("colorAxis")&&f.push("colorAxis"):this.axisTypes=["colorAxis"]}function k(f){var a=this,n=f?"show":"hide";a.visible=a.options.visible=!!f;["graphic","dataLabel"].forEach(function(f){if(a[f])a[f][n]()});this.series.buildKDTree()}function B(){var f=this,a=this.options.nullColor,n=this.colorAxis,b=this.colorKey;(this.data.length?this.data:this.points).forEach(function(v){var e=v.getNestedProperty(b);
(e=v.options.color||(v.isNull||null===v.value?a:n&&"undefined"!==typeof e?n.toColor(e,v):v.color||f.color))&&v.color!==e&&(v.color=e,"point"===f.options.legendType&&v.legendItem&&v.legendItem.label&&f.chart.legend.colorizeItem(v,v.visible))})}function n(f){var a=f.prototype.createAxis;f.prototype.createAxis=function(f,n){if("colorAxis"!==f)return a.apply(this,arguments);var b=new z(this,d(n.axis,{index:this[f].length,isX:!1}));this.isDirtyLegend=!0;this.axes.forEach(function(f){f.series=[]});this.series.forEach(function(f){f.bindAxes();
f.isDirtyData=!0});g(n.redraw,!0)&&this.redraw(n.animation);return b}}function f(){this.elem.attr("fill",q(this.start).tweenTo(q(this.end),this.pos),void 0,!0)}function A(){this.elem.attr("stroke",q(this.start).tweenTo(q(this.end),this.pos),void 0,!0)}var C=[],z;l.compose=function(l,d,g,w,v){z||(z=l);-1===C.indexOf(d)&&(C.push(d),l=d.prototype,l.collectionsWithUpdate.push("colorAxis"),l.collectionsWithInit.colorAxis=[l.addColorAxis],m(d,"afterGetAxes",r),n(d));-1===C.indexOf(g)&&(C.push(g),d=g.prototype,
d.fillSetter=f,d.strokeSetter=A);-1===C.indexOf(w)&&(C.push(w),m(w,"afterGetAllItems",b),m(w,"afterColorizeItem",a),m(w,"afterUpdate",e));-1===C.indexOf(v)&&(C.push(v),p(v.prototype,{optionalAxis:"colorAxis",translateColors:B}),p(v.prototype.pointClass.prototype,{setVisible:k}),m(v,"afterTranslate",u,{order:1}),m(v,"bindAxes",t))};l.pointSetVisible=k})(r||(r={}));return r});y(c,"Core/Axis/Color/ColorAxisDefaults.js",[],function(){return{lineWidth:0,minPadding:0,maxPadding:0,gridLineWidth:1,tickPixelInterval:72,
startOnTick:!0,endOnTick:!0,offset:0,marker:{animation:{duration:50},width:.01,color:"#999999"},labels:{overflow:"justify",rotation:0},minColor:"#e6ebf5",maxColor:"#003399",tickLength:5,showInLegend:!0}});y(c,"Core/Axis/Color/ColorAxis.js",[c["Core/Axis/Axis.js"],c["Core/Color/Color.js"],c["Core/Axis/Color/ColorAxisComposition.js"],c["Core/Axis/Color/ColorAxisDefaults.js"],c["Core/Globals.js"],c["Core/Legend/LegendSymbol.js"],c["Core/Series/SeriesRegistry.js"],c["Core/Utilities.js"]],function(c,h,
q,m,p,d,g,x){var r=this&&this.__extends||function(){var a=function(b,e){a=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(a,f){a.__proto__=f}||function(a,f){for(var n in f)f.hasOwnProperty(n)&&(a[n]=f[n])};return a(b,e)};return function(b,e){function n(){this.constructor=b}a(b,e);b.prototype=null===e?Object.create(e):(n.prototype=e.prototype,new n)}}(),l=h.parse,w=g.series,b=x.extend,a=x.isNumber,e=x.merge,u=x.pick;h=function(t){function k(a,n){var f=t.call(this,a,n)||this;f.beforePadding=
!1;f.chart=void 0;f.coll="colorAxis";f.dataClasses=void 0;f.name="";f.options=void 0;f.stops=void 0;f.visible=!0;f.init(a,n);return f}r(k,t);k.compose=function(a,n,f,b){q.compose(k,a,n,f,b)};k.prototype.init=function(a,n){var f=a.options.legend||{},b=n.layout?"vertical"!==n.layout:"vertical"!==f.layout,u=n.visible;f=e(k.defaultColorAxisOptions,n,{showEmpty:!1,title:null,visible:f.enabled&&!1!==u});this.coll="colorAxis";this.side=n.side||b?2:1;this.reversed=n.reversed||!b;this.opposite=!b;t.prototype.init.call(this,
a,f);this.userOptions.visible=u;n.dataClasses&&this.initDataClasses(n);this.initStops();this.horiz=b;this.zoomEnabled=!1};k.prototype.initDataClasses=function(a){var n=this.chart,f=this.legendItem=this.legendItem||{},b=a.dataClasses.length,u=this.options,k,t=0,B=n.options.chart.colorCount;this.dataClasses=k=[];f.labels=[];(a.dataClasses||[]).forEach(function(f,a){f=e(f);k.push(f);if(n.styledMode||!f.color)"category"===u.dataClassColor?(n.styledMode||(a=n.options.colors,B=a.length,f.color=a[t]),f.colorIndex=
t,t++,t===B&&(t=0)):f.color=l(u.minColor).tweenTo(l(u.maxColor),2>b?.5:a/(b-1))})};k.prototype.hasData=function(){return!!(this.tickPositions||[]).length};k.prototype.setTickPositions=function(){if(!this.dataClasses)return t.prototype.setTickPositions.call(this)};k.prototype.initStops=function(){this.stops=this.options.stops||[[0,this.options.minColor],[1,this.options.maxColor]];this.stops.forEach(function(a){a.color=l(a[1])})};k.prototype.setOptions=function(a){t.prototype.setOptions.call(this,a);
this.options.crosshair=this.options.marker};k.prototype.setAxisSize=function(){var a=this.legendItem&&this.legendItem.symbol,b=this.chart,f=b.options.legend||{},e,u;a?(this.left=f=a.attr("x"),this.top=e=a.attr("y"),this.width=u=a.attr("width"),this.height=a=a.attr("height"),this.right=b.chartWidth-f-u,this.bottom=b.chartHeight-e-a,this.len=this.horiz?u:a,this.pos=this.horiz?f:e):this.len=(this.horiz?f.symbolWidth:f.symbolHeight)||k.defaultLegendLength};k.prototype.normalizedValue=function(a){this.logarithmic&&
(a=this.logarithmic.log2lin(a));return 1-(this.max-a)/(this.max-this.min||1)};k.prototype.toColor=function(a,b){var f=this.dataClasses,n=this.stops,e;if(f)for(e=f.length;e--;){var u=f[e];var k=u.from;n=u.to;if(("undefined"===typeof k||a>=k)&&("undefined"===typeof n||a<=n)){var t=u.color;b&&(b.dataClass=e,b.colorIndex=u.colorIndex);break}}else{a=this.normalizedValue(a);for(e=n.length;e--&&!(a>n[e][0]););k=n[e]||n[e+1];n=n[e+1]||k;a=1-(n[0]-a)/(n[0]-k[0]||1);t=k.color.tweenTo(n.color,a)}return t};k.prototype.getOffset=
function(){var a=this.legendItem&&this.legendItem.group,b=this.chart.axisOffset[this.side];if(a){this.axisParent=a;t.prototype.getOffset.call(this);var f=this.chart.legend;f.allItems.forEach(function(a){a instanceof k&&a.drawLegendSymbol(f,a)});f.render();this.chart.getMargins(!0);this.added||(this.added=!0,this.labelLeft=0,this.labelRight=this.width);this.chart.axisOffset[this.side]=b}};k.prototype.setLegendColor=function(){var a=this.reversed,b=a?1:0;a=a?0:1;b=this.horiz?[b,0,a,0]:[0,a,0,b];this.legendColor=
{linearGradient:{x1:b[0],y1:b[1],x2:b[2],y2:b[3]},stops:this.stops}};k.prototype.drawLegendSymbol=function(a,b){b=b.legendItem||{};var f=a.padding,e=a.options,n=u(e.itemDistance,10),t=this.horiz,l=u(e.symbolWidth,t?k.defaultLegendLength:12),d=u(e.symbolHeight,t?12:k.defaultLegendLength);e=u(e.labelPadding,t?16:30);this.setLegendColor();b.symbol||(b.symbol=this.chart.renderer.rect(0,a.baseline-11,l,d).attr({zIndex:1}).add(b.group));b.labelWidth=l+f+(t?n:this.options.labels.x+this.maxLabelLength);b.labelHeight=
d+f+(t?e:0)};k.prototype.setState=function(a){this.series.forEach(function(b){b.setState(a)})};k.prototype.setVisible=function(){};k.prototype.getSeriesExtremes=function(){var a=this.series,b=a.length,f;this.dataMin=Infinity;for(this.dataMax=-Infinity;b--;){var e=a[b];var k=e.colorKey=u(e.options.colorKey,e.colorKey,e.pointValKey,e.zoneAxis,"y");var t=e.pointArrayMap;var l=e[k+"Min"]&&e[k+"Max"];if(e[k+"Data"])var d=e[k+"Data"];else if(t){d=[];t=t.indexOf(k);var g=e.yData;if(0<=t&&g)for(f=0;f<g.length;f++)d.push(u(g[f][t],
g[f]))}else d=e.yData;l?(e.minColorValue=e[k+"Min"],e.maxColorValue=e[k+"Max"]):(d=w.prototype.getExtremes.call(e,d),e.minColorValue=d.dataMin,e.maxColorValue=d.dataMax);"undefined"!==typeof e.minColorValue&&(this.dataMin=Math.min(this.dataMin,e.minColorValue),this.dataMax=Math.max(this.dataMax,e.maxColorValue));l||w.prototype.applyExtremes.call(e)}};k.prototype.drawCrosshair=function(a,b){var f=this.legendItem||{},e=b&&b.plotX,n=b&&b.plotY,u=this.pos,k=this.len;if(b){var l=this.toPixels(b.getNestedProperty(b.series.colorKey));
l<u?l=u-2:l>u+k&&(l=u+k+2);b.plotX=l;b.plotY=this.len-l;t.prototype.drawCrosshair.call(this,a,b);b.plotX=e;b.plotY=n;this.cross&&!this.cross.addedToColorAxis&&f.group&&(this.cross.addClass("highcharts-coloraxis-marker").add(f.group),this.cross.addedToColorAxis=!0,this.chart.styledMode||"object"!==typeof this.crosshair||this.cross.attr({fill:this.crosshair.color}))}};k.prototype.getPlotLinePath=function(b){var e=this.left,f=b.translatedValue,u=this.top;return a(f)?this.horiz?[["M",f-4,u-6],["L",f+
4,u-6],["L",f,u],["Z"]]:[["M",e,f],["L",e-6,f+6],["L",e-6,f-6],["Z"]]:t.prototype.getPlotLinePath.call(this,b)};k.prototype.update=function(a,b){var f=this.chart.legend;this.series.forEach(function(a){a.isDirtyData=!0});(a.dataClasses&&f.allItems||this.dataClasses)&&this.destroyItems();t.prototype.update.call(this,a,b);this.legendItem&&this.legendItem.label&&(this.setLegendColor(),f.colorizeItem(this,!0))};k.prototype.destroyItems=function(){var a=this.chart,b=this.legendItem||{};if(b.label)a.legend.destroyItem(this);
else if(b.labels){var f=0;for(b=b.labels;f<b.length;f++)a.legend.destroyItem(b[f])}a.isDirtyLegend=!0};k.prototype.destroy=function(){this.chart.isDirtyLegend=!0;this.destroyItems();t.prototype.destroy.apply(this,[].slice.call(arguments))};k.prototype.remove=function(a){this.destroyItems();t.prototype.remove.call(this,a)};k.prototype.getDataClassLegendSymbols=function(){var a=this,e=a.chart,f=a.legendItem&&a.legendItem.labels||[],k=e.options.legend,t=u(k.valueDecimals,-1),l=u(k.valueSuffix,""),g=
function(f){return a.series.reduce(function(a,b){a.push.apply(a,b.points.filter(function(a){return a.dataClass===f}));return a},[])},r;f.length||a.dataClasses.forEach(function(u,k){var v=u.from,n=u.to,A=e.numberFormatter,H=!0;r="";"undefined"===typeof v?r="< ":"undefined"===typeof n&&(r="> ");"undefined"!==typeof v&&(r+=A(v,t)+l);"undefined"!==typeof v&&"undefined"!==typeof n&&(r+=" - ");"undefined"!==typeof n&&(r+=A(n,t)+l);f.push(b({chart:e,name:r,options:{},drawLegendSymbol:d.drawRectangle,visible:!0,
isDataClass:!0,setState:function(a){for(var f=0,b=g(k);f<b.length;f++)b[f].setState(a)},setVisible:function(){this.visible=H=a.visible=!H;for(var f=0,b=g(k);f<b.length;f++)b[f].setVisible(H);e.legend.colorizeItem(this,H)}},u))});return f};k.defaultColorAxisOptions=m;k.defaultLegendLength=200;k.keepProps=["legendItem"];return k}(c);Array.prototype.push.apply(c.keepProps,h.keepProps);"";return h});y(c,"Maps/MapNavigationDefaults.js",[c["Core/Defaults.js"],c["Core/Utilities.js"]],function(c,h){h=h.extend;
var q={buttonOptions:{alignTo:"plotBox",align:"left",verticalAlign:"top",x:0,width:18,height:18,padding:5,style:{fontSize:"15px",fontWeight:"bold"},theme:{"stroke-width":1,"text-align":"center"}},buttons:{zoomIn:{onclick:function(){this.mapZoom(.5)},text:"+",y:0},zoomOut:{onclick:function(){this.mapZoom(2)},text:"-",y:28}},mouseWheelSensitivity:1.1};h(c.defaultOptions.lang,{zoomIn:"Zoom in",zoomOut:"Zoom out"});return c.defaultOptions.mapNavigation=q});y(c,"Maps/MapNavigation.js",[c["Core/Chart/Chart.js"],
c["Core/Globals.js"],c["Core/Utilities.js"]],function(c,h,q){function m(a){a&&(a.preventDefault&&a.preventDefault(),a.stopPropagation&&a.stopPropagation(),a.cancelBubble=!0)}function p(a){this.navButtons=[];this.init(a)}var d=h.doc,g=q.addEvent,x=q.extend,r=q.isNumber,l=q.merge,w=q.objectEach,b=q.pick;p.prototype.init=function(a){this.chart=a};p.prototype.update=function(a){var e=this,u=this.chart,t=u.options.mapNavigation,k,d=function(a){this.handler.call(u,a);m(a)},n=e.navButtons;a&&(t=u.options.mapNavigation=
l(u.options.mapNavigation,a));for(;n.length;)n.pop().destroy();b(t.enableButtons,t.enabled)&&!u.renderer.forExport&&(e.navButtonsGroup||(e.navButtonsGroup=u.renderer.g().attr({zIndex:4}).add()),w(t.buttons,function(a,b){a=l(t.buttonOptions,a);!u.styledMode&&a.theme&&(k=a.theme,k.style=l(a.theme.style,a.style));var f=u.renderer.button(a.text||"",0,0,d,k,void 0,void 0,void 0,"zoomIn"===b?"topbutton":"bottombutton").addClass("highcharts-map-navigation highcharts-"+{zoomIn:"zoom-in",zoomOut:"zoom-out"}[b]).attr({width:a.width,
height:a.height,title:u.options.lang[b],padding:a.padding,zIndex:5}).add(e.navButtonsGroup);f.handler=a.onclick;g(f.element,"dblclick",m);n.push(f);x(a,{width:f.width,height:2*f.height});if(u.hasLoaded)f.align(a,!1,a.alignTo);else var A=g(u,"load",function(){f.element&&f.align(a,!1,a.alignTo);A()})}),a=function(){var a=u.exportingGroup&&u.exportingGroup.getBBox();if(a){var b=e.navButtonsGroup.getBBox();if(!(b.x>=a.x+a.width||b.x+b.width<=a.x||b.y>=a.y+a.height||b.y+b.height<=a.y)){var k=-b.y-b.height+
a.y-5;a=a.y+a.height-b.y+5;e.navButtonsGroup.attr({translateY:"bottom"===(t.buttonOptions&&t.buttonOptions.verticalAlign)?k:a})}}},u.hasLoaded||g(u,"render",a));this.updateEvents(t)};p.prototype.updateEvents=function(a){var e=this.chart;b(a.enableDoubleClickZoom,a.enabled)||a.enableDoubleClickZoomTo?this.unbindDblClick=this.unbindDblClick||g(e.container,"dblclick",function(a){e.pointer.onContainerDblClick(a)}):this.unbindDblClick&&(this.unbindDblClick=this.unbindDblClick());b(a.enableMouseWheelZoom,
a.enabled)?this.unbindMouseWheel=this.unbindMouseWheel||g(e.container,void 0!==d.onwheel?"wheel":void 0!==d.onmousewheel?"mousewheel":"DOMMouseScroll",function(a){e.pointer.inClass(a.target,"highcharts-no-mousewheel")||(e.pointer.onContainerMouseWheel(a),m(a));return!1}):this.unbindMouseWheel&&(this.unbindMouseWheel=this.unbindMouseWheel())};x(c.prototype,{fitToBox:function(a,b){[["x","width"],["y","height"]].forEach(function(e){var t=e[0];e=e[1];a[t]+a[e]>b[t]+b[e]&&(a[e]>b[e]?(a[e]=b[e],a[t]=b[t]):
a[t]=b[t]+b[e]-a[e]);a[e]>b[e]&&(a[e]=b[e]);a[t]<b[t]&&(a[t]=b[t])});return a},mapZoom:function(a,b,u,t,k){this.mapView&&(r(a)&&(a=Math.log(a)/Math.log(.5)),this.mapView.zoomBy(a,r(b)&&r(u)?this.mapView.projection.inverse([b,u]):void 0,r(t)&&r(k)?[t,k]:void 0))}});g(c,"beforeRender",function(){this.mapNavigation=new p(this);this.mapNavigation.update()});h.MapNavigation=p});y(c,"Maps/MapPointer.js",[c["Core/Pointer.js"],c["Core/Utilities.js"]],function(c,h){var q=h.defined,m=h.extend,p=h.pick;h=h.wrap;
var d=c.prototype.normalize,g=0,x;m(c.prototype,{normalize:function(g,l){var r=this.chart;g=d.call(this,g,l);r&&r.mapView&&(l=r.mapView.pixelsToLonLat({x:g.chartX-r.plotLeft,y:g.chartY-r.plotTop}))&&m(g,l);return g},onContainerDblClick:function(d){var l=this.chart;d=this.normalize(d);l.options.mapNavigation.enableDoubleClickZoomTo?l.pointer.inClass(d.target,"highcharts-tracker")&&l.hoverPoint&&l.hoverPoint.zoomTo():l.isInsidePlot(d.chartX-l.plotLeft,d.chartY-l.plotTop)&&l.mapZoom(.5,void 0,void 0,
d.chartX,d.chartY)},onContainerMouseWheel:function(d){var l=this.chart;d=this.normalize(d);var c=q(d.wheelDelta)&&-d.wheelDelta/120||d.deltaY||d.detail;1<=Math.abs(c)&&(g+=Math.abs(c),x&&clearTimeout(x),x=setTimeout(function(){g=0},50));10>g&&l.isInsidePlot(d.chartX-l.plotLeft,d.chartY-l.plotTop)&&l.mapView&&l.mapView.zoomBy((l.options.mapNavigation.mouseWheelSensitivity-1)*-c,void 0,[d.chartX,d.chartY],1>Math.abs(c)?!1:void 0)}});h(c.prototype,"zoomOption",function(d){var l=this.chart.options.mapNavigation;
p(l.enableTouchZoom,l.enabled)&&(this.chart.options.chart.zooming.pinchType="xy");d.apply(this,[].slice.call(arguments,1))});h(c.prototype,"pinchTranslate",function(d,l,g,b,a,e,u){d.call(this,l,g,b,a,e,u);"map"===this.chart.options.chart.type&&this.hasZoom&&(d=b.scaleX>b.scaleY,this.pinchTranslateDirection(!d,l,g,b,a,e,u,d?b.scaleX:b.scaleY))})});y(c,"Series/ColorMapComposition.js",[c["Core/Series/SeriesRegistry.js"],c["Core/Utilities.js"]],function(c,h){var q=c.seriesTypes.column.prototype,m=h.addEvent,
p=h.defined,d;(function(d){function g(d){this.moveToTopOnHover&&this.graphic&&this.graphic.attr({zIndex:d&&"hover"===d.state?1:0})}var c=[];d.pointMembers={dataLabelOnNull:!0,moveToTopOnHover:!0,isValid:function(){return null!==this.value&&Infinity!==this.value&&-Infinity!==this.value&&(void 0===this.value||!isNaN(this.value))}};d.seriesMembers={colorKey:"value",axisTypes:["xAxis","yAxis","colorAxis"],parallelArrays:["x","y","value"],pointArrayMap:["value"],trackerGroups:["group","markerGroup","dataLabelsGroup"],
colorAttribs:function(d){var l={};!p(d.color)||d.state&&"normal"!==d.state||(l[this.colorProp||"fill"]=d.color);return l},pointAttribs:q.pointAttribs};d.compose=function(d){var l=d.prototype.pointClass;-1===c.indexOf(l)&&(c.push(l),m(l,"afterSetState",g));return d}})(d||(d={}));return d});y(c,"Maps/MapSymbols.js",[c["Core/Renderer/SVG/SVGRenderer.js"]],function(c){function h(c,m,p,d,g,h,r,l){return[["M",c+g,m],["L",c+p-h,m],["C",c+p-h/2,m,c+p,m+h/2,c+p,m+h],["L",c+p,m+d-r],["C",c+p,m+d-r/2,c+p-r/
2,m+d,c+p-r,m+d],["L",c+l,m+d],["C",c+l/2,m+d,c,m+d-l/2,c,m+d-l],["L",c,m+g],["C",c,m+g/2,c+g/2,m,c+g,m],["Z"]]}c=c.prototype.symbols;c.bottombutton=function(c,m,p,d,g){g=g&&g.r||0;return h(c-1,m-1,p,d,0,0,g,g)};c.topbutton=function(c,m,p,d,g){g=g&&g.r||0;return h(c-1,m-1,p,d,g,g,0,0)};return c});y(c,"Core/Chart/MapChart.js",[c["Core/Chart/Chart.js"],c["Core/Defaults.js"],c["Core/Renderer/SVG/SVGRenderer.js"],c["Core/Utilities.js"]],function(c,h,q,m){var p=this&&this.__extends||function(){var d=function(c,
g){d=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(b,a){b.__proto__=a}||function(b,a){for(var e in a)a.hasOwnProperty(e)&&(b[e]=a[e])};return d(c,g)};return function(c,g){function b(){this.constructor=c}d(c,g);c.prototype=null===g?Object.create(g):(b.prototype=g.prototype,new b)}}(),d=h.getOptions,g=m.merge,x=m.pick;c=function(c){function l(){return null!==c&&c.apply(this,arguments)||this}p(l,c);l.prototype.init=function(l,b){var a=d().credits;l=g({chart:{panning:{enabled:!0,type:"xy"},
type:"map"},credits:{mapText:x(a.mapText,' \u00a9 <a href="{geojson.copyrightUrl}">{geojson.copyrightShort}</a>'),mapTextFull:x(a.mapTextFull,"{geojson.copyright}")},mapView:{},tooltip:{followTouchMove:!1}},l);c.prototype.init.call(this,l,b)};return l}(c);(function(d){d.maps={};d.mapChart=function(c,g,b){return new d(c,g,b)};d.splitPath=function(d){"string"===typeof d&&(d=d.replace(/([A-Za-z])/g," $1 ").replace(/^\s*/,"").replace(/\s*$/,""),d=d.split(/[ ,;]+/).map(function(d){return/[A-za-z]/.test(d)?
d:parseFloat(d)}));return q.prototype.pathToSegments(d)}})(c||(c={}));return c});y(c,"Maps/MapUtilities.js",[],function(){return{boundsFromPath:function(c){var h=-Number.MAX_VALUE,q=Number.MAX_VALUE,m=-Number.MAX_VALUE,p=Number.MAX_VALUE,d;c.forEach(function(c){var g=c[c.length-2];c=c[c.length-1];"number"===typeof g&&"number"===typeof c&&(q=Math.min(q,g),h=Math.max(h,g),p=Math.min(p,c),m=Math.max(m,c),d=!0)});if(d)return{x1:q,y1:p,x2:h,y2:m}},pointInPolygon:function(c,h){var q,m=!1,p=c.x,d=c.y;c=
0;for(q=h.length-1;c<h.length;q=c++){var g=h[c][1]>d;var x=h[q][1]>d;g!==x&&p<(h[q][0]-h[c][0])*(d-h[c][1])/(h[q][1]-h[c][1])+h[c][0]&&(m=!m)}return m}}});y(c,"Series/Map/MapPoint.js",[c["Series/ColorMapComposition.js"],c["Maps/MapUtilities.js"],c["Core/Series/SeriesRegistry.js"],c["Core/Utilities.js"]],function(c,h,q,m){var p=this&&this.__extends||function(){var d=function(c,b){d=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(a,b){a.__proto__=b}||function(a,b){for(var e in b)b.hasOwnProperty(e)&&
(a[e]=b[e])};return d(c,b)};return function(c,b){function a(){this.constructor=c}d(c,b);c.prototype=null===b?Object.create(b):(a.prototype=b.prototype,new a)}}(),d=h.boundsFromPath,g=m.extend,x=m.isNumber,r=m.pick;h=function(c){function l(){var b=null!==c&&c.apply(this,arguments)||this;b.options=void 0;b.path=void 0;b.series=void 0;return b}p(l,c);l.getProjectedPath=function(b,a){b.projectedPath||(a&&b.geometry?(a.hasCoordinates=!0,b.projectedPath=a.path(b.geometry)):b.projectedPath=b.path);return b.projectedPath||
[]};l.prototype.applyOptions=function(b,a){var e=this.series;b=c.prototype.applyOptions.call(this,b,a);a=e.joinBy;e.mapData&&e.mapMap&&(a=c.prototype.getNestedProperty.call(b,a[1]),(a="undefined"!==typeof a&&e.mapMap[a])?g(b,a):-1!==e.pointArrayMap.indexOf("value")&&(b.value=b.value||null));return b};l.prototype.getProjectedBounds=function(b){b=l.getProjectedPath(this,b);b=d(b);var a=this.properties;if(b){var e=a&&a["hc-middle-x"];a=a&&a["hc-middle-y"];b.midX=b.x1+(b.x2-b.x1)*r(this.middleX,x(e)?
e:.5);e=r(this.middleY,x(a)?a:.5);this.geometry||(e=1-e);b.midY=b.y2-(b.y2-b.y1)*e;return b}};l.prototype.onMouseOver=function(b){m.clearTimeout(this.colorInterval);if(!this.isNull&&this.visible||this.series.options.nullInteraction)c.prototype.onMouseOver.call(this,b);else this.series.onMouseOut(b)};l.prototype.setVisible=function(b){var a=b?"show":"hide";this.visible=this.options.visible=!!b;if(this.dataLabel)this.dataLabel[a]();this.graphic&&this.graphic.attr(this.series.pointAttribs(this))};l.prototype.zoomTo=
function(){var b=this.series.chart,a=b.mapView,e=this.bounds;if(a&&e){var d=x(this.insetIndex)&&a.insets[this.insetIndex];if(d){var c=d.projectedUnitsToPixels({x:e.x1,y:e.y1});e=d.projectedUnitsToPixels({x:e.x2,y:e.y2});c=a.pixelsToProjectedUnits({x:c.x,y:c.y});e=a.pixelsToProjectedUnits({x:e.x,y:e.y});e={x1:c.x,y1:c.y,x2:e.x,y2:e.y}}a.fitToBounds(e,void 0,!1);this.series.isDirty=!0;b.redraw()}};return l}(q.seriesTypes.scatter.prototype.pointClass);g(h.prototype,{dataLabelOnNull:c.pointMembers.dataLabelOnNull,
moveToTopOnHover:c.pointMembers.moveToTopOnHover,isValid:c.pointMembers.isValid});return h});y(c,"Maps/MapViewOptionsDefault.js",[],function(){return{center:[0,0],fitToGeometry:void 0,maxZoom:void 0,padding:0,projection:{name:void 0,parallels:void 0,rotation:void 0},zoom:void 0}});y(c,"Maps/MapViewInsetsOptionsDefault.js",[],function(){return{borderColor:"#cccccc",borderWidth:1,center:[0,0],padding:"10%",relativeTo:"mapBoundingBox",units:"percent"}});y(c,"Extensions/GeoJSON.js",[c["Core/Chart/Chart.js"],
c["Core/FormatUtilities.js"],c["Core/Globals.js"],c["Core/Utilities.js"]],function(c,h,q,m){function p(b,a){a||(a=Object.keys(b.objects)[0]);a=b.objects[a];if(a["hc-decoded-geojson"])return a["hc-decoded-geojson"];var e=b.arcs;if(b.transform){var c=b.transform,d=c.scale,k=c.translate;e=b.arcs.map(function(a){var b=0,e=0;return a.map(function(a){a=a.slice();a[0]=(b+=a[0])*d[0]+k[0];a[1]=(e+=a[1])*d[1]+k[1];return a})})}var l=function(a){return"number"===typeof a[0]?a.reduce(function(a,b,c){var f=0>
b?e[~b]:e[b];0>b?(f=f.slice(0,0===c?f.length:f.length-1),f.reverse()):c&&(f=f.slice(1));return a.concat(f)},[]):a.map(l)};c=a.geometries.map(function(a){return{type:"Feature",properties:a.properties,geometry:{type:a.type,coordinates:a.coordinates||l(a.arcs)}}});b={type:"FeatureCollection",copyright:b.copyright,copyrightShort:b.copyrightShort,copyrightUrl:b.copyrightUrl,features:c,"hc-recommended-mapview":a["hc-recommended-mapview"],bbox:b.bbox,title:b.title};return a["hc-decoded-geojson"]=b}function d(b,
a,e){void 0===a&&(a="map");var c=[];b="Topology"===b.type?p(b):b;b.features.forEach(function(b){var e=b.geometry||{},d=e.type;e=e.coordinates;b=b.properties;var n;"map"!==a&&"mapbubble"!==a||"Polygon"!==d&&"MultiPolygon"!==d?"mapline"!==a||"LineString"!==d&&"MultiLineString"!==d?"mappoint"===a&&"Point"===d&&e.length&&(n={geometry:{coordinates:e,type:d}}):e.length&&(n={geometry:{coordinates:e,type:d}}):e.length&&(n={geometry:{coordinates:e,type:d}});if(n){d=b&&(b.name||b.NAME);e=b&&b.lon;var f=b&&
b.lat;c.push(l(n,{lat:"number"===typeof f?f:void 0,lon:"number"===typeof e?e:void 0,name:"string"===typeof d?d:void 0,properties:b}))}});e&&b.copyrightShort&&(e.chart.mapCredits=g(e.chart.options.credits.mapText,{geojson:b}),e.chart.mapCreditsFull=g(e.chart.options.credits.mapTextFull,{geojson:b}));return c}var g=h.format,x=q.win,r=m.error,l=m.extend,w=m.merge;h=m.wrap;"";c.prototype.transformFromLatLon=function(b,a){var e=this.options.chart.proj4||x.proj4;if(e){var c=a.jsonmarginX;c=void 0===c?0:
c;var d=a.jsonmarginY;d=void 0===d?0:d;var k=a.jsonres;k=void 0===k?1:k;var l=a.scale;l=void 0===l?1:l;var n=a.xoffset;n=void 0===n?0:n;var f=a.xpan;f=void 0===f?0:f;var g=a.yoffset;g=void 0===g?0:g;var p=a.ypan;p=void 0===p?0:p;b=e(a.crs,[b.lon,b.lat]);e=a.cosAngle||a.rotation&&Math.cos(a.rotation);var m=a.sinAngle||a.rotation&&Math.sin(a.rotation);a=a.rotation?[b[0]*e+b[1]*m,-b[0]*m+b[1]*e]:b;return{x:((a[0]-n)*l+f)*k+c,y:-(((g-a[1])*l+p)*k-d)}}r(21,!1,this)};c.prototype.transformToLatLon=function(b,
a){var e=this.options.chart.proj4||x.proj4;if(!e)r(21,!1,this);else if(null!==b.y){var c=a.jsonmarginX,d=a.jsonmarginY,k=a.jsonres;k=void 0===k?1:k;var l=a.scale;l=void 0===l?1:l;var n=a.xoffset,f=a.xpan,g=a.yoffset,p=a.ypan;b={x:((b.x-(void 0===c?0:c))/k-(void 0===f?0:f))/l+(void 0===n?0:n),y:((b.y-(void 0===d?0:d))/k+(void 0===p?0:p))/l+(void 0===g?0:g)};c=a.cosAngle||a.rotation&&Math.cos(a.rotation);d=a.sinAngle||a.rotation&&Math.sin(a.rotation);a=e(a.crs,"WGS84",a.rotation?{x:b.x*c+b.y*-d,y:b.x*
d+b.y*c}:b);return{lat:a.y,lon:a.x}}};c.prototype.fromPointToLatLon=function(b){return this.mapView&&this.mapView.projectedUnitsToLonLat(b)};c.prototype.fromLatLonToPoint=function(b){return this.mapView&&this.mapView.lonLatToProjectedUnits(b)};h(c.prototype,"addCredits",function(b,a){a=w(!0,this.options.credits,a);this.mapCredits&&(a.href=null);b.call(this,a);this.credits&&this.mapCreditsFull&&this.credits.attr({title:this.mapCreditsFull})});q.geojson=d;q.topo2geo=p;return{geojson:d,topo2geo:p}});
y(c,"Core/Geometry/PolygonClip.js",[],function(){var c=function(c,p,d){return(p[0]-c[0])*(d[1]-c[1])>(p[1]-c[1])*(d[0]-c[0])},h=function(c,p,d,g){var m=[c[0]-p[0],c[1]-p[1]],h=[d[0]-g[0],d[1]-g[1]];c=c[0]*p[1]-c[1]*p[0];d=d[0]*g[1]-d[1]*g[0];g=1/(m[0]*h[1]-m[1]*h[0]);m=[(c*h[0]-d*m[0])*g,(c*h[1]-d*m[1])*g];m.isIntersection=!0;return m},q;(function(m){m.clipLineString=function(c,d){var g=[];c=m.clipPolygon(c,d,!1);for(d=1;d<c.length;d++)c[d].isIntersection&&c[d-1].isIntersection&&(g.push(c.splice(0,
d)),d=0),d===c.length-1&&g.push(c);return g};m.clipPolygon=function(p,d,g){void 0===g&&(g=!0);for(var m=d[d.length-1],r,l,q=p,b=0;b<d.length;b++){var a=q;p=d[b];q=[];r=g?a[a.length-1]:a[0];for(var e=0;e<a.length;e++)l=a[e],c(m,p,l)?(c(m,p,r)||q.push(h(m,p,r,l)),q.push(l)):c(m,p,r)&&q.push(h(m,p,r,l)),r=l;m=p}return q}})(q||(q={}));return q});y(c,"Maps/Projections/LambertConformalConic.js",[],function(){var c=Math.sign||function(c){return 0===c?0:0<c?1:-1},h=Math.PI/180,q=Math.PI/2;return function(){function m(p){var d,
g=(p.parallels||[]).map(function(c){return c*h}),m=g[0]||0;g=null!==(d=g[1])&&void 0!==d?d:m;d=Math.cos(m);"object"===typeof p.projectedBounds&&(this.projectedBounds=p.projectedBounds);p=m===g?Math.sin(m):Math.log(d/Math.cos(g))/Math.log(Math.tan((q+g)/2)/Math.tan((q+m)/2));1e-10>Math.abs(p)&&(p=1e-10*(c(p)||1));this.n=p;this.c=d*Math.pow(Math.tan((q+m)/2),p)/p}m.prototype.forward=function(c){var d=c[0]*h,g=this.c,m=this.n,p=this.projectedBounds;c=c[1]*h;0<g?c<-q+.000001&&(c=-q+.000001):c>q-.000001&&
(c=q-.000001);var l=g/Math.pow(Math.tan((q+c)/2),m);c=l*Math.sin(m*d)*63.78137;d=63.78137*(g-l*Math.cos(m*d));g=[c,d];p&&(c<p.x1||c>p.x2||d<p.y1||d>p.y2)&&(g.outside=!0);return g};m.prototype.inverse=function(m){var d=m[0]/63.78137,g=this.c,p=this.n;m=g-m[1]/63.78137;var r=c(p)*Math.sqrt(d*d+m*m),l=Math.atan2(d,Math.abs(m))*c(m);0>m*p&&(l-=Math.PI*c(d)*c(m));return[l/p/h,(2*Math.atan(Math.pow(g/r,1/p))-q)/h]};return m}()});y(c,"Maps/Projections/EqualEarth.js",[],function(){var c=Math.sqrt(3)/2;return function(){function h(){this.bounds=
{x1:-200.37508342789243,x2:200.37508342789243,y1:-97.52595454902263,y2:97.52595454902263}}h.prototype.forward=function(h){var m=Math.PI/180,p=Math.asin(c*Math.sin(h[1]*m)),d=p*p,g=d*d*d;return[h[0]*m*Math.cos(p)*74.03120656864502/(c*(1.340264+3*-.081106*d+g*(7*.000893+.034164*d))),74.03120656864502*p*(1.340264+-.081106*d+g*(.000893+.003796*d))]};h.prototype.inverse=function(h){var m=h[0]/74.03120656864502;h=h[1]/74.03120656864502;var p=180/Math.PI,d=h,g;for(g=0;12>g;++g){var q=d*d;var r=q*q*q;var l=
d*(1.340264+-.081106*q+r*(.000893+.003796*q))-h;q=1.340264+3*-.081106*q+r*(7*.000893+.034164*q);d-=l/=q;if(1e-9>Math.abs(l))break}q=d*d;return[p*c*m*(1.340264+3*-.081106*q+q*q*q*(7*.000893+.034164*q))/Math.cos(d),p*Math.asin(Math.sin(d)/c)]};return h}()});y(c,"Maps/Projections/Miller.js",[],function(){var c=Math.PI/4,h=Math.PI/180;return function(){function q(){this.bounds={x1:-200.37508342789243,x2:200.37508342789243,y1:-146.91480769173063,y2:146.91480769173063}}q.prototype.forward=function(m){return[m[0]*
h*63.78137,79.7267125*Math.log(Math.tan(c+.4*m[1]*h))]};q.prototype.inverse=function(m){return[m[0]/63.78137/h,2.5*(Math.atan(Math.exp(m[1]/63.78137*.8))-c)/h]};return q}()});y(c,"Maps/Projections/Orthographic.js",[],function(){var c=Math.PI/180;return function(){function h(){this.antimeridianCutting=!1;this.bounds={x1:-63.78460826781007,x2:63.78460826781007,y1:-63.78460826781007,y2:63.78460826781007}}h.prototype.forward=function(h){var m=h[0];h=h[1]*c;h=[Math.cos(h)*Math.sin(m*c)*63.78460826781007,
63.78460826781007*Math.sin(h)];if(-90>m||90<m)h.outside=!0;return h};h.prototype.inverse=function(h){var m=h[0]/63.78460826781007;h=h[1]/63.78460826781007;var p=Math.sqrt(m*m+h*h),d=Math.asin(p),g=Math.sin(d);return[Math.atan2(m*g,p*Math.cos(d))/c,Math.asin(p&&h*g/p)/c]};return h}()});y(c,"Maps/Projections/WebMercator.js",[],function(){var c=Math.PI/180;return function(){function h(){this.bounds={x1:-200.37508342789243,x2:200.37508342789243,y1:-200.3750834278071,y2:200.3750834278071};this.maxLatitude=
85.0511287798}h.prototype.forward=function(h){var m=Math.sin(h[1]*c);m=[63.78137*h[0]*c,63.78137*Math.log((1+m)/(1-m))/2];85.0511287798<Math.abs(h[1])&&(m.outside=!0);return m};h.prototype.inverse=function(h){return[h[0]/(63.78137*c),(2*Math.atan(Math.exp(h[1]/63.78137))-Math.PI/2)/c]};return h}()});y(c,"Maps/Projections/ProjectionRegistry.js",[c["Maps/Projections/LambertConformalConic.js"],c["Maps/Projections/EqualEarth.js"],c["Maps/Projections/Miller.js"],c["Maps/Projections/Orthographic.js"],c["Maps/Projections/WebMercator.js"]],
function(c,h,q,m,p){return{EqualEarth:h,LambertConformalConic:c,Miller:q,Orthographic:m,WebMercator:p}});y(c,"Maps/Projection.js",[c["Core/Geometry/PolygonClip.js"],c["Maps/Projections/ProjectionRegistry.js"],c["Core/Utilities.js"]],function(c,h,q){var m=this&&this.__spreadArray||function(c,b,a){if(a||2===arguments.length)for(var e=0,d=b.length,t;e<d;e++)!t&&e in b||(t||(t=Array.prototype.slice.call(b,0,e)),t[e]=b[e]);return c.concat(t||Array.prototype.slice.call(b))},p=c.clipLineString,d=c.clipPolygon,
g=q.clamp,x=q.erase,r=2*Math.PI/360,l=function(c){-180>c&&(c+=360);180<c&&(c-=360);return c};return function(){function c(b){void 0===b&&(b={});this.hasGeoProjection=this.hasCoordinates=!1;this.maxLatitude=90;this.options=b;var a=b.name,e=b.projectedBounds,d=b.rotation;this.rotator=d?this.getRotator(d):void 0;if(a=a?c.registry[a]:void 0)this.def=new a(b);var t=this.def,k=this.rotator;t&&(this.maxLatitude=t.maxLatitude||90,this.hasGeoProjection=!0);k&&t?(this.forward=function(a){return t.forward(k.forward(a))},
this.inverse=function(a){return k.inverse(t.inverse(a))}):t?(this.forward=function(a){return t.forward(a)},this.inverse=function(a){return t.inverse(a)}):k&&(this.forward=k.forward,this.inverse=k.inverse);this.bounds="world"===e?t&&t.bounds:e}c.add=function(b,a){c.registry[b]=a};c.greatCircle=function(b,a,c){var e=Math.atan2,d=Math.cos,k=Math.sin,l=Math.sqrt,n=b[1]*r,f=b[0]*r,g=a[1]*r,m=a[0]*r,h=g-n,p=m-f;h=k(h/2)*k(h/2)+d(n)*d(g)*k(p/2)*k(p/2);h=2*e(l(h),l(1-h));var q=Math.round(6371E3*h/5E5);p=
[];c&&p.push(b);if(1<q)for(q=b=1/q;.999>q;q+=b){var w=k((1-q)*h)/k(h),F=k(q*h)/k(h),v=w*d(n)*d(f)+F*d(g)*d(m),I=w*d(n)*k(f)+F*d(g)*k(m);w=w*k(n)+F*k(g);w=e(w,l(v*v+I*I));v=e(I,v);p.push([v/r,w/r])}c&&p.push(a);return p};c.insertGreatCircles=function(b){for(var a=b.length-1;a--;)if(10<Math.max(Math.abs(b[a][0]-b[a+1][0]),Math.abs(b[a][1]-b[a+1][1]))){var e=c.greatCircle(b[a],b[a+1]);e.length&&b.splice.apply(b,m([a+1,0],e,!1))}};c.toString=function(b){b=b||{};var a=b.rotation;return[b.name,a&&a.join(",")].join(";")};
c.prototype.lineIntersectsBounds=function(b){var a=this.bounds||{},c=a.x2,d=a.y1,l=a.y2,k=function(a,b,c){var e=a[0];a=a[1];var f=b?0:1;if("number"===typeof c&&e[b]>=c!==a[b]>=c)return e=e[f]+(c-e[b])/(a[b]-e[b])*(a[f]-e[f]),b?[e,c]:[c,e]},g=b[0];if(a=k(b,0,a.x1))g=a,b[1]=a;else if(a=k(b,0,c))g=a,b[1]=a;if(a=k(b,1,d))g=a;else if(a=k(b,1,l))g=a;return g};c.prototype.getRotator=function(b){var a=b[0]*r,c=(b[1]||0)*r;b=(b[2]||0)*r;var d=Math.cos(c),l=Math.sin(c),k=Math.cos(b),g=Math.sin(b);if(0!==a||
0!==c||0!==b)return{forward:function(b){var c=b[0]*r+a,e=b[1]*r,n=Math.cos(e);b=Math.cos(c)*n;c=Math.sin(c)*n;e=Math.sin(e);n=e*d+b*l;return[Math.atan2(c*k-n*g,b*d-e*l)/r,Math.asin(n*k+c*g)/r]},inverse:function(b){var c=b[0]*r,e=b[1]*r,n=Math.cos(e);b=Math.cos(c)*n;c=Math.sin(c)*n;e=Math.sin(e);n=e*k-c*g;return[(Math.atan2(c*k+e*g,b*d+n*l)-a)/r,Math.asin(n*d-b*l)/r]}}};c.prototype.forward=function(b){return b};c.prototype.inverse=function(b){return b};c.prototype.cutOnAntimeridian=function(b,a){var e=
[],d=[b];b.forEach(function(c,f){var d=b[f-1];if(!f){if(!a)return;d=b[b.length-1]}var k=d[0],v=c[0];(-90>k||90<k)&&(-90>v||90<v)&&0<k!==0<v&&(v=g((180-(k+360)%360)/((v+360)%360-(k+360)%360),0,1),e.push({i:f,lat:d[1]+v*(c[1]-d[1]),direction:0>k?1:-1,previousLonLat:d,lonLat:c}))});if(e.length)if(a){if(1===e.length%2){var t=e.slice().sort(function(a,b){return Math.abs(b.lat)-Math.abs(a.lat)})[0];x(e,t)}for(var k=e.length-2;0<=k;){var h=e[k].i,n=l(180+.000001*e[k].direction),f=l(180-.000001*e[k].direction);
h=b.splice.apply(b,m([h,e[k+1].i-h],c.greatCircle([n,e[k].lat],[n,e[k+1].lat],!0),!1));h.push.apply(h,c.greatCircle([f,e[k+1].lat],[f,e[k].lat],!0));d.push(h);k-=2}if(t)for(n=0;n<d.length;n++){k=t.direction;var p=t.lat;f=d[n];h=f.indexOf(t.lonLat);if(-1<h){n=(0>p?-1:1)*this.maxLatitude;var q=l(180+.000001*k),z=l(180-.000001*k);p=c.greatCircle([q,p],[q,n],!0);for(q+=120*k;-180<q&&180>q;q+=120*k)p.push([q,n]);p.push.apply(p,c.greatCircle([z,n],[z,t.lat],!0));f.splice.apply(f,m([h,0],p,!1));break}}}else for(k=
e.length;k--;)h=e[k].i,h=b.splice(h,b.length,[l(180+.000001*e[k].direction),e[k].lat]),h.unshift([l(180-.000001*e[k].direction),e[k].lat]),d.push(h);return d};c.prototype.path=function(b){var a=this,e=this.bounds,l=this.def,g=this.rotator,k=[],h="Polygon"===b.type||"MultiPolygon"===b.type,n=this.hasGeoProjection,f=!l||!1!==l.antimeridianCutting,m=f?g:void 0,q=f?l||this:this,z;e&&(z=[[e.x1,e.y1],[e.x2,e.y1],[e.x2,e.y2],[e.x1,e.y2]]);var r=function(b){b=b.map(function(a){if(f){m&&(a=m.forward(a));var b=
a[0];.000001>Math.abs(b-180)&&(b=180>b?179.999999:180.000001);a=[b,a[1]]}return a});var l=[b];n&&(c.insertGreatCircles(b),f&&(l=a.cutOnAntimeridian(b,h)));l.forEach(function(a){if(!(2>a.length)){var b=!1,l=!1,g=function(a){b?k.push(["L",a[0],a[1]]):(k.push(["M",a[0],a[1]]),b=!0)},t=!1,J=!1,u=a.map(function(a){a=q.forward(a);a.outside?t=!0:J=!0;Infinity===a[1]?a[1]=1E10:-Infinity===a[1]&&(a[1]=-1E10);return a});if(f){h&&u.push(u[0]);if(t){if(!J)return;if(z)if(h)u=d(u,z);else if(e){p(u,z).forEach(function(a){b=
!1;a.forEach(g)});return}}u.forEach(g)}else for(var m=0;m<u.length;m++){var r=a[m],A=u[m];if(A.outside)l=!0;else{if(h&&!C){var C=r;a.push(r);u.push(A)}l&&B&&(h&&n?c.greatCircle(B,r).forEach(function(a){return g(q.forward(a))}):b=!1);g(A);var B=r;l=!1}}}})};"LineString"===b.type?r(b.coordinates):"MultiLineString"===b.type?b.coordinates.forEach(function(a){return r(a)}):"Polygon"===b.type?(b.coordinates.forEach(function(a){return r(a)}),k.length&&k.push(["Z"])):"MultiPolygon"===b.type&&(b.coordinates.forEach(function(a){a.forEach(function(a){return r(a)})}),
k.length&&k.push(["Z"]));return k};c.registry=h;return c}()});y(c,"Maps/MapView.js",[c["Maps/MapViewOptionsDefault.js"],c["Maps/MapViewInsetsOptionsDefault.js"],c["Extensions/GeoJSON.js"],c["Core/Chart/MapChart.js"],c["Maps/MapUtilities.js"],c["Maps/Projection.js"],c["Core/Utilities.js"]],function(c,h,q,m,p,d,g){var x=this&&this.__extends||function(){var a=function(b,c){a=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(a,b){a.__proto__=b}||function(a,b){for(var c in b)b.hasOwnProperty(c)&&
(a[c]=b[c])};return a(b,c)};return function(b,c){function e(){this.constructor=b}a(b,c);b.prototype=null===c?Object.create(c):(e.prototype=c.prototype,new e)}}(),r=this&&this.__spreadArray||function(a,b,c){if(c||2===arguments.length)for(var e=0,f=b.length,d;e<f;e++)!d&&e in b||(d||(d=Array.prototype.slice.call(b,0,e)),d[e]=b[e]);return a.concat(d||Array.prototype.slice.call(b))},l=q.topo2geo,w=m.maps,b=p.boundsFromPath,a=p.pointInPolygon,e=g.addEvent,u=g.clamp,t=g.fireEvent,k=g.isArray,B=g.isNumber,
n=g.isObject,f=g.isString,A=g.merge,C=g.pick,z=g.relativeLength,G=function(a,b){return Math.log(400.979322/Math.max((a.x2-a.x1)/(b.width/256),(a.y2-a.y1)/(b.height/256)))/Math.log(2)},E=function(){function g(a,b){var f=this;this.insets=[];this.padding=[0,0,0,0];this.eventsToUnbind=[];var k;if(!(this instanceof D)){var v=r([a.options.chart.map],(a.options.series||[]).map(function(a){return a.mapData}),!0).map(function(a){return f.getGeoMap(a)}),n=[];v.forEach(function(a){a&&(k||(k=a["hc-recommended-mapview"]),
a.bbox&&(a=a.bbox,n.push({x1:a[0],y1:a[1],x2:a[2],y2:a[3]})))});var l=n.length&&g.compositeBounds(n);if(l){var h=l.x1;var u=l.y1,t=l.x2;l=l.y2;h=180<t-h&&90<l-u?{name:"EqualEarth"}:{name:"LambertConformalConic",parallels:[u,l],rotation:[-(h+t)/2]}}this.geoMap=v[0]}this.userOptions=b||{};v=A(c,{projection:h},k,b);l=k&&k.insets;b=b&&b.insets;l&&b&&(v.insets=g.mergeInsets(l,b));this.chart=a;this.center=v.center;this.options=v;this.projection=new d(v.projection);this.playingField=a.plotBox;this.zoom=
v.zoom||0;this.createInsets();this.eventsToUnbind.push(e(a,"afterSetChartSize",function(){f.playingField=f.getField();if(void 0===f.minZoom||f.minZoom===f.zoom)f.fitToBounds(void 0,void 0,!1),!f.chart.hasRendered&&B(f.userOptions.zoom)&&(f.zoom=f.userOptions.zoom),f.userOptions.center&&A(!0,f.center,f.userOptions.center)}));this.setUpEvents()}g.mergeInsets=function(a,b){var c=function(a){var b={};a.forEach(function(a,c){b[a&&a.id||"i".concat(c)]=a});return b},e=A(c(a),c(b));return Object.keys(e).map(function(a){return e[a]})};
g.prototype.createInsets=function(){var a=this,b=this.options,c=b.insets;c&&c.forEach(function(c){c=new D(a,A(b.insetOptions,c));a.insets.push(c)})};g.prototype.fitToBounds=function(a,b,c,e){void 0===c&&(c=!0);var f=a||this.getProjectedBounds();if(f){var d=C(b,a?0:this.options.padding);b=this.getField(!1);d=k(d)?d:[d,d,d,d];this.padding=[z(d[0],b.height),z(d[1],b.width),z(d[2],b.height),z(d[3],b.width)];this.playingField=this.getField();b=G(f,this.playingField);a||(this.minZoom=b);a=this.projection.inverse([(f.x2+
f.x1)/2,(f.y2+f.y1)/2]);this.setView(a,b,c,e)}};g.prototype.getField=function(a){void 0===a&&(a=!0);a=a?this.padding:[0,0,0,0];return{x:a[3],y:a[0],width:this.chart.plotWidth-a[1]-a[3],height:this.chart.plotHeight-a[0]-a[2]}};g.prototype.getGeoMap=function(a){if(f(a))return w[a];if(n(a,!0)){if("FeatureCollection"===a.type)return a;if("Topology"===a.type)return l(a)}};g.prototype.getMapBBox=function(){var a=this.getProjectedBounds(),b=this.getScale();if(a){var c=this.padding,e=this.projectedUnitsToPixels({x:a.x1,
y:a.y2});return{width:(a.x2-a.x1)*b+c[1]+c[3],height:(a.y2-a.y1)*b+c[0]+c[2],x:e.x-c[3],y:e.y-c[0]}}};g.prototype.getProjectedBounds=function(){var a=this.projection,c=this.chart.series.reduce(function(a,b){var c=b.getProjectedBounds&&b.getProjectedBounds();c&&!1!==b.options.affectsMapView&&a.push(c);return a},[]),e=this.options.fitToGeometry;return e?(this.fitToGeometryCache||("MultiPoint"===e.type?(e=e.coordinates.map(function(b){return a.forward(b)}),c=e.map(function(a){return a[0]}),e=e.map(function(a){return a[1]}),
this.fitToGeometryCache={x1:Math.min.apply(0,c),x2:Math.max.apply(0,c),y1:Math.min.apply(0,e),y2:Math.max.apply(0,e)}):this.fitToGeometryCache=b(a.path(e))),this.fitToGeometryCache):this.projection.bounds||g.compositeBounds(c)};g.prototype.getScale=function(){return 256/400.979322*Math.pow(2,this.zoom)};g.prototype.getSVGTransform=function(){var a=this.playingField,b=a.x,c=a.y,e=a.width;a=a.height;var f=this.projection.forward(this.center),d=this.projection.hasCoordinates?-1:1,k=this.getScale();d*=
k;return{scaleX:k,scaleY:d,translateX:b+e/2-f[0]*k,translateY:c+a/2-f[1]*d}};g.prototype.lonLatToPixels=function(a){if(a=this.lonLatToProjectedUnits(a))return this.projectedUnitsToPixels(a)};g.prototype.lonLatToProjectedUnits=function(b){var c=this.chart,e=c.mapTransforms;if(e){for(var f in e)if(Object.hasOwnProperty.call(e,f)&&e[f].hitZone){var d=c.transformFromLatLon(b,e[f]);if(d&&a(d,e[f].hitZone.coordinates[0]))return d}return c.transformFromLatLon(b,e["default"])}e=0;for(f=this.insets;e<f.length;e++)if(c=
f[e],c.options.geoBounds&&a({x:b.lon,y:b.lat},c.options.geoBounds.coordinates[0]))return b=c.projection.forward([b.lon,b.lat]),b=c.projectedUnitsToPixels({x:b[0],y:b[1]}),this.pixelsToProjectedUnits(b);b=this.projection.forward([b.lon,b.lat]);if(!b.outside)return{x:b[0],y:b[1]}};g.prototype.projectedUnitsToLonLat=function(b){var c=this.chart,e=c.mapTransforms;if(e){for(var f in e)if(Object.hasOwnProperty.call(e,f)&&e[f].hitZone&&a(b,e[f].hitZone.coordinates[0]))return c.transformToLatLon(b,e[f]);
return c.transformToLatLon(b,e["default"])}e=this.projectedUnitsToPixels(b);f=0;for(var d=this.insets;f<d.length;f++)if(c=d[f],c.hitZone&&a(e,c.hitZone.coordinates[0]))return b=c.pixelsToProjectedUnits(e),b=c.projection.inverse([b.x,b.y]),{lon:b[0],lat:b[1]};b=this.projection.inverse([b.x,b.y]);return{lon:b[0],lat:b[1]}};g.prototype.redraw=function(a){this.chart.series.forEach(function(a){a.useMapGeometry&&(a.isDirty=!0)});this.chart.redraw(a)};g.prototype.setView=function(a,b,c,e){void 0===c&&(c=
!0);a&&(this.center=a);"number"===typeof b&&("number"===typeof this.minZoom&&(b=Math.max(b,this.minZoom)),"number"===typeof this.options.maxZoom&&(b=Math.min(b,this.options.maxZoom)),B(b)&&(this.zoom=b));var f=this.getProjectedBounds();if(f){a=this.projection.forward(this.center);var d=this.playingField;b=d.x;var k=d.y,g=d.width;d=d.height;var l=this.getScale(),n=this.projectedUnitsToPixels({x:f.x1,y:f.y1}),h=this.projectedUnitsToPixels({x:f.x2,y:f.y2});f=[(f.x1+f.x2)/2,(f.y1+f.y2)/2];var u=n.x,m=
h.y;h=h.x;n=n.y;h-u<g?a[0]=f[0]:u<b&&h<b+g?a[0]+=Math.max(u-b,h-g-b)/l:h>b+g&&u>b&&(a[0]+=Math.min(h-g-b,u-b)/l);n-m<d?a[1]=f[1]:m<k&&n<k+d?a[1]-=Math.max(m-k,n-d-k)/l:n>k+d&&m>k&&(a[1]-=Math.min(n-d-k,m-k)/l);this.center=this.projection.inverse(a);this.insets.forEach(function(a){a.options.field&&(a.hitZone=a.getHitZone(),a.playingField=a.getField())});this.render()}t(this,"afterSetView");c&&this.redraw(e)};g.prototype.projectedUnitsToPixels=function(a){var b=this.getScale(),c=this.projection.forward(this.center),
e=this.playingField;return{x:e.x+e.width/2-b*(c[0]-a.x),y:e.y+e.height/2+b*(c[1]-a.y)}};g.prototype.pixelsToLonLat=function(a){return this.projectedUnitsToLonLat(this.pixelsToProjectedUnits(a))};g.prototype.pixelsToProjectedUnits=function(a){var b=a.x;a=a.y;var c=this.getScale(),e=this.projection.forward(this.center),f=this.playingField;return{x:e[0]+(b-(f.x+f.width/2))/c,y:e[1]-(a-(f.y+f.height/2))/c}};g.prototype.setUpEvents=function(){var a=this,b=this.chart,c,f,d,k=function(e){var k=b.pointer.pinchDown,
g=a.projection,l=b.mouseDownX,n=b.mouseDownY;1===k.length&&(l=k[0].chartX,n=k[0].chartY);if("number"===typeof l&&"number"===typeof n){var h=""+l+",".concat(n),t=e.originalEvent;k=t.chartX;t=t.chartY;h!==f&&(f=h,c=a.projection.forward(a.center),d=(a.projection.options.rotation||[0,0]).slice());h=(h=g.def&&g.def.bounds)&&G(h,a.playingField)||-Infinity;"Orthographic"===g.options.name&&(a.minZoom||Infinity)<1.1*h?(g=440/(a.getScale()*Math.min(b.plotWidth,b.plotHeight)),d&&(l=(l-k)*g-d[0],n=u(-d[1]-(n-
t)*g,-80,80),k=a.zoom,a.update({projection:{rotation:[-l,-n]}},!1),a.zoom=k,b.redraw(!1))):B(k)&&B(t)&&(g=a.getScale(),n=a.projection.inverse([c[0]+(l-k)/g,c[1]-(n-t)/g*(a.projection.hasCoordinates?1:-1)]),a.setView(n,void 0,!0,!1));e.preventDefault()}};e(b,"pan",k);e(b,"touchpan",k);e(b,"selection",function(c){if(c.resetSelection)a.zoomBy();else{var e=c.x-b.plotLeft,f=c.y-b.plotTop,d=a.pixelsToProjectedUnits({x:e,y:f}),k=d.y;d=d.x;e=a.pixelsToProjectedUnits({x:e+c.width,y:f+c.height});a.fitToBounds({x1:d,
y1:k,x2:e.x,y2:e.y},void 0,!0,c.originalEvent.touches?!1:void 0);/^touch/.test(c.originalEvent.type)||b.showResetZoom();c.preventDefault()}})};g.prototype.render=function(){this.group||(this.group=this.chart.renderer.g("map-view").attr({zIndex:4}).add())};g.prototype.update=function(a,b,c){void 0===b&&(b=!0);var e=a.projection;e=e&&d.toString(e)!==d.toString(this.options.projection);var f=!1;A(!0,this.userOptions,a);A(!0,this.options,a);"insets"in a&&(this.insets.forEach(function(a){return a.destroy()}),
this.insets.length=0,f=!0);(e||"fitToGeometry"in a)&&delete this.fitToGeometryCache;if(e||f)this.chart.series.forEach(function(a){var b=a.transformGroups;a.clearBounds&&a.clearBounds();a.isDirty=!0;a.isDirtyData=!0;if(f&&b)for(;1<b.length;)(a=b.pop())&&a.destroy()}),e&&(this.projection=new d(this.options.projection)),f&&this.createInsets(),a.center||B(a.zoom)||this.fitToBounds(void 0,void 0,!1);a.center||B(a.zoom)?this.setView(this.options.center,a.zoom,!1):"fitToGeometry"in a&&this.fitToBounds(void 0,
void 0,!1);b&&this.chart.redraw(c)};g.prototype.zoomBy=function(a,b,c,e){var f=this.chart,d=this.projection.forward(this.center);b=b?this.projection.forward(b):[];var k=b[0],g=b[1];"number"===typeof a?(a=this.zoom+a,b=void 0,c&&(k=c[0],g=c[1],c=this.getScale(),k=k-f.plotLeft-f.plotWidth/2,f=g-f.plotTop-f.plotHeight/2,k=d[0]+k/c,g=d[1]+f/c),"number"===typeof k&&"number"===typeof g&&(c=1-Math.pow(2,this.zoom)/Math.pow(2,a),k=d[0]-k,f=d[1]-g,d[0]-=k*c,d[1]+=f*c,b=this.projection.inverse(d)),this.setView(b,
a,void 0,e)):this.fitToBounds(void 0,void 0,void 0,e)};g.compositeBounds=function(a){if(a.length)return a.slice(1).reduce(function(a,b){a.x1=Math.min(a.x1,b.x1);a.y1=Math.min(a.y1,b.y1);a.x2=Math.max(a.x2,b.x2);a.y2=Math.max(a.y2,b.y2);return a},A(a[0]))};return g}(),D=function(c){function e(a,e){var f=c.call(this,a.chart,e)||this;f.id=e.id;f.mapView=a;f.options=A(h,e);f.allBounds=[];f.options.geoBounds&&(a=a.projection.path(f.options.geoBounds),f.geoBoundsProjectedBox=b(a),f.geoBoundsProjectedPolygon=
a.map(function(a){return[a[1]||0,a[2]||0]}));return f}x(e,c);e.prototype.getField=function(a){void 0===a&&(a=!0);var b=this.hitZone;if(b){var e=a?this.padding:[0,0,0,0];b=b.coordinates[0];var f=b.map(function(a){return a[0]}),d=b.map(function(a){return a[1]});b=Math.min.apply(0,f)+e[3];f=Math.max.apply(0,f)-e[1];var k=Math.min.apply(0,d)+e[0];e=Math.max.apply(0,d)-e[2];if(B(b)&&B(k))return{x:b,y:k,width:f-b,height:e-k}}return c.prototype.getField.call(this,a)};e.prototype.getHitZone=function(){var a=
this.chart,b=this.mapView,c=this.options,e=(c.field||{}).coordinates;if(e){e=e[0];if("percent"===c.units){var f="mapBoundingBox"===c.relativeTo&&b.getMapBBox()||A(a.plotBox,{x:0,y:0});e=e.map(function(a){return[z(""+a[0]+"%",f.width,f.x),z(""+a[1]+"%",f.height,f.y)]})}return{type:"Polygon",coordinates:[e]}}};e.prototype.getProjectedBounds=function(){return E.compositeBounds(this.allBounds)};e.prototype.isInside=function(b){var c=this.geoBoundsProjectedBox,e=this.geoBoundsProjectedPolygon;return!!(c&&
b.x>=c.x1&&b.x<=c.x2&&b.y>=c.y1&&b.y<=c.y2&&e&&a(b,e))};e.prototype.render=function(){var a=this.chart,b=this.mapView,c=this.options,e=c.borderPath||c.field;if(e&&b.group){var f=!0;this.border||(this.border=a.renderer.path().addClass("highcharts-mapview-inset-border").add(b.group),f=!1);a.styledMode||this.border.attr({stroke:c.borderColor,"stroke-width":c.borderWidth});var d=Math.round(this.border.strokeWidth())%2/2,k="mapBoundingBox"===c.relativeTo&&b.getMapBBox()||b.playingField;b=(e.coordinates||
[]).reduce(function(b,e){return e.reduce(function(b,e,f){var g=e[0];e=e[1];"percent"===c.units&&(g=a.plotLeft+z(""+g+"%",k.width,k.x),e=a.plotTop+z(""+e+"%",k.height,k.y));g=Math.floor(g)+d;e=Math.floor(e)+d;b.push(0===f?["M",g,e]:["L",g,e]);return b},b)},[]);this.border[f?"animate":"attr"]({d:b})}};e.prototype.destroy=function(){this.border&&(this.border=this.border.destroy());this.eventsToUnbind.forEach(function(a){return a()})};e.prototype.setUpEvents=function(){};return e}(E);e(m,"afterInit",
function(){this.mapView=new E(this,this.options.mapView)});return E});y(c,"Series/Map/MapSeries.js",[c["Core/Animation/AnimationUtilities.js"],c["Series/ColorMapComposition.js"],c["Series/CenteredUtilities.js"],c["Core/Globals.js"],c["Core/Legend/LegendSymbol.js"],c["Core/Chart/MapChart.js"],c["Series/Map/MapPoint.js"],c["Maps/MapView.js"],c["Core/Series/Series.js"],c["Core/Series/SeriesRegistry.js"],c["Core/Renderer/SVG/SVGRenderer.js"],c["Core/Utilities.js"]],function(c,h,q,m,p,d,g,x,r,l,w,b){var a=
this&&this.__extends||function(){var a=function(b,c){a=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(a,b){a.__proto__=b}||function(a,b){for(var c in b)b.hasOwnProperty(c)&&(a[c]=b[c])};return a(b,c)};return function(b,c){function e(){this.constructor=b}a(b,c);b.prototype=null===c?Object.create(c):(e.prototype=c.prototype,new e)}}(),e=c.animObject;c=m.noop;var u=d.splitPath;d=l.seriesTypes;var t=d.column,k=d.scatter;d=b.extend;var B=b.find,n=b.fireEvent,f=b.getNestedProperty,A=b.isArray,
C=b.defined,z=b.isNumber,G=b.isObject,E=b.merge,D=b.objectEach,F=b.pick,v=b.splat;b=function(b){function c(){var a=null!==b&&b.apply(this,arguments)||this;a.chart=void 0;a.data=void 0;a.group=void 0;a.joinBy=void 0;a.options=void 0;a.points=void 0;a.processedData=[];return a}a(c,b);c.prototype.animate=function(a){var b=this.chart,c=this.group,f=e(this.options.animation);b.renderer.isSVG&&(a?c.attr({translateX:b.plotLeft+b.plotWidth/2,translateY:b.plotTop+b.plotHeight/2,scaleX:.001,scaleY:.001}):c.animate({translateX:b.plotLeft,
translateY:b.plotTop,scaleX:1,scaleY:1},f))};c.prototype.animateDrilldown=function(a){var b=this.chart,c=this.group;b.renderer.isSVG&&(a?c.attr({translateX:b.plotLeft+b.plotWidth/2,translateY:b.plotTop+b.plotHeight/2,scaleX:.1,scaleY:.1,opacity:.01}):(c.animate({translateX:b.plotLeft,translateY:b.plotTop,scaleX:1,scaleY:1,opacity:1},this.chart.options.drilldown.animation),b.drilldown&&b.drilldown.fadeInGroup(this.dataLabelsGroup)))};c.prototype.animateDrillupFrom=function(){var a=this.chart;a.renderer.isSVG&&
this.group.animate({translateX:a.plotLeft+a.plotWidth/2,translateY:a.plotTop+a.plotHeight/2,scaleX:.1,scaleY:.1,opacity:.01})};c.prototype.animateDrillupTo=function(a){t.prototype.animateDrillupTo.call(this,a)};c.prototype.clearBounds=function(){this.points.forEach(function(a){delete a.bounds;delete a.insetIndex;delete a.projectedPath});delete this.bounds};c.prototype.doFullTranslate=function(){return!(!(this.isDirtyData||this.chart.isResizing||this.chart.renderer.isVML)&&this.hasRendered)};c.prototype.drawMapDataLabels=
function(){r.prototype.drawDataLabels.call(this);this.dataLabelsGroup&&this.dataLabelsGroup.clip(this.chart.clipRect)};c.prototype.drawPoints=function(){var a=this,b=this,c=this.chart,e=this.group,f=this.transformGroups,d=void 0===f?[]:f,k=c.mapView,g=c.renderer;k&&(this.transformGroups=d,d[0]||(d[0]=g.g().add(e)),k.insets.forEach(function(a,b){d[b+1]||d.push(g.g().add(e))}),this.doFullTranslate()&&(this.points.forEach(function(b){var e=b.graphic,f=b.shapeArgs;b.group=d["number"===typeof b.insetIndex?
b.insetIndex+1:0];e&&e.parentGroup!==b.group&&e.add(b.group);f&&c.hasRendered&&!c.styledMode&&(f.fill=a.pointAttribs(b,b.state).fill)}),t.prototype.drawPoints.apply(this),this.points.forEach(function(e){var f=e.graphic;if(f){var d=f.animate,k="";e.name&&(k+="highcharts-name-"+e.name.replace(/ /g,"-").toLowerCase());e.properties&&e.properties["hc-key"]&&(k+=" highcharts-key-"+e.properties["hc-key"].toString().toLowerCase());k&&f.addClass(k);c.styledMode&&f.css(a.pointAttribs(e,e.selected&&"select"||
void 0));f.animate=function(a,e,k){var g=z(a["stroke-width"])&&!z(f["stroke-width"]),n=z(f["stroke-width"])&&!z(a["stroke-width"]);if(g||n){var l=F(b.getStrokeWidth(b.options),1)/(c.mapView&&c.mapView.getScale()||1);g&&(f["stroke-width"]=l);n&&(a["stroke-width"]=l)}return d.call(f,a,e,n?function(){f.element.removeAttribute("stroke-width");delete f["stroke-width"];k&&k.apply(this,arguments)}:k)}}})),d.forEach(function(e,f){var d=(0===f?k:k.insets[f-1]).getSVGTransform(),n=F(a.getStrokeWidth(a.options),
1),l=d.scaleX,h=0<d.scaleY?1:-1,t=function(c){(b.points||[]).forEach(function(b){var e=b.graphic,f;e&&e["stroke-width"]&&(f=a.getStrokeWidth(b.options))&&e.attr({"stroke-width":f/c})})};if(g.globalAnimation&&c.hasRendered){var u=Number(e.attr("translateX")),m=Number(e.attr("translateY")),p=Number(e.attr("scaleX"));e.attr({animator:0}).animate({animator:1},{step:function(a,b){a=p+(l-p)*b.pos;e.attr({translateX:u+(d.translateX-u)*b.pos,translateY:m+(d.translateY-m)*b.pos,scaleX:a,scaleY:a*h,"stroke-width":n/
a});t(a)}})}else e.attr(E(d,{"stroke-width":n/l})),t(l)}),this.drawMapDataLabels())};c.prototype.getProjectedBounds=function(){if(!this.bounds&&this.chart.mapView){var a=this.chart.mapView,b=a.insets,c=a.projection,e=[];(this.points||[]).forEach(function(a){if(a.path||a.geometry){"string"===typeof a.path?a.path=u(a.path):A(a.path)&&"M"===a.path[0]&&(a.path=w.prototype.pathToSegments(a.path));if(!a.bounds){var f=a.getProjectedBounds(c);if(f){a.labelrank=F(a.labelrank,(f.x2-f.x1)*(f.y2-f.y1));var d=
f.midX,k=f.midY;if(b&&z(d)&&z(k)){var g=B(b,function(a){return a.isInside({x:d,y:k})});g&&(delete a.projectedPath,(f=a.getProjectedBounds(g.projection))&&g.allBounds.push(f),a.insetIndex=b.indexOf(g))}a.bounds=f}}a.bounds&&void 0===a.insetIndex&&e.push(a.bounds)}});this.bounds=x.compositeBounds(e)}return this.bounds};c.prototype.getStrokeWidth=function(a){var b=this.pointAttrToOptions;return a[b&&b["stroke-width"]||"borderWidth"]};c.prototype.hasData=function(){return!!this.processedXData.length};
c.prototype.pointAttribs=function(a,b){var c=a.series.chart,e=c.mapView;c=c.styledMode?this.colorAttribs(a):t.prototype.pointAttribs.call(this,a,b);var f=this.getStrokeWidth(a.options);b&&(b=E(this.options.states[b],a.options.states&&a.options.states[b]||{}),b=this.getStrokeWidth(b),C(b)&&(f=b));f&&e&&(f/=e.getScale());b=this.getStrokeWidth(this.options);c.dashstyle&&e&&z(b)&&(f=b/e.getScale());a.visible||(c.fill=this.options.nullColor);C(f)?c["stroke-width"]=f:delete c["stroke-width"];c["stroke-linecap"]=
c["stroke-linejoin"]=this.options.linecap;return c};c.prototype.updateData=function(){return this.processedData?!1:b.prototype.updateData.apply(this,arguments)};c.prototype.setData=function(a,c,e,f){void 0===c&&(c=!0);delete this.bounds;b.prototype.setData.call(this,a,!1,void 0,f);this.processData();this.generatePoints();c&&this.chart.redraw(e)};c.prototype.processData=function(){var a=this.options,b=a.data,c=this.chart.options.chart,e=this.joinBy,d=a.keys||this.pointArrayMap,k=[],n={},l=this.chart.mapView;
l=l&&(G(a.mapData,!0)?l.getGeoMap(a.mapData):l.geoMap);var h=this.chart.mapTransforms;(this.chart.mapTransforms=h=c.mapTransforms||l&&l["hc-transform"]||h)&&D(h,function(a){a.rotation&&(a.cosAngle=Math.cos(a.rotation),a.sinAngle=Math.sin(a.rotation))});if(A(a.mapData))var t=a.mapData;else l&&"FeatureCollection"===l.type&&(this.mapTitle=l.title,t=m.geojson(l,this.type,this));var u=this.processedData=[];b&&b.forEach(function(c,f){var k=0;if(z(c))u[f]={value:c};else if(A(c)){u[f]={};!a.keys&&c.length>
d.length&&"string"===typeof c[0]&&(u[f]["hc-key"]=c[0],++k);for(var l=0;l<d.length;++l,++k)d[l]&&"undefined"!==typeof c[k]&&(0<d[l].indexOf(".")?g.prototype.setNestedProperty(u[f],c[k],d[l]):u[f][d[l]]=c[k])}else u[f]=b[f];e&&"_i"===e[0]&&(u[f]._i=f)});if(t){this.mapData=t;this.mapMap={};for(h=0;h<t.length;h++)c=t[h],l=c.properties,c._i=h,e[0]&&l&&l[e[0]]&&(c[e[0]]=l[e[0]]),n[c[e[0]]]=c;this.mapMap=n;if(e[1]){var p=e[1];u.forEach(function(a){a=f(p,a);n[a]&&k.push(n[a])})}if(a.allAreas){if(e[1]){var q=
e[1];u.forEach(function(a){k.push(f(q,a))})}var r="|"+k.map(function(a){return a&&a[e[0]]}).join("|")+"|";t.forEach(function(a){e[0]&&-1!==r.indexOf("|"+a[e[0]]+"|")||u.push(E(a,{value:null}))})}}this.processedXData=Array(u.length)};c.prototype.setOptions=function(a){a=r.prototype.setOptions.call(this,a);var b=a.joinBy;null===b&&(b="_i");b=this.joinBy=v(b);b[1]||(b[1]=b[0]);return a};c.prototype.translate=function(){var a=this.doFullTranslate(),b=this.chart.mapView,c=b&&b.projection;!this.chart.hasRendered||
!this.isDirtyData&&this.hasRendered||(this.processData(),this.generatePoints(),delete this.bounds,!b||b.userOptions.center||z(b.userOptions.zoom)?this.getProjectedBounds():b.fitToBounds(void 0,void 0,!1));if(b){var e=b.getSVGTransform();this.points.forEach(function(f){var d=z(f.insetIndex)&&b.insets[f.insetIndex].getSVGTransform()||e;d&&f.bounds&&z(f.bounds.midX)&&z(f.bounds.midY)&&(f.plotX=f.bounds.midX*d.scaleX+d.translateX,f.plotY=f.bounds.midY*d.scaleY+d.translateY);a&&(f.shapeType="path",f.shapeArgs=
{d:g.getProjectedPath(f,c)})})}n(this,"afterTranslate")};c.defaultOptions=E(k.defaultOptions,{affectsMapView:!0,animation:!1,dataLabels:{crop:!1,formatter:function(){var a=this.series.chart.numberFormatter,b=this.point.value;return z(b)?a(b,-1):""},inside:!0,overflow:!1,padding:0,verticalAlign:"middle"},linecap:"butt",marker:null,nullColor:"#f7f7f7",stickyTracking:!1,tooltip:{followPointer:!0,pointFormat:"{point.name}: {point.value}<br/>"},turboThreshold:0,allAreas:!0,borderColor:"#cccccc",borderWidth:1,
joinBy:"hc-key",states:{hover:{halo:null,brightness:.2},normal:{animation:!0},select:{color:"#cccccc"}}});return c}(k);d(b.prototype,{type:"map",axisTypes:h.seriesMembers.axisTypes,colorAttribs:h.seriesMembers.colorAttribs,colorKey:h.seriesMembers.colorKey,directTouch:!0,drawDataLabels:c,drawGraph:c,drawLegendSymbol:p.drawRectangle,forceDL:!0,getCenter:q.getCenter,getExtremesFromAll:!0,getSymbol:c,isCartesian:!1,parallelArrays:h.seriesMembers.parallelArrays,pointArrayMap:h.seriesMembers.pointArrayMap,
pointClass:g,preserveAspectRatio:!0,searchPoint:c,trackerGroups:h.seriesMembers.trackerGroups,useMapGeometry:!0});h.compose(b);l.registerSeriesType("map",b);"";return b});y(c,"Series/MapLine/MapLineSeries.js",[c["Series/Map/MapSeries.js"],c["Core/Series/SeriesRegistry.js"],c["Core/Utilities.js"]],function(c,h,q){var m=this&&this.__extends||function(){var c=function(d,g){c=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(c,b){c.__proto__=b}||function(c,b){for(var a in b)b.hasOwnProperty(a)&&
(c[a]=b[a])};return c(d,g)};return function(d,g){function l(){this.constructor=d}c(d,g);d.prototype=null===g?Object.create(g):(l.prototype=g.prototype,new l)}}(),p=h.series,d=q.extend,g=q.merge;q=function(d){function h(){var c=null!==d&&d.apply(this,arguments)||this;c.data=void 0;c.options=void 0;c.points=void 0;return c}m(h,d);h.prototype.pointAttribs=function(d,g){d=c.prototype.pointAttribs.call(this,d,g);d.fill=this.options.fillColor;return d};h.defaultOptions=g(c.defaultOptions,{lineWidth:1,fillColor:"none"});
return h}(c);d(q.prototype,{type:"mapline",colorProp:"stroke",drawLegendSymbol:p.prototype.drawLegendSymbol,pointAttrToOptions:{stroke:"color","stroke-width":"lineWidth"}});h.registerSeriesType("mapline",q);"";return q});y(c,"Series/MapPoint/MapPointPoint.js",[c["Core/Series/SeriesRegistry.js"],c["Core/Utilities.js"]],function(c,h){var q=this&&this.__extends||function(){var c=function(d,g){c=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(c,d){c.__proto__=d}||function(c,d){for(var g in d)d.hasOwnProperty(g)&&
(c[g]=d[g])};return c(d,g)};return function(d,g){function h(){this.constructor=d}c(d,g);d.prototype=null===g?Object.create(g):(h.prototype=g.prototype,new h)}}(),m=h.isNumber;return function(c){function d(){var d=null!==c&&c.apply(this,arguments)||this;d.options=void 0;d.series=void 0;return d}q(d,c);d.prototype.isValid=function(){return!!(this.options.geometry||m(this.x)&&m(this.y)||m(this.options.lon)&&m(this.options.lat))};return d}(c.seriesTypes.scatter.prototype.pointClass)});y(c,"Series/MapPoint/MapPointSeries.js",
[c["Core/Globals.js"],c["Series/MapPoint/MapPointPoint.js"],c["Core/Series/SeriesRegistry.js"],c["Core/Renderer/SVG/SVGRenderer.js"],c["Core/Utilities.js"]],function(c,h,q,m,p){var d=this&&this.__extends||function(){var a=function(b,c){a=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(a,b){a.__proto__=b}||function(a,b){for(var c in b)b.hasOwnProperty(c)&&(a[c]=b[c])};return a(b,c)};return function(b,c){function e(){this.constructor=b}a(b,c);b.prototype=null===c?Object.create(c):(e.prototype=
c.prototype,new e)}}();c=c.noop;var g=q.seriesTypes,x=g.map,r=g.scatter;g=p.extend;var l=p.fireEvent,w=p.isNumber,b=p.merge;p=function(a){function c(){var b=null!==a&&a.apply(this,arguments)||this;b.chart=void 0;b.data=void 0;b.options=void 0;b.points=void 0;b.clearBounds=x.prototype.clearBounds;return b}d(c,a);c.prototype.drawDataLabels=function(){a.prototype.drawDataLabels.call(this);this.dataLabelsGroup&&this.dataLabelsGroup.clip(this.chart.clipRect)};c.prototype.projectPoint=function(a){var b=
this.chart.mapView;if(b){var c=a.geometry,e=a.lon;a=a.lat;c=c&&"Point"===c.type&&c.coordinates;w(e)&&w(a)&&(c=[e,a]);if(c)return b.lonLatToProjectedUnits({lon:c[0],lat:c[1]})}};c.prototype.translate=function(){var a=this,b=this.chart.mapView;this.processedXData||this.processData();this.generatePoints();this.getProjectedBounds&&this.isDirtyData&&(delete this.bounds,this.getProjectedBounds());if(b){var c=b.getSVGTransform(),e=b.projection.hasCoordinates;this.points.forEach(function(d){var f=d.x;f=void 0===
f?void 0:f;var k=d.y;k=void 0===k?void 0:k;var g=w(d.insetIndex)&&b.insets[d.insetIndex].getSVGTransform()||c,l=a.projectPoint(d.options)||d.properties&&a.projectPoint(d.properties);if(l)f=l.x,k=l.y;else if(d.bounds&&(f=d.bounds.midX,k=d.bounds.midY,g&&w(f)&&w(k))){d.plotX=f*g.scaleX+g.translateX;d.plotY=k*g.scaleY+g.translateY;var n=!0}w(f)&&w(k)?n||(n=b.projectedUnitsToPixels({x:f,y:k}),d.plotX=n.x,d.plotY=e?n.y:a.chart.plotHeight-n.y):d.y=d.plotX=d.plotY=void 0;d.isInside=a.isPointInside(d);d.zone=
a.zones.length?d.getZone():void 0})}l(this,"afterTranslate")};c.defaultOptions=b(r.defaultOptions,{dataLabels:{crop:!1,defer:!1,enabled:!0,formatter:function(){return this.point.name},overflow:!1,style:{color:"#000000"}}});return c}(r);m.prototype.symbols.mapmarker=function(a,b,c,d,k){var e=k&&"legend"===k.context;e?(a+=c/2,k=b+d):k&&"number"===typeof k.anchorX&&"number"===typeof k.anchorY?(a=k.anchorX,k=k.anchorY):(a+=c/2,k=b+d/2,b-=d);d=e?d/3:d/2;return[["M",a,k],["C",a,k,a-d,b+1.5*d,a-d,b+d],["A",
d,d,1,1,1,a+d,b+d],["C",a+d,b+1.5*d,a,k,a,k],["Z"]]};g(p.prototype,{type:"mappoint",axisTypes:["colorAxis"],forceDL:!0,isCartesian:!1,pointClass:h,searchPoint:c,useMapGeometry:!0});q.registerSeriesType("mappoint",p);"";return p});y(c,"Series/Bubble/BubbleLegendDefaults.js",[],function(){return{borderColor:void 0,borderWidth:2,className:void 0,color:void 0,connectorClassName:void 0,connectorColor:void 0,connectorDistance:60,connectorWidth:1,enabled:!1,labels:{className:void 0,allowOverlap:!1,format:"",
formatter:void 0,align:"right",style:{fontSize:"10px",color:"#000000"},x:0,y:0},maxSize:60,minSize:10,legendIndex:0,ranges:{value:void 0,borderColor:void 0,color:void 0,connectorColor:void 0},sizeBy:"area",sizeByAbsoluteValue:!1,zIndex:1,zThreshold:0}});y(c,"Series/Bubble/BubbleLegendItem.js",[c["Core/Color/Color.js"],c["Core/FormatUtilities.js"],c["Core/Globals.js"],c["Core/Utilities.js"]],function(c,h,q,m){var p=c.parse,d=q.noop,g=m.arrayMax,x=m.arrayMin,r=m.isNumber,l=m.merge,w=m.pick,b=m.stableSort;
c=function(){function a(a,b){this.options=this.symbols=this.visible=this.selected=this.ranges=this.movementX=this.maxLabel=this.legend=this.fontMetrics=this.chart=void 0;this.setState=d;this.init(a,b)}a.prototype.init=function(a,b){this.options=a;this.visible=!0;this.chart=b.chart;this.legend=b};a.prototype.addToLegend=function(a){a.splice(this.options.legendIndex,0,this)};a.prototype.drawLegendSymbol=function(a){var c=this.chart,e=w(a.options.itemDistance,20),d=this.legendItem||{},g=this.options,
l=g.ranges,f=g.connectorDistance;this.fontMetrics=c.renderer.fontMetrics(g.labels.style.fontSize);l&&l.length&&r(l[0].value)?(b(l,function(a,b){return b.value-a.value}),this.ranges=l,this.setOptions(),this.render(),a=this.getMaxLabelSize(),l=this.ranges[0].radius,c=2*l,f=f-l+a.width,f=0<f?f:0,this.maxLabel=a,this.movementX="left"===g.labels.align?f:0,d.labelWidth=c+f+e,d.labelHeight=c+this.fontMetrics.h/2):a.options.bubbleLegend.autoRanges=!0};a.prototype.setOptions=function(){var a=this.ranges,b=
this.options,c=this.chart.series[b.seriesIndex],d=this.legend.baseline,g={zIndex:b.zIndex,"stroke-width":b.borderWidth},h={zIndex:b.zIndex,"stroke-width":b.connectorWidth},f={align:this.legend.options.rtl||"left"===b.labels.align?"right":"left",zIndex:b.zIndex},m=c.options.marker.fillOpacity,q=this.chart.styledMode;a.forEach(function(e,k){q||(g.stroke=w(e.borderColor,b.borderColor,c.color),g.fill=w(e.color,b.color,1!==m?p(c.color).setOpacity(m).get("rgba"):c.color),h.stroke=w(e.connectorColor,b.connectorColor,
c.color));a[k].radius=this.getRangeRadius(e.value);a[k]=l(a[k],{center:a[0].radius-a[k].radius+d});q||l(!0,a[k],{bubbleAttribs:l(g),connectorAttribs:l(h),labelAttribs:f})},this)};a.prototype.getRangeRadius=function(a){var b=this.options;return this.chart.series[this.options.seriesIndex].getRadius.call(this,b.ranges[b.ranges.length-1].value,b.ranges[0].value,b.minSize,b.maxSize,a)};a.prototype.render=function(){var a=this.legendItem||{},b=this.chart.renderer,c=this.options.zThreshold;this.symbols||
(this.symbols={connectors:[],bubbleItems:[],labels:[]});a.symbol=b.g("bubble-legend");a.label=b.g("bubble-legend-item");a.symbol.translateX=0;b=a.symbol.translateY=0;for(var d=this.ranges;b<d.length;b++){var g=d[b];g.value>=c&&this.renderRange(g)}a.symbol.add(a.label);a.label.add(a.group);this.hideOverlappingLabels()};a.prototype.renderRange=function(a){var b=this.options,c=b.labels,e=this.chart,d=e.series[b.seriesIndex],g=e.renderer,f=this.symbols;e=f.labels;var l=a.center,h=Math.abs(a.radius),m=
b.connectorDistance||0,p=c.align,q=b.connectorWidth,r=this.ranges[0].radius||0,w=l-h-b.borderWidth/2+q/2,v=this.fontMetrics;v=v.f/2-(v.h-v.f)/2;var x=g.styledMode;m=this.legend.options.rtl||"left"===p?-m:m;"center"===p&&(m=0,b.connectorDistance=0,a.labelAttribs.align="center");p=w+b.labels.y;var D=r+m+b.labels.x;f.bubbleItems.push(g.circle(r,l+((w%1?1:.5)-(q%2?0:.5)),h).attr(x?{}:a.bubbleAttribs).addClass((x?"highcharts-color-"+d.colorIndex+" ":"")+"highcharts-bubble-legend-symbol "+(b.className||
"")).add(this.legendItem.symbol));f.connectors.push(g.path(g.crispLine([["M",r,w],["L",r+m,w]],b.connectorWidth)).attr(x?{}:a.connectorAttribs).addClass((x?"highcharts-color-"+this.options.seriesIndex+" ":"")+"highcharts-bubble-legend-connectors "+(b.connectorClassName||"")).add(this.legendItem.symbol));a=g.text(this.formatLabel(a),D,p+v).attr(x?{}:a.labelAttribs).css(x?{}:c.style).addClass("highcharts-bubble-legend-labels "+(b.labels.className||"")).add(this.legendItem.symbol);e.push(a);a.placed=
!0;a.alignAttr={x:D,y:p+v}};a.prototype.getMaxLabelSize=function(){var a,b;this.symbols.labels.forEach(function(c){b=c.getBBox(!0);a=a?b.width>a.width?b:a:b});return a||{}};a.prototype.formatLabel=function(a){var b=this.options,c=b.labels.formatter;b=b.labels.format;var e=this.chart.numberFormatter;return b?h.format(b,a):c?c.call(a):e(a.value,1)};a.prototype.hideOverlappingLabels=function(){var a=this.chart,b=this.symbols;!this.options.labels.allowOverlap&&b&&(a.hideOverlappingLabels(b.labels),b.labels.forEach(function(a,
c){a.newOpacity?a.newOpacity!==a.oldOpacity&&b.connectors[c].show():b.connectors[c].hide()}))};a.prototype.getRanges=function(){var a=this.legend.bubbleLegend,b=a.options.ranges,c,d=Number.MAX_VALUE,h=-Number.MAX_VALUE;a.chart.series.forEach(function(a){a.isBubble&&!a.ignoreSeries&&(c=a.zData.filter(r),c.length&&(d=w(a.options.zMin,Math.min(d,Math.max(x(c),!1===a.options.displayNegative?a.options.zThreshold:-Number.MAX_VALUE))),h=w(a.options.zMax,Math.max(h,g(c)))))});var n=d===h?[{value:h}]:[{value:d},
{value:(d+h)/2},{value:h,autoRanges:!0}];b.length&&b[0].radius&&n.reverse();n.forEach(function(a,c){b&&b[c]&&(n[c]=l(b[c],a))});return n};a.prototype.predictBubbleSizes=function(){var a=this.chart,b=this.fontMetrics,c=a.legend.options,d=c.floating,g=(c="horizontal"===c.layout)?a.legend.lastLineHeight:0,l=a.plotSizeX,f=a.plotSizeY,h=a.series[this.options.seriesIndex],m=h.getPxExtremes();a=Math.ceil(m.minPxSize);m=Math.ceil(m.maxPxSize);var p=Math.min(f,l);h=h.options.maxSize;if(d||!/%$/.test(h))b=
m;else if(h=parseFloat(h),b=(p+g-b.h/2)*h/100/(h/100+1),c&&f-b>=l||!c&&l-b>=f)b=m;return[a,Math.ceil(b)]};a.prototype.updateRanges=function(a,b){var c=this.legend.options.bubbleLegend;c.minSize=a;c.maxSize=b;c.ranges=this.getRanges()};a.prototype.correctSizes=function(){var a=this.legend,b=this.chart.series[this.options.seriesIndex].getPxExtremes();1<Math.abs(Math.ceil(b.maxPxSize)-this.options.maxSize)&&(this.updateRanges(this.options.minSize,b.maxPxSize),a.render())};return a}();"";return c});y(c,
"Series/Bubble/BubbleLegendComposition.js",[c["Series/Bubble/BubbleLegendDefaults.js"],c["Series/Bubble/BubbleLegendItem.js"],c["Core/Defaults.js"],c["Core/Utilities.js"]],function(c,h,q,m){function p(b,c,e){var k=this.legend,f=0<=d(this),h;if(k&&k.options.enabled&&k.bubbleLegend&&k.options.bubbleLegend.autoRanges&&f){var m=k.bubbleLegend.options;f=k.bubbleLegend.predictBubbleSizes();k.bubbleLegend.updateRanges(f[0],f[1]);m.placed||(k.group.placed=!1,k.allItems.forEach(function(a){h=a.legendItem||
{};h.group&&(h.group.translateY=null)}));k.render();this.getMargins();this.axes.forEach(function(b){b.visible&&b.render();m.placed||(b.setScale(),b.updateNames(),a(b.ticks,function(a){a.isNew=!0;a.isNewLabel=!0}))});m.placed=!0;this.getMargins();b.call(this,c,e);k.bubbleLegend.correctSizes();l(k,g(k))}else b.call(this,c,e),k&&k.options.enabled&&k.bubbleLegend&&(k.render(),l(k,g(k)))}function d(a){a=a.series;for(var b=0;b<a.length;){if(a[b]&&a[b].isBubble&&a[b].visible&&a[b].zData.length)return b;
b++}return-1}function g(a){a=a.allItems;var b=[],c=a.length,d,f=0;for(d=0;d<c;d++){var e=a[d].legendItem||{};var g=(a[d+1]||{}).legendItem||{};e.labelHeight&&(a[d].itemHeight=e.labelHeight);if(a[d]===a[c-1]||e.y!==g.y){b.push({height:0});e=b[b.length-1];for(f;f<=d;f++)a[f].itemHeight>e.height&&(e.height=a[f].itemHeight);e.step=d}}return b}function x(a){var b=this.bubbleLegend,c=this.options,e=c.bubbleLegend,f=d(this.chart);b&&b.ranges&&b.ranges.length&&(e.ranges.length&&(e.autoRanges=!!e.ranges[0].autoRanges),
this.destroyItem(b));0<=f&&c.enabled&&e.enabled&&(e.seriesIndex=f,this.bubbleLegend=new h(e,this),this.bubbleLegend.addToLegend(a.allItems))}function r(){var a=this.chart,b=this.visible,c=this.chart.legend;c&&c.bubbleLegend&&(this.visible=!b,this.ignoreSeries=b,a=0<=d(a),c.bubbleLegend.visible!==a&&(c.update({bubbleLegend:{enabled:a}}),c.bubbleLegend.visible=a),this.visible=b)}function l(a,b){var c=a.options.rtl,d,e,g,k,l=0;a.allItems.forEach(function(a,f){k=a.legendItem||{};if(k.group){d=k.group.translateX||
0;e=k.y||0;if((g=a.movementX)||c&&a.ranges)g=c?d-a.options.maxSize/2:d+g,k.group.attr({translateX:g});f>b[l].step&&l++;k.group.attr({translateY:Math.round(e+b[l].height/2)});k.y=e+b[l].height/2}})}var w=q.setOptions,b=m.addEvent,a=m.objectEach,e=m.wrap,u=[];return{compose:function(a,d,g){-1===u.indexOf(a)&&(u.push(a),w({legend:{bubbleLegend:c}}),e(a.prototype,"drawChartBox",p));-1===u.indexOf(d)&&(u.push(d),b(d,"afterGetAllItems",x));-1===u.indexOf(g)&&(u.push(g),b(g,"legendItemClick",r))}}});y(c,
"Series/Bubble/BubblePoint.js",[c["Core/Series/Point.js"],c["Core/Series/SeriesRegistry.js"],c["Core/Utilities.js"]],function(c,h,q){var m=this&&this.__extends||function(){var c=function(d,g){c=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(c,d){c.__proto__=d}||function(c,d){for(var g in d)d.hasOwnProperty(g)&&(c[g]=d[g])};return c(d,g)};return function(d,g){function h(){this.constructor=d}c(d,g);d.prototype=null===g?Object.create(g):(h.prototype=g.prototype,new h)}}();q=q.extend;
h=function(h){function d(){var c=null!==h&&h.apply(this,arguments)||this;c.options=void 0;c.series=void 0;return c}m(d,h);d.prototype.haloPath=function(d){return c.prototype.haloPath.call(this,0===d?0:(this.marker?this.marker.radius||0:0)+d)};return d}(h.seriesTypes.scatter.prototype.pointClass);q(h.prototype,{ttBelow:!1});return h});y(c,"Series/Bubble/BubbleSeries.js",[c["Series/Bubble/BubbleLegendComposition.js"],c["Series/Bubble/BubblePoint.js"],c["Core/Color/Color.js"],c["Core/Globals.js"],c["Core/Series/SeriesRegistry.js"],
c["Core/Utilities.js"]],function(c,h,q,m,p,d){function g(){var a=this,b=this.len,c=this.chart,d=this.isXAxis,e=d?"xData":"yData",f=this.min,g=this.max-f,l=0,h=b,m=b/g,p;this.series.forEach(function(b){if(b.bubblePadding&&(b.visible||!c.options.chart.ignoreHiddenSeries)){p=a.allowZoomOutside=!0;var n=b[e];d&&((b.onPoint||b).getRadii(0,0,b),b.onPoint&&(b.radii=b.onPoint.radii));if(0<g)for(var q=n.length;q--;)if(k(n[q])&&a.dataMin<=n[q]&&n[q]<=a.max){var r=b.radii&&b.radii[q]||0;l=Math.min((n[q]-f)*
m-r,l);h=Math.max((n[q]-f)*m+r,h)}}});p&&0<g&&!this.logarithmic&&(h-=b,m*=(b+Math.max(0,l)-Math.min(h,b))/b,[["min","userMin",l],["max","userMax",h]].forEach(function(b){"undefined"===typeof n(a.options[b[0]],a[b[1]])&&(a[b[0]]+=b[2]/m)}))}var x=this&&this.__extends||function(){var a=function(b,c){a=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(a,b){a.__proto__=b}||function(a,b){for(var c in b)b.hasOwnProperty(c)&&(a[c]=b[c])};return a(b,c)};return function(b,c){function d(){this.constructor=
b}a(b,c);b.prototype=null===c?Object.create(c):(d.prototype=c.prototype,new d)}}(),r=q.parse;q=m.noop;var l=p.series,w=p.seriesTypes;m=w.column.prototype;var b=w.scatter;w=d.addEvent;var a=d.arrayMax,e=d.arrayMin,u=d.clamp,t=d.extend,k=d.isNumber,B=d.merge,n=d.pick,f=[];d=function(d){function h(){var a=null!==d&&d.apply(this,arguments)||this;a.data=void 0;a.maxPxSize=void 0;a.minPxSize=void 0;a.options=void 0;a.points=void 0;a.radii=void 0;a.yData=void 0;a.zData=void 0;return a}x(h,d);h.compose=function(a,
b,d,e){c.compose(b,d,e);-1===f.indexOf(a)&&(f.push(a),a.prototype.beforePadding=g)};h.prototype.animate=function(a){!a&&this.points.length<this.options.animationLimit&&this.points.forEach(function(a){var b=a.graphic;b&&b.width&&(this.hasRendered||b.attr({x:a.plotX,y:a.plotY,width:1,height:1}),b.animate(this.markerAttribs(a),this.options.animation))},this)};h.prototype.getRadii=function(){var a=this,b=this.zData,c=this.yData,d=[],e=this.chart.bubbleZExtremes;var f=this.getPxExtremes();var g=f.minPxSize,
k=f.maxPxSize;if(!e){var h=Number.MAX_VALUE,l=-Number.MAX_VALUE,m;this.chart.series.forEach(function(b){b.bubblePadding&&(b.visible||!a.chart.options.chart.ignoreHiddenSeries)&&(b=(b.onPoint||b).getZExtremes())&&(h=Math.min(h||b.zMin,b.zMin),l=Math.max(l||b.zMax,b.zMax),m=!0)});m?(e={zMin:h,zMax:l},this.chart.bubbleZExtremes=e):e={zMin:0,zMax:0}}var n=0;for(f=b.length;n<f;n++){var p=b[n];d.push(this.getRadius(e.zMin,e.zMax,g,k,p,c&&c[n]))}this.radii=d};h.prototype.getRadius=function(a,b,c,d,e,f){var g=
this.options,h="width"!==g.sizeBy,l=g.zThreshold,m=b-a,n=.5;if(null===f||null===e)return null;if(k(e)){g.sizeByAbsoluteValue&&(e=Math.abs(e-l),m=Math.max(b-l,Math.abs(a-l)),a=0);if(e<a)return c/2-1;0<m&&(n=(e-a)/m)}h&&0<=n&&(n=Math.sqrt(n));return Math.ceil(c+n*(d-c))/2};h.prototype.hasData=function(){return!!this.processedXData.length};h.prototype.pointAttribs=function(a,b){var c=this.options.marker.fillOpacity;a=l.prototype.pointAttribs.call(this,a,b);1!==c&&(a.fill=r(a.fill).setOpacity(c).get("rgba"));
return a};h.prototype.translate=function(){d.prototype.translate.call(this);this.getRadii();this.translateBubble()};h.prototype.translateBubble=function(){for(var a=this.data,b=this.radii,c=this.getPxExtremes().minPxSize,d=a.length;d--;){var e=a[d],f=b?b[d]:0;k(f)&&f>=c/2?(e.marker=t(e.marker,{radius:f,width:2*f,height:2*f}),e.dlBox={x:e.plotX-f,y:e.plotY-f,width:2*f,height:2*f}):(e.shapeArgs=e.plotY=e.dlBox=void 0,e.isInside=!1)}};h.prototype.getPxExtremes=function(){var a=Math.min(this.chart.plotWidth,
this.chart.plotHeight),b=function(b){if("string"===typeof b){var c=/%$/.test(b);b=parseInt(b,10)}return c?a*b/100:b},c=b(n(this.options.minSize,8));b=Math.max(b(n(this.options.maxSize,"20%")),c);return{minPxSize:c,maxPxSize:b}};h.prototype.getZExtremes=function(){var b=this.options,c=(this.zData||[]).filter(k);if(c.length){var d=n(b.zMin,u(e(c),!1===b.displayNegative?b.zThreshold||0:-Number.MAX_VALUE,Number.MAX_VALUE));b=n(b.zMax,a(c));if(k(d)&&k(b))return{zMin:d,zMax:b}}};h.defaultOptions=B(b.defaultOptions,
{dataLabels:{formatter:function(){var a=this.series.chart.numberFormatter,b=this.point.z;return k(b)?a(b,-1):""},inside:!0,verticalAlign:"middle"},animationLimit:250,marker:{lineColor:null,lineWidth:1,fillOpacity:.5,radius:null,states:{hover:{radiusPlus:0}},symbol:"circle"},minSize:8,maxSize:"20%",softThreshold:!1,states:{hover:{halo:{size:5}}},tooltip:{pointFormat:"({point.x}, {point.y}), Size: {point.z}"},turboThreshold:0,zThreshold:0,zoneAxis:"z"});return h}(b);t(d.prototype,{alignDataLabel:m.alignDataLabel,
applyZones:q,bubblePadding:!0,buildKDTree:q,directTouch:!0,isBubble:!0,pointArrayMap:["y","z"],pointClass:h,parallelArrays:["x","y","z"],trackerGroups:["group","dataLabelsGroup"],specialGroup:"group",zoneAxis:"z"});w(d,"updatedData",function(a){delete a.target.chart.bubbleZExtremes});w(d,"remove",function(a){delete a.target.chart.bubbleZExtremes});p.registerSeriesType("bubble",d);"";"";return d});y(c,"Series/MapBubble/MapBubblePoint.js",[c["Series/Bubble/BubblePoint.js"],c["Core/Series/SeriesRegistry.js"],
c["Core/Utilities.js"]],function(c,h,q){var m=this&&this.__extends||function(){var c=function(d,g){c=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(c,d){c.__proto__=d}||function(c,d){for(var g in d)d.hasOwnProperty(g)&&(c[g]=d[g])};return c(d,g)};return function(d,g){function h(){this.constructor=d}c(d,g);d.prototype=null===g?Object.create(g):(h.prototype=g.prototype,new h)}}();h=h.seriesTypes.map.prototype.pointClass.prototype;q=q.extend;c=function(c){function d(){return null!==
c&&c.apply(this,arguments)||this}m(d,c);d.prototype.isValid=function(){return"number"===typeof this.z};return d}(c);q(c.prototype,{applyOptions:h.applyOptions,getProjectedBounds:h.getProjectedBounds});return c});y(c,"Series/MapBubble/MapBubbleSeries.js",[c["Series/Bubble/BubbleSeries.js"],c["Series/MapBubble/MapBubblePoint.js"],c["Core/Series/SeriesRegistry.js"],c["Core/Utilities.js"]],function(c,h,q,m){var p=this&&this.__extends||function(){var c=function(d,b){c=Object.setPrototypeOf||{__proto__:[]}instanceof
Array&&function(a,b){a.__proto__=b}||function(a,b){for(var c in b)b.hasOwnProperty(c)&&(a[c]=b[c])};return c(d,b)};return function(d,b){function a(){this.constructor=d}c(d,b);d.prototype=null===b?Object.create(b):(a.prototype=b.prototype,new a)}}(),d=q.seriesTypes,g=d.map.prototype,x=d.mappoint.prototype;d=m.extend;var r=m.merge;m=function(d){function h(){var b=null!==d&&d.apply(this,arguments)||this;b.data=void 0;b.options=void 0;b.points=void 0;b.clearBounds=g.clearBounds;return b}p(h,d);h.prototype.searchPoint=
function(b,a){return this.searchKDTree({clientX:b.chartX-this.chart.plotLeft,plotY:b.chartY-this.chart.plotTop},a,b)};h.prototype.translate=function(){x.translate.call(this);this.getRadii();this.translateBubble()};h.defaultOptions=r(c.defaultOptions,{lineWidth:0,animationLimit:500,joinBy:"hc-key",tooltip:{pointFormat:"{point.name}: {point.z}"}});return h}(c);d(m.prototype,{type:"mapbubble",axisTypes:["colorAxis"],getProjectedBounds:g.getProjectedBounds,isCartesian:!1,pointArrayMap:["z"],pointClass:h,
processData:g.processData,projectPoint:x.projectPoint,setData:g.setData,setOptions:g.setOptions,updateData:g.updateData,useMapGeometry:!0,xyFromShape:!0});q.registerSeriesType("mapbubble",m);"";return m});y(c,"Series/Heatmap/HeatmapPoint.js",[c["Core/Series/SeriesRegistry.js"],c["Core/Utilities.js"]],function(c,h){var q=this&&this.__extends||function(){var c=function(d,g){c=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(c,b){c.__proto__=b}||function(c,b){for(var a in b)b.hasOwnProperty(a)&&
(c[a]=b[a])};return c(d,g)};return function(d,g){function h(){this.constructor=d}c(d,g);d.prototype=null===g?Object.create(g):(h.prototype=g.prototype,new h)}}(),m=h.clamp,p=h.defined,d=h.extend,g=h.pick;c=function(c){function d(){var d=null!==c&&c.apply(this,arguments)||this;d.options=void 0;d.series=void 0;d.value=void 0;d.x=void 0;d.y=void 0;return d}q(d,c);d.prototype.applyOptions=function(d,g){(this.isNull||null===this.value)&&delete this.color;c.prototype.applyOptions.call(this,d,g);this.formatPrefix=
this.isNull||null===this.value?"null":"point";return this};d.prototype.getCellAttributes=function(){var c=this.series,d=c.options,b=(d.colsize||1)/2,a=(d.rowsize||1)/2,e=c.xAxis,h=c.yAxis,q=this.options.marker||c.options.marker;c=c.pointPlacementToXValue();var k=g(this.pointPadding,d.pointPadding,0),r={x1:m(Math.round(e.len-e.translate(this.x-b,!1,!0,!1,!0,-c)),-e.len,2*e.len),x2:m(Math.round(e.len-e.translate(this.x+b,!1,!0,!1,!0,-c)),-e.len,2*e.len),y1:m(Math.round(h.translate(this.y-a,!1,!0,!1,
!0)),-h.len,2*h.len),y2:m(Math.round(h.translate(this.y+a,!1,!0,!1,!0)),-h.len,2*h.len)};[["width","x"],["height","y"]].forEach(function(a){var b=a[0];a=a[1];var c=a+"1",d=a+"2",e=Math.abs(r[c]-r[d]),g=q&&q.lineWidth||0,h=Math.abs(r[c]+r[d])/2;b=q&&q[b];p(b)&&b<e&&(b=b/2+g/2,r[c]=h-b,r[d]=h+b);k&&("y"===a&&(c=d,d=a+"1"),r[c]+=k,r[d]-=k)});return r};d.prototype.haloPath=function(c){if(!c)return[];var d=this.shapeArgs||{},b=d.x;b=void 0===b?0:b;var a=d.y;a=void 0===a?0:a;var e=d.width;e=void 0===e?
0:e;d=d.height;d=void 0===d?0:d;return[["M",b-c,a-c],["L",b-c,a+d+c],["L",b+e+c,a+d+c],["L",b+e+c,a-c],["Z"]]};d.prototype.isValid=function(){return Infinity!==this.value&&-Infinity!==this.value};return d}(c.seriesTypes.scatter.prototype.pointClass);d(c.prototype,{dataLabelOnNull:!0,moveToTopOnHover:!0,ttBelow:!1});return c});y(c,"Series/Heatmap/HeatmapSeries.js",[c["Core/Color/Color.js"],c["Series/ColorMapComposition.js"],c["Series/Heatmap/HeatmapPoint.js"],c["Core/Legend/LegendSymbol.js"],c["Core/Series/SeriesRegistry.js"],
c["Core/Renderer/SVG/SVGRenderer.js"],c["Core/Utilities.js"]],function(c,h,q,m,p,d,g){var x=this&&this.__extends||function(){var a=function(b,c){a=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(a,b){a.__proto__=b}||function(a,b){for(var c in b)b.hasOwnProperty(c)&&(a[c]=b[c])};return a(b,c)};return function(b,c){function d(){this.constructor=b}a(b,c);b.prototype=null===c?Object.create(c):(d.prototype=c.prototype,new d)}}(),r=p.series,l=p.seriesTypes,w=l.column,b=l.scatter,a=d.prototype.symbols;
d=g.extend;var e=g.fireEvent,u=g.isNumber,t=g.merge,k=g.pick;g=function(d){function g(){var a=null!==d&&d.apply(this,arguments)||this;a.colorAxis=void 0;a.data=void 0;a.options=void 0;a.points=void 0;a.valueMax=NaN;a.valueMin=NaN;return a}x(g,d);g.prototype.drawPoints=function(){var a=this;if((this.options.marker||{}).enabled||this._hasPointMarkers)r.prototype.drawPoints.call(this),this.points.forEach(function(b){b.graphic&&(b.graphic[a.chart.styledMode?"css":"animate"](a.colorAttribs(b)),null===
b.value&&b.graphic.addClass("highcharts-null-point"))})};g.prototype.getExtremes=function(){var a=r.prototype.getExtremes.call(this,this.valueData),b=a.dataMin;a=a.dataMax;u(b)&&(this.valueMin=b);u(a)&&(this.valueMax=a);return r.prototype.getExtremes.call(this)};g.prototype.getValidPoints=function(a,b){return r.prototype.getValidPoints.call(this,a,b,!0)};g.prototype.hasData=function(){return!!this.processedXData.length};g.prototype.init=function(){d.prototype.init.apply(this,arguments);var b=this.options;
b.pointRange=k(b.pointRange,b.colsize||1);this.yAxis.axisPointRange=b.rowsize||1;a.ellipse=a.circle;b.marker&&(b.marker.r=b.borderRadius)};g.prototype.markerAttribs=function(a,b){var c=a.shapeArgs||{};if(a.hasImage)return{x:a.plotX,y:a.plotY};if(b&&"normal"!==b){var d=a.options.marker||{};a=this.options.marker||{};a=a.states&&a.states[b]||{};d=d.states&&d.states[b]||{};b=(d.width||a.width||c.width||0)+(d.widthPlus||a.widthPlus||0);a=(d.height||a.height||c.height||0)+(d.heightPlus||a.heightPlus||0);
return{x:(c.x||0)+((c.width||0)-b)/2,y:(c.y||0)+((c.height||0)-a)/2,width:b,height:a}}return c};g.prototype.pointAttribs=function(a,b){var d=r.prototype.pointAttribs.call(this,a,b),e=this.options||{},f=this.chart.options.plotOptions||{},g=f.series||{},h=f.heatmap||{};f=a&&a.options.borderColor||e.borderColor||h.borderColor||g.borderColor;g=a&&a.options.borderWidth||e.borderWidth||h.borderWidth||g.borderWidth||d["stroke-width"];d.stroke=a&&a.marker&&a.marker.lineColor||e.marker&&e.marker.lineColor||
f||this.color;d["stroke-width"]=g;b&&"normal"!==b&&(a=t(e.states&&e.states[b],e.marker&&e.marker.states&&e.marker.states[b],a&&a.options.states&&a.options.states[b]||{}),d.fill=a.color||c.parse(d.fill).brighten(a.brightness||0).get(),d.stroke=a.lineColor||d.stroke);return d};g.prototype.translate=function(){var b=this.options,c=b.marker&&b.marker.symbol||"rect",d=a[c]?c:"rect",g=-1!==["circle","square"].indexOf(d);this.generatePoints();this.points.forEach(function(e){var f=e.getCellAttributes(),h=
Math.min(f.x1,f.x2),k=Math.min(f.y1,f.y2),l=Math.max(Math.abs(f.x2-f.x1),0),m=Math.max(Math.abs(f.y2-f.y1),0);e.hasImage=0===(e.marker&&e.marker.symbol||c||"").indexOf("url");g&&(k=Math.abs(l-m),h=Math.min(f.x1,f.x2)+(l<m?0:k/2),k=Math.min(f.y1,f.y2)+(l<m?k/2:0),l=m=Math.min(l,m));e.hasImage&&(e.marker={width:l,height:m});e.plotX=e.clientX=(f.x1+f.x2)/2;e.plotY=(f.y1+f.y2)/2;e.shapeType="path";e.shapeArgs=t(!0,{x:h,y:k,width:l,height:m},{d:a[d](h,k,l,m,{r:b.borderRadius})})});e(this,"afterTranslate")};
g.defaultOptions=t(b.defaultOptions,{animation:!1,borderRadius:0,borderWidth:0,nullColor:"#f7f7f7",dataLabels:{formatter:function(){var a=this.series.chart.numberFormatter,b=this.point.value;return u(b)?a(b,-1):""},inside:!0,verticalAlign:"middle",crop:!1,overflow:"allow",padding:0},marker:{symbol:"rect",radius:0,lineColor:void 0,states:{hover:{lineWidthPlus:0},select:{}}},clip:!0,pointRange:null,tooltip:{pointFormat:"{point.x}, {point.y}: {point.value}<br/>"},states:{hover:{halo:!1,brightness:.2}}});
return g}(b);d(g.prototype,{axisTypes:h.seriesMembers.axisTypes,colorKey:h.seriesMembers.colorKey,directTouch:!0,getExtremesFromAll:!0,parallelArrays:h.seriesMembers.parallelArrays,pointArrayMap:["y","value"],pointClass:q,specialGroup:"group",trackerGroups:h.seriesMembers.trackerGroups,alignDataLabel:w.prototype.alignDataLabel,colorAttribs:h.seriesMembers.colorAttribs,drawLegendSymbol:m.drawRectangle,getSymbol:r.prototype.getSymbol});h.compose(g);p.registerSeriesType("heatmap",g);"";"";return g});
y(c,"masters/modules/map.src.js",[c["Core/Globals.js"],c["Core/Axis/Color/ColorAxis.js"],c["Series/MapBubble/MapBubbleSeries.js"],c["Core/Chart/MapChart.js"],c["Maps/MapView.js"],c["Maps/Projection.js"]],function(c,h,q,m,p,d){c.ColorAxis=h;c.MapChart=m;c.mapChart=c.Map=m.mapChart;c.MapView=p;c.maps=m.maps;c.Projection=d;h.compose(c.Chart,c.Fx,c.Legend,c.Series);q.compose(c.Axis,c.Chart,c.Legend,c.Series)})});
//# sourceMappingURL=map.js.map