/*
 Highstock JS v10.3.3 (2023-01-20)

 All technical indicators for Highcharts Stock

 (c) 2010-2021 Pawel Fus

 License: www.highcharts.com/license
*/
(function(e){"object"===typeof module&&module.exports?(e["default"]=e,module.exports=e):"function"===typeof define&&define.amd?define("highcharts/indicators/indicators-all",["highcharts","highcharts/modules/stock"],function(u){e(u);e.Highcharts=u;return e}):e("undefined"!==typeof Highcharts?Highcharts:void 0)})(function(e){function u(e,f,g,k){e.hasOwnProperty(f)||(e[f]=k.apply(null,g),"function"===typeof CustomEvent&&window.dispatchEvent(new CustomEvent("HighchartsModuleLoaded",{detail:{path:f,module:e[f]}})))}
e=e?e._modules:{};u(e,"Stock/Indicators/SMA/SMAIndicator.js",[e["Core/Chart/Chart.js"],e["Core/Series/SeriesRegistry.js"],e["Core/Utilities.js"]],function(e,f,g){var k=this&&this.__extends||function(){var c=function(a,b){c=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(c,a){c.__proto__=a}||function(c,a){for(var b in a)a.hasOwnProperty(b)&&(c[b]=a[b])};return c(a,b)};return function(a,b){function n(){this.constructor=a}c(a,b);a.prototype=null===b?Object.create(b):(n.prototype=b.prototype,
new n)}}(),l=f.seriesTypes.line,q=g.addEvent,m=g.error,h=g.extend,d=g.isArray,a=g.merge,b=g.pick,c=g.splat;g=function(n){function v(){var c=null!==n&&n.apply(this,arguments)||this;c.data=void 0;c.dataEventsToUnbind=void 0;c.linkedParent=void 0;c.options=void 0;c.points=void 0;return c}k(v,n);v.prototype.destroy=function(){this.dataEventsToUnbind.forEach(function(c){c()});n.prototype.destroy.apply(this,arguments)};v.prototype.getName=function(){var c=[],a=this.name;a||((this.nameComponents||[]).forEach(function(a,
n){c.push(this.options.params[a]+b(this.nameSuffixes[n],""))},this),a=(this.nameBase||this.type.toUpperCase())+(this.nameComponents?" ("+c.join(", ")+")":""));return a};v.prototype.getValues=function(c,a){var b=a.period,n=c.xData;c=c.yData;var v=c.length,B=[],x=[],h=[],f=-1,g=0,e=0;if(!(n.length<b)){for(d(c[0])&&(f=a.index?a.index:0);g<b-1;)e+=0>f?c[g]:c[g][f],g++;for(a=g;a<v;a++){e+=0>f?c[a]:c[a][f];var m=[n[a],e/b];B.push(m);x.push(m[0]);h.push(m[1]);e-=0>f?c[a-g]:c[a-g][f]}return{values:B,xData:x,
yData:h}}};v.prototype.init=function(c,a){var b=this;n.prototype.init.call(b,c,a);a=q(e,"afterLinkSeries",function(){var a=!!b.dataEventsToUnbind.length;if(b.linkedParent)if(a||(b.dataEventsToUnbind.push(q(b.linkedParent,"updatedData",function(){b.recalculateValues()})),b.calculateOn.xAxis&&b.dataEventsToUnbind.push(q(b.linkedParent.xAxis,b.calculateOn.xAxis,function(){b.recalculateValues()}))),"init"===b.calculateOn.chart)b.processedYData||b.recalculateValues();else{if(!a)var n=q(b.chart,b.calculateOn.chart,
function(){b.recalculateValues();n()})}else return m("Series "+b.options.linkedTo+" not found! Check `linkedTo`.",!1,c)},{order:0});b.dataEventsToUnbind=[];b.eventsToUnbind.push(a)};v.prototype.recalculateValues=function(){var a=[],b=this.points||[],n=(this.xData||[]).length,d={values:[],xData:[],yData:[]},v=!0;d=this.linkedParent.options&&this.linkedParent.yData&&this.linkedParent.yData.length?this.getValues(this.linkedParent,this.options.params)||d:d;if(n&&!this.hasGroupedData&&this.visible&&this.points)if(this.cropped){if(this.xAxis){var h=
this.xAxis.min;var w=this.xAxis.max}n=this.cropData(d.xData,d.yData,h,w);for(h=0;h<n.xData.length;h++)a.push([n.xData[h]].concat(c(n.yData[h])));n=d.xData.indexOf(this.xData[0]);h=d.xData.indexOf(this.xData[this.xData.length-1]);-1===n&&h===d.xData.length-2&&a[0][0]===b[0].x&&a.shift();this.updateData(a)}else d.xData.length!==n-1&&d.xData.length!==n+1&&(v=!1,this.updateData(d.values));v&&(this.xData=d.xData,this.yData=d.yData,this.options.data=d.values);this.calculateOn.xAxis&&this.processedXData&&
(delete this.processedXData,this.isDirty=!0,this.redraw());this.isDirtyData=!!this.linkedSeries};v.prototype.processData=function(){var c=this.options.compareToMain,a=this.linkedParent;n.prototype.processData.apply(this,arguments);this.dataModify&&a&&a.dataModify&&a.dataModify.compareValue&&c&&(this.dataModify.compareValue=a.dataModify.compareValue)};v.defaultOptions=a(l.defaultOptions,{name:void 0,tooltip:{valueDecimals:4},linkedTo:void 0,compareToMain:!1,params:{index:3,period:14}});return v}(l);
h(g.prototype,{calculateOn:{chart:"init"},hasDerivedData:!0,nameComponents:["period"],nameSuffixes:[],useCommonDataGrouping:!0});f.registerSeriesType("sma",g);"";return g});u(e,"Stock/Indicators/EMA/EMAIndicator.js",[e["Core/Series/SeriesRegistry.js"],e["Core/Utilities.js"]],function(e,f){var g=this&&this.__extends||function(){var h=function(d,a){h=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(a,c){a.__proto__=c}||function(a,c){for(var b in c)c.hasOwnProperty(b)&&(a[b]=c[b])};return h(d,
a)};return function(d,a){function b(){this.constructor=d}h(d,a);d.prototype=null===a?Object.create(a):(b.prototype=a.prototype,new b)}}(),k=e.seriesTypes.sma,l=f.correctFloat,q=f.isArray,m=f.merge;f=function(h){function d(){var a=null!==h&&h.apply(this,arguments)||this;a.data=void 0;a.options=void 0;a.points=void 0;return a}g(d,h);d.prototype.accumulatePeriodPoints=function(a,b,c){for(var n=0,d=0,h;d<a;)h=0>b?c[d]:c[d][b],n+=h,d++;return n};d.prototype.calculateEma=function(a,b,c,n,d,h,x){a=a[c-1];
b=0>h?b[c-1]:b[c-1][h];n="undefined"===typeof d?x:l(b*n+d*(1-n));return[a,n]};d.prototype.getValues=function(a,b){var c=b.period,n=a.xData,d=(a=a.yData)?a.length:0,h=2/(c+1),x=[],f=[],g=[],t=-1;if(!(d<c)){q(a[0])&&(t=b.index?b.index:0);b=this.accumulatePeriodPoints(c,t,a);for(b/=c;c<d+1;c++){var p=this.calculateEma(n,a,c,h,p,t,b);x.push(p);f.push(p[0]);g.push(p[1]);p=p[1]}return{values:x,xData:f,yData:g}}};d.defaultOptions=m(k.defaultOptions,{params:{index:3,period:9}});return d}(k);e.registerSeriesType("ema",
f);"";return f});u(e,"Stock/Indicators/AD/ADIndicator.js",[e["Core/Series/SeriesRegistry.js"],e["Core/Utilities.js"]],function(e,f){var g=this&&this.__extends||function(){var h=function(d,a){h=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(a,c){a.__proto__=c}||function(a,c){for(var b in c)c.hasOwnProperty(b)&&(a[b]=c[b])};return h(d,a)};return function(d,a){function b(){this.constructor=d}h(d,a);d.prototype=null===a?Object.create(a):(b.prototype=a.prototype,new b)}}(),k=e.seriesTypes.sma,
l=f.error,q=f.extend,m=f.merge;f=function(h){function d(){var a=null!==h&&h.apply(this,arguments)||this;a.data=void 0;a.options=void 0;a.points=void 0;return a}g(d,h);d.populateAverage=function(a,b,c,n,d){d=b[n][1];var v=b[n][2];b=b[n][3];c=c[n];return[a[n],b===d&&b===v||d===v?0:(2*b-v-d)/(d-v)*c]};d.prototype.getValues=function(a,b){var c=b.period,n=a.xData,v=a.yData,h=b.volumeSeriesID,x=a.chart.get(h);b=x&&x.yData;var f=v?v.length:0,g=[],t=[],p=[];if(!(n.length<=c&&f&&4!==v[0].length)){if(x){for(h=
c;h<f;h++)a=g.length,x=d.populateAverage(n,v,b,h,c),0<a&&(x[1]+=g[a-1][1]),g.push(x),t.push(x[0]),p.push(x[1]);return{values:g,xData:t,yData:p}}l("Series "+h+" not found! Check `volumeSeriesID`.",!0,a.chart)}};d.defaultOptions=m(k.defaultOptions,{params:{index:void 0,volumeSeriesID:"volume"}});return d}(k);q(f.prototype,{nameComponents:!1,nameBase:"Accumulation/Distribution"});e.registerSeriesType("ad",f);"";return f});u(e,"Stock/Indicators/AO/AOIndicator.js",[e["Core/Globals.js"],e["Core/Series/SeriesRegistry.js"],
e["Core/Utilities.js"]],function(e,f,g){var k=this&&this.__extends||function(){var a=function(c,b){a=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(a,c){a.__proto__=c}||function(a,c){for(var b in c)c.hasOwnProperty(b)&&(a[b]=c[b])};return a(c,b)};return function(c,b){function n(){this.constructor=c}a(c,b);c.prototype=null===b?Object.create(b):(n.prototype=b.prototype,new n)}}();e=e.noop;var l=f.seriesTypes,q=l.column.prototype,m=l.sma;l=g.extend;var h=g.merge,d=g.correctFloat,a=g.isArray;
g=function(b){function c(){var a=null!==b&&b.apply(this,arguments)||this;a.data=void 0;a.options=void 0;a.points=void 0;return a}k(c,b);c.prototype.drawGraph=function(){var a=this.options,c=this.points,b=a.greaterBarColor;a=a.lowerBarColor;var d=c[0];if(!this.userOptions.color&&d)for(d.color=b,d=1;d<c.length;d++)c[d].color=c[d].y>c[d-1].y?b:c[d].y<c[d-1].y?a:c[d-1].color};c.prototype.getValues=function(c){var b=c.xData||[];c=c.yData||[];var n=c.length,h=[],f=[],g=[],t=0,p=0,w;if(!(34>=b.length)&&
a(c[0])&&4===c[0].length){for(w=0;33>w;w++){var r=(c[w][1]+c[w][2])/2;29<=w&&(t=d(t+r));p=d(p+r)}for(w=33;w<n;w++){r=(c[w][1]+c[w][2])/2;t=d(t+r);p=d(p+r);r=t/5;var A=p/34;r=d(r-A);h.push([b[w],r]);f.push(b[w]);g.push(r);r=w+1-5;A=w+1-34;t=d(t-(c[r][1]+c[r][2])/2);p=d(p-(c[A][1]+c[A][2])/2)}return{values:h,xData:f,yData:g}}};c.defaultOptions=h(m.defaultOptions,{params:{index:void 0,period:void 0},greaterBarColor:"#06b535",lowerBarColor:"#f21313",threshold:0,groupPadding:.2,pointPadding:.2,crisp:!1,
states:{hover:{halo:{size:0}}}});return c}(m);l(g.prototype,{nameBase:"AO",nameComponents:!1,markerAttribs:e,getColumnMetrics:q.getColumnMetrics,crispCol:q.crispCol,translate:q.translate,drawPoints:q.drawPoints});f.registerSeriesType("ao",g);"";return g});u(e,"Stock/Indicators/MultipleLinesComposition.js",[e["Core/Series/SeriesRegistry.js"],e["Core/Utilities.js"]],function(e,f){var g=e.seriesTypes.sma.prototype,k=f.defined,l=f.error,q=f.merge,m;(function(h){function d(c){return"plot"+c.charAt(0).toUpperCase()+
c.slice(1)}function a(c,a){var b=[];(c.pointArrayMap||[]).forEach(function(c){c!==a&&b.push(d(c))});return b}function b(){var c=this,b=c.linesApiNames,n=c.areaLinesNames,v=c.points,h=c.options,f=c.graph,B={options:{gapSize:h.gapSize}},x=[],y=a(c,c.pointValKey),e=v.length,O;y.forEach(function(c,a){for(x[a]=[];e--;)O=v[e],x[a].push({x:O.x,plotX:O.plotX,plotY:O[c],isNull:!k(O[c])});e=v.length});if(c.userOptions.fillColor&&n.length){var m=y.indexOf(d(n[0]));m=x[m];n=1===n.length?v:x[y.indexOf(d(n[1]))];
y=c.color;c.points=n;c.nextPoints=m;c.color=c.userOptions.fillColor;c.options=q(v,B);c.graph=c.area;c.fillGraph=!0;g.drawGraph.call(c);c.area=c.graph;delete c.nextPoints;delete c.fillGraph;c.color=y}b.forEach(function(a,b){x[b]?(c.points=x[b],h[a]?c.options=q(h[a].styles,B):l('Error: "There is no '+a+' in DOCS options declared. Check if linesApiNames are consistent with your DOCS line names."'),c.graph=c["graph"+a],g.drawGraph.call(c),c["graph"+a]=c.graph):l('Error: "'+a+" doesn't have equivalent in pointArrayMap. To many elements in linesApiNames relative to pointArrayMap.\"")});
c.points=v;c.options=h;c.graph=f;g.drawGraph.call(c)}function c(c){var a,b=[];c=c||this.points;if(this.fillGraph&&this.nextPoints){if((a=g.getGraphPath.call(this,this.nextPoints))&&a.length){a[0][0]="L";b=g.getGraphPath.call(this,c);a=a.slice(0,b.length);for(var n=a.length-1;0<=n;n--)b.push(a[n])}}else b=g.getGraphPath.apply(this,arguments);return b}function n(c){var a=[];(this.pointArrayMap||[]).forEach(function(b){a.push(c[b])});return a}function v(){var c=this,b=this.pointArrayMap,n=[],d;n=a(this);
g.translate.apply(this,arguments);this.points.forEach(function(a){b.forEach(function(b,v){d=a[b];c.dataModify&&(d=c.dataModify.modifyValue(d));null!==d&&(a[n[v]]=c.yAxis.toPixels(d,!0))})})}var f=[],x=["bottomLine"],y=["top","bottom"],e=["top"];h.compose=function(a){if(-1===f.indexOf(a)){f.push(a);var d=a.prototype;d.linesApiNames=d.linesApiNames||x.slice();d.pointArrayMap=d.pointArrayMap||y.slice();d.pointValKey=d.pointValKey||"top";d.areaLinesNames=d.areaLinesNames||e.slice();d.drawGraph=b;d.getGraphPath=
c;d.toYData=n;d.translate=v}return a}})(m||(m={}));return m});u(e,"Stock/Indicators/Aroon/AroonIndicator.js",[e["Stock/Indicators/MultipleLinesComposition.js"],e["Core/Series/SeriesRegistry.js"],e["Core/Utilities.js"]],function(e,f,g){function k(a,b){var c=a[0],n=0,d;for(d=1;d<a.length;d++)if("max"===b&&a[d]>=c||"min"===b&&a[d]<=c)c=a[d],n=d;return n}var l=this&&this.__extends||function(){var a=function(b,c){a=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(c,a){c.__proto__=a}||function(c,
a){for(var b in a)a.hasOwnProperty(b)&&(c[b]=a[b])};return a(b,c)};return function(b,c){function n(){this.constructor=b}a(b,c);b.prototype=null===c?Object.create(c):(n.prototype=c.prototype,new n)}}(),q=f.seriesTypes.sma,m=g.extend,h=g.merge,d=g.pick;g=function(a){function b(){var c=null!==a&&a.apply(this,arguments)||this;c.data=void 0;c.options=void 0;c.points=void 0;return c}l(b,a);b.prototype.getValues=function(c,a){a=a.period;var b=c.xData,n=(c=c.yData)?c.length:0,h=[],f=[],g=[],t;for(t=a-1;t<
n;t++){var p=c.slice(t-a+1,t+2);var w=k(p.map(function(c){return d(c[2],c)}),"min");p=k(p.map(function(c){return d(c[1],c)}),"max");p=p/a*100;w=w/a*100;b[t+1]&&(h.push([b[t+1],p,w]),f.push(b[t+1]),g.push([p,w]))}return{values:h,xData:f,yData:g}};b.defaultOptions=h(q.defaultOptions,{params:{index:void 0,period:25},marker:{enabled:!1},tooltip:{pointFormat:'<span style="color:{point.color}">\u25cf</span><b> {series.name}</b><br/>Aroon Up: {point.y}<br/>Aroon Down: {point.aroonDown}<br/>'},aroonDown:{styles:{lineWidth:1,
lineColor:void 0}},dataGrouping:{approximation:"averages"}});return b}(q);m(g.prototype,{areaLinesNames:[],linesApiNames:["aroonDown"],nameBase:"Aroon",pointArrayMap:["y","aroonDown"],pointValKey:"y"});e.compose(g);f.registerSeriesType("aroon",g);"";return g});u(e,"Stock/Indicators/AroonOscillator/AroonOscillatorIndicator.js",[e["Stock/Indicators/MultipleLinesComposition.js"],e["Core/Series/SeriesRegistry.js"],e["Core/Utilities.js"]],function(e,f,g){var k=this&&this.__extends||function(){var h=function(d,
a){h=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(a,c){a.__proto__=c}||function(a,c){for(var b in c)c.hasOwnProperty(b)&&(a[b]=c[b])};return h(d,a)};return function(d,a){function b(){this.constructor=d}h(d,a);d.prototype=null===a?Object.create(a):(b.prototype=a.prototype,new b)}}(),l=f.seriesTypes.aroon,q=g.extend,m=g.merge;g=function(h){function d(){var a=null!==h&&h.apply(this,arguments)||this;a.data=void 0;a.options=void 0;a.points=void 0;return a}k(d,h);d.prototype.getValues=
function(a,b){var c=[],n=[],d=[];a=h.prototype.getValues.call(this,a,b);for(b=0;b<a.yData.length;b++){var f=a.yData[b][0];var x=a.yData[b][1];f-=x;c.push([a.xData[b],f]);n.push(a.xData[b]);d.push(f)}return{values:c,xData:n,yData:d}};d.defaultOptions=m(l.defaultOptions,{tooltip:{pointFormat:'<span style="color:{point.color}">\u25cf</span><b> {series.name}</b>: {point.y}'}});return d}(l);q(g.prototype,{nameBase:"Aroon Oscillator",linesApiNames:[],pointArrayMap:["y"],pointValKey:"y"});e.compose(l);f.registerSeriesType("aroonoscillator",
g);"";return g});u(e,"Stock/Indicators/ATR/ATRIndicator.js",[e["Core/Series/SeriesRegistry.js"],e["Core/Utilities.js"]],function(e,f){function g(h,d){return Math.max(h[1]-h[2],"undefined"===typeof d?0:Math.abs(h[1]-d[3]),"undefined"===typeof d?0:Math.abs(h[2]-d[3]))}var k=this&&this.__extends||function(){var h=function(d,a){h=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(a,c){a.__proto__=c}||function(a,c){for(var b in c)c.hasOwnProperty(b)&&(a[b]=c[b])};return h(d,a)};return function(d,
a){function b(){this.constructor=d}h(d,a);d.prototype=null===a?Object.create(a):(b.prototype=a.prototype,new b)}}(),l=e.seriesTypes.sma,q=f.isArray,m=f.merge;f=function(h){function d(){var a=null!==h&&h.apply(this,arguments)||this;a.data=void 0;a.points=void 0;a.options=void 0;return a}k(d,h);d.prototype.getValues=function(a,b){b=b.period;var c=a.xData,n=(a=a.yData)?a.length:0,d=1,h=0,f=0,y=[],e=[],t=[],p;var w=[[c[0],a[0]]];if(!(c.length<=b)&&q(a[0])&&4===a[0].length){for(p=1;p<=n;p++)if(w.push([c[p],
a[p]]),b<d){var r=b;var A=c[p-1],m=g(a[p-1],a[p-2]);r=[A,(h*(r-1)+m)/r];h=r[1];y.push(r);e.push(r[0]);t.push(r[1])}else b===d?(h=f/(p-1),y.push([c[p-1],h]),e.push(c[p-1]),t.push(h)):f+=g(a[p-1],a[p-2]),d++;return{values:y,xData:e,yData:t}}};d.defaultOptions=m(l.defaultOptions,{params:{index:void 0}});return d}(l);e.registerSeriesType("atr",f);"";return f});u(e,"Stock/Indicators/BB/BBIndicator.js",[e["Stock/Indicators/MultipleLinesComposition.js"],e["Core/Series/SeriesRegistry.js"],e["Core/Utilities.js"]],
function(e,f,g){var k=this&&this.__extends||function(){var d=function(a,b){d=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(c,a){c.__proto__=a}||function(c,a){for(var b in a)a.hasOwnProperty(b)&&(c[b]=a[b])};return d(a,b)};return function(a,b){function c(){this.constructor=a}d(a,b);a.prototype=null===b?Object.create(b):(c.prototype=b.prototype,new c)}}(),l=f.seriesTypes.sma,q=g.extend,m=g.isArray,h=g.merge;g=function(d){function a(){var a=null!==d&&d.apply(this,arguments)||this;a.data=
void 0;a.options=void 0;a.points=void 0;return a}k(a,d);a.prototype.init=function(){f.seriesTypes.sma.prototype.init.apply(this,arguments);this.options=h({topLine:{styles:{lineColor:this.color}},bottomLine:{styles:{lineColor:this.color}}},this.options)};a.prototype.getValues=function(a,c){var b=c.period,d=c.standardDeviation,h=a.xData,x=(a=a.yData)?a.length:0,y=[],g=[],t=[],p;if(!(h.length<b)){var w=m(a[0]);for(p=b;p<=x;p++){var r=h.slice(p-b,p);var A=a.slice(p-b,p);var e=f.seriesTypes.sma.prototype.getValues.call(this,
{xData:r,yData:A},c);r=e.xData[0];e=e.yData[0];for(var k=0,l=A.length,q=0;q<l;q++){var z=(w?A[q][c.index]:A[q])-e;k+=z*z}z=Math.sqrt(k/(l-1));A=e+d*z;z=e-d*z;y.push([r,A,e,z]);g.push(r);t.push([A,e,z])}return{values:y,xData:g,yData:t}}};a.defaultOptions=h(l.defaultOptions,{params:{period:20,standardDeviation:2,index:3},bottomLine:{styles:{lineWidth:1,lineColor:void 0}},topLine:{styles:{lineWidth:1,lineColor:void 0}},tooltip:{pointFormat:'<span style="color:{point.color}">\u25cf</span><b> {series.name}</b><br/>Top: {point.top}<br/>Middle: {point.middle}<br/>Bottom: {point.bottom}<br/>'},
marker:{enabled:!1},dataGrouping:{approximation:"averages"}});return a}(l);q(g.prototype,{areaLinesNames:["top","bottom"],linesApiNames:["topLine","bottomLine"],nameComponents:["period","standardDeviation"],pointArrayMap:["top","middle","bottom"],pointValKey:"middle"});e.compose(g);f.registerSeriesType("bb",g);"";return g});u(e,"Stock/Indicators/CCI/CCIIndicator.js",[e["Core/Series/SeriesRegistry.js"],e["Core/Utilities.js"]],function(e,f){function g(h){return h.reduce(function(d,a){return d+a},0)}
var k=this&&this.__extends||function(){var h=function(d,a){h=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(a,c){a.__proto__=c}||function(a,c){for(var b in c)c.hasOwnProperty(b)&&(a[b]=c[b])};return h(d,a)};return function(d,a){function b(){this.constructor=d}h(d,a);d.prototype=null===a?Object.create(a):(b.prototype=a.prototype,new b)}}(),l=e.seriesTypes.sma,q=f.isArray,m=f.merge;f=function(h){function d(){var a=null!==h&&h.apply(this,arguments)||this;a.data=void 0;a.points=void 0;
a.options=void 0;return a}k(d,h);d.prototype.getValues=function(a,b){b=b.period;var c=a.xData,n=(a=a.yData)?a.length:0,d=[],h=[],f=[],y=[],e=1;if(!(c.length<=b)&&q(a[0])&&4===a[0].length){for(;e<b;){var t=a[e-1];d.push((t[1]+t[2]+t[3])/3);e++}for(e=b;e<=n;e++){t=a[e-1];t=(t[1]+t[2]+t[3])/3;var p=d.push(t);var w=d.slice(p-b);p=g(w)/b;var r,A=w.length,m=0;for(r=0;r<A;r++)m+=Math.abs(p-w[r]);w=m/b;t=(t-p)/(.015*w);h.push([c[e-1],t]);f.push(c[e-1]);y.push(t)}return{values:h,xData:f,yData:y}}};d.defaultOptions=
m(l.defaultOptions,{params:{index:void 0}});return d}(l);e.registerSeriesType("cci",f);"";return f});u(e,"Stock/Indicators/CMF/CMFIndicator.js",[e["Core/Series/SeriesRegistry.js"],e["Core/Utilities.js"]],function(e,f){var g=this&&this.__extends||function(){var f=function(e,h){f=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(d,a){d.__proto__=a}||function(d,a){for(var b in a)a.hasOwnProperty(b)&&(d[b]=a[b])};return f(e,h)};return function(e,h){function d(){this.constructor=e}f(e,h);
e.prototype=null===h?Object.create(h):(d.prototype=h.prototype,new d)}}(),k=e.seriesTypes.sma,l=f.merge;f=function(f){function e(){var h=null!==f&&f.apply(this,arguments)||this;h.data=void 0;h.options=void 0;h.points=void 0;h.volumeSeries=void 0;h.linkedParent=void 0;h.yData=void 0;h.nameBase="Chaikin Money Flow";return h}g(e,f);e.prototype.isValid=function(){var h=this.chart,d=this.options,a=this.linkedParent;h=this.volumeSeries||(this.volumeSeries=h.get(d.params.volumeSeriesID));var b=a&&a.yData&&
4===a.yData[0].length;return!!(a&&h&&a.xData&&a.xData.length>=d.params.period&&h.xData&&h.xData.length>=d.params.period&&b)};e.prototype.getValues=function(h,d){if(this.isValid())return this.getMoneyFlow(h.xData,h.yData,this.volumeSeries.yData,d.period)};e.prototype.getMoneyFlow=function(h,d,a,b){function c(a,c){var b=a[1],n=a[2];a=a[3];return null!==c&&null!==b&&null!==n&&null!==a&&b!==n?(a-n-(b-a))/(b-n)*c:(w=p,null)}var n=d.length,v=[],f=0,x=0,y=[],e=[],t=[],p,w=-1;if(0<b&&b<=n){for(p=0;p<b;p++)v[p]=
c(d[p],a[p]),f+=a[p],x+=v[p];y.push(h[p-1]);e.push(p-w>=b&&0!==f?x/f:null);for(t.push([y[0],e[0]]);p<n;p++){v[p]=c(d[p],a[p]);f-=a[p-b];f+=a[p];x-=v[p-b];x+=v[p];var r=[h[p],p-w>=b?x/f:null];y.push(r[0]);e.push(r[1]);t.push([r[0],r[1]])}}return{values:t,xData:y,yData:e}};e.defaultOptions=l(k.defaultOptions,{params:{index:void 0,volumeSeriesID:"volume"}});return e}(k);e.registerSeriesType("cmf",f);"";return f});u(e,"Stock/Indicators/DMI/DMIIndicator.js",[e["Stock/Indicators/MultipleLinesComposition.js"],
e["Core/Series/SeriesRegistry.js"],e["Core/Utilities.js"]],function(e,f,g){var k=this&&this.__extends||function(){var a=function(b,c){a=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(a,c){a.__proto__=c}||function(a,c){for(var b in c)c.hasOwnProperty(b)&&(a[b]=c[b])};return a(b,c)};return function(b,c){function n(){this.constructor=b}a(b,c);b.prototype=null===c?Object.create(c):(n.prototype=c.prototype,new n)}}(),l=f.seriesTypes.sma,q=g.correctFloat,m=g.extend,h=g.isArray,d=g.merge;
g=function(a){function b(){var c=null!==a&&a.apply(this,arguments)||this;c.options=void 0;return c}k(b,a);b.prototype.calculateDM=function(a,b,d){var c=a[b][1],n=a[b][2],v=a[b-1][1];a=a[b-1][2];return q(c-v>a-n?d?Math.max(c-v,0):0:d?0:Math.max(a-n,0))};b.prototype.calculateDI=function(a,b){return a/b*100};b.prototype.calculateDX=function(a,b){return q(Math.abs(a-b)/Math.abs(a+b)*100)};b.prototype.smoothValues=function(a,b,d){return q(a-a/d+b)};b.prototype.getTR=function(a,b){return q(Math.max(a[1]-
a[2],b?Math.abs(a[1]-b[3]):0,b?Math.abs(a[2]-b[3]):0))};b.prototype.getValues=function(a,b){b=b.period;var c=a.xData,n=(a=a.yData)?a.length:0,d=[],f=[],e=[];if(!(c.length<=b)&&h(a[0])&&4===a[0].length){var t=0,p=0,w=0,r;for(r=1;r<n;r++)if(r<=b){var g=this.calculateDM(a,r,!0);var m=this.calculateDM(a,r);var k=this.getTR(a[r],a[r-1]);t+=g;p+=m;w+=k;r===b&&(k=this.calculateDI(t,w),m=this.calculateDI(p,w),g=this.calculateDX(t,p),d.push([c[r],g,k,m]),f.push(c[r]),e.push([g,k,m]))}else g=this.calculateDM(a,
r,!0),m=this.calculateDM(a,r),k=this.getTR(a[r],a[r-1]),t=this.smoothValues(t,g,b),p=this.smoothValues(p,m,b),w=this.smoothValues(w,k,b),k=this.calculateDI(t,w),m=this.calculateDI(p,w),g=this.calculateDX(t,p),d.push([c[r],g,k,m]),f.push(c[r]),e.push([g,k,m]);return{values:d,xData:f,yData:e}}};b.defaultOptions=d(l.defaultOptions,{params:{index:void 0},marker:{enabled:!1},tooltip:{pointFormat:'<span style="color: {point.color}">\u25cf</span><b> {series.name}</b><br/><span style="color: {point.color}">DX</span>: {point.y}<br/><span style="color: {point.series.options.plusDILine.styles.lineColor}">+DI</span>: {point.plusDI}<br/><span style="color: {point.series.options.minusDILine.styles.lineColor}">-DI</span>: {point.minusDI}<br/>'},
plusDILine:{styles:{lineWidth:1,lineColor:"#06b535"}},minusDILine:{styles:{lineWidth:1,lineColor:"#f21313"}},dataGrouping:{approximation:"averages"}});return b}(l);m(g.prototype,{areaLinesNames:[],nameBase:"DMI",linesApiNames:["plusDILine","minusDILine"],pointArrayMap:["y","plusDI","minusDI"],parallelArrays:["x","y","plusDI","minusDI"],pointValKey:"y"});e.compose(g);f.registerSeriesType("dmi",g);"";return g});u(e,"Stock/Indicators/DPO/DPOIndicator.js",[e["Core/Series/SeriesRegistry.js"],e["Core/Utilities.js"]],
function(e,f){function g(a,b,c,n,v){b=d(b[c][n],b[c]);return v?h(a-b):h(a+b)}var k=this&&this.__extends||function(){var a=function(b,c){a=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(a,c){a.__proto__=c}||function(a,c){for(var b in c)c.hasOwnProperty(b)&&(a[b]=c[b])};return a(b,c)};return function(b,c){function n(){this.constructor=b}a(b,c);b.prototype=null===c?Object.create(c):(n.prototype=c.prototype,new n)}}(),l=e.seriesTypes.sma,q=f.extend,m=f.merge,h=f.correctFloat,d=f.pick;
f=function(a){function b(){var c=null!==a&&a.apply(this,arguments)||this;c.options=void 0;c.data=void 0;c.points=void 0;return c}k(b,a);b.prototype.getValues=function(a,b){var c=b.period;b=b.index;var n=c+Math.floor(c/2+1),h=a.xData||[];a=a.yData||[];var f=a.length,e=[],t=[],p=[],w,r,A=0;if(!(h.length<=n)){for(w=0;w<c-1;w++)A=g(A,a,w,b);for(r=0;r<=f-n;r++){var m=r+c-1;w=r+n-1;A=g(A,a,m,b);m=d(a[w][b],a[w]);m-=A/c;A=g(A,a,r,b,!0);e.push([h[w],m]);t.push(h[w]);p.push(m)}return{values:e,xData:t,yData:p}}};
b.defaultOptions=m(l.defaultOptions,{params:{index:0,period:21}});return b}(l);q(f.prototype,{nameBase:"DPO"});e.registerSeriesType("dpo",f);"";return f});u(e,"Stock/Indicators/Chaikin/ChaikinIndicator.js",[e["Stock/Indicators/AD/ADIndicator.js"],e["Core/Series/SeriesRegistry.js"],e["Core/Utilities.js"]],function(e,f,g){var k=this&&this.__extends||function(){var a=function(b,c){a=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(a,c){a.__proto__=c}||function(a,c){for(var b in c)c.hasOwnProperty(b)&&
(a[b]=c[b])};return a(b,c)};return function(b,c){function n(){this.constructor=b}a(b,c);b.prototype=null===c?Object.create(c):(n.prototype=c.prototype,new n)}}(),l=f.seriesTypes.ema,q=g.correctFloat,m=g.extend,h=g.merge,d=g.error;g=function(a){function b(){var c=null!==a&&a.apply(this,arguments)||this;c.data=void 0;c.options=void 0;c.points=void 0;return c}k(b,a);b.prototype.getValues=function(a,b){var c=b.periods,n=b.period,h=[],f=[],g=[],t;if(2!==c.length||c[1]<=c[0])d('Error: "Chaikin requires two periods. Notice, first period should be lower than the second one."');
else if(b=e.prototype.getValues.call(this,a,{volumeSeriesID:b.volumeSeriesID,period:n}))if(a=l.prototype.getValues.call(this,b,{period:c[0]}),b=l.prototype.getValues.call(this,b,{period:c[1]}),a&&b){c=c[1]-c[0];for(t=0;t<b.yData.length;t++)n=q(a.yData[t+c]-b.yData[t]),h.push([b.xData[t],n]),f.push(b.xData[t]),g.push(n);return{values:h,xData:f,yData:g}}};b.defaultOptions=h(l.defaultOptions,{params:{index:void 0,volumeSeriesID:"volume",period:9,periods:[3,10]}});return b}(l);m(g.prototype,{nameBase:"Chaikin Osc",
nameComponents:["periods"]});f.registerSeriesType("chaikin",g);"";return g});u(e,"Stock/Indicators/CMO/CMOIndicator.js",[e["Core/Series/SeriesRegistry.js"],e["Core/Utilities.js"]],function(e,f){var g=this&&this.__extends||function(){var f=function(h,d){f=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(a,b){a.__proto__=b}||function(a,b){for(var c in b)b.hasOwnProperty(c)&&(a[c]=b[c])};return f(h,d)};return function(h,d){function a(){this.constructor=h}f(h,d);h.prototype=null===d?Object.create(d):
(a.prototype=d.prototype,new a)}}(),k=e.seriesTypes.sma,l=f.isNumber,q=f.merge;f=function(f){function h(){var d=null!==f&&f.apply(this,arguments)||this;d.data=void 0;d.options=void 0;d.points=void 0;return d}g(h,f);h.prototype.getValues=function(d,a){var b=a.period,c=d.xData,n=d.yData;d=n?n.length:0;var h=[],f=[],e=[],y,g=a.index;if(!(c.length<b)){l(n[0])?a=n:(g=Math.min(g,n[0].length-1),a=n.map(function(a){return a[g]}));var t=0,p=n=0;for(y=b;0<y;y--)a[y]>a[y-1]?n+=a[y]-a[y-1]:a[y]<a[y-1]&&(p+=a[y-
1]-a[y]);t=0<n+p?100*(n-p)/(n+p):0;f.push(c[b]);e.push(t);h.push([c[b],t]);for(y=b+1;y<d;y++)t=Math.abs(a[y-b-1]-a[y-b]),a[y]>a[y-1]?n+=a[y]-a[y-1]:a[y]<a[y-1]&&(p+=a[y-1]-a[y]),a[y-b]>a[y-b-1]?n-=t:p-=t,t=0<n+p?100*(n-p)/(n+p):0,f.push(c[y]),e.push(t),h.push([c[y],t]);return{values:h,xData:f,yData:e}}};h.defaultOptions=q(k.defaultOptions,{params:{period:20,index:3}});return h}(k);e.registerSeriesType("cmo",f);"";return f});u(e,"Stock/Indicators/DEMA/DEMAIndicator.js",[e["Core/Series/SeriesRegistry.js"],
e["Core/Utilities.js"]],function(e,f){var g=this&&this.__extends||function(){var h=function(d,a){h=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(a,c){a.__proto__=c}||function(a,c){for(var b in c)c.hasOwnProperty(b)&&(a[b]=c[b])};return h(d,a)};return function(d,a){function b(){this.constructor=d}h(d,a);d.prototype=null===a?Object.create(a):(b.prototype=a.prototype,new b)}}(),k=e.seriesTypes.ema,l=f.correctFloat,q=f.isArray,m=f.merge;f=function(h){function d(){var a=null!==h&&h.apply(this,
arguments)||this;a.EMApercent=void 0;a.data=void 0;a.options=void 0;a.points=void 0;return a}g(d,h);d.prototype.getEMA=function(a,b,c,n,d,f){return h.prototype.calculateEma.call(this,f||[],a,"undefined"===typeof d?1:d,this.EMApercent,b,"undefined"===typeof n?-1:n,c)};d.prototype.getValues=function(a,b){var c=b.period,n=[],d=2*c,f=a.xData,e=(a=a.yData)?a.length:0,g=[],k=[],t=[],p=0,w,r=-1;this.EMApercent=2/(c+1);if(!(e<2*c-1)){q(a[0])&&(r=b.index?b.index:0);b=h.prototype.accumulatePeriodPoints.call(this,
c,r,a);var A=b/c;b=0;for(w=c;w<e+2;w++){w<e+1&&(p=this.getEMA(a,m,A,r,w)[1],n.push(p));var m=p;if(w<d)b+=p;else{w===d&&(A=b/c);p=n[w-c-1];var D=this.getEMA([p],D,A)[1];var z=[f[w-2],l(2*p-D)];g.push(z);k.push(z[0]);t.push(z[1])}}return{values:g,xData:k,yData:t}}};d.defaultOptions=m(k.defaultOptions);return d}(k);e.registerSeriesType("dema",f);"";return f});u(e,"Stock/Indicators/TEMA/TEMAIndicator.js",[e["Core/Series/SeriesRegistry.js"],e["Core/Utilities.js"]],function(e,f){var g=this&&this.__extends||
function(){var h=function(d,a){h=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(a,c){a.__proto__=c}||function(a,c){for(var b in c)c.hasOwnProperty(b)&&(a[b]=c[b])};return h(d,a)};return function(d,a){function b(){this.constructor=d}h(d,a);d.prototype=null===a?Object.create(a):(b.prototype=a.prototype,new b)}}(),k=e.seriesTypes.ema,l=f.correctFloat,q=f.isArray,m=f.merge;f=function(h){function d(){var a=null!==h&&h.apply(this,arguments)||this;a.EMApercent=void 0;a.data=void 0;a.options=
void 0;a.points=void 0;return a}g(d,h);d.prototype.getEMA=function(a,b,c,n,d,h){return k.prototype.calculateEma(h||[],a,"undefined"===typeof d?1:d,this.EMApercent,b,"undefined"===typeof n?-1:n,c)};d.prototype.getTemaPoint=function(a,b,c,n){return[a[n-3],l(3*c.level1-3*c.level2+c.level3)]};d.prototype.getValues=function(a,b){var c=b.period,n=2*c,d=3*c,h=a.xData,f=(a=a.yData)?a.length:0,e=-1,g=[],t=[],p=[],w=[],r=[],A,m,l={};this.EMApercent=2/(c+1);if(!(f<3*c-2)){q(a[0])&&(e=b.index?b.index:0);b=k.prototype.accumulatePeriodPoints(c,
e,a);var z=b/c;b=0;for(A=c;A<f+3;A++){A<f+1&&(l.level1=this.getEMA(a,C,z,e,A)[1],w.push(l.level1));var C=l.level1;if(A<n)b+=l.level1;else{A===n&&(z=b/c,b=0);l.level1=w[A-c-1];l.level2=this.getEMA([l.level1],Q,z)[1];r.push(l.level2);var Q=l.level2;if(A<d)b+=l.level2;else{A===d&&(z=b/c);A===f+1&&(l.level1=w[A-c-1],l.level2=this.getEMA([l.level1],Q,z)[1],r.push(l.level2));l.level1=w[A-c-2];l.level2=r[A-2*c-1];l.level3=this.getEMA([l.level2],l.prevLevel3,z)[1];if(m=this.getTemaPoint(h,d,l,A))g.push(m),
t.push(m[0]),p.push(m[1]);l.prevLevel3=l.level3}}}return{values:g,xData:t,yData:p}}};d.defaultOptions=m(k.defaultOptions);return d}(k);e.registerSeriesType("tema",f);"";return f});u(e,"Stock/Indicators/TRIX/TRIXIndicator.js",[e["Core/Series/SeriesRegistry.js"],e["Core/Utilities.js"]],function(e,f){var g=this&&this.__extends||function(){var f=function(h,d){f=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(a,b){a.__proto__=b}||function(a,b){for(var c in b)b.hasOwnProperty(c)&&(a[c]=
b[c])};return f(h,d)};return function(h,d){function a(){this.constructor=h}f(h,d);h.prototype=null===d?Object.create(d):(a.prototype=d.prototype,new a)}}(),k=e.seriesTypes.tema,l=f.correctFloat,q=f.merge;f=function(f){function h(){var d=null!==f&&f.apply(this,arguments)||this;d.data=void 0;d.options=void 0;d.points=void 0;return d}g(h,f);h.prototype.getTemaPoint=function(d,a,b,c){if(c>a)return[d[c-3],0!==b.prevLevel3?l(b.level3-b.prevLevel3)/b.prevLevel3*100:null]};h.defaultOptions=q(k.defaultOptions);
return h}(k);e.registerSeriesType("trix",f);"";return f});u(e,"Stock/Indicators/APO/APOIndicator.js",[e["Core/Series/SeriesRegistry.js"],e["Core/Utilities.js"]],function(e,f){var g=this&&this.__extends||function(){var h=function(d,a){h=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(a,c){a.__proto__=c}||function(a,c){for(var b in c)c.hasOwnProperty(b)&&(a[b]=c[b])};return h(d,a)};return function(d,a){function b(){this.constructor=d}h(d,a);d.prototype=null===a?Object.create(a):(b.prototype=
a.prototype,new b)}}(),k=e.seriesTypes.ema,l=f.extend,q=f.merge,m=f.error;f=function(h){function d(){var a=null!==h&&h.apply(this,arguments)||this;a.data=void 0;a.options=void 0;a.points=void 0;return a}g(d,h);d.prototype.getValues=function(a,b){var c=b.periods,n=b.index;b=[];var d=[],h=[],f;if(2!==c.length||c[1]<=c[0])m('Error: "APO requires two periods. Notice, first period should be lower than the second one."');else{var e=k.prototype.getValues.call(this,a,{index:n,period:c[0]});a=k.prototype.getValues.call(this,
a,{index:n,period:c[1]});if(e&&a){c=c[1]-c[0];for(f=0;f<a.yData.length;f++)n=e.yData[f+c]-a.yData[f],b.push([a.xData[f],n]),d.push(a.xData[f]),h.push(n);return{values:b,xData:d,yData:h}}}};d.defaultOptions=q(k.defaultOptions,{params:{period:void 0,periods:[10,20]}});return d}(k);l(f.prototype,{nameBase:"APO",nameComponents:["periods"]});e.registerSeriesType("apo",f);"";return f});u(e,"Stock/Indicators/IKH/IKHIndicator.js",[e["Extensions/DataGrouping/ApproximationRegistry.js"],e["Core/Color/Color.js"],
e["Core/Series/SeriesRegistry.js"],e["Core/Utilities.js"]],function(e,f,g,k){function l(a){return a.reduce(function(a,c){return Math.max(a,c[1])},-Infinity)}function q(a){return a.reduce(function(a,c){return Math.min(a,c[2])},Infinity)}function m(a){return{high:l(a),low:q(a)}}function h(a){var c,b,n,d,f;a.series.forEach(function(a){if(a.xData)for(d=a.xData,f=b=a.xIncrement?1:d.length-1;0<f;f--)if(n=d[f]-d[f-1],"undefined"===typeof c||n<c)c=n});return c}function d(a,c,b,d){if(a&&c&&b&&d){var n=c.plotX-
a.plotX;c=c.plotY-a.plotY;var f=d.plotX-b.plotX;d=d.plotY-b.plotY;var h=a.plotX-b.plotX,v=a.plotY-b.plotY;b=(-c*h+n*v)/(-f*c+n*d);f=(f*v-d*h)/(-f*c+n*d);if(0<=b&&1>=b&&0<=f&&1>=f)return{plotX:a.plotX+f*n,plotY:a.plotY+f*c}}}function a(a){var c=a.indicator;c.points=a.points;c.nextPoints=a.nextPoints;c.color=a.color;c.options=y(a.options.senkouSpan.styles,a.gap);c.graph=a.graph;c.fillGraph=!0;g.seriesTypes.sma.prototype.drawGraph.call(c)}var b=this&&this.__extends||function(){var a=function(c,b){a=
Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(a,c){a.__proto__=c}||function(a,c){for(var b in c)c.hasOwnProperty(b)&&(a[b]=c[b])};return a(c,b)};return function(c,b){function d(){this.constructor=c}a(c,b);c.prototype=null===b?Object.create(b):(d.prototype=b.prototype,new d)}}(),c=f.parse,n=g.seriesTypes.sma,v=k.defined;f=k.extend;var B=k.isArray,x=k.isNumber,y=k.merge,O=k.objectEach;k=function(f){function e(){var a=null!==f&&f.apply(this,arguments)||this;a.data=[];a.options={};a.points=
[];a.graphCollection=[];return a}b(e,f);e.prototype.init=function(){f.prototype.init.apply(this,arguments);this.options=y({tenkanLine:{styles:{lineColor:this.color}},kijunLine:{styles:{lineColor:this.color}},chikouLine:{styles:{lineColor:this.color}},senkouSpanA:{styles:{lineColor:this.color,fill:c(this.color).setOpacity(.5).get()}},senkouSpanB:{styles:{lineColor:this.color,fill:c(this.color).setOpacity(.5).get()}},senkouSpan:{styles:{fill:c(this.color).setOpacity(.2).get()}}},this.options)};e.prototype.toYData=
function(a){return[a.tenkanSen,a.kijunSen,a.chikouSpan,a.senkouSpanA,a.senkouSpanB]};e.prototype.translate=function(){g.seriesTypes.sma.prototype.translate.apply(this);for(var a=0,c=this.points;a<c.length;a++)for(var b=c[a],d=0,n=this.pointArrayMap;d<n.length;d++){var f=n[d],h=b[f];x(h)&&(b["plot"+f]=this.yAxis.toPixels(h,!0),b.plotY=b["plot"+f],b.tooltipPos=[b.plotX,b["plot"+f]],b.isNull=!1)}};e.prototype.drawGraph=function(){var c=this,b=c.points,n=c.options,f=c.graph,h=c.color,e={options:{gapSize:n.gapSize}},
x=c.pointArrayMap.length,t=[[],[],[],[],[],[]],p={tenkanLine:t[0],kijunLine:t[1],chikouLine:t[2],senkouSpanA:t[3],senkouSpanB:t[4],senkouSpan:t[5]},B=[],k=c.options.senkouSpan,m=k.color||k.styles.fill,l=k.negativeColor,q=[[],[]],z=[[],[]];k=b.length;var u=0,N,R,P;for(c.ikhMap=p;k--;){var G=b[k];for(N=0;N<x;N++){var H=c.pointArrayMap[N];v(G[H])&&t[N].push({plotX:G.plotX,plotY:G["plot"+H],isNull:!1})}l&&k!==b.length-1&&(H=p.senkouSpanB.length-1,G=d(p.senkouSpanA[H-1],p.senkouSpanA[H],p.senkouSpanB[H-
1],p.senkouSpanB[H]))&&(G={plotX:G.plotX,plotY:G.plotY,isNull:!1,intersectPoint:!0},p.senkouSpanA.splice(H,0,G),p.senkouSpanB.splice(H,0,G),B.push(H))}O(p,function(a,b){n[b]&&"senkouSpan"!==b&&(c.points=t[u],c.options=y(n[b].styles,e),c.graph=c["graph"+b],c.fillGraph=!1,c.color=h,g.seriesTypes.sma.prototype.drawGraph.call(c),c["graph"+b]=c.graph);u++});if(c.graphCollection)for(x=0,k=c.graphCollection;x<k.length;x++)H=k[x],c[H].destroy(),delete c[H];c.graphCollection=[];if(l&&p.senkouSpanA[0]&&p.senkouSpanB[0]){B.unshift(0);
B.push(p.senkouSpanA.length-1);for(k=0;k<B.length-1;k++){H=B[k];G=B[k+1];x=p.senkouSpanB.slice(H,G+1);H=p.senkouSpanA.slice(H,G+1);if(1<=Math.floor(x.length/2))if(G=Math.floor(x.length/2),x[G].plotY===H[G].plotY){for(P=N=G=0;P<x.length;P++)G+=x[P].plotY,N+=H[P].plotY;G=G>N?0:1}else G=x[G].plotY>H[G].plotY?0:1;else G=x[0].plotY>H[0].plotY?0:1;q[G]=q[G].concat(x);z[G]=z[G].concat(H)}["graphsenkouSpanColor","graphsenkouSpanNegativeColor"].forEach(function(b,d){q[d].length&&z[d].length&&(R=0===d?m:l,
a({indicator:c,points:q[d],nextPoints:z[d],color:R,options:n,gap:e,graph:c[b]}),c[b]=c.graph,c.graphCollection.push(b))})}else a({indicator:c,points:p.senkouSpanB,nextPoints:p.senkouSpanA,color:m,options:n,gap:e,graph:c.graphsenkouSpan}),c.graphsenkouSpan=c.graph;delete c.nextPoints;delete c.fillGraph;c.points=b;c.options=n;c.graph=f;c.color=h};e.prototype.getGraphPath=function(a){var c=[],b;a=a||this.points;if(this.fillGraph&&this.nextPoints){if((b=g.seriesTypes.sma.prototype.getGraphPath.call(this,
this.nextPoints))&&b.length){b[0][0]="L";c=g.seriesTypes.sma.prototype.getGraphPath.call(this,a);b=b.slice(0,c.length);for(var d=b.length-1;0<=d;d--)c.push(b[d])}}else c=g.seriesTypes.sma.prototype.getGraphPath.apply(this,arguments);return c};e.prototype.getValues=function(a,c){var b=c.period,d=c.periodTenkan;c=c.periodSenkouSpanB;var n=a.xData,f=a.yData,v=f&&f.length||0;a=h(a.xAxis);var e=[],x=[],g;if(!(n.length<=b)&&B(f[0])&&4===f[0].length){var p=n[0]-b*a;for(g=0;g<b;g++)x.push(p+g*a);for(g=0;g<
v;g++){if(g>=d){var t=f.slice(g-d,g);t=m(t);t=(t.high+t.low)/2}if(g>=b){var y=f.slice(g-b,g);y=m(y);y=(y.high+y.low)/2;var r=(t+y)/2}if(g>=c){var k=f.slice(g-c,g);k=m(k);k=(k.high+k.low)/2}p=f[g][3];var w=n[g];"undefined"===typeof e[g]&&(e[g]=[]);"undefined"===typeof e[g+b-1]&&(e[g+b-1]=[]);e[g+b-1][0]=t;e[g+b-1][1]=y;e[g+b-1][2]=void 0;"undefined"===typeof e[g+1]&&(e[g+1]=[]);e[g+1][2]=p;g<=b&&(e[g+b-1][3]=void 0,e[g+b-1][4]=void 0);"undefined"===typeof e[g+2*b-2]&&(e[g+2*b-2]=[]);e[g+2*b-2][3]=
r;e[g+2*b-2][4]=k;x.push(w)}for(g=1;g<=b;g++)x.push(w+g*a);return{values:e,xData:x,yData:e}}};e.defaultOptions=y(n.defaultOptions,{params:{index:void 0,period:26,periodTenkan:9,periodSenkouSpanB:52},marker:{enabled:!1},tooltip:{pointFormat:'<span style="color:{point.color}">\u25cf</span> <b> {series.name}</b><br/>TENKAN SEN: {point.tenkanSen:.3f}<br/>KIJUN SEN: {point.kijunSen:.3f}<br/>CHIKOU SPAN: {point.chikouSpan:.3f}<br/>SENKOU SPAN A: {point.senkouSpanA:.3f}<br/>SENKOU SPAN B: {point.senkouSpanB:.3f}<br/>'},
tenkanLine:{styles:{lineWidth:1,lineColor:void 0}},kijunLine:{styles:{lineWidth:1,lineColor:void 0}},chikouLine:{styles:{lineWidth:1,lineColor:void 0}},senkouSpanA:{styles:{lineWidth:1,lineColor:void 0}},senkouSpanB:{styles:{lineWidth:1,lineColor:void 0}},senkouSpan:{styles:{fill:"rgba(255, 0, 0, 0.5)"}},dataGrouping:{approximation:"ichimoku-averages"}});return e}(n);f(k.prototype,{pointArrayMap:["tenkanSen","kijunSen","chikouSpan","senkouSpanA","senkouSpanB"],pointValKey:"tenkanSen",nameComponents:["periodSenkouSpanB",
"period","periodTenkan"]});e["ichimoku-averages"]=function(){var a=[],c;[].forEach.call(arguments,function(b,d){a.push(e.average(b));c=!c&&"undefined"===typeof a[d]});return c?void 0:a};g.registerSeriesType("ikh",k);"";return k});u(e,"Stock/Indicators/KeltnerChannels/KeltnerChannelsIndicator.js",[e["Stock/Indicators/MultipleLinesComposition.js"],e["Core/Series/SeriesRegistry.js"],e["Core/Utilities.js"]],function(e,f,g){var k=this&&this.__extends||function(){var d=function(a,b){d=Object.setPrototypeOf||
{__proto__:[]}instanceof Array&&function(a,b){a.__proto__=b}||function(a,b){for(var c in b)b.hasOwnProperty(c)&&(a[c]=b[c])};return d(a,b)};return function(a,b){function c(){this.constructor=a}d(a,b);a.prototype=null===b?Object.create(b):(c.prototype=b.prototype,new c)}}(),l=f.seriesTypes.sma,q=g.correctFloat,m=g.extend,h=g.merge;g=function(d){function a(){var a=null!==d&&d.apply(this,arguments)||this;a.data=void 0;a.options=void 0;a.points=void 0;return a}k(a,d);a.prototype.init=function(){f.seriesTypes.sma.prototype.init.apply(this,
arguments);this.options=h({topLine:{styles:{lineColor:this.color}},bottomLine:{styles:{lineColor:this.color}}},this.options)};a.prototype.getValues=function(a,c){var b=c.period,d=c.periodATR,h=c.multiplierATR,e=a.yData;e=e?e.length:0;var g=[];c=f.seriesTypes.ema.prototype.getValues(a,{period:b,index:c.index});var k=f.seriesTypes.atr.prototype.getValues(a,{period:d}),t=[],p=[],w;if(!(e<b)){for(w=b;w<=e;w++){var r=c.values[w-b];var m=k.values[w-d];var l=r[0];a=q(r[1]+h*m[1]);m=q(r[1]-h*m[1]);r=r[1];
g.push([l,a,r,m]);t.push(l);p.push([a,r,m])}return{values:g,xData:t,yData:p}}};a.defaultOptions=h(l.defaultOptions,{params:{index:0,period:20,periodATR:10,multiplierATR:2},bottomLine:{styles:{lineWidth:1,lineColor:void 0}},topLine:{styles:{lineWidth:1,lineColor:void 0}},tooltip:{pointFormat:'<span style="color:{point.color}">\u25cf</span><b> {series.name}</b><br/>Upper Channel: {point.top}<br/>EMA({series.options.params.period}): {point.middle}<br/>Lower Channel: {point.bottom}<br/>'},marker:{enabled:!1},
dataGrouping:{approximation:"averages"},lineWidth:1});return a}(l);m(g.prototype,{nameBase:"Keltner Channels",areaLinesNames:["top","bottom"],nameComponents:["period","periodATR","multiplierATR"],linesApiNames:["topLine","bottomLine"],pointArrayMap:["top","middle","bottom"],pointValKey:"middle"});e.compose(g);f.registerSeriesType("keltnerchannels",g);"";return g});u(e,"Stock/Indicators/Klinger/KlingerIndicator.js",[e["Stock/Indicators/MultipleLinesComposition.js"],e["Core/Series/SeriesRegistry.js"],
e["Core/Utilities.js"]],function(e,f,g){var k=this&&this.__extends||function(){var a=function(c,b){a=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(a,c){a.__proto__=c}||function(a,c){for(var b in c)c.hasOwnProperty(b)&&(a[b]=c[b])};return a(c,b)};return function(c,b){function d(){this.constructor=c}a(c,b);c.prototype=null===b?Object.create(b):(d.prototype=b.prototype,new d)}}(),l=f.seriesTypes,q=l.ema,m=l.sma,h=g.correctFloat,d=g.error;l=g.extend;var a=g.isArray,b=g.merge;g=function(c){function n(){var a=
null!==c&&c.apply(this,arguments)||this;a.data=void 0;a.points=void 0;a.options=void 0;a.volumeSeries=void 0;return a}k(n,c);n.prototype.calculateTrend=function(a,c){return a[c][1]+a[c][2]+a[c][3]>a[c-1][1]+a[c-1][2]+a[c-1][3]?1:-1};n.prototype.isValidData=function(c){var b=this.chart,n=this.options,f=this.linkedParent;c=a(c)&&4===c.length;(b=this.volumeSeries||(this.volumeSeries=b.get(n.params.volumeSeriesID)))||d("Series "+n.params.volumeSeriesID+" not found! Check `volumeSeriesID`.",!0,f.chart);
return!(![f,b].every(function(a){return a&&a.xData&&a.xData.length>=n.params.slowAvgPeriod})||!c)};n.prototype.getCM=function(a,c,b,d,n){return h(c+(b===d?a:n))};n.prototype.getDM=function(a,c){return h(a-c)};n.prototype.getVolumeForce=function(a){var c=[],b=1;var d=0;var n=a[0][1]-a[0][2];var f=0;for(b;b<a.length;b++){var h=this.calculateTrend(a,b);var e=this.getDM(a[b][1],a[b][2]);d=this.getCM(d,e,h,f,n);f=this.volumeSeries.yData[b]*h*Math.abs(2*(e/d-1))*100;c.push([f]);f=h;n=e}return c};n.prototype.getEMA=
function(a,c,b,d,n,f,h){return q.prototype.calculateEma(h||[],a,"undefined"===typeof f?1:f,d,c,"undefined"===typeof n?-1:n,b)};n.prototype.getSMA=function(a,c,b){return q.prototype.accumulatePeriodPoints(a,c,b)/a};n.prototype.getValues=function(a,c){var b=[],d=a.xData;a=a.yData;var n=[],f=[],e=[],g,v=0,k=0,m=void 0,B=void 0,l=null;if(this.isValidData(a[0])){var q=this.getVolumeForce(a),z=this.getSMA(c.fastAvgPeriod,0,q),E=this.getSMA(c.slowAvgPeriod,0,q),F=2/(c.fastAvgPeriod+1),u=2/(c.slowAvgPeriod+
1);for(v;v<a.length;v++)v>=c.fastAvgPeriod&&(m=k=this.getEMA(q,m,z,F,0,v,d)[1]),v>=c.slowAvgPeriod&&(B=g=this.getEMA(q,B,E,u,0,v,d)[1],g=h(k-g),e.push(g),e.length>=c.signalPeriod&&(l=e.slice(-c.signalPeriod).reduce(function(a,c){return a+c})/c.signalPeriod),b.push([d[v],g,l]),n.push(d[v]),f.push([g,l]));return{values:b,xData:n,yData:f}}};n.defaultOptions=b(m.defaultOptions,{params:{fastAvgPeriod:34,slowAvgPeriod:55,signalPeriod:13,volumeSeriesID:"volume"},signalLine:{styles:{lineWidth:1,lineColor:"#ff0000"}},
dataGrouping:{approximation:"averages"},tooltip:{pointFormat:'<span style="color: {point.color}">\u25cf</span><b> {series.name}</b><br/><span style="color: {point.color}">Klinger</span>: {point.y}<br/><span style="color: {point.series.options.signalLine.styles.lineColor}">Signal</span>: {point.signal}<br/>'}});return n}(m);l(g.prototype,{areaLinesNames:[],linesApiNames:["signalLine"],nameBase:"Klinger",nameComponents:["fastAvgPeriod","slowAvgPeriod"],pointArrayMap:["y","signal"],parallelArrays:["x",
"y","signal"],pointValKey:"y"});e.compose(g);f.registerSeriesType("klinger",g);"";return g});u(e,"Stock/Indicators/MACD/MACDIndicator.js",[e["Core/Globals.js"],e["Core/Series/SeriesRegistry.js"],e["Core/Utilities.js"]],function(e,f,g){var k=this&&this.__extends||function(){var a=function(c,b){a=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(a,c){a.__proto__=c}||function(a,c){for(var b in c)c.hasOwnProperty(b)&&(a[b]=c[b])};return a(c,b)};return function(c,b){function d(){this.constructor=
c}a(c,b);c.prototype=null===b?Object.create(b):(d.prototype=b.prototype,new d)}}(),l=e.noop,q=f.seriesTypes.sma,m=g.extend,h=g.correctFloat,d=g.defined,a=g.merge;g=function(b){function c(){var a=null!==b&&b.apply(this,arguments)||this;a.data=void 0;a.options=void 0;a.points=void 0;a.currentLineZone=void 0;a.graphmacd=void 0;a.graphsignal=void 0;a.macdZones=void 0;a.signalZones=void 0;return a}k(c,b);c.prototype.init=function(){f.seriesTypes.sma.prototype.init.apply(this,arguments);var a=this.color,
c=this.userOptions._colorIndex;this.options&&(d(this.userOptions._colorIndex)&&(this.options.signalLine&&this.options.signalLine.styles&&!this.options.signalLine.styles.lineColor&&(this.userOptions._colorIndex++,this.getCyclic("color",void 0,this.chart.options.colors),this.options.signalLine.styles.lineColor=this.color),this.options.macdLine&&this.options.macdLine.styles&&!this.options.macdLine.styles.lineColor&&(this.userOptions._colorIndex++,this.getCyclic("color",void 0,this.chart.options.colors),
this.options.macdLine.styles.lineColor=this.color)),this.macdZones={zones:this.options.macdLine.zones,startIndex:0},this.signalZones={zones:this.macdZones.zones.concat(this.options.signalLine.zones),startIndex:this.macdZones.zones.length},this.resetZones=!0);this.color=a;this.userOptions._colorIndex=c};c.prototype.toYData=function(a){return[a.y,a.signal,a.MACD]};c.prototype.translate=function(){var a=this,c=["plotSignal","plotMACD"];e.seriesTypes.column.prototype.translate.apply(a);a.points.forEach(function(b){[b.signal,
b.MACD].forEach(function(d,n){null!==d&&(b[c[n]]=a.yAxis.toPixels(d,!0))})})};c.prototype.destroy=function(){this.graph=null;this.graphmacd=this.graphmacd&&this.graphmacd.destroy();this.graphsignal=this.graphsignal&&this.graphsignal.destroy();f.seriesTypes.sma.prototype.destroy.apply(this,arguments)};c.prototype.drawGraph=function(){for(var c=this,b=c.points,h=b.length,e=c.options,g=c.zones,k={options:{gapSize:e.gapSize}},t=[[],[]],p;h--;)p=b[h],d(p.plotMACD)&&t[0].push({plotX:p.plotX,plotY:p.plotMACD,
isNull:!d(p.plotMACD)}),d(p.plotSignal)&&t[1].push({plotX:p.plotX,plotY:p.plotSignal,isNull:!d(p.plotMACD)});["macd","signal"].forEach(function(b,d){c.points=t[d];c.options=a(e[b+"Line"].styles,k);c.graph=c["graph"+b];c.currentLineZone=b+"Zones";c.zones=c[c.currentLineZone].zones;f.seriesTypes.sma.prototype.drawGraph.call(c);c["graph"+b]=c.graph});c.points=b;c.options=e;c.zones=g;c.currentLineZone=null};c.prototype.getZonesGraphs=function(a){var c=b.prototype.getZonesGraphs.call(this,a),d=c;this.currentLineZone&&
(d=c.splice(this[this.currentLineZone].startIndex+1),d.length?d.splice(0,0,a[0]):d=[a[0]]);return d};c.prototype.applyZones=function(){var a=this.zones;this.zones=this.signalZones.zones;f.seriesTypes.sma.prototype.applyZones.call(this);this.graphmacd&&this.options.macdLine.zones.length&&this.graphmacd.hide();this.zones=a};c.prototype.getValues=function(a,c){var b=c.longPeriod-c.shortPeriod,n=0,e=[],g=[],v=[];if(!(a.xData.length<c.longPeriod+c.signalPeriod)){var p=f.seriesTypes.ema.prototype.getValues(a,
{period:c.shortPeriod,index:c.index});var k=f.seriesTypes.ema.prototype.getValues(a,{period:c.longPeriod,index:c.index});p=p.values;k=k.values;for(a=0;a<=p.length;a++)d(k[a])&&d(k[a][1])&&d(p[a+b])&&d(p[a+b][0])&&e.push([p[a+b][0],0,null,p[a+b][1]-k[a][1]]);for(a=0;a<e.length;a++)g.push(e[a][0]),v.push([0,null,e[a][3]]);c=f.seriesTypes.ema.prototype.getValues({xData:g,yData:v},{period:c.signalPeriod,index:2});c=c.values;for(a=0;a<e.length;a++)e[a][0]>=c[0][0]&&(e[a][2]=c[n][1],v[a]=[0,c[n][1],e[a][3]],
null===e[a][3]?(e[a][1]=0,v[a][0]=0):(e[a][1]=h(e[a][3]-c[n][1]),v[a][0]=h(e[a][3]-c[n][1])),n++);return{values:e,xData:g,yData:v}}};c.defaultOptions=a(q.defaultOptions,{params:{shortPeriod:12,longPeriod:26,signalPeriod:9,period:26},signalLine:{zones:[],styles:{lineWidth:1,lineColor:void 0}},macdLine:{zones:[],styles:{lineWidth:1,lineColor:void 0}},threshold:0,groupPadding:.1,pointPadding:.1,crisp:!1,states:{hover:{halo:{size:0}}},tooltip:{pointFormat:'<span style="color:{point.color}">\u25cf</span> <b> {series.name}</b><br/>Value: {point.MACD}<br/>Signal: {point.signal}<br/>Histogram: {point.y}<br/>'},
dataGrouping:{approximation:"averages"},minPointLength:0});return c}(q);m(g.prototype,{nameComponents:["longPeriod","shortPeriod","signalPeriod"],pointArrayMap:["y","signal","MACD"],parallelArrays:["x","y","signal","MACD"],pointValKey:"y",markerAttribs:l,getColumnMetrics:e.seriesTypes.column.prototype.getColumnMetrics,crispCol:e.seriesTypes.column.prototype.crispCol,drawPoints:e.seriesTypes.column.prototype.drawPoints});f.registerSeriesType("macd",g);"";return g});u(e,"Stock/Indicators/MFI/MFIIndicator.js",
[e["Core/Series/SeriesRegistry.js"],e["Core/Utilities.js"]],function(e,f){function g(a){return a.reduce(function(a,b){return a+b})}function k(a){return(a[1]+a[2]+a[3])/3}var l=this&&this.__extends||function(){var a=function(c,b){a=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(a,c){a.__proto__=c}||function(a,c){for(var b in c)c.hasOwnProperty(b)&&(a[b]=c[b])};return a(c,b)};return function(c,b){function d(){this.constructor=c}a(c,b);c.prototype=null===b?Object.create(b):(d.prototype=
b.prototype,new d)}}(),q=e.seriesTypes.sma,m=f.extend,h=f.merge,d=f.error,a=f.isArray;f=function(b){function c(){var a=null!==b&&b.apply(this,arguments)||this;a.data=void 0;a.options=void 0;a.points=void 0;return a}l(c,b);c.prototype.getValues=function(c,b){var n=b.period,f=c.xData,h=c.yData,e=h?h.length:0,t=b.decimals,p=1,v=c.chart.get(b.volumeSeriesID),m=v&&v.yData,l=[],q=[],z=[],J=[],C=[];if(!v)d("Series "+b.volumeSeriesID+" not found! Check `volumeSeriesID`.",!0,c.chart);else if(!(f.length<=n)&&
a(h[0])&&4===h[0].length&&m){for(c=k(h[p]);p<n+1;)b=c,c=k(h[p]),b=c>=b,v=c*m[p],J.push(b?v:0),C.push(b?0:v),p++;for(n=p-1;n<e;n++)n>p-1&&(J.shift(),C.shift(),b=c,c=k(h[n]),b=c>b,v=c*m[n],J.push(b?v:0),C.push(b?0:v)),b=g(C),v=g(J),b=v/b,b=parseFloat((100-100/(1+b)).toFixed(t)),l.push([f[n],b]),q.push(f[n]),z.push(b);return{values:l,xData:q,yData:z}}};c.defaultOptions=h(q.defaultOptions,{params:{index:void 0,volumeSeriesID:"volume",decimals:4}});return c}(q);m(f.prototype,{nameBase:"Money Flow Index"});
e.registerSeriesType("mfi",f);"";return f});u(e,"Stock/Indicators/Momentum/MomentumIndicator.js",[e["Core/Series/SeriesRegistry.js"],e["Core/Utilities.js"]],function(e,f){var g=this&&this.__extends||function(){var f=function(d,a){f=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(a,c){a.__proto__=c}||function(a,c){for(var b in c)c.hasOwnProperty(b)&&(a[b]=c[b])};return f(d,a)};return function(d,a){function b(){this.constructor=d}f(d,a);d.prototype=null===a?Object.create(a):(b.prototype=
a.prototype,new b)}}(),k=e.seriesTypes.sma,l=f.extend,q=f.isArray,m=f.merge;f=function(f){function d(){var a=null!==f&&f.apply(this,arguments)||this;a.data=void 0;a.options=void 0;a.points=void 0;return a}g(d,f);d.prototype.getValues=function(a,b){var c=b.period;b=b.index;var d=a.xData,f=(a=a.yData)?a.length:0,h=[],e=[],g=[],k;if(!(d.length<=c)&&q(a[0])){for(k=c+1;k<f;k++){var t=[d[k-1],a[k-1][b]-a[k-c-1][b]];h.push(t);e.push(t[0]);g.push(t[1])}t=[d[k-1],a[k-1][b]-a[k-c-1][b]];h.push(t);e.push(t[0]);
g.push(t[1]);return{values:h,xData:e,yData:g}}};d.defaultOptions=m(k.defaultOptions,{params:{index:3}});return d}(k);l(f.prototype,{nameBase:"Momentum"});e.registerSeriesType("momentum",f);"";return f});u(e,"Stock/Indicators/NATR/NATRIndicator.js",[e["Core/Series/SeriesRegistry.js"],e["Core/Utilities.js"]],function(e,f){var g=this&&this.__extends||function(){var f=function(e,h){f=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(d,a){d.__proto__=a}||function(d,a){for(var b in a)a.hasOwnProperty(b)&&
(d[b]=a[b])};return f(e,h)};return function(e,h){function d(){this.constructor=e}f(e,h);e.prototype=null===h?Object.create(h):(d.prototype=h.prototype,new d)}}(),k=e.seriesTypes.atr,l=f.merge;f=function(f){function e(){var e=null!==f&&f.apply(this,arguments)||this;e.data=void 0;e.points=void 0;e.options=void 0;return e}g(e,f);e.prototype.getValues=function(f,d){var a=k.prototype.getValues.apply(this,arguments),b=a.values.length,c=d.period-1,n=f.yData,e=0;if(a){for(;e<b;e++)a.yData[e]=a.values[e][1]/
n[c][3]*100,a.values[e][1]=a.yData[e],c++;return a}};e.defaultOptions=l(k.defaultOptions,{tooltip:{valueSuffix:"%"}});return e}(k);e.registerSeriesType("natr",f);"";return f});u(e,"Stock/Indicators/OBV/OBVIndicator.js",[e["Core/Series/SeriesRegistry.js"],e["Core/Utilities.js"]],function(e,f){var g=this&&this.__extends||function(){var d=function(a,b){d=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(a,b){a.__proto__=b}||function(a,b){for(var c in b)b.hasOwnProperty(c)&&(a[c]=b[c])};
return d(a,b)};return function(a,b){function c(){this.constructor=a}d(a,b);a.prototype=null===b?Object.create(b):(c.prototype=b.prototype,new c)}}(),k=e.seriesTypes.sma,l=f.isNumber,q=f.error,m=f.extend,h=f.merge;f=function(d){function a(){var a=null!==d&&d.apply(this,arguments)||this;a.data=void 0;a.points=void 0;a.options=void 0;return a}g(a,d);a.prototype.getValues=function(a,c){var b=a.chart.get(c.volumeSeriesID),d=a.xData,f=a.yData,e=[],h=[],g=[],k=!l(f[0]),p=1,m=0;if(b){b=b.yData;a=[d[0],m];
var r=k?f[0][3]:f[0];e.push(a);h.push(d[0]);g.push(a[1]);for(p;p<f.length;p++)c=k?f[p][3]:f[p],m=c>r?m+b[p]:c===r?m:m-b[p],a=[d[p],m],r=c,e.push(a),h.push(d[p]),g.push(a[1]);return{values:e,xData:h,yData:g}}q("Series "+c.volumeSeriesID+" not found! Check `volumeSeriesID`.",!0,a.chart)};a.defaultOptions=h(k.defaultOptions,{marker:{enabled:!1},params:{index:void 0,period:void 0,volumeSeriesID:"volume"},tooltip:{valueDecimals:0}});return a}(k);m(f.prototype,{nameComponents:void 0});e.registerSeriesType("obv",
f);"";return f});u(e,"Stock/Indicators/PivotPoints/PivotPointsPoint.js",[e["Core/Series/SeriesRegistry.js"]],function(e){function f(f,g){var k=f.series.pointArrayMap,m=k.length;for(e.seriesTypes.sma.prototype.pointClass.prototype[g].call(f);m--;)g="dataLabel"+k[m],f[g]&&f[g].element&&f[g].destroy(),f[g]=null}var g=this&&this.__extends||function(){var f=function(e,g){f=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(f,e){f.__proto__=e}||function(f,e){for(var d in e)e.hasOwnProperty(d)&&
(f[d]=e[d])};return f(e,g)};return function(e,g){function k(){this.constructor=e}f(e,g);e.prototype=null===g?Object.create(g):(k.prototype=g.prototype,new k)}}();return function(e){function k(){var f=null!==e&&e.apply(this,arguments)||this;f.P=void 0;f.pivotLine=void 0;f.series=void 0;return f}g(k,e);k.prototype.destroyElements=function(){f(this,"destroyElements")};k.prototype.destroy=function(){f(this,"destroyElements")};return k}(e.seriesTypes.sma.prototype.pointClass)});u(e,"Stock/Indicators/PivotPoints/PivotPointsIndicator.js",
[e["Stock/Indicators/PivotPoints/PivotPointsPoint.js"],e["Core/Series/SeriesRegistry.js"],e["Core/Utilities.js"]],function(e,f,g){var k=this&&this.__extends||function(){var a=function(b,c){a=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(a,c){a.__proto__=c}||function(a,c){for(var b in c)c.hasOwnProperty(b)&&(a[b]=c[b])};return a(b,c)};return function(b,c){function d(){this.constructor=b}a(b,c);b.prototype=null===c?Object.create(c):(d.prototype=c.prototype,new d)}}(),l=f.seriesTypes.sma,
q=g.merge,m=g.extend,h=g.defined,d=g.isArray;g=function(a){function b(){var c=null!==a&&a.apply(this,arguments)||this;c.data=void 0;c.options=void 0;c.points=void 0;c.endPoint=void 0;c.plotEndPoint=void 0;return c}k(b,a);b.prototype.toYData=function(a){return[a.P]};b.prototype.translate=function(){var a=this;f.seriesTypes.sma.prototype.translate.apply(a);a.points.forEach(function(c){a.pointArrayMap.forEach(function(b){h(c[b])&&(c["plot"+b]=a.yAxis.toPixels(c[b],!0))})});a.plotEndPoint=a.xAxis.toPixels(a.endPoint,
!0)};b.prototype.getGraphPath=function(a){for(var c=this,b=a.length,d=[[],[],[],[],[],[],[],[],[]],e=[],g=c.plotEndPoint,k=c.pointArrayMap.length,t,p,m;b--;){p=a[b];for(m=0;m<k;m++)t=c.pointArrayMap[m],h(p[t])&&d[m].push({plotX:p.plotX,plotY:p["plot"+t],isNull:!1},{plotX:g,plotY:p["plot"+t],isNull:!1},{plotX:g,plotY:null,isNull:!0});g=p.plotX}d.forEach(function(a){e=e.concat(f.seriesTypes.sma.prototype.getGraphPath.call(c,a))});return e};b.prototype.drawDataLabels=function(){var a=this,b=a.pointArrayMap,
d,e,h;if(a.options.dataLabels.enabled){var g=a.points.length;b.concat([!1]).forEach(function(c,n){for(h=g;h--;)e=a.points[h],c?(e.y=e[c],e.pivotLine=c,e.plotY=e["plot"+c],d=e["dataLabel"+c],n&&(e["dataLabel"+b[n-1]]=e.dataLabel),e.dataLabels||(e.dataLabels=[]),e.dataLabels[0]=e.dataLabel=d=d&&d.element?d:null):e["dataLabel"+b[n-1]]=e.dataLabel;f.seriesTypes.sma.prototype.drawDataLabels.call(a)})}};b.prototype.getValues=function(a,b){var c=b.period,f=a.xData,e=(a=a.yData)?a.length:0;b=this[b.algorithm+
"Placement"];var n=[],h=[],g=[],p;if(!(f.length<c)&&d(a[0])&&4===a[0].length){for(p=c+1;p<=e+c;p+=c){var k=f.slice(p-c-1,p);var m=a.slice(p-c-1,p);var l=k.length;var q=k[l-1];m=this.getPivotAndHLC(m);m=b(m);m=n.push([q].concat(m));h.push(q);g.push(n[m-1].slice(1))}this.endPoint=k[0]+(q-k[0])/l*c;return{values:n,xData:h,yData:g}}};b.prototype.getPivotAndHLC=function(a){var c=-Infinity,b=Infinity,d=a[a.length-1][3];a.forEach(function(a){c=Math.max(c,a[1]);b=Math.min(b,a[2])});return[(c+b+d)/3,c,b,d]};
b.prototype.standardPlacement=function(a){var c=a[1]-a[2];return[null,null,a[0]+c,2*a[0]-a[2],a[0],2*a[0]-a[1],a[0]-c,null,null]};b.prototype.camarillaPlacement=function(a){var c=a[1]-a[2];return[a[3]+1.5*c,a[3]+1.25*c,a[3]+1.1666*c,a[3]+1.0833*c,a[0],a[3]-1.0833*c,a[3]-1.1666*c,a[3]-1.25*c,a[3]-1.5*c]};b.prototype.fibonacciPlacement=function(a){var c=a[1]-a[2];return[null,a[0]+c,a[0]+.618*c,a[0]+.382*c,a[0],a[0]-.382*c,a[0]-.618*c,a[0]-c,null]};b.defaultOptions=q(l.defaultOptions,{params:{index:void 0,
period:28,algorithm:"standard"},marker:{enabled:!1},enableMouseTracking:!1,dataLabels:{enabled:!0,format:"{point.pivotLine}"},dataGrouping:{approximation:"averages"}});return b}(l);m(g.prototype,{nameBase:"Pivot Points",pointArrayMap:"R4 R3 R2 R1 P S1 S2 S3 S4".split(" "),pointValKey:"P",pointClass:e});f.registerSeriesType("pivotpoints",g);"";return g});u(e,"Stock/Indicators/PPO/PPOIndicator.js",[e["Core/Series/SeriesRegistry.js"],e["Core/Utilities.js"]],function(e,f){var g=this&&this.__extends||
function(){var d=function(a,b){d=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(a,b){a.__proto__=b}||function(a,b){for(var c in b)b.hasOwnProperty(c)&&(a[c]=b[c])};return d(a,b)};return function(a,b){function c(){this.constructor=a}d(a,b);a.prototype=null===b?Object.create(b):(c.prototype=b.prototype,new c)}}(),k=e.seriesTypes.ema,l=f.correctFloat,q=f.extend,m=f.merge,h=f.error;f=function(d){function a(){var a=null!==d&&d.apply(this,arguments)||this;a.data=void 0;a.options=void 0;
a.points=void 0;return a}g(a,d);a.prototype.getValues=function(a,c){var b=c.periods,d=c.index;c=[];var f=[],e=[],g;if(2!==b.length||b[1]<=b[0])h('Error: "PPO requires two periods. Notice, first period should be lower than the second one."');else{var m=k.prototype.getValues.call(this,a,{index:d,period:b[0]});a=k.prototype.getValues.call(this,a,{index:d,period:b[1]});if(m&&a){b=b[1]-b[0];for(g=0;g<a.yData.length;g++)d=l((m.yData[g+b]-a.yData[g])/a.yData[g]*100),c.push([a.xData[g],d]),f.push(a.xData[g]),
e.push(d);return{values:c,xData:f,yData:e}}}};a.defaultOptions=m(k.defaultOptions,{params:{period:void 0,periods:[12,26]}});return a}(k);q(f.prototype,{nameBase:"PPO",nameComponents:["periods"]});e.registerSeriesType("ppo",f);"";return f});u(e,"Stock/Indicators/ArrayUtilities.js",[],function(){return{getArrayExtremes:function(e,f,g){return e.reduce(function(e,l){return[Math.min(e[0],l[f]),Math.max(e[1],l[g])]},[Number.MAX_VALUE,-Number.MAX_VALUE])}}});u(e,"Stock/Indicators/PC/PCIndicator.js",[e["Stock/Indicators/ArrayUtilities.js"],
e["Stock/Indicators/MultipleLinesComposition.js"],e["Core/Color/Palettes.js"],e["Core/Series/SeriesRegistry.js"],e["Core/Utilities.js"]],function(e,f,g,k,l){var q=this&&this.__extends||function(){var a=function(b,c){a=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(a,c){a.__proto__=c}||function(a,c){for(var b in c)c.hasOwnProperty(b)&&(a[b]=c[b])};return a(b,c)};return function(b,c){function d(){this.constructor=b}a(b,c);b.prototype=null===c?Object.create(c):(d.prototype=c.prototype,
new d)}}(),m=k.seriesTypes.sma,h=l.merge;l=l.extend;var d=function(a){function b(){var c=null!==a&&a.apply(this,arguments)||this;c.data=void 0;c.options=void 0;c.points=void 0;return c}q(b,a);b.prototype.getValues=function(a,b){b=b.period;var c=a.xData,d=(a=a.yData)?a.length:0,f=[],n=[],h=[],g;if(!(d<b)){for(g=b;g<=d;g++){var p=c[g-1];var k=a.slice(g-b,g);var m=e.getArrayExtremes(k,2,1);k=m[1];var l=m[0];m=(k+l)/2;f.push([p,k,m,l]);n.push(p);h.push([k,m,l])}return{values:f,xData:n,yData:h}}};b.defaultOptions=
h(m.defaultOptions,{params:{index:void 0,period:20},lineWidth:1,topLine:{styles:{lineColor:g.colors[2],lineWidth:1}},bottomLine:{styles:{lineColor:g.colors[8],lineWidth:1}},dataGrouping:{approximation:"averages"}});return b}(m);l(d.prototype,{areaLinesNames:["top","bottom"],nameBase:"Price Channel",nameComponents:["period"],linesApiNames:["topLine","bottomLine"],pointArrayMap:["top","middle","bottom"],pointValKey:"middle"});f.compose(d);k.registerSeriesType("pc",d);"";return d});u(e,"Stock/Indicators/PriceEnvelopes/PriceEnvelopesIndicator.js",
[e["Core/Series/SeriesRegistry.js"],e["Core/Utilities.js"]],function(e,f){var g=this&&this.__extends||function(){var f=function(d,a){f=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(a,c){a.__proto__=c}||function(a,c){for(var b in c)c.hasOwnProperty(b)&&(a[b]=c[b])};return f(d,a)};return function(d,a){function b(){this.constructor=d}f(d,a);d.prototype=null===a?Object.create(a):(b.prototype=a.prototype,new b)}}(),k=e.seriesTypes.sma,l=f.extend,q=f.isArray,m=f.merge;f=function(f){function d(){var a=
null!==f&&f.apply(this,arguments)||this;a.data=void 0;a.options=void 0;a.points=void 0;return a}g(d,f);d.prototype.init=function(){e.seriesTypes.sma.prototype.init.apply(this,arguments);this.options=m({topLine:{styles:{lineColor:this.color}},bottomLine:{styles:{lineColor:this.color}}},this.options)};d.prototype.toYData=function(a){return[a.top,a.middle,a.bottom]};d.prototype.translate=function(){var a=this,b=["plotTop","plotMiddle","plotBottom"];e.seriesTypes.sma.prototype.translate.apply(a);a.points.forEach(function(c){[c.top,
c.middle,c.bottom].forEach(function(d,f){null!==d&&(c[b[f]]=a.yAxis.toPixels(d,!0))})})};d.prototype.drawGraph=function(){for(var a=this,b=a.points,c=b.length,d=a.options,f=a.graph,h={options:{gapSize:d.gapSize}},g=[[],[]],k;c--;)k=b[c],g[0].push({plotX:k.plotX,plotY:k.plotTop,isNull:k.isNull}),g[1].push({plotX:k.plotX,plotY:k.plotBottom,isNull:k.isNull});["topLine","bottomLine"].forEach(function(c,b){a.points=g[b];a.options=m(d[c].styles,h);a.graph=a["graph"+c];e.seriesTypes.sma.prototype.drawGraph.call(a);
a["graph"+c]=a.graph});a.points=b;a.options=d;a.graph=f;e.seriesTypes.sma.prototype.drawGraph.call(a)};d.prototype.getValues=function(a,b){var c=b.period,d=b.topBand,f=b.bottomBand,h=a.xData,g=(a=a.yData)?a.length:0,k=[],m=[],t=[],p;if(!(h.length<c)&&q(a[0])&&4===a[0].length){for(p=c;p<=g;p++){var l=h.slice(p-c,p);var r=a.slice(p-c,p);r=e.seriesTypes.sma.prototype.getValues.call(this,{xData:l,yData:r},b);l=r.xData[0];r=r.yData[0];var A=r*(1+d);var I=r*(1-f);k.push([l,A,r,I]);m.push(l);t.push([A,r,
I])}return{values:k,xData:m,yData:t}}};d.defaultOptions=m(k.defaultOptions,{marker:{enabled:!1},tooltip:{pointFormat:'<span style="color:{point.color}">\u25cf</span><b> {series.name}</b><br/>Top: {point.top}<br/>Middle: {point.middle}<br/>Bottom: {point.bottom}<br/>'},params:{period:20,topBand:.1,bottomBand:.1},bottomLine:{styles:{lineWidth:1,lineColor:void 0}},topLine:{styles:{lineWidth:1}},dataGrouping:{approximation:"averages"}});return d}(k);l(f.prototype,{nameComponents:["period","topBand","bottomBand"],
nameBase:"Price envelopes",pointArrayMap:["top","middle","bottom"],parallelArrays:["x","y","top","bottom"],pointValKey:"middle"});e.registerSeriesType("priceenvelopes",f);"";return f});u(e,"Stock/Indicators/PSAR/PSARIndicator.js",[e["Core/Series/SeriesRegistry.js"],e["Core/Utilities.js"]],function(e,f){var g=this&&this.__extends||function(){var f=function(e,d){f=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(a,b){a.__proto__=b}||function(a,b){for(var c in b)b.hasOwnProperty(c)&&(a[c]=
b[c])};return f(e,d)};return function(e,d){function a(){this.constructor=e}f(e,d);e.prototype=null===d?Object.create(d):(a.prototype=d.prototype,new a)}}(),k=e.seriesTypes.sma,l=f.merge;f=f.extend;var q=function(f){function e(){var d=null!==f&&f.apply(this,arguments)||this;d.data=void 0;d.points=void 0;d.options=void 0;return d}g(e,f);e.prototype.getValues=function(d,a){var b=d.xData;d=d.yData;var c=d[0][1],f=a.maxAccelerationFactor,e=a.increment,h=a.initialAccelerationFactor,g=d[0][2],k=a.decimals,
m=a.index,t=[],p=[],l=[],r=1,q;if(!(m>=d.length)){for(q=0;q<m;q++)c=Math.max(d[q][1],c),g=Math.min(d[q][2],parseFloat(g.toFixed(k)));var I=d[q][1]>g?1:-1;a=a.initialAccelerationFactor;var D=a*(c-g);t.push([b[m],g]);p.push(b[m]);l.push(parseFloat(g.toFixed(k)));for(q=m+1;q<d.length;q++){m=d[q-1][2];var z=d[q-2][2];var C=d[q-1][1];var u=d[q-2][1];var E=d[q][1];var F=d[q][2];null!==z&&null!==u&&null!==m&&null!==C&&null!==E&&null!==F&&(g=I===r?1===I?g+D<Math.min(z,m)?g+D:Math.min(z,m):g+D>Math.max(u,
C)?g+D:Math.max(u,C):c,m=1===I?E>c?E:c:F<c?F:c,E=1===r&&F>g||-1===r&&E>g?1:-1,r=E,D=m,F=e,z=f,C=h,a=r===I?1===r&&D>c?a===z?z:parseFloat((a+F).toFixed(2)):-1===r&&D<c?a===z?z:parseFloat((a+F).toFixed(2)):a:C,c=m-g,D=a*c,t.push([b[q],parseFloat(g.toFixed(k))]),p.push(b[q]),l.push(parseFloat(g.toFixed(k))),r=I,I=E,c=m)}return{values:t,xData:p,yData:l}}};e.defaultOptions=l(k.defaultOptions,{lineWidth:0,marker:{enabled:!0},states:{hover:{lineWidthPlus:0}},params:{period:void 0,initialAccelerationFactor:.02,
maxAccelerationFactor:.2,increment:.02,index:2,decimals:4}});return e}(k);f(q.prototype,{nameComponents:void 0});e.registerSeriesType("psar",q);"";return q});u(e,"Stock/Indicators/ROC/ROCIndicator.js",[e["Core/Series/SeriesRegistry.js"],e["Core/Utilities.js"]],function(e,f){var g=this&&this.__extends||function(){var f=function(d,a){f=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(a,c){a.__proto__=c}||function(a,c){for(var b in c)c.hasOwnProperty(b)&&(a[b]=c[b])};return f(d,a)};return function(d,
a){function b(){this.constructor=d}f(d,a);d.prototype=null===a?Object.create(a):(b.prototype=a.prototype,new b)}}(),k=e.seriesTypes.sma,l=f.isArray,q=f.merge;f=f.extend;var m=function(f){function d(){var a=null!==f&&f.apply(this,arguments)||this;a.data=void 0;a.options=void 0;a.points=void 0;return a}g(d,f);d.prototype.getValues=function(a,b){var c=b.period,d=a.xData,f=(a=a.yData)?a.length:0,e=[],h=[],g=[],k=-1;if(!(d.length<=c)){l(a[0])&&(k=b.index);for(b=c;b<f;b++){var m=0>k?(m=a[b-c])?(a[b]-m)/
m*100:null:(m=a[b-c][k])?(a[b][k]-m)/m*100:null;m=[d[b],m];e.push(m);h.push(m[0]);g.push(m[1])}return{values:e,xData:h,yData:g}}};d.defaultOptions=q(k.defaultOptions,{params:{index:3,period:9}});return d}(k);f(m.prototype,{nameBase:"Rate of Change"});e.registerSeriesType("roc",m);"";return m});u(e,"Stock/Indicators/RSI/RSIIndicator.js",[e["Core/Series/SeriesRegistry.js"],e["Core/Utilities.js"]],function(e,f){var g=this&&this.__extends||function(){var f=function(e,d){f=Object.setPrototypeOf||{__proto__:[]}instanceof
Array&&function(a,b){a.__proto__=b}||function(a,b){for(var c in b)b.hasOwnProperty(c)&&(a[c]=b[c])};return f(e,d)};return function(e,d){function a(){this.constructor=e}f(e,d);e.prototype=null===d?Object.create(d):(a.prototype=d.prototype,new a)}}(),k=e.seriesTypes.sma,l=f.isNumber,q=f.merge;f=function(f){function e(){var d=null!==f&&f.apply(this,arguments)||this;d.data=void 0;d.points=void 0;d.options=void 0;return d}g(e,f);e.prototype.getValues=function(d,a){var b=a.period,c=d.xData,f=d.yData;d=
f?f.length:0;var e=a.decimals,g=1,h=[],k=[],m=[],t=a.index,p=a=0,q;if(!(c.length<b)){if(l(f[0]))var r=f;else t=Math.min(t,f[0].length-1),r=f.map(function(a){return a[t]});for(;g<b;){var A=parseFloat((r[g]-r[g-1]).toFixed(e));0<A?a+=A:p+=Math.abs(A);g++}f=parseFloat((a/(b-1)).toFixed(e));for(q=parseFloat((p/(b-1)).toFixed(e));g<d;g++)A=parseFloat((r[g]-r[g-1]).toFixed(e)),0<A?(a=A,p=0):(a=0,p=Math.abs(A)),f=parseFloat(((f*(b-1)+a)/b).toFixed(e)),q=parseFloat(((q*(b-1)+p)/b).toFixed(e)),a=0===q?100:
0===f?0:parseFloat((100-100/(1+f/q)).toFixed(e)),h.push([c[g],a]),k.push(c[g]),m.push(a);return{values:h,xData:k,yData:m}}};e.defaultOptions=q(k.defaultOptions,{params:{decimals:4,index:3}});return e}(k);e.registerSeriesType("rsi",f);"";return f});u(e,"Stock/Indicators/Stochastic/StochasticIndicator.js",[e["Stock/Indicators/ArrayUtilities.js"],e["Stock/Indicators/MultipleLinesComposition.js"],e["Core/Series/SeriesRegistry.js"],e["Core/Utilities.js"]],function(e,f,g,k){var l=this&&this.__extends||
function(){var a=function(b,c){a=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(a,c){a.__proto__=c}||function(a,c){for(var b in c)c.hasOwnProperty(b)&&(a[b]=c[b])};return a(b,c)};return function(b,c){function d(){this.constructor=b}a(b,c);b.prototype=null===c?Object.create(c):(d.prototype=c.prototype,new d)}}(),q=g.seriesTypes.sma,m=k.extend,h=k.isArray,d=k.merge;k=function(a){function b(){var c=null!==a&&a.apply(this,arguments)||this;c.data=void 0;c.options=void 0;c.points=void 0;
return c}l(b,a);b.prototype.init=function(){g.seriesTypes.sma.prototype.init.apply(this,arguments);this.options=d({smoothedLine:{styles:{lineColor:this.color}}},this.options)};b.prototype.getValues=function(a,b){var c=b.periods[0];b=b.periods[1];var d=a.xData,f=(a=a.yData)?a.length:0,n=[],k=[],m=[],p=null,l;if(!(f<c)&&h(a[0])&&4===a[0].length){for(l=c-1;l<f;l++){var r=a.slice(l-c+1,l+1);var q=e.getArrayExtremes(r,2,1);var I=q[0];r=a[l][3]-I;I=q[1]-I;r=r/I*100;k.push(d[l]);m.push([r,null]);l>=c-1+
(b-1)&&(p=g.seriesTypes.sma.prototype.getValues.call(this,{xData:k.slice(-b),yData:m.slice(-b)},{period:b}),p=p.yData[0]);n.push([d[l],r,p]);m[m.length-1][1]=p}return{values:n,xData:k,yData:m}}};b.defaultOptions=d(q.defaultOptions,{params:{index:void 0,period:void 0,periods:[14,3]},marker:{enabled:!1},tooltip:{pointFormat:'<span style="color:{point.color}">\u25cf</span><b> {series.name}</b><br/>%K: {point.y}<br/>%D: {point.smoothed}<br/>'},smoothedLine:{styles:{lineWidth:1,lineColor:void 0}},dataGrouping:{approximation:"averages"}});
return b}(q);m(k.prototype,{areaLinesNames:[],nameComponents:["periods"],nameBase:"Stochastic",pointArrayMap:["y","smoothed"],parallelArrays:["x","y","smoothed"],pointValKey:"y",linesApiNames:["smoothedLine"]});f.compose(k);g.registerSeriesType("stochastic",k);"";return k});u(e,"Stock/Indicators/SlowStochastic/SlowStochasticIndicator.js",[e["Core/Series/SeriesRegistry.js"],e["Core/Utilities.js"]],function(e,f){var g=this&&this.__extends||function(){var f=function(d,a){f=Object.setPrototypeOf||{__proto__:[]}instanceof
Array&&function(a,c){a.__proto__=c}||function(a,c){for(var b in c)c.hasOwnProperty(b)&&(a[b]=c[b])};return f(d,a)};return function(d,a){function b(){this.constructor=d}f(d,a);d.prototype=null===a?Object.create(a):(b.prototype=a.prototype,new b)}}(),k=e.seriesTypes,l=k.sma.prototype,q=k.stochastic;k=f.extend;var m=f.merge;f=function(f){function d(){var a=null!==f&&f.apply(this,arguments)||this;a.data=void 0;a.options=void 0;a.points=void 0;return a}g(d,f);d.prototype.getValues=function(a,b){var c=
b.periods,d=f.prototype.getValues.call(this,a,b);a={values:[],xData:[],yData:[]};b=0;if(d){a.xData=d.xData.slice(c[1]-1);d=d.yData.slice(c[1]-1);var e=l.getValues.call(this,{xData:a.xData,yData:d},{index:1,period:c[2]});if(e){for(var g=a.xData.length;b<g;b++)a.yData[b]=[d[b][1],e.yData[b-c[2]+1]||null],a.values[b]=[a.xData[b],d[b][1],e.yData[b-c[2]+1]||null];return a}}};d.defaultOptions=m(q.defaultOptions,{params:{periods:[14,3,3]}});return d}(q);k(f.prototype,{nameBase:"Slow Stochastic"});e.registerSeriesType("slowstochastic",
f);"";return f});u(e,"Stock/Indicators/Supertrend/SupertrendIndicator.js",[e["Core/Series/SeriesRegistry.js"],e["Core/Utilities.js"],e["Core/Chart/StockChart.js"]],function(e,f,g){function k(a,c,b){return{index:c,close:a.yData[c][b],x:a.xData[c]}}var l=this&&this.__extends||function(){var a=function(c,b){a=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(a,c){a.__proto__=c}||function(a,c){for(var b in c)c.hasOwnProperty(b)&&(a[b]=c[b])};return a(c,b)};return function(c,b){function d(){this.constructor=
c}a(c,b);c.prototype=null===b?Object.create(b):(d.prototype=b.prototype,new d)}}(),q=e.seriesTypes,m=q.atr,h=q.sma,d=f.addEvent,a=f.correctFloat,b=f.isArray;q=f.extend;var c=f.merge,n=f.objectEach;f=function(f){function e(){var a=null!==f&&f.apply(this,arguments)||this;a.data=void 0;a.linkedParent=void 0;a.options=void 0;a.points=void 0;return a}l(e,f);e.prototype.init=function(){var a;h.prototype.init.apply(this,arguments);var c=this,b=d(g,"afterLinkSeries",function(){if(c.options){var d=c.options;
a=c.linkedParent.options;d.cropThreshold=a.cropThreshold-(d.params.period-1)}b()},{order:1})};e.prototype.drawGraph=function(){var a=this,b=a.options,d=a.linkedParent,f=d?d.points:[],e=a.points,g=a.graph,m=e.length,l=f.length-m;l=0<l?l:0;for(var q={options:{gapSize:b.gapSize}},v={top:[],bottom:[],intersect:[]},z={top:{styles:{lineWidth:b.lineWidth,lineColor:b.fallingTrendColor||b.color,dashStyle:b.dashStyle}},bottom:{styles:{lineWidth:b.lineWidth,lineColor:b.risingTrendColor||b.color,dashStyle:b.dashStyle}},
intersect:b.changeTrendLine},C,B,E,F,u,K,L,M;m--;)C=e[m],B=e[m-1],E=f[m-1+l],F=f[m-2+l],u=f[m+l],K=f[m+l+1],L=C.options.color,M={x:C.x,plotX:C.plotX,plotY:C.plotY,isNull:!1},!F&&E&&d.yData[E.index-1]&&(F=k(d,E.index-1,3)),!K&&u&&d.yData[u.index+1]&&(K=k(d,u.index+1,3)),!E&&F&&d.yData[F.index+1]?E=k(d,F.index+1,3):!E&&u&&d.yData[u.index-1]&&(E=k(d,u.index-1,3)),C&&E&&u&&F&&C.x!==E.x&&(C.x===u.x?(F=E,E=u):C.x===F.x?(E=F,F={close:d.yData[E.index-1][3],x:d.xData[E.index-1]}):K&&C.x===K.x&&(E=K,F=u)),
B&&F&&E?(u={x:B.x,plotX:B.plotX,plotY:B.plotY,isNull:!1},C.y>=E.close&&B.y>=F.close?(C.color=L||b.fallingTrendColor||b.color,v.top.push(M)):C.y<E.close&&B.y<F.close?(C.color=L||b.risingTrendColor||b.color,v.bottom.push(M)):(v.intersect.push(M),v.intersect.push(u),v.intersect.push(c(u,{isNull:!0})),C.y>=E.close&&B.y<F.close?(C.color=L||b.fallingTrendColor||b.color,B.color=L||b.risingTrendColor||b.color,v.top.push(M),v.top.push(c(u,{isNull:!0}))):C.y<E.close&&B.y>=F.close&&(C.color=L||b.risingTrendColor||
b.color,B.color=L||b.fallingTrendColor||b.color,v.bottom.push(M),v.bottom.push(c(u,{isNull:!0}))))):E&&(C.y>=E.close?(C.color=L||b.fallingTrendColor||b.color,v.top.push(M)):(C.color=L||b.risingTrendColor||b.color,v.bottom.push(M)));n(v,function(b,d){a.points=b;a.options=c(z[d].styles,q);a.graph=a["graph"+d+"Line"];h.prototype.drawGraph.call(a);a["graph"+d+"Line"]=a.graph});a.points=e;a.options=b;a.graph=g};e.prototype.getValues=function(c,d){var f=d.period;d=d.multiplier;var e=c.xData,g=c.yData,h=
[],n=[],k=[],l=0===f?0:f-1,q=[],v=[],x;if(!(e.length<=f||!b(g[0])||4!==g[0].length||0>f)){c=m.prototype.getValues.call(this,c,{period:f}).yData;for(x=0;x<c.length;x++){var y=g[l+x];var u=g[l+x-1]||[];var B=q[x-1];var z=v[x-1];var K=k[x-1];0===x&&(B=z=K=0);f=a((y[1]+y[2])/2+d*c[x]);var L=a((y[1]+y[2])/2-d*c[x]);q[x]=f<B||u[3]>B?f:B;v[x]=L>z||u[3]<z?L:z;if(K===B&&y[3]<q[x]||K===z&&y[3]<v[x])var M=q[x];else if(K===B&&y[3]>q[x]||K===z&&y[3]>v[x])M=v[x];h.push([e[l+x],M]);n.push(e[l+x]);k.push(M)}return{values:h,
xData:n,yData:k}}};e.defaultOptions=c(h.defaultOptions,{params:{index:void 0,multiplier:3,period:10},risingTrendColor:"#06b535",fallingTrendColor:"#f21313",changeTrendLine:{styles:{lineWidth:1,lineColor:"#333333",dashStyle:"LongDash"}}});return e}(h);q(f.prototype,{nameBase:"Supertrend",nameComponents:["multiplier","period"]});e.registerSeriesType("supertrend",f);"";return f});u(e,"Stock/Indicators/VBP/VBPPoint.js",[e["Core/Series/SeriesRegistry.js"]],function(e){var f=this&&this.__extends||function(){var f=
function(e,g){f=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(f,e){f.__proto__=e}||function(f,e){for(var g in e)e.hasOwnProperty(g)&&(f[g]=e[g])};return f(e,g)};return function(e,g){function k(){this.constructor=e}f(e,g);e.prototype=null===g?Object.create(g):(k.prototype=g.prototype,new k)}}();return function(e){function g(){return null!==e&&e.apply(this,arguments)||this}f(g,e);g.prototype.destroy=function(){this.negativeGraphic&&(this.negativeGraphic=this.negativeGraphic.destroy());
return e.prototype.destroy.apply(this,arguments)};return g}(e.seriesTypes.sma.prototype.pointClass)});u(e,"Stock/Indicators/VBP/VBPIndicator.js",[e["Stock/Indicators/VBP/VBPPoint.js"],e["Core/Animation/AnimationUtilities.js"],e["Core/Globals.js"],e["Core/Series/SeriesRegistry.js"],e["Core/Utilities.js"],e["Core/Chart/StockChart.js"]],function(e,f,g,k,l,q){var m=this&&this.__extends||function(){var a=function(b,c){a=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(a,b){a.__proto__=b}||
function(a,b){for(var c in b)b.hasOwnProperty(c)&&(a[c]=b[c])};return a(b,c)};return function(b,c){function d(){this.constructor=b}a(b,c);b.prototype=null===c?Object.create(c):(d.prototype=c.prototype,new d)}}(),h=f.animObject;f=g.noop;var d=k.seriesTypes,a=d.column.prototype,b=d.sma,c=l.addEvent,n=l.arrayMax,v=l.arrayMin,B=l.correctFloat,x=l.defined,y=l.error,u=l.extend,t=l.isArray,p=l.merge,w=Math.abs;l=function(d){function f(){var a=null!==d&&d.apply(this,arguments)||this;a.data=void 0;a.negWidths=
void 0;a.options=void 0;a.points=void 0;a.posWidths=void 0;a.priceZones=void 0;a.rangeStep=void 0;a.volumeDataArray=void 0;a.zoneStarts=void 0;a.zoneLinesSVG=void 0;return a}m(f,d);f.prototype.init=function(a){var b=this,d,f,e;g.seriesTypes.sma.prototype.init.apply(b,arguments);var h=c(q,"afterLinkSeries",function(){b.options&&(d=b.options.params,f=b.linkedParent,e=a.get(d.volumeSeriesID),b.addCustomEvents(f,e));h()},{order:1});return b};f.prototype.addCustomEvents=function(a,b){function d(){f.chart.redraw();
f.setData([]);f.zoneStarts=[];f.zoneLinesSVG&&(f.zoneLinesSVG=f.zoneLinesSVG.destroy())}var f=this;f.dataEventsToUnbind.push(c(a,"remove",function(){d()}));b&&f.dataEventsToUnbind.push(c(b,"remove",function(){d()}));return f};f.prototype.animate=function(a){var b=this,c=b.chart.inverted,d=b.group,f={};!a&&d&&(a=c?b.yAxis.top:b.xAxis.left,c?(d["forceAnimate:translateY"]=!0,f.translateY=a):(d["forceAnimate:translateX"]=!0,f.translateX=a),d.animate(f,u(h(b.options.animation),{step:function(a,c){b.group.attr({scaleX:Math.max(.001,
c.pos)})}})))};f.prototype.drawPoints=function(){this.options.volumeDivision.enabled&&(this.posNegVolume(!0,!0),a.drawPoints.apply(this,arguments),this.posNegVolume(!1,!1));a.drawPoints.apply(this,arguments)};f.prototype.posNegVolume=function(a,b){var c=b?["positive","negative"]:["negative","positive"],d=this.options.volumeDivision,f=this.points.length,e=[],g=[],h=0,n;a?(this.posWidths=e,this.negWidths=g):(e=this.posWidths,g=this.negWidths);for(;h<f;h++){var k=this.points[h];k[c[0]+"Graphic"]=k.graphic;
k.graphic=k[c[1]+"Graphic"];if(a){var m=k.shapeArgs.width;var p=this.priceZones[h];(n=p.wholeVolumeData)?(e.push(m/n*p.positiveVolumeData),g.push(m/n*p.negativeVolumeData)):(e.push(0),g.push(0))}k.color=b?d.styles.positiveColor:d.styles.negativeColor;k.shapeArgs.width=b?this.posWidths[h]:this.negWidths[h];k.shapeArgs.x=b?k.shapeArgs.x:this.posWidths[h]}};f.prototype.translate=function(){var b=this,c=b.options,d=b.chart,f=b.yAxis,e=f.min,g=b.options.zoneLines,h=b.priceZones,k=0,m,p,l;a.translate.apply(b);
var t=b.points;if(t.length){var q=.5>c.pointPadding?c.pointPadding:.1;c=b.volumeDataArray;var r=n(c);var v=d.plotWidth/2;var x=d.plotTop;var y=w(f.toPixels(e)-f.toPixels(e+b.rangeStep));var u=w(f.toPixels(e)-f.toPixels(e+b.rangeStep));q&&(e=w(y*(1-2*q)),k=w((y-e)/2),y=w(e));t.forEach(function(a,c){p=a.barX=a.plotX=0;l=a.plotY=f.toPixels(h[c].start)-x-(f.reversed?y-u:y)-k;m=B(v*h[c].wholeVolumeData/r);a.pointWidth=m;a.shapeArgs=b.crispCol.apply(b,[p,l,m,y]);a.volumeNeg=h[c].negativeVolumeData;a.volumePos=
h[c].positiveVolumeData;a.volumeAll=h[c].wholeVolumeData});g.enabled&&b.drawZones(d,f,b.zoneStarts,g.styles)}};f.prototype.getValues=function(a,b){var c=a.processedXData,d=a.processedYData,f=this.chart,e=b.ranges,g=[],h=[],n=[],k;if(a.chart)if(k=f.get(b.volumeSeriesID))if((b=t(d[0]))&&4!==d[0].length)y("Type of "+a.name+" series is different than line, OHLC or candlestick.",!0,f);else return(this.priceZones=this.specifyZones(b,c,d,e,k)).forEach(function(a,b){g.push([a.x,a.end]);h.push(g[b][0]);n.push(g[b][1])}),
{values:g,xData:h,yData:n};else y("Series "+b.volumeSeriesID+" not found! Check `volumeSeriesID`.",!0,f);else y("Base series not found! In case it has been removed, add a new one.",!0,f)};f.prototype.specifyZones=function(a,b,c,d,f){if(a){var e=c.length;for(var g=c[0][3],h=g,k=1,m;k<e;k++)m=c[k][3],m<g&&(g=m),m>h&&(h=m);e={min:g,max:h}}else e=!1;e=(g=e)?g.min:v(c);m=g?g.max:n(c);g=this.zoneStarts=[];h=[];var p=0;k=1;var l=this.linkedParent;!this.options.compareToMain&&l.dataModify&&(e=l.dataModify.modifyValue(e),
m=l.dataModify.modifyValue(m));if(!x(e)||!x(m))return this.points.length&&(this.setData([]),this.zoneStarts=[],this.zoneLinesSVG&&(this.zoneLinesSVG=this.zoneLinesSVG.destroy())),[];l=this.rangeStep=B(m-e)/d;for(g.push(e);p<d-1;p++)g.push(B(g[p]+l));g.push(m);for(d=g.length;k<d;k++)h.push({index:k-1,x:b[0],start:g[k-1],end:g[k]});return this.volumePerZone(a,h,f,b,c)};f.prototype.volumePerZone=function(a,b,c,d,f){var e=this,g=c.processedXData,h=c.processedYData,n=b.length-1,k=f.length;c=h.length;var m,
p,l,t,q;w(k-c)&&(d[0]!==g[0]&&h.unshift(0),d[k-1]!==g[c-1]&&h.push(0));e.volumeDataArray=[];b.forEach(function(b){b.wholeVolumeData=0;b.positiveVolumeData=0;for(q=b.negativeVolumeData=0;q<k;q++){l=p=!1;t=a?f[q][3]:f[q];m=q?a?f[q-1][3]:f[q-1]:t;var c=e.linkedParent;!e.options.compareToMain&&c.dataModify&&(t=c.dataModify.modifyValue(t),m=c.dataModify.modifyValue(m));t<=b.start&&0===b.index&&(p=!0);t>=b.end&&b.index===n&&(l=!0);(t>b.start||p)&&(t<b.end||l)&&(b.wholeVolumeData+=h[q],m>t?b.negativeVolumeData+=
h[q]:b.positiveVolumeData+=h[q])}e.volumeDataArray.push(b.wholeVolumeData)});return b};f.prototype.drawZones=function(a,b,c,d){var f=a.renderer,e=this.zoneLinesSVG,g=[],h=a.plotWidth,n=a.plotTop,k;c.forEach(function(c){k=b.toPixels(c)-n;g=g.concat(a.renderer.crispLine([["M",0,k],["L",h,k]],d.lineWidth))});e?e.animate({d:g}):e=this.zoneLinesSVG=f.path(g).attr({"stroke-width":d.lineWidth,stroke:d.color,dashstyle:d.dashStyle,zIndex:this.group.zIndex+.1}).add(this.group)};f.defaultOptions=p(b.defaultOptions,
{params:{index:void 0,period:void 0,ranges:12,volumeSeriesID:"volume"},zoneLines:{enabled:!0,styles:{color:"#0A9AC9",dashStyle:"LongDash",lineWidth:1}},volumeDivision:{enabled:!0,styles:{positiveColor:"rgba(144, 237, 125, 0.8)",negativeColor:"rgba(244, 91, 91, 0.8)"}},animationLimit:1E3,enableMouseTracking:!1,pointPadding:0,zIndex:-1,crisp:!0,dataGrouping:{enabled:!1},dataLabels:{allowOverlap:!0,enabled:!0,format:"P: {point.volumePos:.2f} | N: {point.volumeNeg:.2f}",padding:0,style:{fontSize:"7px"},
verticalAlign:"top"}});return f}(b);u(l.prototype,{nameBase:"Volume by Price",nameComponents:["ranges"],calculateOn:{chart:"render",xAxis:"afterSetExtremes"},pointClass:e,markerAttribs:f,drawGraph:f,getColumnMetrics:a.getColumnMetrics,crispCol:a.crispCol});k.registerSeriesType("vbp",l);"";return l});u(e,"Stock/Indicators/VWAP/VWAPIndicator.js",[e["Core/Series/SeriesRegistry.js"],e["Core/Utilities.js"]],function(e,f){var g=this&&this.__extends||function(){var f=function(d,a){f=Object.setPrototypeOf||
{__proto__:[]}instanceof Array&&function(a,c){a.__proto__=c}||function(a,c){for(var b in c)c.hasOwnProperty(b)&&(a[b]=c[b])};return f(d,a)};return function(d,a){function b(){this.constructor=d}f(d,a);d.prototype=null===a?Object.create(a):(b.prototype=a.prototype,new b)}}(),k=e.seriesTypes.sma,l=f.error,q=f.isArray,m=f.merge;f=function(f){function d(){var a=null!==f&&f.apply(this,arguments)||this;a.data=void 0;a.points=void 0;a.options=void 0;return a}g(d,f);d.prototype.getValues=function(a,b){var c=
a.chart,d=a.xData;a=a.yData;var f=b.period,e=!0,g;if(g=c.get(b.volumeSeriesID))return q(a[0])||(e=!1),this.calculateVWAPValues(e,d,a,g,f);l("Series "+b.volumeSeriesID+" not found! Check `volumeSeriesID`.",!0,c)};d.prototype.calculateVWAPValues=function(a,b,c,d,f){var e=d.yData,g=d.xData.length,h=b.length;d=[];var n=[],k=[],m=[],l=[],q;g=h<=g?h:g;for(q=h=0;h<g;h++){var v=a?(c[h][1]+c[h][2]+c[h][3])/3:c[h];v*=e[h];v=q?d[h-1]+v:v;var u=q?n[h-1]+e[h]:e[h];d.push(v);n.push(u);l.push([b[h],v/u]);k.push(l[h][0]);
m.push(l[h][1]);q++;q===f&&(q=0)}return{values:l,xData:k,yData:m}};d.defaultOptions=m(k.defaultOptions,{params:{index:void 0,period:30,volumeSeriesID:"volume"}});return d}(k);e.registerSeriesType("vwap",f);"";return f});u(e,"Stock/Indicators/WilliamsR/WilliamsRIndicator.js",[e["Stock/Indicators/ArrayUtilities.js"],e["Core/Series/SeriesRegistry.js"],e["Core/Utilities.js"]],function(e,f,g){var k=this&&this.__extends||function(){var d=function(a,b){d=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&
function(a,b){a.__proto__=b}||function(a,b){for(var c in b)b.hasOwnProperty(c)&&(a[c]=b[c])};return d(a,b)};return function(a,b){function c(){this.constructor=a}d(a,b);a.prototype=null===b?Object.create(b):(c.prototype=b.prototype,new c)}}(),l=f.seriesTypes.sma,q=g.extend,m=g.isArray,h=g.merge;g=function(d){function a(){var a=null!==d&&d.apply(this,arguments)||this;a.data=void 0;a.options=void 0;a.points=void 0;return a}k(a,d);a.prototype.getValues=function(a,c){c=c.period;var b=a.xData,d=(a=a.yData)?
a.length:0,f=[],g=[],h=[],k;if(!(b.length<c)&&m(a[0])&&4===a[0].length){for(k=c-1;k<d;k++){var l=a.slice(k-c+1,k+1);var p=e.getArrayExtremes(l,2,1);l=p[0];p=p[1];var q=a[k][3];l=(p-q)/(p-l)*-100;b[k]&&(f.push([b[k],l]),g.push(b[k]),h.push(l))}return{values:f,xData:g,yData:h}}};a.defaultOptions=h(l.defaultOptions,{params:{index:void 0,period:14}});return a}(l);q(g.prototype,{nameBase:"Williams %R"});f.registerSeriesType("williamsr",g);"";return g});u(e,"Stock/Indicators/WMA/WMAIndicator.js",[e["Core/Series/SeriesRegistry.js"],
e["Core/Utilities.js"]],function(e,f){function g(d,a){a*=(a+1)/2;return d.reduce(function(a,c,d){return[null,a[1]+c[1]*(d+1)]})[1]/a}function k(d,a,b,c){b=g(d,d.length);a=a[c-1];d.shift();return[a,b]}var l=this&&this.__extends||function(){var d=function(a,b){d=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(a,b){a.__proto__=b}||function(a,b){for(var c in b)b.hasOwnProperty(c)&&(a[c]=b[c])};return d(a,b)};return function(a,b){function c(){this.constructor=a}d(a,b);a.prototype=null===
b?Object.create(b):(c.prototype=b.prototype,new c)}}(),q=e.seriesTypes.sma,m=f.isArray,h=f.merge;f=function(d){function a(){var a=null!==d&&d.apply(this,arguments)||this;a.data=void 0;a.options=void 0;a.points=void 0;return a}l(a,d);a.prototype.getValues=function(a,c){var b=c.period,d=a.xData,f=(a=a.yData)?a.length:0,e=1,g=d[0],h=a[0],l=[],p=[],q=[],r=-1;if(!(d.length<b)){m(a[0])&&(r=c.index,h=a[0][r]);for(c=[[g,h]];e!==b;)c.push([d[e],0>r?a[e]:a[e][r]]),e++;for(b=e;b<f;b++)e=k(c,d,a,b),l.push(e),
p.push(e[0]),q.push(e[1]),c.push([d[b],0>r?a[b]:a[b][r]]);e=k(c,d,a,b);l.push(e);p.push(e[0]);q.push(e[1]);return{values:l,xData:p,yData:q}}};a.defaultOptions=h(q.defaultOptions,{params:{index:3,period:9}});return a}(q);e.registerSeriesType("wma",f);"";return f});u(e,"Stock/Indicators/Zigzag/ZigzagIndicator.js",[e["Core/Series/SeriesRegistry.js"],e["Core/Utilities.js"]],function(e,f){var g=this&&this.__extends||function(){var f=function(e,d){f=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&
function(a,b){a.__proto__=b}||function(a,b){for(var c in b)b.hasOwnProperty(c)&&(a[c]=b[c])};return f(e,d)};return function(e,d){function a(){this.constructor=e}f(e,d);e.prototype=null===d?Object.create(d):(a.prototype=d.prototype,new a)}}(),k=e.seriesTypes.sma,l=f.merge;f=f.extend;var q=function(f){function e(){var d=null!==f&&f.apply(this,arguments)||this;d.data=void 0;d.points=void 0;d.options=void 0;return d}g(e,f);e.prototype.getValues=function(d,a){var b=a.lowIndex,c=a.highIndex,f=a.deviation/
100;a=1+f;var e=1-f;f=d.xData;var g=d.yData;d=g?g.length:0;var h=[],k=[],m=[],l,p,q=!1,r=!1;if(!(!f||1>=f.length||d&&("undefined"===typeof g[0][b]||"undefined"===typeof g[0][c]))){var u=g[0][b];var z=g[0][c];for(l=1;l<d;l++){if(g[l][b]<=z*e){h.push([f[0],z]);var D=[f[l],g[l][b]];q=p=!0}else g[l][c]>=u*a&&(h.push([f[0],u]),D=[f[l],g[l][c]],p=!1,q=!0);if(q){k.push(h[0][0]);m.push(h[0][1]);var J=l++;l=d}}for(l=J;l<d;l++)p?(g[l][b]<=D[1]&&(D=[f[l],g[l][b]]),g[l][c]>=D[1]*a&&(r=c)):(g[l][c]>=D[1]&&(D=
[f[l],g[l][c]]),g[l][b]<=D[1]*e&&(r=b)),!1!==r&&(h.push(D),k.push(D[0]),m.push(D[1]),D=[f[l],g[l][r]],p=!p,r=!1);b=h.length;0!==b&&h[b-1][0]<f[d-1]&&(h.push(D),k.push(D[0]),m.push(D[1]));return{values:h,xData:k,yData:m}}};e.defaultOptions=l(k.defaultOptions,{params:{index:void 0,period:void 0,lowIndex:2,highIndex:1,deviation:1}});return e}(k);f(q.prototype,{nameComponents:["deviation"],nameSuffixes:["%"],nameBase:"Zig Zag"});e.registerSeriesType("zigzag",q);"";return q});u(e,"Stock/Indicators/LinearRegression/LinearRegressionIndicator.js",
[e["Core/Series/SeriesRegistry.js"],e["Core/Utilities.js"]],function(e,f){var g=this&&this.__extends||function(){var f=function(d,a){f=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(a,c){a.__proto__=c}||function(a,c){for(var b in c)c.hasOwnProperty(b)&&(a[b]=c[b])};return f(d,a)};return function(d,a){function b(){this.constructor=d}f(d,a);d.prototype=null===a?Object.create(a):(b.prototype=a.prototype,new b)}}(),k=e.seriesTypes.sma,l=f.isArray,q=f.extend,m=f.merge;f=function(f){function d(){var a=
null!==f&&f.apply(this,arguments)||this;a.data=void 0;a.options=void 0;a.points=void 0;return a}g(d,f);d.prototype.getRegressionLineParameters=function(a,b){var c=this.options.params.index,d=function(a,b){return l(a)?a[b]:a},f=a.reduce(function(a,b){return b+a},0),e=b.reduce(function(a,b){return d(b,c)+a},0);f/=a.length;e/=b.length;var g=0,h=0,k;for(k=0;k<a.length;k++){var m=a[k]-f;var p=d(b[k],c)-e;g+=m*p;h+=Math.pow(m,2)}a=h?g/h:0;return{slope:a,intercept:e-a*f}};d.prototype.getEndPointY=function(a,
b){return a.slope*b+a.intercept};d.prototype.transformXData=function(a,b){var c=a[0];return a.map(function(a){return(a-c)/b})};d.prototype.findClosestDistance=function(a){var b,c;for(c=1;c<a.length-1;c++){var d=a[c]-a[c-1];0<d&&("undefined"===typeof b||d<b)&&(b=d)}return b};d.prototype.getValues=function(a,b){var c=a.xData;a=a.yData;b=b.period;var d,f={xData:[],yData:[],values:[]},e=this.options.params.xAxisUnit||this.findClosestDistance(c);for(d=b-1;d<=c.length-1;d++){var g=d-b+1;var h=d+1;var k=
c[d];var m=c.slice(g,h);g=a.slice(g,h);h=this.transformXData(m,e);m=this.getRegressionLineParameters(h,g);g=this.getEndPointY(m,h[h.length-1]);f.values.push({regressionLineParameters:m,x:k,y:g});f.xData.push(k);f.yData.push(g)}return f};d.defaultOptions=m(k.defaultOptions,{params:{xAxisUnit:null},tooltip:{valueDecimals:4}});return d}(k);q(f.prototype,{nameBase:"Linear Regression Indicator"});e.registerSeriesType("linearRegression",f);"";return f});u(e,"Stock/Indicators/LinearRegressionSlopes/LinearRegressionSlopesIndicator.js",
[e["Core/Series/SeriesRegistry.js"],e["Core/Utilities.js"]],function(e,f){var g=this&&this.__extends||function(){var f=function(e,d){f=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(a,b){a.__proto__=b}||function(a,b){for(var c in b)b.hasOwnProperty(c)&&(a[c]=b[c])};return f(e,d)};return function(e,d){function a(){this.constructor=e}f(e,d);e.prototype=null===d?Object.create(d):(a.prototype=d.prototype,new a)}}(),k=e.seriesTypes.linearRegression,l=f.extend,q=f.merge;f=function(f){function e(){var d=
null!==f&&f.apply(this,arguments)||this;d.data=void 0;d.options=void 0;d.points=void 0;return d}g(e,f);e.prototype.getEndPointY=function(d){return d.slope};e.defaultOptions=q(k.defaultOptions);return e}(k);l(f.prototype,{nameBase:"Linear Regression Slope Indicator"});e.registerSeriesType("linearRegressionSlope",f);"";return f});u(e,"Stock/Indicators/LinearRegressionIntercept/LinearRegressionInterceptIndicator.js",[e["Core/Series/SeriesRegistry.js"],e["Core/Utilities.js"]],function(e,f){var g=this&&
this.__extends||function(){var f=function(e,d){f=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(a,b){a.__proto__=b}||function(a,b){for(var c in b)b.hasOwnProperty(c)&&(a[c]=b[c])};return f(e,d)};return function(e,d){function a(){this.constructor=e}f(e,d);e.prototype=null===d?Object.create(d):(a.prototype=d.prototype,new a)}}(),k=e.seriesTypes.linearRegression,l=f.extend,q=f.merge;f=function(f){function e(){var d=null!==f&&f.apply(this,arguments)||this;d.data=void 0;d.options=void 0;
d.points=void 0;return d}g(e,f);e.prototype.getEndPointY=function(d){return d.intercept};e.defaultOptions=q(k.defaultOptions);return e}(k);l(f.prototype,{nameBase:"Linear Regression Intercept Indicator"});e.registerSeriesType("linearRegressionIntercept",f);"";return f});u(e,"Stock/Indicators/LinearRegressionAngle/LinearRegressionAngleIndicator.js",[e["Core/Series/SeriesRegistry.js"],e["Core/Utilities.js"]],function(e,f){var g=this&&this.__extends||function(){var f=function(e,d){f=Object.setPrototypeOf||
{__proto__:[]}instanceof Array&&function(a,b){a.__proto__=b}||function(a,b){for(var c in b)b.hasOwnProperty(c)&&(a[c]=b[c])};return f(e,d)};return function(e,d){function a(){this.constructor=e}f(e,d);e.prototype=null===d?Object.create(d):(a.prototype=d.prototype,new a)}}(),k=e.seriesTypes.linearRegression,l=f.extend,q=f.merge;f=function(f){function e(){var d=null!==f&&f.apply(this,arguments)||this;d.data=void 0;d.options=void 0;d.points=void 0;return d}g(e,f);e.prototype.slopeToAngle=function(d){return 180/
Math.PI*Math.atan(d)};e.prototype.getEndPointY=function(d){return this.slopeToAngle(d.slope)};e.defaultOptions=q(k.defaultOptions,{tooltip:{pointFormat:'<span style="color:{point.color}">\u25cf</span>{series.name}: <b>{point.y}\u00b0</b><br/>'}});return e}(k);l(f.prototype,{nameBase:"Linear Regression Angle Indicator"});e.registerSeriesType("linearRegressionAngle",f);"";return f});u(e,"Stock/Indicators/ABands/ABandsIndicator.js",[e["Stock/Indicators/MultipleLinesComposition.js"],e["Core/Series/SeriesRegistry.js"],
e["Core/Utilities.js"]],function(e,f,g){var k=this&&this.__extends||function(){var d=function(a,b){d=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(a,b){a.__proto__=b}||function(a,b){for(var c in b)b.hasOwnProperty(c)&&(a[c]=b[c])};return d(a,b)};return function(a,b){function c(){this.constructor=a}d(a,b);a.prototype=null===b?Object.create(b):(c.prototype=b.prototype,new c)}}(),l=f.seriesTypes.sma,q=g.correctFloat,m=g.extend,h=g.merge;g=function(d){function a(){var a=null!==d&&d.apply(this,
arguments)||this;a.data=void 0;a.options=void 0;a.points=void 0;return a}k(a,d);a.prototype.getValues=function(a,c){var b=c.period,f=c.factor;c=c.index;var e=a.xData,g=(a=a.yData)?a.length:0,h=[],k=[],l=[],m=[],w=[],r;if(!(g<b)){for(r=0;r<=g;r++){if(r<g){var u=a[r][2];var z=a[r][1];var D=f;u=q(z-u)/(q(z+u)/2)*1E3*D;h.push(a[r][1]*q(1+2*u));k.push(a[r][2]*q(1-2*u))}if(r>=b){u=e.slice(r-b,r);var J=a.slice(r-b,r);D=d.prototype.getValues.call(this,{xData:u,yData:h.slice(r-b,r)},{period:b});z=d.prototype.getValues.call(this,
{xData:u,yData:k.slice(r-b,r)},{period:b});J=d.prototype.getValues.call(this,{xData:u,yData:J},{period:b,index:c});u=J.xData[0];D=D.yData[0];z=z.yData[0];J=J.yData[0];l.push([u,D,J,z]);m.push(u);w.push([D,J,z])}}return{values:l,xData:m,yData:w}}};a.defaultOptions=h(l.defaultOptions,{params:{period:20,factor:.001,index:3},lineWidth:1,topLine:{styles:{lineWidth:1}},bottomLine:{styles:{lineWidth:1}},dataGrouping:{approximation:"averages"}});return a}(l);m(g.prototype,{areaLinesNames:["top","bottom"],
linesApiNames:["topLine","bottomLine"],nameBase:"Acceleration Bands",nameComponents:["period","factor"],pointArrayMap:["top","middle","bottom"],pointValKey:"middle"});e.compose(g);f.registerSeriesType("abands",g);"";return g});u(e,"Stock/Indicators/TrendLine/TrendLineIndicator.js",[e["Core/Series/SeriesRegistry.js"],e["Core/Utilities.js"]],function(e,f){var g=this&&this.__extends||function(){var e=function(d,a){e=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(a,c){a.__proto__=c}||
function(a,c){for(var b in c)c.hasOwnProperty(b)&&(a[b]=c[b])};return e(d,a)};return function(d,a){function b(){this.constructor=d}e(d,a);d.prototype=null===a?Object.create(a):(b.prototype=a.prototype,new b)}}(),k=e.seriesTypes.sma,l=f.extend,q=f.merge,m=f.isArray;f=function(e){function d(){var a=null!==e&&e.apply(this,arguments)||this;a.data=void 0;a.options=void 0;a.points=void 0;return a}g(d,e);d.prototype.getValues=function(a,b){var c=a.xData,d=a.yData;a=[];var e=[],f=[],g=0,h=0,k=0,l=0,p=c.length,
q=b.index;for(b=0;b<p;b++){var r=c[b];var u=m(d[b])?d[b][q]:d[b];g+=r;h+=u;k+=r*u;l+=r*r}d=(p*k-g*h)/(p*l-g*g);isNaN(d)&&(d=0);g=(h-d*g)/p;for(b=0;b<p;b++)r=c[b],u=d*r+g,a[b]=[r,u],e[b]=r,f[b]=u;return{xData:e,yData:f,values:a}};d.defaultOptions=q(k.defaultOptions,{params:{period:void 0,index:3}});return d}(k);l(f.prototype,{nameBase:"Trendline",nameComponents:!1});e.registerSeriesType("trendline",f);"";return f});u(e,"Stock/Indicators/DisparityIndex/DisparityIndexIndicator.js",[e["Core/Series/SeriesRegistry.js"],
e["Core/Utilities.js"]],function(e,f){var g=this&&this.__extends||function(){var a=function(b,c){a=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(a,b){a.__proto__=b}||function(a,b){for(var c in b)b.hasOwnProperty(c)&&(a[c]=b[c])};return a(b,c)};return function(b,c){function d(){this.constructor=b}a(b,c);b.prototype=null===c?Object.create(c):(d.prototype=c.prototype,new d)}}(),k=e.seriesTypes.sma,l=f.correctFloat,q=f.defined,m=f.extend,h=f.isArray,d=f.merge;f=function(a){function b(){var b=
null!==a&&a.apply(this,arguments)||this;b.averageIndicator=void 0;b.data=void 0;b.options=void 0;b.points=void 0;return b}g(b,a);b.prototype.init=function(){var a=arguments,b=a[1].params;this.averageIndicator=e.seriesTypes[b&&b.average?b.average:void 0]||k;this.averageIndicator.prototype.init.apply(this,a)};b.prototype.calculateDisparityIndex=function(a,b){return l(a-b)/b*100};b.prototype.getValues=function(a,b){var c=b.index,d=a.xData,e=a.yData,f=e?e.length:0,g=[],k=[],l=[],m=this.averageIndicator,
n=h(e[0]);b=m.prototype.getValues(a,b);a=b.yData;b=d.indexOf(b.xData[0]);if(a&&0!==a.length&&q(c)&&!(e.length<=b)){for(m=b;m<f;m++){var u=this.calculateDisparityIndex(n?e[m][c]:e[m],a[m-b]);g.push([d[m],u]);k.push(d[m]);l.push(u)}return{values:g,xData:k,yData:l}}};b.defaultOptions=d(k.defaultOptions,{params:{average:"sma",index:3},marker:{enabled:!1},dataGrouping:{approximation:"averages"}});return b}(k);m(f.prototype,{nameBase:"Disparity Index",nameComponents:["period","average"]});e.registerSeriesType("disparityindex",
f);"";return f});u(e,"masters/indicators/indicators-all.src.js",[],function(){})});
//# sourceMappingURL=indicators-all.js.map